﻿<%@ Page Language="C#" AutoEventWireup="true" EnableEventValidation="false" CodeBehind="FormsFormat.aspx.cs"
    Inherits="QuestionnaireConfirm.FormsFormat" %>

<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" lang="ja">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <title>
        <%= Resources.Messages.AppTitle %>
	</title>
    <link rel="SHORTCUT ICON" href="image/record_operator_favicon.ico" />
    <link rel="stylesheet" href="css/redmond/jquery-ui-1.11.2.min.css" />
    <link rel="stylesheet" href="css/style.css?date=<%=DateTime.Now.ToString("yyyyMMddHHmmss")%>" />
    <style>
        html,body{
            background-color:#f5f5f5 !important;
        }
        #headerItem {
            width: 100%;
            margin: 3px 0;
        }

        #headerItemTitle {
            width: 43%;
            font-weight: 700;
            font-style: normal;
            font-size: 14px;
            color: #555;
        }

        
        #headerItemButtonLeft {
            float: left;
            margin-left: 4px;
        }

        #headerItemButtonRight {
            float: right;
        }

        .sortColumn {
            position: relative;
            left: 20px;
            width: 160px;
        }

        .sortDirection {
            position: relative;
            left: 30px;
            width: 60px;
        }

        #headerItemButton {
            display: flex;
            justify-content: space-between;
        }

        #footerItem {
            width: 100%;
            margin: 3px 0;
        }

        #footerItemSpace {
            display: none;
        }
        #footerItemScanPage{
            overflow: hidden;
        }

        #footerItemScanPageLeft {
            float: left;
        }

        #footerItemScanPageRight {
            float: right;
            display: flex;
            width: 130px;
            justify-content: space-around;
            align-items: center;
            height: 32px;
        }

        #footerItemElement {

            padding: 8px 5px;
            display: flex;
            justify-content: space-between;

        }

        #footerItemElementLeft {
            float: left;
/*            padding-top: 8px;*/
        }

        #footerItemElementRight {
            text-align:right;
            /* margin-top: -32px; */
        }

        #footer {
            margin-top: 23px;
        }

        .fg-button {
            margin: 1px;
            width: 10px;
            font-size: 10px;
        }

        #allVerifiedCheckBox {
            vertical-align: middle;
        }

        #previewVisibleDisable {
            position: absolute;
        }

        .scanPageArea {
            width: 43%;
            max-width: 43%;
            border: 0px;
            padding: 0;
            vertical-align: top;
            background-color: #D8D8D8;
           /* border-radius: 5px 5px 0 0;*/
            /*border-top: 1px solid #D8D8D8;
            border-left: 1px solid #D8D8D8;
            border-right: 1px solid #D8D8D8;*/
        }

        .dataTables_scroll {
            margin-left: 7px;
        }

        .dataTable > tbody > tr > td {
            padding: 7px;
        }
        .nextPageButton {
            font-size: 16px;
            line-height: 30px;
            width: 94px;
        }
        #columnPopupItems {
            border: 1px solid #b2b2b2;
            margin: 20px 0;
            max-height: 350px;
            overflow-y: scroll;
        }
        #elementsTableMasterDiv{
            min-width: 550px;
        }
        .layoutFormat {
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            min-height: 100vh;
        }
        #scanPageScalingListSpan .xux-dropdown-header{
			width: 175px
		}
        .xux-decoratedTable-table table tbody {
        display:block;
        overflow-y:auto;
        }

        .xux-decoratedTable-table table thead, tbody tr {
            display: table;
            width: 100%;
            table-layout: fixed;
        }

        .xux-modalWindow.xux-width-normal{
            width:400px;
        }
        .xux-normalButton{
            width:94px !important;
        }
        .xux-button{
            display:inline !important;
        }
         .xux-modalWindow.xux-width-normal{
            width:400px !important;
        }
        button.va-middle{
            height:32px;
            background:#eaeaea none repeat scroll 0 0 !important;
        }
        .xux-textArea{
            overscroll-behavior: unset !important
        }
        /*  .xux-decoratedTable-table table thead {
        width: calc( 100% - 1em )
        }*/
        /*   .copyRight .xux-normalButton{
            width:82px !important;
            height:26px !important;
            line-height:25px !important;
        }*/
    </style>
    <script src="js/jquery-2.1.1.min.js"></script>

    <% QuestionnaireConfirm.Util.ExportDataUtil expUtil = new QuestionnaireConfirm.Util.ExportDataUtil(Session.SessionID, (string)Session["USER_ID"], (string)Session["USER_NAME"], Convert.ToInt32(Session["businessId"]), System.DateTime.Now); %>
    <script>
        var userId_;
        var jobIds_;
        var formId_;
        var formName_;
        var errElementId_;
        var errScanPageId_;
        var scanPageInfo_ = [];
        var scanPageIndex_ = 0;
        var prevScanPageId = 0;
        var $elementsTable_;
        var elementRowsList_ = [];
        var tempData = [];
        var recordIndex_ = 0;
        var isUpdating_ = false;
        var statusCond_ = {};
        var isChangeTab_ = false;
        var scalingSize_ = 0;
        var originalTop_ = 0;
        var originalLeft_ = 0;
        var originalWidth_ = 0;
        var originalHeight_ = 0;
        var scalingList_ = [17, 67, 100, 133, 167, 200, 300, 400];
        var sortFilterColumn_ = null;<%-- フィルターダイアログ用 --%>
        var scaledScanPageImageWidth_ = 0;
        var scaledScanPageImageHeight_ = 0;
        var scanPagePanelWidth_ = 0;
        var scanPagePanelHeight_ = 0;
        var moveX_ = 0;
        var moveY_ = 0;
        var $filterDialogHeader_ = null;
        var freeEntryMaxLength_ = <%= QuestionnaireConfirm.Util.RecordUtil.GetFreeEntryMaxLength() %>;
        var isParentClosed_ = false;
        var expScaleFlg = false;
        var redScaleFlg = false;
        var prevScanPageFlg = false;
        var nextScanPageFlg = false;
        var prevRecordPageFlg = false;
        var nextRecordPageFlg = false;
        var previewSpaceWidth_ = 0;
        var tmpScalingParam_ = 1;
        var scanTabWidth_ = 0;
        var prevData_;
        var selectedElementDataId_ = -1;
        var businessId_;
        var DataTableOptions = null;
        var COOKIENAME_PREVIEW_SETTING = 'Forms.PreviewSetting';
        var COOKIENAME_ANSWER_IMAGE_SETTING = 'Forms.AnswerImageSetting';
        var COOKIENAME_CONFIRMATION_OPEN = 'ConfirmationOpen';

        var FILTER_ALLROWS_ID = 'allRows';
        var FILTER_ALLROWS_ID_SELECTOR = '#allRows';
        var FILTER_COND_CLASSNAME = 'filterCond';
        var FILTER_COND_CLASSNAME_SELECTOR = '.filterCond';
        var FILTER_RADIO_GROUP_NAME = 'filterRadioItem';
        var TABLE_WIDTH_QUESTION = 100;
        var TABLE_WIDTH_CONFIRM = 53;
        var aoData = [];
        var renderTable = null;
        var allVerifiedCheckBoxValue = null;
        var clickHeaderCell = null;
        var clickHeaderCellWidth = 0;
        var toggleRecordSort = null
        //$(window).resize(function () {
        //    if (document.body.clientWidth < 700) {
        //        window.resizeTo(700, 700);
        //    }
        //});
		
		var windowGlobal = $(window);
	    <%-- 画面遷移が発生した場合の処理 --%>
        $(window).bind('beforeunload', function (e) {
            if (isParentClosed_) return;

            setPreviewSetting();

            var changedRows = getChangedElementRows();
            if (0 < changedRows.length || isUpdating_) {
                return '<%= Resources.Messages.ConfirmDataChangedMessage %>';
            }
        });
        $(window).load(function () {
            setCookie(COOKIENAME_CONFIRMATION_OPEN, "1");
        });
        $(window).unload(function () {
            $.removeCookie(COOKIENAME_CONFIRMATION_OPEN);
        });

        //ドキュメント全体にkeydownイベントを追加
        $(document).on("keydown", function (event) {
            checkboxSpacekeyDown(event);
        });

        function timeout() {
            <%--alert('<%= Resources.Messages.ConfirmWindowCloseMessageTimeout %>');
            isParentClosed_ = true;
            window.close();--%>
            alertMessageInfo('<%= Resources.Messages.ConfirmWindowCloseMessageTimeout %>', function () {
                isParentClosed_ = true;
                window.close();
            });
        }

        <%-- 帳票ページボタン表示制御 --%>
        function showRecordPageButton(prev, next) {
            if (prev) {
                $('.prevRecordButtonEnable').show();
                $('.prevRecordButtonDisable').hide();
            } else {
                $('.prevRecordButtonEnable').hide();
                $('.prevRecordButtonDisable').show();
            }
            if (next) {
                $('.nextRecordButtonEnable').show();
                $('.nextRecordButtonDisable').hide();
            } else {
                $('.nextRecordButtonEnable').hide();
                $('.nextRecordButtonDisable').show();
            }
        }

		<%-- 拡縮プルダウン作成 --%>
        function createScalingCombobox(defaultSize, heightScaleSize, widthScaleSize, previewSetting) {
			<%-- 既存の拡縮プルダウンを削除 --%>
            var $scanPageScalingListSpan = $('#scanPageScalingListSpan');
            $scanPageScalingListSpan.children().remove();
			<%-- 新しい拡縮プルダウンの作成 --%>
            $scanPageScalingListSpan.append('<select id="scanPageScalingList" class="scanPageScalingList"></select>');
            var $scanPageScalingList = $('#scanPageScalingList');
			<%-- 拡縮プルダウンの倍率リスト作成 --%>
            var append = '';
            scalingSize_ = 0;
            for (var i = 0; i < scalingList_.length; i++) {
                append = '<option value="' + scalingList_[i] + '" ';
                if (previewSetting.size == scalingList_[i]) {
                    append += 'selected';
                    scalingSize_ = scalingList_[i];
                }
                append += '>' + scalingList_[i] + '%</option>';
                $scanPageScalingList.append(append);
            }

            append = '<option value="scalling" ';
            if (scalingSize_ == 0 && !(previewSetting.size == 0 || previewSetting.size == -1 || previewSetting.size == -2)) {
                append += 'selected';
                scalingSize_ = previewSetting.size;
            }
            append += '><%= Resources.Messages.ScalingImageSizeCaption %></option>';
            $scanPageScalingList.append(append);

            var cookie = isPreviewSetting(scanPageIndex_ + 1);
            append = '<option value="' + defaultSize + '" ';
            if (previewSetting.size == 0 && cookie) {
                append += 'selected';
                scalingSize_ = defaultSize;
            }
            append += '><%= Resources.Messages.EntireImageSizeCaption %></option>';
            $scanPageScalingList.append(append);

            append = '<option value="' + heightScaleSize + '" ';
            if (previewSetting.size == -1 || (!cookie && widthScaleSize < heightScaleSize)) {<%-- AR67831 --%>
                append += 'selected';
                scalingSize_ = heightScaleSize;
            }
            append += '><%= Resources.Messages.HeightImageSizeCaption %></option>';
            $scanPageScalingList.append(append);

            append = '<option value="' + widthScaleSize + '" ';
            if (previewSetting.size == -2 || (!cookie && heightScaleSize < widthScaleSize)) {<%-- AR67831 --%>
                append += 'selected';
                scalingSize_ = widthScaleSize;
            }
            append += '><%= Resources.Messages.WidthImageSizeCaption %></option>';
            $scanPageScalingList.append(append);

            $scanPageScalingList.change(function () {
                var selectVal = $("#scanPageScalingList option:selected").val();
                if (selectVal === 'scalling') {
                    return;
                }
                selectVal = Number(selectVal);
                if (selectVal === 400) {
                    expScaleFlg = false;
                    redScaleFlg = true;
                } else if (selectVal === 17) {
                    expScaleFlg = true;
                    redScaleFlg = false;
                } else {
                    expScaleFlg = true;
                    redScaleFlg = true;
                }
                showPreviewScaleButton(expScaleFlg, redScaleFlg);
                scalingSize_ = selectVal;
                onChangeScaling(scalingSize_);
            });
			<%-- 表示済み設問色づけのサイズ変更 --%> 
            onChangeScalingForQuestionColoring(scalingSize_);
            showPreviewScaleButton(true, true);
            $("#scanPageScalingList").xuxDropdown();
            $("#scanPageScalingList").xuxDropdown("refresh");
        }

		<%-- スキャン結果一覧で操作した内容（値、確認の変更）をDataTablesの実データに反映 --%>
        function onChangeScaling(scalingSize) {
            var scaleParam = scalingSize / 100;
            var $scanPageImage = $('#scanPageImage');
            $scanPageImage.css('-webkit-transform', 'scale(' + scaleParam + ')');
            $scanPageImage.css('-moz-transform', 'scale(' + scaleParam + ')');
            $scanPageImage.css('-o-transform', 'scale(' + scaleParam + ')');
            $scanPageImage.css('-ms-transform', 'scale(' + scaleParam + ')');
            $scanPageImage.css('transform', 'scale(' + scaleParam + ')');
            scaledScanPageImageWidth_ = scanPageInfo_[scanPageIndex_].width.toFixed(0) * scaleParam;
            scaledScanPageImageHeight_ = scanPageInfo_[scanPageIndex_].height.toFixed(0) * scaleParam;
		    <%-- 拡大・縮小前の画像の大きさ --%> 
            var pastPreviewImageSizeX = parseInt($('#scanPageImage').css('width').slice(0, -2), 10) * tmpScalingParam_;
            var pastPreviewImageSizeY = parseInt($('#scanPageImage').css('height').slice(0, -2), 10) * tmpScalingParam_;
		    <%-- プレビュー枠の大きさ --%> 
            var previewPanelSizeX = parseInt($('#scanPagePanel').css('width').slice(0, -2), 10);
            var previewPanelSizeY = parseInt($('#scanPagePanel').css('height').slice(0, -2), 10);

            if (pastPreviewImageSizeX + moveX_ < previewPanelSizeX / 2 ||
                pastPreviewImageSizeY + moveY_ < previewPanelSizeY / 2) {
		        <%-- プレビュー枠の中心に画像がなかった場合は、原点表示 --%> 
                moveX_ = moveY_ = 0;
            } else {
	            <%-- 前回の拡大・縮小率との比率を算出 --%> 
                var changeRatio = scaleParam / tmpScalingParam_;
	            <%-- 比率 * 移動距離 + (プレビュー枠の大きさ分を補正) --%> 
                moveX_ = (changeRatio * moveX_) + (previewPanelSizeX * (changeRatio - 1) / 2);
                moveY_ = (changeRatio * moveY_) + (previewPanelSizeY * (changeRatio - 1) / 2);
                if (moveX_ < 0) {
                    moveX_ = 0;
                } else {
	                <%-- プレビューの枠に画像(X方向)が収まる場合は、原点から表示 --%> 
                    var imageSizeX = parseInt($('#scanPageImage').css('width').slice(0, -2), 10) * scaleParam;
                    if (imageSizeX < previewPanelSizeX) moveX_ = 0;
                }
                if (moveY_ < 0) {
                    moveY_ = 0;
                } else {
                    <%-- プレビューの枠に画像(Y方向)が収まる場合は、原点から表示 --%> 
                    var imageSizeY = parseInt($('#scanPageImage').css('height').slice(0, -2), 10) * scaleParam;
                    if (imageSizeY < previewPanelSizeY) moveY_ = 0;
                }
            }
            $('#scanPagePanel').scrollLeft(moveX_).scrollTop(moveY_);
		    <%-- 次回の比率算出のため保存 --%> 
            tmpScalingParam_ = scaleParam;
			<%-- 表示済み設問色づけのサイズ変更 --%> 
            onChangeScalingForQuestionColoring(scalingSize);
        }

		<%-- 表示済み設問色づけのサイズ変更 --%>
        function onChangeScalingForQuestionColoring(scalingSize) {
            var scaleParam = scalingSize / 100;
			<%-- 表示済み設問色づけのサイズ変更 --%> 
            var $questionColoringBorder = $('#questionColoringBorder');
            var $questionColoringArea = $('#questionColoringArea');
            if (!$questionColoringBorder || !$questionColoringArea) {
                return;
            }
			<%-- 設問色づけdivタグ情報を作成 --%>
            $questionColoringBorder.css('top', (originalTop_ * scaleParam) + 'px');
            $questionColoringBorder.css('left', (originalLeft_ * scaleParam) + 'px');
            $questionColoringBorder.css('width', (originalWidth_ * scaleParam) + 'px');
            $questionColoringBorder.css('height', (originalHeight_ * scaleParam) + 'px');

            $questionColoringArea.css('top', (originalTop_ * scaleParam) + 'px');
            $questionColoringArea.css('left', (originalLeft_ * scaleParam) + 'px');
            $questionColoringArea.css('width', (originalWidth_ * scaleParam) + 'px');
            $questionColoringArea.css('height', (originalHeight_ * scaleParam) + 'px');
        }

		<%-- 設問色づけdivタグの表示 --%>
        function SetQuestionColoring(data, config) {
			<%-- 拡縮サイズの計算および変更前のサイズを保存 --%>
            var scaleParam = scalingSize_ / 100;
            originalLeft_ = data.positionX * 96 / 25.4;
            originalTop_ = data.positionY * 96 / 25.4;
            originalWidth_ = data.width * 96 / 25.4;
            originalHeight_ = data.height * 96 / 25.4;

	        <%-- 設問色づけdivタグ情報（線）を作成 --%>
            var $questionColoringBorder = $('<div id="questionColoringBorder" class="questionColoring" />')
                .css('top', (originalTop_ * scaleParam) + 'px')
                .css('left', (originalLeft_ * scaleParam) + 'px')
                .css('width', (originalWidth_ * scaleParam) + 'px')
                .css('height', (originalHeight_ * scaleParam) + 'px')
                .css('opacity', + config.borderOpacity)
                .css('border', '2px solid ' + config.borderColor);

	        <%-- 設問色づけdivタグ情報（塗りつぶし）を作成 --%>
            var $questionColoringArea = $('<div id="questionColoringArea" class="questionColoring" />')
                .css('top', (originalTop_ * scaleParam) + 'px')
                .css('left', (originalLeft_ * scaleParam) + 'px')
                .css('width', (originalWidth_ * scaleParam) + 'px')
                .css('height', (originalHeight_ * scaleParam) + 'px')
                .css('background-color', config.areaColor)
                .css('opacity', + config.areaOpacity)
                .css('padding', '2px');

		    <%-- 設問色づけdivタグの表示 --%>
            $('#scanPagePanel').append($questionColoringArea);
            $('#scanPagePanel').append($questionColoringBorder);
        }
        var isLoadtable = false;
 		<%-- スキャンページ情報取得 --%>
        function getScanPageInfo() {
            dispFormatLoading("<%= Resources.Messages.ProcessingMessage %>");
            if ($elementsTable_) {
                //$elementsTable_.clear();
                //$elementsTable_.columns.adjust();
                //$elementsTable_.draw();
            }
			<%-- POST対応 --%>
            var paramJobIds = [];
            paramJobIds.push(jobIds_[recordIndex_]);
            $.ajax({
                type: 'POST',
                url: 'api/ScanPageInfo',
                contentType: 'application/json',
                data: JSON.stringify({ jobId: paramJobIds, formId: formId_ }),
                success: function (data, dataType) {
                    scanPageInfo_ = data;
                    if (!scanPageInfo_ || scanPageInfo_.length === 0) {
                        $('#scanPageIndex').text(scanPageIndex_);
                        showPreviewScaleButton(false, false);
                        showPreviewPageButton(false, false);
                        removeLoading();
                        return;
                    }
                    $('#scanPageCount').text(scanPageInfo_.length);
                    scanPageIndex_ = 0;
                    if (scanPageInfo_.length >= 1) {
                        $("prevScanPageButtonEnable")
                    }
                    prevScanPageId = data[scanPageIndex_].scanPageId;
			    	<%-- スキャンページIDがundefinedの場合、セッションタイムアウトでログイン画面が返却されているためセッションタイムアウト処理を実施. --%>
                    if (typeof scanPageInfo_[0].scanPageId === "undefined") {
                        isParentClosed_ = true;
                        window.close();
                        return;
                    }
                    if (errScanPageId_ !== '') {
                        var scanPageInfoLength = scanPageInfo_.length;
                        for (var i = 0; i < scanPageInfoLength; i++) {
                            if (Number(errScanPageId_) === scanPageInfo_[i].scanPageId) {
                                scanPageIndex_ = i;
                                break;
                            }
                        }
                    }
                    loadScanPageImage();
					<%-- 初期データ読み込み --%>
                    isLoadtable = true;
                    loadTabData();
                    <%-- classで指定してもjquery-ui-1.11.2.min.cssに上書きされてしまうためこのタイミングで書き換える --%>
                    //$('.text-button, .applyButton, .cancelButton').css('padding-bottom', '8px').css('padding-top', '8px');
                }
            });
        }

		<%-- 画面表示設定の初期処理（Cookieから取得、無い場合は初期値使用) --%>
        function getConfig() {
            var config = $('#config').val();
            config = config !== '' ? JSON.parse(config) : {};

	        <%-- textareaのフォントサイズ --%>
            var fontSize = '<%= ConfigurationManager.AppSettings["ConfirmTextAreaFontSize"] %>';
            config.fontSize = checkFontSize(fontSize);

	        <%-- 塗りつぶし（色）ASPXで設定済 --%>

	        <%-- 塗りつぶし（透明度） --%>
            var areaOpacity = '<%= ConfigurationManager.AppSettings["ConfirmHighlightAreaOpacity"] %>';
            config.areaOpacity = checkHightlightOpacity(1, areaOpacity);

	        <%-- 線（色）ASPXで設定済 --%>

			<%-- 線（透明度） --%>
            var borderOpacity = '<%= ConfigurationManager.AppSettings["ConfirmHighlightBorderOpacity"] %>';
            config.borderOpacity = checkHightlightOpacity(2, borderOpacity);

			<%-- スキャン画像の表示(幅/高さ)の設定 --%>
            config.answerImageMaxWidth = '<%= ConfigurationManager.AppSettings["ConfirmAnswerImageMaxWidth"] %>';
            config.answerImageMaxHeight = '<%= ConfigurationManager.AppSettings["ConfirmAnswerImageMaxHeight"] %>';
            config.answerImageSentenceMaxWidth = '<%= ConfigurationManager.AppSettings["ConfirmAnswerSentenceImageMaxWidth"] %>';
            config.answerImageSentenceMaxHeight = '<%= ConfigurationManager.AppSettings["ConfirmAnswerSentenceImageMaxHeight"] %>';

            var answerImageSetting = getCookie(COOKIENAME_ANSWER_IMAGE_SETTING);
            if (answerImageSetting) {
                for (var i = 0; i < answerImageSetting.length; i++) {
                    var setting = answerImageSetting[i];
                    if (setting.user == userId_) {
                        if (setting.ai) {
                            if (setting.ai.width) config.answerImageMaxWidth = setting.ai.width;
                            if (setting.ai.height) config.answerImageMaxHeight = setting.ai.height;
                        }
                        if (setting.ais) {
                            if (setting.ais.width) config.answerImageSentenceMaxWidth = setting.ais.width;
                            if (setting.ais.height) config.answerImageSentenceMaxHeight = setting.ais.height;
                        }
                    }
                }
            }

            config.answerImageMaxWidth = checkAnswerImage(1, config.answerImageMaxWidth);
            config.answerImageMaxHeight = checkAnswerImage(2, config.answerImageMaxHeight);
            config.answerImageSentenceMaxWidth = checkAnswerImage(3, config.answerImageSentenceMaxWidth);
            config.answerImageSentenceMaxHeight = checkAnswerImage(4, config.answerImageSentenceMaxHeight);

            return config
        }

		<%-- 該当ページのプレビュー設定情報(倍率/位置)を取得する --%>
        function getPreviewSetting(page) {
            var result = { size: 0, x: 0, y: 0 };
            var previewSetting = getCookie(COOKIENAME_PREVIEW_SETTING);
            if (previewSetting) {
                var userId = userId_;
                for (var i = 0; i < previewSetting.length; i++) {
                    if (previewSetting[i].user == userId) {
                        var setting = previewSetting[i].setting;
                        for (var j = 0; j < setting.length; j++) {
                            if (setting[j].page == page) {
                                result.size = setting[j].size;
                                result.x = setting[j].x;
                                result.y = setting[j].y;
                            }
                        }
                    }
                }
            }
            return result;
        }

		<%-- 該当ページのプレビュー設定情報が存在するかチェックする --%>
        function isPreviewSetting(page) {
            var result = false;
            var previewSetting = getCookie(COOKIENAME_PREVIEW_SETTING);
            if (previewSetting) {
                var userId = userId_;
                for (var i = 0; i < previewSetting.length; i++) {
                    if (previewSetting[i].user == userId) {
                        var setting = previewSetting[i].setting;
                        for (var j = 0; j < setting.length; j++) {
                            if (setting[j].page == page) {
                                result = true;
                                break;
                            }
                        }
                    }
                    if (result) break;
                }
            }
            return result;
        }

		<%-- プレビュー設定情報(倍率/位置)を保存する --%>
        function setPreviewSetting() {
            var size;
            var page = scanPageIndex_ + 1;

            var sizeText = $("#scanPageScalingList option:selected").text();
            if (sizeText == '<%= Resources.Messages.EntireImageSizeCaption %>') {
                size = 0;
            } else if (sizeText == '<%= Resources.Messages.HeightImageSizeCaption%>') {
                size = -1;
            } else if (sizeText == '<%= Resources.Messages.WidthImageSizeCaption %>') {
                size = -2;
            } else {
                size = scalingSize_;
            }

            var previewSetting = getCookie(COOKIENAME_PREVIEW_SETTING);
            var userId = userId_;
            if (previewSetting) {
                var isExistedUser = false;
                for (var i = 0; i < previewSetting.length; i++) {
                    if (previewSetting[i].user == userId) {
                        isExistedUser = true;
                        var isExistedSetting = false;
                        for (var j = 0; j < previewSetting[i].setting.length; j++) {
                            if (previewSetting[i].setting[j].page == page) {
                                isExistedSetting = true;
                                previewSetting[i].setting[j].size = size;
                                previewSetting[i].setting[j].x = moveX_;
                                previewSetting[i].setting[j].y = moveY_;
                            }
                        }
                        if (!isExistedSetting) {
                            previewSetting[i].setting.push({ page: page, size: size, x: moveX_, y: moveY_ });
                        }
                    }
                }
                if (!isExistedUser) {
                    previewSetting.push({
                        user: userId,
                        setting: [{ page: page, size: size, x: moveX_, y: moveY_ }]
                    });
                }
            } else {
                previewSetting = [
                    {
                        user: userId,
                        setting: [{ page: page, size: size, x: moveX_, y: moveY_ }]
                    }
                ];
            }
            setCookie(COOKIENAME_PREVIEW_SETTING, previewSetting);
        }

		<%-- スキャンページ読み込み --%>
        function loadScanPageImage() {
            if (!scanPageInfo_ || scanPageInfo_.length == 0) {
                return;
            }
            var imageWidth = scanPageInfo_[scanPageIndex_].width.toFixed(0);
            var imageHeight = scanPageInfo_[scanPageIndex_].height.toFixed(0);
            var widthScaleSize = ((Number($('#scanPagePanel').css('width').slice(0, -2)) - 20) / imageWidth).toFixed(2) * 100;
            var heightScaleSize = ((Number($('#scanPagePanel').css('height').slice(0, -2)) - 30) / imageHeight).toFixed(2) * 100;

            <%-- Cookieより設定情報を取得する --%>
            var previewSetting = getPreviewSetting(scanPageIndex_ + 1);

            <%-- 全体表示サイズを計測 --%>
            var defaultSize = 0;
            if (widthScaleSize > heightScaleSize) {
                defaultSize = heightScaleSize;
            } else {
                defaultSize = widthScaleSize;
            }

            <%-- 表示倍率設定 --%>
            var scaleParam = 0;
            if (previewSetting.size == 0) {
                <%-- AR67831 --%>
                if (isPreviewSetting(scanPageInfo_[scanPageIndex_].pageNumber)) {
                    <%-- Cookieあり --%>
                    scaleParam = defaultSize;
                } else {
                    <%-- Cookieなし --%>
                    if (widthScaleSize > heightScaleSize) {
                        scaleParam = widthScaleSize;
                    } else {
                        scaleParam = heightScaleSize;
                    }
                }
            } else if (previewSetting.size == -1) {
                scaleParam = heightScaleSize;
            } else if (previewSetting.size == -2) {
                scaleParam = widthScaleSize;
            } else {
                scaleParam = previewSetting.size;
            }
            scaleParam = tmpScalingParam_ = scaleParam / 100;
            scaledScanPageImageWidth_ = scanPageInfo_[scanPageIndex_].width.toFixed(0) * scaleParam;
            scaledScanPageImageHeight_ = scanPageInfo_[scanPageIndex_].height.toFixed(0) * scaleParam;

            <%-- 表示位置設定 --%>
            moveX_ = previewSetting.x;
            moveY_ = previewSetting.y;
            $('#scanPagePanel').scrollLeft(moveX_).scrollTop(moveY_);

            createScalingCombobox(defaultSize, heightScaleSize, widthScaleSize, previewSetting);
            var $scanPageImage = $('#scanPageImage');
            $scanPageImage.css('-webkit-transform', 'scale(' + scaleParam + ')');
            $scanPageImage.css('-moz-transform', 'scale(' + scaleParam + ')');
            $scanPageImage.css('-o-transform', 'scale(' + scaleParam + ')');
            $scanPageImage.css('-ms-transform', 'scale(' + scaleParam + ')');
            $scanPageImage.css('transform', 'scale(' + scaleParam + ')');
            $scanPageImage.bind('load', function () {
                var imageSizeX = parseInt($(this).css('width').slice(0, -2), 10) * scaleParam;
                var imageSizeY = parseInt($(this).css('height').slice(0, -2), 10) * scaleParam;
                <%-- 表示位置が無効な範囲の場合は原点表示 --%>
                if (imageSizeX < moveX_ || imageSizeY < moveY_) moveX_ = moveY_ = 0;
                $('#scanPagePanel').scrollLeft(moveX_).scrollTop(moveY_);

                if (!$('.scanPageArea').is(':hidden')) {
	                <%-- プレビュー閉じるボタンの幅、プレビュー枠のpadding・borderを考慮して、プレビュー閉じるボタンを移動--%>
                    previewSpaceWidth_ = (parseInt($('#previewVisibleDisable').css('width').slice(0, -2), 10) / 2) - (parseInt($('#scanPagePanel').css('padding-left').slice(0, -2), 10) * 2) - 2 - (parseInt($('.scanPagePanel').css('margin-left').slice(0, -2), 10) * 2);
                    changePreviewCloseBtnPosition(previewSpaceWidth_);
                    $('#previewVisibleDisable').show();
                }
            });
            $scanPageImage.attr('src', 'api/ScanPageImage?scanPageId=' + scanPageInfo_[scanPageIndex_].scanPageId);
            $('#scanPageIndex').text(1 + scanPageIndex_);
            var scanPageInfoLength = scanPageInfo_.length;
            if (scanPageInfoLength == 1) {
                prevScanPageFlg = false;
                nextScanPageFlg = false;
            } else {
                if (0 === scanPageIndex_) {
                    prevScanPageFlg = false;
                    nextScanPageFlg = true;
                } else if (scanPageIndex_ === scanPageInfoLength - 1) {
                    prevScanPageFlg = true;
                    nextScanPageFlg = false;
                } else {
                    prevScanPageFlg = true;
                    nextScanPageFlg = true;
                }
            }
            showPreviewPageButton(prevScanPageFlg, nextScanPageFlg);
        }

		<%-- タブ初期化 --%>
        function loadTabData() {
            removeQuestionColoring();
            elementRowsList_ = [];
            if (!scanPageInfo_ || scanPageInfo_.length == 0) {
                return;
            }
            //if ($elementsTable_) {
            //	$elementsTable_.clear();
            //	$elementsTable_.columns.adjust();
            //	$elementsTable_.draw();
            //}

            $("#recordId").text(jobIds_[recordIndex_]);

			<%-- スキャン結果一覧の表示 --%>
            $.ajax({
                type: 'GET',
                url: 'api/FormsFormatElementRows',
                data: { jobId: jobIds_[recordIndex_], formId: formId_ },
                dataType: "json",
                success: function (data, dataType) {
                    var dataLength = data.length;
                    for (var i = 0; i < dataLength; i++) {
                        var row = data[i];
				    	<%-- 業務レコードIDがundefinedの場合、セッションタイムアウトでログイン画面が返却されているためセッションタイムアウト処理を実施. --%>
                        if (typeof row.businessRecordId === "undefined") {
                            isParentClosed_ = true;
                            window.close();
                            return;
                        }
				    	<%-- 選択肢の場合は選択ステータスの値をbooleanに変換 --%>
                        if (row.elementType === 3) {
                            row.elementValue = row.elementValue === 'True';
                        } else if (row.elementType === 1 || row.elementType === 4 || row.elementType === 5) {
                            row.elementValue = doSanitaizeEncode(row.elementValue);
                        }

                        aoData[row.elementImageId] = {
                            _aFilterData: [row.elementName, row.subElementName, "", row.elementValue, row.isVerified]
                        };
                    }

                    elementRowsList_ = data;
					<%-- DataTablesを一旦クリアし、取得したデータを設定 --%>
					//$elementsTable_.clear().rows.add(data);
					<%-- DataTablesのカラム幅調整 --%>
					//$elementsTable_.columns.adjust();
					<%-- DataTablesの描画 --%>
                    //$elementsTable_.draw();
                    if (DataTableOptions == null) {
                        renderTable(data);
                    } else {
                        var sorttable = toggleRecordSort($elementsTable_, 2, DataTableOptions.sortOptions.order, null);
                        var tampDatATable = searchTable(DataTableOptions, elementRowsList_);
                        renderTable(tampDatATable);
                    }
                    

					<%-- 行選択 --%>
                    if (prevData_ != null && 0 < prevData_.length) {
                        var prevIndex = -1;
                        //for(var i = 0; i < prevData_.length; i++) {
                        //    if (prevData_[i].elementDataId == selectedElementDataId_) {
                        //        prevIndex = i;
                        //        break;
                        //    }
                        //}
                        //if (prevIndex != -1) {
                        //    var currentData_ = $('#elementsTable').DataTable().rows({filter: 'applied'}).data();
                        //    if (0 < currentData_.length) {
                        //        var targetRowIndex = -1;
                        //        for(var i = prevIndex; 0 <= i; i--) {
                        //            for (var j = 0; j < currentData_.length; j++) {
                        //                if (prevData_[i].elementDataId == currentData_[j].elementDataId) {
                        //                    targetRowIndex = j;
                        //                    break;
                        //                }
                        //            }
                        //            if (targetRowIndex != -1) {
                        //                var $oTable = $('#elementsTable').dataTable();
                        //                if ($oTable != null) {
                        //                    $oTable.find('tbody tr:nth-child(' + (targetRowIndex + 1) + ')').click();
                        //                }
                        //                break;
                        //            }
                        //        }
                        //    }
                        //}
                    }
                }
            });
        }

        var messageConfirmExportData_ = '<%= Resources.Messages.ConfirmExportDataMessage %>';
        var messageConfirmExportDataAndDelete_ = '<%= Resources.Messages.ConfirmExportDataAndDeleteMessage %>';
        var titleConfirmEndFormat_ = '<%= Resources.Messages.ConfirmEndFormatTitle %>';
        var isExportCsv_ = '<%= expUtil.IsSetExportData() %>' == 'True';
        var isDelete_ = '<%= expUtil.IsSetDeleteAfter() %>' == 'True';
        var remainRecordIds_ = null;

		<%-- 画面初期処理 --%>
        $(function () {
            userId_ = $('#userId').val();
            jobIds_ = $('#businessRecordIds').val().split(',');
            formId_ = $('#formId').val();
            formName_ = $('#formName').val();
            errElementId_ = $('#errElementId').val();
            errScanPageId_ = $('#errScanPageId').val();
            businessId_ = $('#businessId').val();
            $("input[type=checkbox]").xuxCheckbox();
            $("input[type=button]").xuxButton();
            $("#configDialog").xuxModalWindow({});
           
            var windowHeight_ = window.innerHeight - 210;<%-- 画面上部の高さ - フッターのコピーライト分を減算 --%>
            if (windowHeight_ < 100) {
                windowHeight_ = 450;
            }

            var scanImageAreaHeight_ = window.innerHeight - 180;<%-- 画面上部の高さ - フッターのコピーライト分を減算 --%>
            if (scanImageAreaHeight_ < 450) {
                scanImageAreaHeight_ = 450;
            }

            $('#scanPagePanel').css('height', scanImageAreaHeight_);

            scanPagePanelWidth_ = parseInt($('#scanPagePanel').css('width').slice(0, -2), 10);
            scanPagePanelHeight_ = parseInt($('#scanPagePanel').css('height').slice(0, -2), 10);

			<%-- レコード数の表示 --%>
            $('.currentRecordCount').text(recordIndex_ + 1);
            $('.maxRecordCount').text(jobIds_.length);
            prevRecordPageFlg = false;
            nextRecordPageFlg = jobIds_.length === 1 ? false : true;
            showRecordPageButton(prevRecordPageFlg, nextRecordPageFlg);

			<%-- ajaxの初期化 --%>
            $.ajaxSetup({
                cache: false,
                global: false,
                error: function (XMLHttpRequest, textStatus, errorThrown) {
                    if (XMLHttpRequest.status == 200) {
                        timeout();
                        return;
                    }
                    alertMessageEror('<%= Resources.Messages.AjaxErrorMessage %>');
                    isUpdating_ = false;
                    removeLoading();
                }
            });

            getScanPageInfo();

            var config = getConfig();

			<%-- スキャン結果一覧のヘッダー部に表示する項目名の定義 --%>
            var DataTableColumns = [
				<%-- 設問名 --%>
                { title: '<%= Resources.Messages.ElementNameColumnName %>', data: 'elementName', orderable: false, searchable: false, sortable: false, width: TABLE_WIDTH_QUESTION + 'px' },
				<%-- スキャン画像／認識結果 --%>
                { title: '<span id="tabTitleScan"><%= Resources.Messages.ScanImageRecognitionResulsColumnName %></span>', data: 'elementImageId', orderable: false, searchable: false, sortable: false },
				<%-- 確認チェックボックス --%>
                { title: '<span class="FilterDialog"><%= Resources.Messages.VerifiedColumnName %></span>&nbsp;<input id="allVerifiedCheckBox" type="checkbox" class="confirmCheckBox">', data: 'isVerified', orderable: false, width: TABLE_WIDTH_CONFIRM + 'px' }
            ];

			<%-- 各ヘッダー部に表示する項目名のインデックス --%>
            var ElementImageIdIndex = indexOf(DataTableColumns, function (c) { return c.data === 'elementImageId'; });
            var ElementValueIndex = indexOf(DataTableColumns, function (c) { return c.data === 'elementValue'; });
            var SelectStatusIndex = indexOf(DataTableColumns, function (c) { return c.data === 'selectStatus'; });
            var VerifiedIndex = indexOf(DataTableColumns, function (c) { return c.data === 'isVerified'; });

			<%-- スキャン結果一覧で操作した内容（値、確認の変更）をDataTablesの実データに反映 --%>
            function updateInnerValue(rowIndex, valueIndex, value) {
                aoData[rowIndex]._aFilterData[valueIndex] = value;
                aoData[rowIndex]._aFilterData[valueIndex + 1] = value;
            }
            function searchFormatTable(tempDataTableOptions, tempElementTableDataList) {

                //var returnRow = [];
                var tempRow = [];
                var elementTableDataList = tempElementTableDataList;
                var isSearchTable = false;
                for (var i = 0; i < tempDataTableOptions.columns.length; i++) {

                    if (tempDataTableOptions.columns[i].searchTableFilters != "") {
                        tempRow = [];
                        isSearchTable = true;
                        for (var k = 0; k < elementTableDataList.length; k++) {
                            var keyTemp = tempDataTableOptions.columns[i].searchTableFilters.split("|");
                            for (var j = 0; j < keyTemp.length; j++) {
                                if (keyTemp[j] != "") {
                                    var re = new RegExp(keyTemp[j], "g");
                                    var columnsText = elementTableDataList[k][tempDataTableOptions.columns[i].field];
                                    if (re.test(columnsText)) {
                                        tempRow.push(elementTableDataList[k]);
                                    }
                                }

                            }

                        }
                    }
                    if (i == tempDataTableOptions.columns.length - 1) {
                        if (isSearchTable) {
                            elementTableDataList = tempRow;
                        }
                    } else if (tempRow.length >= 0 && i < tempDataTableOptions.columns.length) {
                        if (isSearchTable) {
                            elementTableDataList = null;
                            elementTableDataList = tempRow;
                        }

                    }
                }

                return elementTableDataList;
            }
            var initFlag = true;
			<%-- DataTablesオプションの定義 --%>
            //-----------------------2021/08/23 add begin--------------------------//
            
            var selectelementImageId = "";
            var searchDisplayItems = null;
            renderTable = function (displayItems) {
                searchDisplayItems = displayItems;
               
                <%-- DataTablesオプションの定義 --%>
                if (DataTableOptions == null) {
                    createJobTable();
                    DataTableOptions = {
                        data: function (params) {
                            return {
                                //"numberOfAllItems": searchDisplayItems.length,
                                "fields": getTableFields(),
                                "items": searchDisplayItems
                            }
                        },
                        columns: getTableTbody(displayItems),
                        pageNavigation: 'none',
                        columnResizable: false,
                        focusUnit: "none",
                        scrollY: windowHeight_ + "px",
                        //size: 'full',
                        horizontalLayout: "center",
                        hoverState: true,
                        autoLoad: true,
                        labelLayout: 'leading',
                        selectionUnit: 'row',
                        selectionRemains: true,
                        itemId: 'elementImageId',
                        height: "500px",
                        pageNumbers: false,
                        //itemsPerPage: 200,
                        //dropdown: true,
                        //itemNumbers: true,
                        //pagesPerLoad: 10,
                        //itemsPerPageChoices: [5, 10, 20, 50, 100, 200],
                        clear: true,
                        sortOptions: {
                            column: 2,
                            order: ''
                        },
                        multipleSelections: false,
                        //search: true,
                        noRowMessage: '<%= Resources.Messages.DataTableZeroRecordsMessage %>',
                        afterRender: function () {

                            var trTemp = 0;

                            $("#elementsTable").find("tr").each(function () {
                                trTemp = trTemp + $(this).height();
                                if ($(this).find("td").first().find('input').first().val() == selectelementImageId) {
                                    $(this).addClass("xux-table-selected");
                                }
                            });
                            selectelementImageId = "";
                            //if (trTemp < 740) {
                            //    $("#elementsTable").find("tbody").first().css("width", "calc( 100% - 1em )");
                            //}
                            let elementsTableHeight = Number($("#scanPagePanel").css("height").slice(0,-2)) - $("#elementsTable>thead").outerHeight(true)
							if(elementsTableHeight < 450){
								elementsTableHeight=450 - $("#elementsTable>thead").outerHeight(true)
							}
							$('#elementsTable').find("tbody").first().css("height", elementsTableHeight +"px" )
                            $("#elementsTableDiv").find(".xux-decoratedTable-trailingBox").eq(1).css("display", "none");
                            $("#dialog-confirm").xuxModalWindow({});
                            $("#columnPopup").xuxModalWindow({});
                            //$('.FilterDialog').unbind("click");
                            //$('.FilterDialog').click(function () {
                            //    var clickColumn = parseInt($(this).attr("columnindex"));
                            //    var columnDef = DataTableOptions.columns[clickColumn];
                            //    if (columnDef.sortable === false) {
                            //        return;
                            //    }
                            //    if (columnDef.sortable !== false) {

                            //    }


                            //    if (DataTableOptions.columns[clickColumn].searchTableColumnDirection == "asc") {
                            //        toggleQuestionSort($elementsTable_, clickColumn, 'desc');
                            //    } else if (DataTableOptions.columns[clickColumn].searchTableColumnDirection == "") {
                            //        toggleQuestionSort($elementsTable_, clickColumn, 'asc');
                            //    } else {
                            //        toggleQuestionSort($elementsTable_, clickColumn, 'asc');
                            //    }
                            //    //clickHeaderCell = $(this).attr("columnindex");
                            //    //clickHeaderCellWidth = $(this).width() + 30;
                            //    //createFilterDialog(-1, $(this));
                            //    $("#columnPopupTitel").html($(this).html());
                            //});
                            resetTableHeadercolor();
                            $("input[type=checkbox]").xuxCheckbox();

                            $("textarea").xuxTextArea();
                            $("input[type=button]").xuxButton();
                            $("#elementsTable").find("thead").first().css("padding", "0px");
                            $("#elementsTable").find("select").xuxDropdown();
                            if (allVerifiedCheckBoxValue != null) {
                                if (allVerifiedCheckBoxValue) {
                                    $("#allVerifiedCheckBox").prop("checked", true).xuxCheckbox("refresh");
                                }
                            }
                            $(".confirmTextArea").focus(function () {
                                var tempelementImageId = $(this).attr("elementImageId");
                                for (var i = 0; i < searchDisplayItems.length; i++) {
                                    if (searchDisplayItems[i].elementImageId == tempelementImageId) {
                                        selectRow(searchDisplayItems[i]);
                                        break;
                                    }

                                }
                                selectRowColor(tempelementImageId);

                            });

                            $("label[for=allVerifiedCheckBox]").css("position", "absolute");
                            $("label[for=allVerifiedCheckBox]").css("margin-left", "40px");
                            $("label[for=allVerifiedCheckBox]").css("margin-top", "-2px");
                            showSortFlag();
                            setAllSelectBox();
                            removeLoading();
                        },
                        select: function (event, ui) {
                            selectRow(ui.itemObject._data);
                            selectelementImageId = ui.itemObject._data.elementImageId;
                        }

                    };
                    clickHeaderCell = 2;
                    clickHeaderCellWidth = 66;
                    $elementsTable_ = $('#elementsTableDiv').xuxDecoratedTable(DataTableOptions);
                } else {
                    $('#elementsTableDiv').xuxDecoratedTable('reload');
                }
                
                
                $elementsTable_.order = function (tempSortOptions) {

                    if (tempSortOptions) {
                        DataTableOptions.sortOptions.column = tempSortOptions[0][0];
                        DataTableOptions.sortOptions.order = tempSortOptions[0][1];
                    } else {
                        if ($elementsTable_) {
                            return [[DataTableOptions.sortOptions.column, DataTableOptions.sortOptions.order]];
                        } else {
                            return null;
                        }

                    }
                }
            }

            function selectRowColor(tempelementImageId) {
                $("#elementsTable").find("tr").each(function () {
                    if ($(this).find("td").first().find('input').first().val() == tempelementImageId) {
                        $(this).addClass("xux-table-selected");
                        selectelementImageId = tempelementImageId;
                    } else {
                        $(this).removeClass("xux-table-selected");
                    }
                });
            }

            function setAllSelectBox() {
                var checkBoxCount = $("[name=VerifiedCheckBox]").length;
                var checkCount = 0;
                $("[name=VerifiedCheckBox]").each(function () {
                    var isChecked = $(this).is(':checked');
                    if (isChecked) {
                        checkCount++;
                    }

                });
                if (checkCount == checkBoxCount) {
                    $("#allVerifiedCheckBox").prop('checked', true).xuxCheckbox("refresh");;
                } else {
                    $("#allVerifiedCheckBox").prop('checked', false).xuxCheckbox("refresh");;
                }
            }

            function selectRow(uiData) {
                <%-- 表示済み設問色づけの削除 --%> 
                removeQuestionColoring();
                var aData = uiData;//$oTable.fnGetData(this);
                if (!aData) {
                    return;
                }
                SetQuestionColoring(aData, config);

				        <%-- 選択した設問が表示されている帳票イメージの切り替え --%>
                var selectScanPageIndex = 0, scanPageInfoLength = scanPageInfo_.length;
                for (var i = 0; i < scanPageInfoLength; i++) {
                    if (aData.scanPageId === scanPageInfo_[i].scanPageId) {
                        selectScanPageIndex = i;
                        break;
                    }
                }
                selectedElementDataId_ = aData.elementDataId;
				        <%-- 現在表示しているスキャンページと異なる場合は帳票イメージ切り替えを行う --%>
                if (selectScanPageIndex !== scanPageIndex_) {
                    setPreviewSetting();

                    scanPageIndex_ = selectScanPageIndex;
                    if (0 === scanPageIndex_) {
                        prevScanPageFlg = false;
                        nextScanPageFlg = true;
                    } else if (scanPageIndex_ === scanPageInfoLength - 1) {
                        prevScanPageFlg = true;
                        nextScanPageFlg = false;
                    } else {
                        prevScanPageFlg = true;
                        nextScanPageFlg = true;
                    }
                    loadScanPageImage();
                    showPreviewPageButton(prevScanPageFlg, nextScanPageFlg);
                }
            }
            function createFilterDialog(columnIndexTemp, obj) {

                sortFilterColumn_ = {};
                $filterDialogHeader_ = null;
                if (!elementRowsList_) {
                    return;
                }

                var $items = $('#columnPopupItems');
                $items.text('');

                var parentTag = obj;//$(this).parent().parent();
                sortFilterColumn_.search = function () { return ""; }//$elementsTable_.column(parentTag);
                var columnIndex = columnIndexTemp < 0 ? parentTag.attr("columnIndex") : columnIndexTemp;
                var columnDef = DataTableOptions.columns[columnIndex];
                $filterDialogHeader_ = $(this);

                var hasFunc = false;

				<%-- ソート機能が無効の場合はスキップ --%>
                if (columnDef.sortable === false) {
                    $("#columnPopup").xuxModalWindow("close");//$columnPopup.dialog('close');
                    //closeDiv($("#columnPopup"));
                    return;
                }

				<%-- ソート機能 --%>
            if (columnDef.sortable !== false) {
                   createRecordSort($items, $elementsTable_, columnIndex, '<%= Resources.Messages.SortDescCaption %>', '<%= Resources.Messages.SortAscCaption %>');
                    hasFunc = true;
                }

				<%-- フィルター機能 --%>
                var values = [];
                var isTypeSelect = false;
                if (columnDef.searchable !== false) {
                    values = $.map(elementRowsList_, function (n, i) {
                        return n[columnDef.field];//n[columnDef.data];
                    });
                    isTypeSelect = typeof (values[0]) === 'string';
                    values.sort();
                    values = $.map(values, function (n, i) { return '$' + doReplaceLineBreakToWhiteSpace(n); });
                    values = $.unique(values);

					<%-- すべて選択 --%>
                    var $allRows;
                    if (isTypeSelect) {
                        $allRows = $('<input id="' + FILTER_ALLROWS_ID + '" type="checkbox" />')
                            .change(function () {
                                if ($(this).is(':checked')) {
                                    $(FILTER_COND_CLASSNAME_SELECTOR).prop('checked', true);
                                } else {
                                    $(FILTER_COND_CLASSNAME_SELECTOR).prop('checked', false);
                                }
                            });
                    } else {
                        $allRows = $('<input id="' + FILTER_ALLROWS_ID + '" type="radio" name="' + FILTER_RADIO_GROUP_NAME + '" />');
                    }
                    var $allRowsDiv = $('<div class="columnPopupItem"></div>')
                        .append($allRows)
                        .append('<span style="padding: 0 0 0 8px;vertical-align: middle;position: relative;top: 1px;" class="ui-button-text"><%= Resources.Messages.AllRowsCaption %></span>');
                    $items
                        //.append($('<hr class="FilterDialogHr" />'))
                        //.append($('<br>'))
                        .append($allRowsDiv);

                    if (isTypeSelect) {
                	    <%-- 選択肢/一文字数値 --%>
                        var $blankCheckBox = $('<input type="checkbox" class="' + FILTER_COND_CLASSNAME + '" value="" />')
                            .change(function () {
                                changeCheckBox($(this), FILTER_ALLROWS_ID_SELECTOR, FILTER_COND_CLASSNAME_SELECTOR);
                            });
                        var $blankCheckBoxDiv = $('<div class="columnPopupItem" id="555555"></div>')
                            .append($blankCheckBox)
                            .append('<span style="padding: 0 0 0 8px;vertical-align: middle;position: relative;top: 1px;" class="ui-button-text"><%= Resources.Messages.BlankRowsCheckBoxCaption %></span>');
                        $items.append($blankCheckBoxDiv);

                        values = $.map(values, function (n, i) { return n.substring(1); });
                        var items = createItems(values, function (value) {
                            return value !== '' ? value : text;
                        }, FILTER_ALLROWS_ID_SELECTOR, FILTER_COND_CLASSNAME, FILTER_COND_CLASSNAME_SELECTOR);
                        $items.append(items);
                        hasFunc = true;
                    } else {
                        values = $.map(values, function (n, i) { return n === '$true'; });
                        var items = createConfirmRadioItems(values, function (value) {
                            return value ? '<%= Resources.Messages.CheckedCaption %>' : '<%= Resources.Messages.UncheckedCaption %>';
                        }, FILTER_COND_CLASSNAME, FILTER_RADIO_GROUP_NAME);
                        $items.append(items);
                        hasFunc = true;
                    }

                    var searchFilters = DataTableOptions.columns[columnIndex].searchTableFilters ? DataTableOptions.columns[columnIndex].searchTableFilters : "";
                    backupSearchFilter_ = DataTableOptions.columns[columnIndex].searchTableFilters ? DataTableOptions.columns[columnIndex].searchTableFilters : "";
                    $("input[type=radio]").xuxRadio();
                    if (isTypeSelect) {
                        defaultCheckSelect(searchFilters, FILTER_ALLROWS_ID_SELECTOR, FILTER_COND_CLASSNAME_SELECTOR);
                    } else {
                        if (searchFilters === '') {
                            $allRows.prop('checked', true).trigger('change');
                        } else {
                            var count = setFilterCheck(searchFilters, FILTER_COND_CLASSNAME_SELECTOR);
                            if (count === 0) {
                                $allRows.prop('checked', true).trigger('change');
                            }
                        }
                    }
                }
                
                if (!hasFunc) {
                    return;
                }

				<%-- フィルターダイアログのスクロール有無判定 --%>
                var filterDialogHeight = 'auto';
                if (isTypeSelect) {
                    var filterDialogMaxHeight = parseInt('<%= ConfigurationManager.AppSettings["FilterDialogMaxHeight"] %>', 10);
                    var FilterColumnHeight = 23;
                    var SortButtonHeight = 75;
                    if ((values.length + 1) * FilterColumnHeight + SortButtonHeight > filterDialogMaxHeight) {
                        var TitleAndOkButtonGroupHeight = 91;
                        filterDialogHeight = filterDialogMaxHeight + TitleAndOkButtonGroupHeight;
                    }
                }

                //$items.append($('<hr class="FilterDialogHr" />'))
                //$items.append($('<br>'))
                var columnPopupDiv = $("#columnPopupButtonDiv");
                $("#columnPopupButtonDiv").html("");
                var cancel = '<button type="button" class="cancle ModalWindowButton" id="filterDialogClose" style="width: 120px;"><%= Resources.Messages.CancelButtonCaption %></button>';
                columnPopupDiv.append($(cancel))
                columnPopupDiv.append("&nbsp;")
                var okstring = '<button type="button" class="ModalWindowButton" id="filterDialogOK" style="width: 120px;"><%= Resources.Messages.OkButtonCaption %></button>';
                columnPopupDiv.append($(okstring))
                $("#filterDialogOK").xuxButton();
                $("#filterDialogOK").xuxButton("option", "type", "default");
                $("input[type=radio]").xuxRadio();
                $("input[type=checkbox]").xuxCheckbox();
                $("input[type=button]").xuxButton();
                $("#filterDialogClose").xuxButton();
                resetTableHeadercolor();
                $("#columnPopup").xuxModalWindow("open");

                $("#filterDialogClose").click(function () {
                    $("#columnPopup").xuxModalWindow("close");
                    //closeDiv($("#columnPopup"));
                });

                $("#filterDialogOK").click(function () {
                    if ($("#sortAscButton").is(':checked')) {
                        DataTableOptions.sortOptions.column = columnIndex;
                        DataTableOptions.sortOptions.order = $("#sortAscButton").val()
                    }
                    if ($("#sortDescButton").is(':checked')) {
                        DataTableOptions.sortOptions.column = columnIndex;
                        DataTableOptions.sortOptions.order = $("#sortDescButton").val();
                    }
                    if ($(FILTER_ALLROWS_ID_SELECTOR).is(':checked')) {
                        //sortFilterColumn_.search('', true);
                        DataTableOptions.columns[columnIndex].searchTableFilters = "";
                        var sorttable = toggleRecordSort($elementsTable_, columnIndex, DataTableOptions.sortOptions.order, null);
                        var tempShowTable = searchTable(DataTableOptions, sorttable);
                        renderTable(tempShowTable);
                        config.filterToDate = null;
                        config.filterFromDate = null;
                        $filterDialogHeader_.removeClass('SortedFilterDialog');
                        $filterDialogHeader_.parent().parent().find(".xux-icon-funnel").first().css("color", '#1b8f98');
                    } else {
                        $filterDialogHeader_.addClass('SortedFilterDialog');
                        var filters = getFilter(FILTER_COND_CLASSNAME_SELECTOR);
                        if (filters && filters.length !== 0) {
                            //sortFilterColumn_.search(filters.join('|'), true, false, false);
                            DataTableOptions.columns[columnIndex].searchTableFilters = filters.join('|');
                        } else {
                            DataTableOptions.columns[columnIndex].searchTableFilters = "";//sortFilterColumn_.search(null, true);
                        }
                        var sorttable = toggleRecordSort($elementsTable_, columnIndex, DataTableOptions.sortOptions.order, null);
                        var tempShowTable = searchTable(DataTableOptions, sorttable);
                        renderTable(tempShowTable);
                    }
                    
                    $("#columnPopup").xuxModalWindow("close");
                    //closeDiv($("#columnPopup"));
                });
            }
            // ソート作成
            function createRecordSort($items, $elementsTable, columnIndex, textDesc, testAsc, isCanceledFunc, typeSearch) {
                $("#columnPopupSortButton").html("");
                $("#columnPopupSortButton").css("margin-left", "4px");
                var $sortDescButton = $('<input type="radio" id="sortDescButton"  class="sortDescRadio" value="desc" name="sortButtonGroupName" />');
                var tempsortDescButtonDiv = $('<div id="sortDescButtonDiv"></div>');
                tempsortDescButtonDiv.append($sortDescButton).append('<span style="padding: 0 0 0 8px;" class="ui-button-text">' + textDesc + '</span>');

                var $sortAscButton = $('<input  id="sortAscButton" class="sortAscRadio" type="radio"  value="asc" name="sortButtonGroupName"/>');
                var tempsortAscButtonDiv = $('<div id="sortAscButtonDiv"></div>');
                tempsortAscButtonDiv.append($sortAscButton).append('<span style="padding: 0 0 0 8px;" class="ui-button-text">' + testAsc + '</span>');
                $("#columnPopupSortButton").append(tempsortDescButtonDiv).append(tempsortAscButtonDiv);
                //$("#columnPopupSortButton")
                //    .append($('<div id="sortDescButtonDiv"></div>').append($sortDescButton).append('<span style="padding: 0 0 0 8px;" class="ui-button-text">' + textDesc + '</span>'))
                //    .append($('<div id="sortAscButtonDiv"></div>').append($sortAscButton).append('<span style="padding: 0 0 0 8px;" class="ui-button-text">' + testAsc + '</span>'));
                //$("#sortDescButtonDiv").xuxRadio();
                //$("#sortAscButtonDiv").xuxRadio();
                changeRecordSortButtonColor($elementsTable, columnIndex);
            }
            // ソートボタンの色を変更する
            function changeRecordSortButtonColor($elementsTable, columnIndex) {
                var enable = 'background: #d8d8d8 none repeat scroll 0 0 !important;';
                var disable = '';
                var sortConds = $elementsTable.order();
                if (sortConds != null && 0 < sortConds.length) {
                    if (sortConds[0].length == 2) {
                        if (sortConds[0][0] == columnIndex) {
                            if (sortConds[0][1] == 'desc') {
                                $(".sortDescRadio").prop('checked', true).trigger('change');
                                //$('#sortDescButton.ui-button').css({ 'cssText': enable });
                                //$('#sortAscButton.ui-button').css({ 'cssText': disable });
                            } else if (sortConds[0][1] == 'asc') {
                                $(".sortAscRadio").prop('checked', true).trigger('change');
                                //$('#sortDescButton.ui-button').css({ 'cssText': disable });
                                //$('#sortAscButton.ui-button').css({ 'cssText': enable });
                            }
                        }
                    }
                }
            }
            // ソート処理
            toggleRecordSort = function ($elementsTable, columnIndex, direction, isCanceledFunc, typeSearch) {
                if (typeSearch == "unknownFilter") {
                    clickUnknownHeaderCell = columnIndex;
                    UnknownDataTableOptions.columns[clickUnknownHeaderCell].searchTableColumnDirection = direction;
                } else {
                    DataTableOptions.columns[columnIndex].searchTableColumnDirection = direction;
                    clickHeaderCell = columnIndex;
                    if (columnIndex >= 2) {
                        clickHeaderCellWidth = $("#elementsTable").find("[columnindex=" + columnIndex + "]").first().width() + 8;
                    }

                }

                isClickFilter = true;
                if (isCanceledFunc != null) {
                    isCanceledFunc();
                }
                var tempDataTable = null;
                if (typeSearch == "unknownFilter") {
                    tempDataTable = unknownRowsList_;
                    saveUnknownSelectPageCount();
                } else {
                    tempDataTable = elementRowsList_;
                   
                }

                var tempkey = getTableFields();
                if (typeSearch == "unknownFilter") {
                    tempkey = ["UnknownFormId", "UnknownFormId", 'FormShortName', 'ErrorMessage', 'IpAddress', 'ScanDate'];
                } else {
                    tempkey = getTableFields();
                }

                var sortPatam = {
                    sortKey: tempkey[columnIndex],
                    sortOrder: direction
                };
                var tempSortTable = sortObjectData(tempDataTable, sortPatam);
                if (typeSearch == "unknownFilter") {
                    unknownRowsList_ = tempSortTable;
                } else {
                    elementRowsList_ = tempSortTable;
                }

                var sortConds = $elementsTable.order();
                var sortCondIndex = indexOf(sortConds, function (cond) { return cond[0] === columnIndex; });
                if (0 <= sortCondIndex) {
                    if (sortConds[sortCondIndex][1] === direction) {
                        sortConds.splice(sortCondIndex, 1);
                        if (sortConds.length === 0) {
                            sortConds[0] = [columnIndex, direction];
                        }
                    }
                    else {
                        sortConds[sortCondIndex][1] = direction;
                    }
                }
                else {
                    sortConds = [[columnIndex, direction]];
                }

                if (typeSearch == "unknownFilter") {
                    //searchRecordTable(UnknownDataTableOptions, tempSortTable, "unknownFilter");
                } else {
                    //searchRecordTable(DataTableOptions, tempSortTable);
                }

                $elementsTable.order(sortConds);
                return tempSortTable;
                //$elementsTable.columns.adjust().draw();

                //changeRecordSortButtonColor($elementsTable, columnIndex);
            }
            function getTableTbody(displayItems) {
                var tableBody = [];
                tableBody = [
                    createTableTbody(0, displayItems),
                    createTableTbody(1, displayItems),
                    createTableTbody(2, displayItems)
                ];
                $('#tabTitleScan').html('<%= Resources.Messages.ScanImageRecognitionResulsColumnName %>');
                return tableBody;
            }

            function createTableTbody(columnIndex, displayItems) {
                var tempColumnTable = {}
                if (columnIndex == 0) {
                    tempColumnTable = {
                        field: "elementName",
                       
                        render: function (td, item) {
                            var html = '<span>' + item._data.elementName + '</span>';
                            td.css("width", "100px");
                            td.attr("title", item._data.elementName);
                            $(html).appendTo(td);
                            var temp = '<input type="hidden" id="hidden"' + item._data.elementImageId + '" value="' + item._data.elementImageId + '">';
                            td.append(temp);
                        }
                    };
                } else if (columnIndex == 1) {
                    tempColumnTable = {
                        field: "elementImageId",
                        render: function (td, item) {
                            var elementImage;
                            var data = item._data;
                            scanTabWidth_ = parseInt($('#tabTitleScan').parent().parent().css('width').slice(0, -2), 10) - 20;<%-- 右端のスクロールバーの幅の分、ヘッダとデーブルの枠にズレが生じてしまうため20px程調整する --%>
                            var ansImgMaxWidth = scanTabWidth_ < config.answerImageMaxWidth ? scanTabWidth_ : config.answerImageMaxWidth;
                            var ansImgSenMaxWidth = scanTabWidth_ < config.answerImageSentenceMaxWidth ? scanTabWidth_ : config.answerImageSentenceMaxWidth;
                            if (item._data.elementType == 2 || data.elementType == 3) {
                                elementImage = $('<img class="thumb" />')
                                    .css('max-width', ansImgMaxWidth + 'px')
                                    .css('max-height', config.answerImageMaxHeight + 'px');
                            } else {
                                elementImage = $('<img class="thumbSentence" />')
                                    .css('max-width', ansImgSenMaxWidth + 'px')
                                    .css('max-height', config.answerImageSentenceMaxHeight + 'px');
                            }
                            elementImage.attr('src', 'api/AnswerImage?elementImageId=' + data.elementImageId);

                            $(elementImage).appendTo(td);

                            // 値
                            var elementValueEdit, backupValue, i;
                            switch (data.elementType) {
						        // 自由入力、分割文字
                                case 1:
                                case 5:
                                    var sanitaizedValue = doSanitaizeDecode(data.elementValue);
                                    elementValueEdit = $('<textarea selectFlag="true" elementImageId="' + data.elementImageId +'" class="inputValue confirmTextArea" rows="' + getRowCount(config.fontSize) + '" maxlength="' + freeEntryMaxLength_ + '" />')
                                        .css("font-size", config.fontSize)
                                        .val(sanitaizedValue)
                                        .change(function () {
                                            data.elementValue = $(this).val();
                                            updateInnerValue(data.elementImageId, 3, data.elementValue);
                                            data.isChanged = true;
                                        });
                                    backupValue = $('<input type="hidden" class="backupValue" />').
                                        val(sanitaizedValue);
                                    $(elementImage).appendTo(td);
                                    $('</br>').appendTo(td);
                                    var temptextDiv = $('<div class="textareaTemp"/>');
                                    $(elementValueEdit).appendTo(temptextDiv)
                                    $(temptextDiv).appendTo(td);
                                    break;
                                <%-- 1文字数値 --%>
                                case 2:
                                    elementValueEdit = $('<select selectFlag="true" id="select' + data.elementImageId+'"></select>');
                                    elementValueEdit.append($('<option>').html('').val(''));
                                    var isSetEmpty = false;
                                    var elementValue = data.elementValue;
                                    for (i = 0; i <= 9; i++) {
                                        elementValueEdit.append($('<option>').html(i).val(i));
                                        if (elementValue == i) {
                                            isSetEmpty = true;
                                        }
                                    }
                                    if (isSetEmpty) {
                                        elementValueEdit.val(elementValue);
                                    } else {
                                        elementValueEdit.val('');
                                    }
                                    elementValueEdit
                                        .change(function () {
                                            data.elementValue = $(this).children(':selected').val();
                                            updateInnerValue(data.elementImageId, ElementValueIndex, data.elementValue);
                                            data.isChanged = true;
                                            selectRowColor(data.elementImageId);
                                        });
                                    td.append(elementImage)
                                        .append('<br />')
                                        .append(elementValueEdit);
                                    break;
                                <%-- 選択肢 --%>
                                case 3:
                                    elementValueEdit = $('<input selectFlag="true" type="checkbox" class="confirmCheckBox" />')
                                        .prop('checked', data.elementValue)
                                        .change(function () {
                                            data.elementValue = $(this).is(':checked');
                                            updateInnerValue(data.elementImageId, SelectStatusIndex, data.elementValue.toString());
                                            data.isChanged = true;
                                            selectRowColor(data.elementImageId);
                                        });
                                    td.append(elementImage)
                                        .append('<br />')
                                        .append(elementValueEdit)
                                        .append(data.subElementName);
                                    break;
                                <%-- 分割文字 --%>
                                case 4:
                                    elementValueEdit = $('<textarea selectFlag="true" class="confirmTextArea" rows="' + getRowCount(config.fontSize) + '" maxlength="' + freeEntryMaxLength_ + '" />')
                                        .css("font-size", config.fontSize)
                                        .val(doSanitaizeDecode(data.elementValue))
                                        .change(function () {
                                            data.elementValue = $(this).val();
                                            updateInnerValue(data.elementImageId, ElementValueIndex, data.elementValue);
                                            data.isChanged = true;
                                        });                                   
                                    td.append(elementImage)
                                        .append('<br />')
                                        .append(data.subElementName)
                                        .append(elementValueEdit);
                                    break;
                            }
                        }
                    };
                } else if (columnIndex == 2) {
                    tempColumnTable = {
                        field: "isVerified",
                        render: function (td, item) {
                            var data = item._data;
                               					                <%-- 確認チェックボックス --%>
                            var checkbox = $('<input selectFlag="true" type="checkbox" name="VerifiedCheckBox" class="confirmCheckBox" />')
                                .attr("checked", data.isVerified)
                                .change(function () {
                                    var isBeforeStatus = data.isVerified;
                                    var isChecked = $(this).is(":checked");
                                    data.isChanged = true;

                                    data.isVerified = isChecked;
                                    updateInnerValue(data.elementImageId, 4, isChecked);
                                    selectRowColor(data.elementImageId);
                                    setAllSelectBox();

                                });
                            var backupVerifiedValue = $('<input type="hidden" name="backupVerifiedValue" />')
                                .val(data.isVerified);
                            $(checkbox).appendTo(td);
                            td.css("width", "110px");
                            td.css("text-align", "center");
                            $(backupVerifiedValue).appendTo(td);
                        }
                    };
                }
                tempColumnTable.searchTableFilters = "";
                return tempColumnTable;
            }

            function getTableFields() {

                var tableFields = []
                tableFields = ["elementName", 'elementImageId', 'isVerified']
                return tableFields;
            }
            function showSortFlag() {
                setTimeout(function () {
             
                    if (clickHeaderCell != null) {
                        $(".FilterDialog").each(function () {
                            var columnindexTemp = $(this).attr("columnindex");
                            var tempPosition = "";
                            //var clickfilterCellWidth = $(this).width() + 58;
                            $(this).parent().parent().find(".xux-table-sort").remove();
                            if (DataTableOptions.columns[clickHeaderCell].searchTableColumnDirection == "desc") {
                                if (columnindexTemp == clickHeaderCell) {
                                    var sortTextTemp = '<span class="xux-table-sort" aria-hidden="true" style="margin-left: 90px;' + tempPosition + '"></span>';
                                    $(this).parent().parent().append(sortTextTemp);
                                    $(this).parent().parent().parent().attr("aria-sort", "descending");
                                    $(this).parent().parent().parent().removeClass("xux-table-sort-asc");
                                    $(this).parent().parent().parent().addClass("xux-table-sort-desc");
                                }
                            } else if (DataTableOptions.columns[clickHeaderCell].searchTableColumnDirection == "asc") {
                                if (columnindexTemp == clickHeaderCell) {
                                    var sortTextTemp = '<span class="xux-table-sort" aria-hidden="true" style="margin-left:90px;' + tempPosition + '"></span>';
                                    $(this).parent().parent().append(sortTextTemp);
                                    $(this).parent().parent().parent().attr("aria-sort", "ascending");
                                    $(this).parent().parent().parent().removeClass("xux-table-sort-desc");
                                    $(this).parent().parent().parent().addClass("xux-table-sort-asc");
                                }
                            }
                            //var tempFilter = $(this).parent().parent().find(".xux-icon-funnel");
                            //if (tempFilter.length <= 0) {
                            //    var filterTextTemp = '<span  class="xux-icon xux-icon-size-medium xux-icon-funnel" style="font-size: 16px;position: absolute;margin-top: 2px;margin-left: 10px"></span>';
                            //    $(this).parent().parent().append(filterTextTemp);
                            //}
                        });
                        //$('.xux-icon-funnel').click(function () {
                        //resetTableHeadercolor();
                        $('.headerRecord').click(function (event) {
                            
                            if (event.target.className == "xux-choice-icon" || event.target.className.indexOf("confirmCheckBox") >= 0) {
                                
                                return;
                            }
                           
                            
                            if (elementRowsList_) {
                                if (elementRowsList_ != null && elementRowsList_.length <= 0) {
                                    return;
                                }
                                var clickColumn = parseInt($(this).parent().find(".FilterDialog").first().attr("columnindex"));
                                //$(this).parent().parent().parent().first().css("background-color", '#B2B2B2');

                                var clickObj = $(this).find(".FilterDialog").first();
                                $("#columnPopup").xuxModalWindow("open");
                                createFilterDialog(clickColumn, clickObj);
                                //showDiv($("#columnPopup"), $("#columnPopupItems"), $(this), $("#elementsTableDiv"), 9999);
                               
                                $("#columnPopupTitel").html(clickObj.html());
                            }

                        });
                        resetTableHeadercolor();
                    }
                }, 0);
            }

            function createJobTable() {
                $("#elementsTableMasterDiv").html("");
                var filterTextConfirmTemp = '<span  class="xux-icon xux-icon-size-medium xux-icon-funnel" style="font-size: 16px;position: absolute;margin-left: 71px;"></span>';
                tempTable = '<div id="elementsTableDiv" style="padding-left: .4em;"><table id="elementsTable">' +
                    ' <thead>' +                       
                        '<th style="width:100px"><span columnIndex="0"><%= Resources.Messages.ElementNameColumnName %></span></th>' +
                        '<th><span columnIndex="1" id="tabTitleScan"><%= Resources.Messages.ScanImageRecognitionResulsColumnName %></span></th>' +
                    '<th  class="headerRecord" style="width:110px"><span style="position: absolute;margin-top: 1px;" columnIndex="2" class="FilterDialog"><%= Resources.Messages.VerifiedColumnName %></span><span class="boxSpan"></span>&nbsp;<input id="allVerifiedCheckBox"  data-checked="checked" type="checkbox" class="confirmCheckBox">' + filterTextConfirmTemp + '</th > ' +
                    '</thead>' +
                    '<tbody></tbody>' +
                    '       </table> </div>';
                $("#elementsTableMasterDiv").html(tempTable);
                <%-- 一括確認チェックボックス --%>
                $('#allVerifiedCheckBox').click(function (event) {


				    <%-- タブ切り替え時の初期化処理で発火しないようガード --%>
                    if (isChangeTab_) {
                        return;
                    }
                    if (!elementRowsList_ || elementRowsList_.length === 0) {
                        return;
                    }
                    var isChecked = $(this).is(':checked');
                    allVerifiedCheckBoxValue = isChecked;
                    $('#elementsTable').find('[name=VerifiedCheckBox]').prop('checked', isChecked).trigger('change');
                });
            }
            $("#selectFormClose").click(function () {
                $("#configDialog").xuxModalWindow("close");
            });
            $("#selectFormOK").click(function () {
                if (!isAliveSession()) return false;

                // 入力チェック
                if (!(checkSize('answerImageMaxWidth')
                    && checkSize('answerImageMaxHeight')
                    && checkSize('answerImageSentenceMaxWidth')
                    && checkSize('answerImageSentenceMaxHeight'))) {
                    return;
                }
                <%-- 再描画 --%>
                config.answerImageMaxWidth = $('#answerImageMaxWidth').val();
                config.answerImageMaxHeight = $('#answerImageMaxHeight').val();
                config.answerImageSentenceMaxWidth = $('#answerImageSentenceMaxWidth').val();
                config.answerImageSentenceMaxHeight = $('#answerImageSentenceMaxHeight').val();
                var ansImgMaxWidth = scanTabWidth_ < config.answerImageMaxWidth ? scanTabWidth_ : config.answerImageMaxWidth;
                var ansImgSenMaxWidth = scanTabWidth_ < config.answerImageSentenceMaxWidth ? scanTabWidth_ : config.answerImageSentenceMaxWidth;
                $('img.thumb').css('max-width', ansImgMaxWidth + 'px');
                $('img.thumb').css('max-height', config.answerImageMaxHeight + "px");
                $('img.thumbSentence').css('max-width', ansImgSenMaxWidth + 'px');
                $('img.thumbSentence').css('max-height', config.answerImageSentenceMaxHeight + "px");
                //$("#elementsTableDiv").xuxDecoratedTable('reload');
                <%-- Cookie保存 --%>
                var aiWidth = config.answerImageMaxWidth;
                var aiHeight = config.answerImageMaxHeight;
                var aisWidth = config.answerImageSentenceMaxWidth;
                var aisHeight = config.answerImageSentenceMaxHeight;
                var answerImageSetting = getCookie(COOKIENAME_ANSWER_IMAGE_SETTING);
                var userId = userId_;
                if (answerImageSetting) {
                    var isExistedUser = false;
                    for (var i = 0; i < answerImageSetting.length; i++) {
                        if (answerImageSetting[i].user == userId) {
                            isExistedUser = true;
                            answerImageSetting[i].ai.width = aiWidth;
                            answerImageSetting[i].ai.height = aiHeight;
                            answerImageSetting[i].ais.width = aisWidth;
                            answerImageSetting[i].ais.height = aisHeight;
                        }
                    }
                    if (!isExistedUser) {
                        answerImageSetting.push({
                            user: userId,
                            ai: { width: aiWidth, height: aiHeight },
                            ais: { width: aisWidth, height: aisHeight }
                        });
                    }
                } else {
                    answerImageSetting = [{
                        user: userId,
                        ai: { width: aiWidth, height: aiHeight },
                        ais: { width: aisWidth, height: aisHeight }
                    }];
                }
                setCookie(COOKIENAME_ANSWER_IMAGE_SETTING, answerImageSetting);
                $("#configDialog").xuxModalWindow("close");
            });
            // ソート作成
            function createQuestionSort($items, $elementsTable, columnIndex, textDesc, testAsc, isCanceledFunc) {
                var $sortDescButton = $('<input id="sortDescButton" type="button" value="' + textDesc + '" />')
                    .button()
                    .click(function () { toggleQuestionSort($elementsTable, columnIndex, 'desc', isCanceledFunc); });
                var $sortAscButton = $('<input class="sortAscButtonDiv" id="sortAscButton" type="button" value="' + testAsc + '" />')
                    .button()
                    .click(function () { toggleQuestionSort($elementsTable, columnIndex, 'asc', isCanceledFunc); });
                $items
                    .append($('<div></div>').append($sortDescButton))
                    .append($('<div></div>').append($sortAscButton));

                changeQuestionSortButtonColor($elementsTable, columnIndex);
            }
            // ソート処理
            function toggleQuestionSort($elementsTable, columnIndex, direction, isCanceledFunc) {
                DataTableOptions.columns[columnIndex].searchTableColumnDirection = direction;
                if (isCanceledFunc != null) {
                    isCanceledFunc();
                }

                var tempkey = getTableFields();

                var sortPatam = {
                    sortKey: tempkey[columnIndex],
                    sortOrder: direction
                };
                var tempSortTable = sortObjectData(elementRowsList_, sortPatam);
                elementRowsList_ = tempSortTable;

                var tempDataTable = searchTable(DataTableOptions, elementRowsList_);
               
                var sortConds = $elementsTable.order();
                var sortCondIndex = indexOf(sortConds, function (cond) { return cond[0] === columnIndex; });
                if (0 <= sortCondIndex) {
                    if (sortConds[sortCondIndex][1] === direction) {
                        sortConds.splice(sortCondIndex, 1);
                        if (sortConds.length === 0) {
                            sortConds[0] = [columnIndex, direction];
                        }
                    }
                    else {
                        sortConds[sortCondIndex][1] = direction;
                    }
                }
                else {
                    sortConds = [[columnIndex, direction]];
                }


                renderTable(tempDataTable);
                $elementsTable.order(sortConds);
                //$elementsTable.columns.adjust().draw();

                changeQuestionSortButtonColor($elementsTable, columnIndex);
            }
            // ソートボタンの色を変更する
            function changeQuestionSortButtonColor($elementsTable, columnIndex) {
                var enable = 'background: #d8d8d8 none repeat scroll 0 0 !important;';
                var disable = '';
                var sortConds = $elementsTable.order();
                if (sortConds != null && 0 < sortConds.length) {
                    if (sortConds[0].length == 2) {
                        if (sortConds[0][0] == columnIndex) {
                            if (sortConds[0][1] == 'desc') {
                                $('#sortDescButton.ui-button').css({ 'cssText': enable });
                                $('#sortAscButton.ui-button').css({ 'cssText': disable });
                            } else if (sortConds[0][1] == 'asc') {
                                $('#sortDescButton.ui-button').css({ 'cssText': disable });
                                $('#sortAscButton.ui-button').css({ 'cssText': enable });
                            }
                        }
                    }
                }
            }
            function createQuestionItems(values, convertCaption, idSelector, className, classNameSelector, inputName) {
                return $.map(values, function (value, index) {
                    if (value === '') {
                        return null;
                    }
                    var removeBRTag = value.replace(/<[Bb][rR]\/>/g, '');
                    var sanitaizeValue = doSanitaizeEncode(doSanitaizeDecode(removeBRTag));
                    var $checkbox = $('<input type="checkbox" class="' + className + '" value="' + sanitaizeValue + '" name="' + inputName + '" />')
                        .change(function () { changeCheckBox($(this), idSelector, classNameSelector); });
                    var showCheckText = convertCaption ? convertCaption(sanitaizeValue) : sanitaizeValue;
                    return $('<div class="columnPopupItem"></div>')
                        .append($checkbox)
                        .append('<span style="padding: 0 0 0 8px;vertical-align: middle;position: relative;top: 1px;" class="ui-button-text">' + showCheckText+'</span>');
                });
            }
            function resetTableHeadercolor() {
                $(".FilterDialog").each(function () {
                    var columnindexTemp = $(this).attr("columnindex");
                    if (DataTableOptions.columns[columnindexTemp].searchTableFilters == "") {
                        $(this).parent().parent().find(".xux-icon-funnel").first().css("color", '');
                        $(this).parent().parent().parent().first().css("background-color", '');
                    } else {
                        $(this).parent().parent().find(".xux-icon-funnel").first().css("color", '#1b8f98');
                        $(this).parent().parent().parent().first().css("background-color", '#B2B2B2');
                    }
                });
            }
			//-----------------------2021/08/23 add end--------------------------//
			<%-- DataTablesの作成 --%>
			//$elementsTable_ = $('#elementsTable').DataTable(DataTableOptions);

			<%-- フィルターダイアログ初期化 --%>
            var $columnPopup = $('#columnPopup').dialog({
                autoOpen: false,
                width: 'auto',
                height: 'auto',
                buttons: {
					'<%= Resources.Messages.OkButtonCaption %>': function () {
                        if ($(FILTER_ALLROWS_ID_SELECTOR).is(':checked')) {
                            sortFilterColumn_.search('', true);
                            config.filterToDate = null;
                            config.filterFromDate = null;
                            $filterDialogHeader_.removeClass('SortedFilterDialog');
                        } else {
                            $filterDialogHeader_.addClass('SortedFilterDialog');
                            var filters = getFilter(FILTER_COND_CLASSNAME_SELECTOR);
                            if (filters && filters.length !== 0) {
                                sortFilterColumn_.search(filters.join('|'), true, false, false);
                            } else {
                                sortFilterColumn_.search(null, true);
                            }
                        }

                        $elementsTable_.columns.adjust().draw();
                        $(this).dialog('close');
                    },
					'<%= Resources.Messages.CancelButtonCaption %>': function () {
                        $(this).dialog('close');
                    }
                },
                close: function (event) {
                }
            });
           
			<%-- イメージ切替(レコード変更) --%>
            function onChangeRecordPage() {
                scanPageIndex_ = 0;
                isChangeTab_ = true;
                var allVerifiedCheckBox = $('#allVerifiedCheckBox');
                if (allVerifiedCheckBox.is(':checked')) {
                    allVerifiedCheckBox.prop('checked', false).trigger('change');
                }
                isChangeTab_ = false;
                $("#columnPopup").xuxModalWindow("close");//$columnPopup.dialog('close');
                //closeDiv($("#columnPopup"));
                getScanPageInfo();
            }

			<%-- 前帳票表示ボタンイベント --%>
            $('.prevRecordButtonEnable').click(function () {
                if (0 < recordIndex_) {
                    if (isParentClosed_) window.close();

                    if (!isAliveSession()) return false;

                    var changedRows = getChangedElementRows();
                    if (0 < changedRows.length || isUpdating_) {
                       <%-- if (!confirm('<%= Resources.Messages.ConfirmDataChangedMessage %>')) {
                            return false;
                        }--%>
                        confirmMessageEror('<%= Resources.Messages.ConfirmDataChangedMessage %>', function () {
                            setPreviewSetting();

                            recordIndex_--;
                            $('.currentRecordCount').text(recordIndex_ + 1);
                            onChangeRecordPage();
                            nextRecordPageFlg = true;
                            prevRecordPageFlg = recordIndex_ === 0 ? false : true;
                            showRecordPageButton(prevRecordPageFlg, nextRecordPageFlg);
                        }, null, '<%= Resources.Messages.OkButtonCaption %>', '<%= Resources.Messages.CancelButtonCaption %>');
                    } else {
                        setPreviewSetting();

                        recordIndex_--;
                        $('.currentRecordCount').text(recordIndex_ + 1);
                        onChangeRecordPage();
                        nextRecordPageFlg = true;
                        prevRecordPageFlg = recordIndex_ === 0 ? false : true;
                        showRecordPageButton(prevRecordPageFlg, nextRecordPageFlg);
                    }

                  
                }
               

                return false;
            });

			<%-- 次帳票表示ボタンイベント --%>
            $('.nextRecordButtonEnable').click(function () {
                if (recordIndex_ < jobIds_.length - 1) {
                    if (isParentClosed_) window.close();

                    if (!isAliveSession()) return false;

                    var changedRows = getChangedElementRows();
                    if (0 < changedRows.length || isUpdating_) {
                       <%-- if (!confirm('<%= Resources.Messages.ConfirmDataChangedMessage %>')) {
                            return false;
                        }--%>
                        confirmMessageEror('<%= Resources.Messages.ConfirmDataChangedMessage %>', function () {
                            setPreviewSetting();

                            recordIndex_++;
                            $('.currentRecordCount').text(recordIndex_ + 1);
                            onChangeRecordPage();
                            prevRecordPageFlg = true;
                            nextRecordPageFlg = recordIndex_ === (jobIds_.length - 1) ? false : true;
                            showRecordPageButton(prevRecordPageFlg, nextRecordPageFlg);
                        }, null, '<%= Resources.Messages.OkButtonCaption %>', '<%= Resources.Messages.CancelButtonCaption %>');
                    } else {
                        setPreviewSetting();

                        recordIndex_++;
                        $('.currentRecordCount').text(recordIndex_ + 1);
                        onChangeRecordPage();
                        prevRecordPageFlg = true;
                        nextRecordPageFlg = recordIndex_ === (jobIds_.length - 1) ? false : true;
                        showRecordPageButton(prevRecordPageFlg, nextRecordPageFlg);
                    }

                  
                }
                

                return false;
            });

			<%-- イメージ切替(ページ変更) --%>
            function onChangeScanPage() {
                removeQuestionColoring();

                prevScanPageId = scanPageInfo_[scanPageIndex_].scanPageId;

                isChangeTab_ = true;
                var allVerifiedCheckBox = $('#allVerifiedCheckBox');
                if (allVerifiedCheckBox.is(':checked')) {
                    allVerifiedCheckBox.prop('checked', false).trigger('change');
                }
                isChangeTab_ = false;
                $("#columnPopup").xuxModalWindow("close");//$columnPopup.dialog('close');
                //closeDiv($("#columnPopup"));
                loadScanPageImage();
                //loadTabData();
            }

			<%-- 前ページ表示ボタン --%>
            $('#prevScanPageButtonEnable').click(function () {
                if (!scanPageInfo_ || scanPageInfo_.length == 0) {
                    return;
                }
                if (0 < scanPageIndex_) {
                    if (isParentClosed_) window.close();

                    setPreviewSetting();

                    scanPageIndex_--;
                    onChangeScanPage();
                    nextScanPageFlg = true;
                }
                prevScanPageFlg = scanPageIndex_ === 0 ? false : true;
                showPreviewPageButton(prevScanPageFlg, nextScanPageFlg);

                return false;
            });

			<%-- 次ページ表示ボタン --%>
            $('#nextScanPageButtonEnable').click(function () {
                if (!scanPageInfo_ || scanPageInfo_.length == 0) {
                    return;
                }
                if (scanPageIndex_ < scanPageInfo_.length - 1) {
                    if (isParentClosed_) window.close();

                    setPreviewSetting();

                    scanPageIndex_++;
                    onChangeScanPage();
                    prevScanPageFlg = true;
                }
                nextScanPageFlg = scanPageIndex_ === (scanPageInfo_.length - 1) ? false : true;
                showPreviewPageButton(prevScanPageFlg, nextScanPageFlg);

                return false;
            });

			<%-- 帳票イメージ拡大ボタン --%>
            $('#scanPageExpandButtonEnable').click(function () {
                var $scanPageScalingList = $('#scanPageScalingList');
                if (!$scanPageScalingList) {
                    return;
                }
                redScaleFlg = true;
                var selectVal = $scanPageScalingList.children('option:selected').val();
                var currentscalingSize = 0;
                if (selectVal !== 'scalling') {
                    currentscalingSize = Number(selectVal) + 10;
                } else {
                    currentscalingSize = scalingSize_ + 10;
                }
                if (currentscalingSize <= 400) {
                    scalingSize_ = currentscalingSize;
                    $scanPageScalingList.children('option[value=scalling]').prop('selected', true);
                    $('#scanPageScalingList').xuxDropdown().xuxDropdown('refresh');
                    onChangeScaling(scalingSize_);
                }
                expScaleFlg = currentscalingSize >= 400 ? false : true;
                showPreviewScaleButton(expScaleFlg, redScaleFlg);

                return false;
            });

			<%-- 帳票イメージ縮小ボタン --%>
            $('#scanPageReduceButtonEnable').click(function () {
                var $scanPageScalingList = $('#scanPageScalingList');
                if (!$scanPageScalingList) {
                    return;
                }
                expScaleFlg = true;
                var selectVal = $scanPageScalingList.children('option:selected').val();
                var currentscalingSize = 0;
                if (selectVal !== 'scalling') {
                    currentscalingSize = Number(selectVal) - 10;
                } else {
                    currentscalingSize = scalingSize_ - 10;
                }
                if (10 <= currentscalingSize) {
                    scalingSize_ = currentscalingSize;
                    $scanPageScalingList.children('option[value=scalling]').prop('selected', true);
                    $('#scanPageScalingList').xuxDropdown().xuxDropdown('refresh');
                    onChangeScaling(scalingSize_);
                }
                redScaleFlg = currentscalingSize <= 10 ? false : true;
                showPreviewScaleButton(expScaleFlg, redScaleFlg);

                return false;
            });

			<%-- 一括確認チェックボックス --%>
            $('#allVerifiedCheckBox').click(function () {
				<%-- タブ切り替え時の初期化処理で発火しないようガード --%>
                if (isChangeTab_) {
                    return;
                }
                if (!elementRowsList_ || elementRowsList_.length === 0) {
                    return;
                }
                var isChecked = $(this).is(':checked');
                $('#elementsTable').find('[name=VerifiedCheckBox]').prop('checked', isChecked).trigger('change');
            });

			<%-- 設問色づけ --%>
            $('#elementsTable_wrapper tbody').on('click', 'tr', function () {
				<%-- 表示済み設問色づけの削除 --%> 
                removeQuestionColoring();
                var $oTable = $('#elementsTable').dataTable();
				<%-- 選択済み行の背景色変更を削除 --%> 
                $($oTable.fnSettings().aoData).each(function () {
                    $(this.nTr).removeClass('row_selected').css('background-color', '').css('border', ''); <%-- AR68534 --%>
                });
                var aData = $oTable.fnGetData(this);
                if (!aData) {
                    return;
                }

                selectedElementDataId_ = aData.elementDataId;
                if (prevScanPageId != aData.scanPageId) {
                    for (var i = 0; i < scanPageInfo_.length; i++) {
                        if (scanPageInfo_[i].scanPageId == aData.scanPageId) {
                            setPreviewSetting();
                            scanPageIndex_ = i;
                            onChangeScanPage();
                            break;
                        }
                    }
                }

				<%-- 新たな選択行の背景色変更 --%> 
                $(this).addClass('row_selected').css('background-color', config.rowSelectColor).css('border', '2px solid ' + config.rowSelectBorderColor); <%-- AR68534 --%>

				<%-- 設問色づけdivタグの表示 --%>
                SetQuestionColoring(aData, config);
            });

			<%-- 確認訂正処理実行 --%>
            $('#applyButton, #applyButtonTop').click(function () {
                isLoadtable = false;
                tempData = elementRowsList_;
                allVerifiedCheckBoxValue = $("#allVerifiedCheckBox").is(':checked');
                if (isParentClosed_) window.close();
                var changedRows = getChangedElementRows();
                if (changedRows.length === 0)
                    return false;

                if (!chechInputMaxLength(changedRows, freeEntryMaxLength_)) {
                    alertMessageInfo('<%= string.Format(Resources.Messages.OverInputMaxLengthMessage, QuestionnaireConfirm.Util.RecordUtil.GetFreeEntryMaxLength()) %>');
                    return false;
                }
                var $applyButton = $('.applyButton');
                $applyButton.prop('disabled', true);

                dispFormatLoading("<%= Resources.Messages.ProcessingMessage %>");
                isUpdating_ = true;

				<%-- 排他チェック処理 --%>
                $.ajax({
                    type: 'GET',
                    url: 'api/UpdateExclusiveCheck',
                    data: { businessRecodeId: jobIds_[recordIndex_], lastUpdateDate: changedRows[0].lastUpdateDate, updateUserId: changedRows[0].updateUserId },
                    dataType: "json",
                    success: function (data, dataType) {
                        if (data !== 0 && data !== 1 && data !== 2) {
                            window.close();
                            return false;
                        }
                        if (data === 1) {
                            <%--if (!confirm('<%= Resources.Messages.OverwriteCofirmMessage %>')) {
                                isUpdating_ = false;
                                $applyButton.prop('disabled', false);
                                removeLoading();
                                return false;
                            }--%>
                            confirmMessageEror('<%= Resources.Messages.OverwriteCofirmMessage %>', function () {
                                var isExec = false; // CSV出力対象の場合はtrue
                                if (isExportCsv_) {
                                    // Web.configで出力するに設定されていた場合
                                    removeLoading();
                                    isExec = checkExportCsv(false, PostElementRows, timeout);
                                }
                                if (!isExec) {
                                    PostElementRows(false)
                                }
                            }, null, '<%= Resources.Messages.OkButtonCaption %>', '<%= Resources.Messages.CancelButtonCaption %>');
                            removeLoading();
                        } else if (data === 2) {
                            alertMessageInfo('<%= Resources.Messages.FailedToUpdateMsg %>');
                            isUpdating_ = false;
                            $applyButton.prop('disabled', false);
                            removeLoading();
                            return false;
                        } else if (data === 0) {
                            var isExec = false; // CSV出力対象の場合はtrue
                            if (isExportCsv_) {
                                // Web.configで出力するに設定されていた場合
                                removeLoading();
                                isExec = checkExportCsv(false, PostElementRows, timeout);
                            }
                            if (!isExec) {
                                isLoadtable = false;
                                PostElementRows(false)
                            }
                        }
                       
                        
                    },
                    error: function (XMLHttpRequest, textStatus, errorThrown) {
                        if (XMLHttpRequest.status == 200 || XMLHttpRequest.status == 401) {
                            removeLoading();
                            timeout();
                            return false;
                        }
                        alertMessageEror('<%= Resources.Messages.AjaxErrorMessage %>');
                        removeLoading();
                    },
                    complete: function (XMLHttpRequest, textStatus) {
                        isUpdating_ = false;
                        $applyButton.prop('disabled', false);
                    }
                });
                return false;
            });
            $("#dialog-confirm-ok").click(function () {
                $("#dialog-confirm").xuxModalWindow("close");
                PostElementRows(true);

            });
            $("#dialog-confirm-close").click(function () {
                isUpdating_ = false;
                $("#dialog-confirm").xuxModalWindow("close");
            });
            function PostElementRows(doExportCsv) {
                dispFormatLoading("<%= Resources.Messages.ProcessingMessage %>");
                isUpdating_ = true;

                var doExportCsv = doExportCsv === undefined ? false : doExportCsv;
                var elementRows = getChangedElementRows();
		        <%-- 更新処理 --%>
                $.ajax({
                    type: 'POST',
                    url: 'api/FormsFormatElementRows',
                    contentType: 'application/json',
                    data: JSON.stringify({ formId: formId_, formName: formName_, userId: userId_, elementRows: elementRows, isExportCsv: doExportCsv }),
                    success: function (data, dataType) {
                        isUpdating_ = false;
                        var remainList = data != null ? data.RemainList : null;
                        var failList = data != null ? data.FailList : null;
                        if (failList != null && 0 < failList.length) {
                            // CSV出力に失敗したレコードがある場合は通知
                            alertMessageInfo('<%= Resources.Messages.ConfirmExportDataFailMessage %>' + "\r\n" + failList.join("\r\n"));
                        }
                        remainRecordIds_ = remainList;
                        if (remainRecordIds_ == null || remainRecordIds_.length == 0) {
                            // 表示レコードなし
                            windowGlobal.unbind('beforeunload');   // 警告を出さない。
                            window.open('about:blank', '_self').close();
                            return;
                        }
                        prevData_ = elementRowsList_;//prevData_ = $('#elementsTable').DataTable().rows({ filter: 'applied' }).data();

                        // レコードデータ出力（削除レコード対応）
                        // jobIds_ の順序は維持。
                        if (jobIds_.length > remainRecordIds_.length) {
                            var recordId = jobIds_[recordIndex_];
                            remainRecordIds_ = remainRecordIds_.map(function (element) { return String(element); });
                            var tmpIds = [];
                            for (var i = 0; i < jobIds_.length; i++) {
                                if (remainRecordIds_.indexOf(jobIds_[i]) >= 0) {
                                    tmpIds.push(jobIds_[i]);
                                }
                            }
                            jobIds_ = tmpIds;
                            recordIndex_ = jobIds_.indexOf(recordId);
                            if (recordIndex_ < 0) {
                                for (var i = 0; i < jobIds_.length; i++) {
                                    if (Number(jobIds_[i]) > Number(recordId)) {
                                        recordIndex_ = i;
                                        break;
                                    }
                                }
                                if (recordIndex_ < 0) {
                                    recordIndex_ = jobIds_.length - 1;
                                }
                            }
                            $('.currentRecordCount').text(recordIndex_ + 1);
                            $('.maxRecordCount').text(jobIds_.length);
                            prevRecordPageFlg = recordIndex_ === 0 ? false : true;
                            nextRecordPageFlg = recordIndex_ === (jobIds_.length - 1) ? false : true;
                            showRecordPageButton(prevRecordPageFlg, nextRecordPageFlg);
                            getScanPageInfo();
                           
                        }
                       
                        if (!isLoadtable) {
                            loadTabData();
                        }
                        isLoadtable = false;
                        removeLoading();
                        // レコード一覧に更新情報を反映
                        opener.NoticeConfirmCorrectUpdate();
                    },
                    error: function (XMLHttpRequest, textStatus, errorThrown) {
                        if (XMLHttpRequest.status == 401) {
                            removeLoading();
                            timeout();
                            return;
                        }
                        alertMessageEror('<%= Resources.Messages.FailedToUpdateMsg %>');
                        removeLoading();
                    }
                });
            }

            $('#colorMode, #bothSide, #layout').change(function () {
                ChangeSelect($(this));
            });

            $('#scanPagePanel').mousedown(function (e) {
                var $scanPagePanel = $('#scanPagePanel');
                $scanPagePanel.css('cursor', 'url(image/hand_drag_p24_24.png), url(image/hand_drag.cur), move');
                var bx = e.pageX;
                var by = e.pageY;
                $(document).on('mousemove.move', function (e) {
                    if (scaledScanPageImageWidth_ > scanPagePanelWidth_) {
                        moveX_ += bx - e.pageX;
                        bx = e.pageX;
                        if (moveX_ < 0) moveX_ = 0;
                        if (moveX_ > scaledScanPageImageWidth_ - scanPagePanelWidth_) moveX_ = scaledScanPageImageWidth_ - scanPagePanelWidth_;
                    }
                    if (scaledScanPageImageHeight_ > scanPagePanelHeight_) {
                        moveY_ += by - e.pageY;
                        by = e.pageY;
                        if (moveY_ < 0) moveY_ = 0;
                        if (moveY_ > scaledScanPageImageHeight_ - scanPagePanelHeight_) moveY_ = scaledScanPageImageHeight_ - scanPagePanelHeight_;
                    }

                    if (isBrowserChrome()) {
                        $scanPagePanel.css('overflow', 'auto').scrollLeft(moveX_).scrollTop(moveY_);
                        $scanPagePanel.css('overflow', 'hidden').scrollLeft();
                    } else {
                        $scanPagePanel.scrollLeft(moveX_).scrollTop(moveY_);
                    }
                    return false;
                }).one('mouseup', function () {
                    $scanPagePanel.css('cursor', 'url(image/hand_hover_p24_24.png), url(image/hand_hover.cur), move');
                    $(document).off('mousemove.move');
                });
                return false;
            })
                .hover(function () {
                    $(this).css('cursor', 'url(image/hand_hover_p24_24.png), url(image/hand_hover.cur), move');
                }, function () {
                    $(this).css('cursor', 'auto');
                });

			<%-- 表示設定ダイアログ初期化 --%>
           
			<%-- 表示設定入力チェック --%>
            function checkSize(name) {
                var $answerImageMax = $('#' + name);

                var val = $answerImageMax.val();
                if (val === '') {
                    alertMessageInfo("<%= Resources.Messages.DiscrepancyAnswerImageNotInput %>");
                    return;
                }
                var regexp = new RegExp(/^[1-9][0-9]*$/);
                var isInputError = false;
                if (!val.match(regexp)) {
                    isInputError = true;
                }
                var limitSize = new Number('<%= ConfigurationManager.AppSettings["AnswerImageSizeMaxLimit"] %>');
                if (isInputError || val > limitSize) {
                    var alertMsg = "<%= Resources.Messages.DiscrepancyAnswerImageSize %>";
                    alertMessageInfo(alertMsg.replace("_MAX_", limitSize));
                    return false;
                }
                return true;
            }

            $('#configButton').click(function () {
                if (!isAliveSession()) return false;

                $('#answerImageMaxWidth').val(config.answerImageMaxWidth);
                $('#answerImageMaxHeight').val(config.answerImageMaxHeight);
                $('#answerImageSentenceMaxWidth').val(config.answerImageSentenceMaxWidth);
                $('#answerImageSentenceMaxHeight').val(config.answerImageSentenceMaxHeight);
                $("input[type=text]").xuxTextField();
                $("#configDialog").xuxModalWindow("open");//$configDialog.dialog('open');
            });
            $('#cancelButton, #cancelButtonTop').unbind("click");
            $('#cancelButton, #cancelButtonTop').click(function () {
               window.close();
            });

            <%-- セッションチェック --%>
            function isAliveSession() {
                var result = false;
                $.ajax({
                    type: 'GET',
                    url: 'api/QuestionnaireFormatElementRows',
                    async: false,
                    success: function (data, dataType) {
                        if (data !== '0' && data !== '1') {
                            timeout();
                            return false;
                        }
                        result = true;
                        return true;
                    }
                    , error: function (XMLHttpRequest, textStatus, errorThrown) {
                        if (XMLHttpRequest.status == 200) {
                            timeout();
                            return false;
                        }
                    }
                });
                return result;
            }

            $('#previewVisible').click(function () {
                if ($('.scanPageArea').is(':hidden')) {
                    $('.scanPageArea').show();
                    $('.areaSeparator').width(0);
                    $('#footerItemScanPage').show();
                    $('#headerItemTitle').css('width', '43%');
                    $('#footerItemSpace').hide();
                    $('#previewVisibleEnable').hide();
                    changePreviewCloseBtnPosition(previewSpaceWidth_);
                    $('#previewVisibleDisable').show();
                    <%-- レコードページング後にプレビュー枠を表示する際に、横幅に合わせる設定の場合画像が表示されないためここで再表示 --%>
                    loadScanPageImage();
                } else {
                    $('.scanPageArea').hide();
                    $('.areaSeparator').width(24);
                    $('#footerItemScanPage').hide();
                    var width = parseInt($('#headerItemTitleLabel').css('width').slice(0, -2), 10) + parseInt($('#recordId').css('width').slice(0, -2), 10);
                    $('#headerItemTitle').css('width', width);
                    $('#footerItemSpace').css('width', width);
                    $('#footerItemSpace').show();
                    $('#previewVisibleEnable').show();
                    $('#previewVisibleDisable').hide();
                }
                //$elementsTable_.columns.adjust().draw();
                return false;
            });


            $(window).resize(function () {
                <%-- プレビュー閉じるボタンの幅、プレビュー枠のpadding・borderを考慮して、プレビュー閉じるボタンを移動 --%>
                changePreviewCloseBtnPosition(previewSpaceWidth_);
                <%-- 画面のサイズによってスキャン画像の大きさを変更する --%>
                var tableWidth = parseInt($('#elementsTableDiv').css('width').slice(0, -2), 10);
                scanTabWidth_ = tableWidth - TABLE_WIDTH_QUESTION - TABLE_WIDTH_CONFIRM - 154;
                var ansImgMaxWidth = scanTabWidth_ < config.answerImageMaxWidth ? scanTabWidth_ : config.answerImageMaxWidth;
                var ansImgSenMaxWidth = scanTabWidth_ < config.answerImageSentenceMaxWidth ? scanTabWidth_ : config.answerImageSentenceMaxWidth;
                $('img.thumb').css('max-width', ansImgMaxWidth + 'px');
                $('img.thumbSentence').css('max-width', ansImgSenMaxWidth + 'px');
            });
        });
    </script>
    <script src="xux/xux-js/xux-gfocal-middle-light-3.1.0-alpha-06.min.js"></script>
    <script>
        xuxInitialize({
            prefix: "./xux/",
        });
       

    </script>
    <script src="xux/xux-js/xux-gfocal-middle-fujifilmbi-3.1.0-alpha-06.min.js"></script>
    <script src="js/jquery.cookie.js"></script>
    <script src="js/common.js?date=<%=DateTime.Now.ToString("yyyyMMddHHmmss")%>"></script>
    <script src="js/filter.js?date=<%=DateTime.Now.ToString("yyyyMMddHHmmss")%>"></script>
    <script>
        (function () {
            $("body").xuxPage();
            $("input[type=checkbox]").xuxCheckbox();
            $("input[type=button]").xuxButton();
   
        });
    
    </script>
</head>
<body style="min-height:100vh;">
    <div class="layoutFormat">

    
    <form runat="server" style="margin:  0 10px;">
        <asp:HiddenField ID="userId" runat="server" />
        <asp:HiddenField ID="businessId" runat="server" />
        <asp:HiddenField ID="businessRecordIds" runat="server" />
        <asp:HiddenField ID="formId" runat="server" />
        <asp:HiddenField ID="formName" runat="server" />
        <asp:HiddenField ID="config" runat="server" />
        <asp:HiddenField ID="errElementId" runat="server" />
        <asp:HiddenField ID="errScanPageId" runat="server" />

        <table id="headerItem">
            <tr>
                <td id="headerItemTitle">
                    <label id="headerItemTitleLabel"><%= Resources.Messages.ConfirmationWindowTitle %> - </label>
                    <span id="recordId"></span>
                </td>
                <td class="areaSeparator">&nbsp;</td>
                <td id="headerItemButton">
                    <div id="headerItemButtonLeft">
                        <%--<span class="va-middle">
                            <span class="currentRecordCount"></span>&nbsp;／&nbsp;<span class="maxRecordCount"></span>
                        </span>
                        <span class="prevRecordButton">
                            <button class="prevRecordButtonEnable va-middle" accesskey="3" title="Alt + 3">
                                <img src="image/cc_record_prev_e.png" /></button>
                            <button class="prevRecordButtonDisable va-middle" disabled="disabled"  title="Alt + 3">
                                <img src="image/cc_record_prev_d.png" /></button>
                        </span>
                        <span class="nextRecordButton">
                            <button class="nextRecordButtonEnable va-middle" accesskey="4" title="Alt + 4">
                                <img src="image/cc_record_next_e.png" /></button>
                            <button class="nextRecordButtonDisable va-middle" disabled="disabled"  title="Alt + 4">
                                <img src="image/cc_record_next_d.png" /></button>
                        </span> --%>
                       <input type="button" value="<%= Resources.Messages.ConfigButtonCaption %>"  id="configButton" />
                    </div>

                     <div id="headerItemButtonRight">
                        <input type="button" name="cancelButtonTop" id="cancelButtonTop" value="<%= Resources.Messages.CancelButtonCaption %>" />
                        <input type="button" class="applyButton" name="applyButtonTop" style="color:#fff;" id="applyButtonTop" value="<%= Resources.Messages.ApplyButtonCaption %>" />
                    </div> 
                </td>
            </tr>
        </table>
        <table id="mainContent" class="mainContent" cellspacing="0">
            <tr>
                <td class="scanPageArea">
                    <div id="scanPagePanel" class="scanPagePanel">
                        <img id="scanPageImage" class="scanPageImage" />
                    </div>
                </td>
                <%-- 帳票ページと一覧の間の隙間 --%>
                <td class="areaSeparator">
                    <span id="previewVisible">
                        <input type="image" id="previewVisibleEnable" src="image/cc_preview_open.png" style="display: none;" />
                        <input type="image" id="previewVisibleDisable" src="image/cc_preview_close.png" style="display: none;" />
                    </span>
                </td>
                <td class="scanRecordListArea">
                    <div id="elementsTableMasterDiv">
                        <div id="elementsTableDiv" >
                            <table id="elementsTable">
                                <thead id="elementsTableHeader">
                                    <th style="width: 100px"><span class="FilterDialog"><%= Resources.Messages.ElementNameColumnName %></span></th>
                                    <th><span id="tabTitleScan"><%= Resources.Messages.ElementImageColumnName %></span></th>
                                    <th style="width: 110px"><span class="FilterDialog"><%= Resources.Messages.VerifiedColumnName %></span>&nbsp;<input id="allVerifiedCheckBox" type="checkbox" class="confirmCheckBox"/></th>
                                </thead>
                                <tbody id="elementsTableBody"></tbody>
                            </table>
                        </div>
                    </div>

                </td>
            </tr>
            <tr>
                <td id="footerItemScanPage">
                    <span id="footerItemScanPageLeft">
                        <span id="scanPageScalingListSpan"></span>
                         <span id="scanPageReduceButton">
                            <button id="scanPageReduceButtonEnable" class="va-middle add-cursor" type="button">
                                <span class="xux-icon xux-icon-size-medium xux-icon-zoomout" style="font-size: 16px; position: relative;"></span>
                            </button>
                             
                            <button id="scanPageReduceButtonDisable" class="va-middle" disabled="disabled" >
                                <span class="xux-icon xux-icon-size-medium xux-icon-zoomout" style="font-size: 16px; position: relative;"></span>
                            </button>
                        </span>
                        <span id="scanPageExpandButton">
                            <button id="scanPageExpandButtonEnable" class="va-middle add-cursor" type="button">
                                <span class="xux-icon xux-icon-size-medium xux-icon-zoomin" style="font-size: 16px; position: relative;"></span>
                            </button>
                            <button id="scanPageExpandButtonDisable" class="va-middle" disabled="disabled">
                                <span class="xux-icon xux-icon-size-medium xux-icon-zoomin" style="font-size: 16px; position: relative;"></span>
                            </button>
                        </span>
                       
                    </span>
                    <span id="footerItemScanPageRight">

                        
                        <span id="prevScanPageButton">
                            <button id="prevScanPageButtonEnable" class="va-middle add-cursor" accesskey="1" title="Alt + 1">
                                <span class="xux-icon xux-icon-size-medium xux-icon-leftarrowhead" style="font-size: 16px; position: relative;" ></span>
                            </button>
                            <button id="prevScanPageButtonDisable" class="va-middle" disabled="disabled" title="Alt + 1">
                               <span class="xux-icon xux-icon-size-medium xux-icon-leftarrowhead" style="font-size: 16px; position: relative;color:#8c8c8c" ></span></button>
                        </span>
                        <span id="scanPageIndex"></span>
                        <span>/</span>
                        <span id="scanPageCount"></span>
                        <span id="nextScanPageButton">
                            <button id="nextScanPageButtonEnable" class="va-middle add-cursor" accesskey="2" title="Alt + 2">
                               <span class="xux-icon xux-icon-size-medium 	xux-icon-rightarrowhead" style="font-size: 16px; position: relative;" />
                               </button>
                            <button id="nextScanPageButtonDisable" class="va-middle" disabled="disabled" title="Alt + 2">
                                <span class="xux-icon xux-icon-size-medium 	xux-icon-rightarrowhead" style="font-size: 16px; position: relative;color:#8c8c8c "/></button>
                        </span>
                    </span>
                </td>
                <td class="areaSeparator">&nbsp;</td>
                <td id="footerItemElement">
                    <div id="footerItemElementLeft">
                       <span class="va-middle">
                            <span class="currentRecordCount"></span>&nbsp;/&nbsp;<span class="maxRecordCount"></span>
                        </span>

                        <span class="prevRecordButton">

                            <button id="prevRecordButtonEnable" class="prevRecordButtonEnable  nextPageButton add-cursor "  title="Alt + 3" accesskey="3" style="border-color:#8c8c8c;color: #0a0a0a;">
                                前の帳票</button>
                            <button id="prevRecordButtonDisable" class="prevRecordButtonDisable  nextPageButton" disabled="disabled"  title="Alt + 3">
                                 前の帳票
                               </button>
                        </span>
                        <span class="nextRecordButton">
                            <button id="nextRecordButtonEnable" class="nextRecordButtonEnable  nextPageButton add-cursor" title="Alt + 4" accesskey="4" style="border-color:#8c8c8c;color: #0a0a0a;" >
                                 次の帳票</button>
                            <button id="nextRecordButtonDisable" class="nextRecordButtonDisable nextPageButton" disabled="disabled"  title="Alt + 4" >
                                次の帳票</button>
                        </span>
                    </div>
                    <div id="footerItemElementRight">
                        <input type="button" name="cancelButton" id="cancelButton" value="<%= Resources.Messages.CancelButtonCaption %>" />
                        <input type="button" class="applyButton" name="applyButton" style="color:#fff;" id="applyButton" value="<%= Resources.Messages.ApplyButtonCaption %>" />
                    </div>
                </td>
            </tr>
        </table>
         
        
    </form>
    <div id="footer" class="copyRight">
           
            <%= Resources.Messages.CopyrightCaption %>
           
        </div>
    
     </div>  
     <!-- 表示設定ダイアログ -->
    <div id="configDialog" title="<%= Resources.Messages.ConfigDialogTitle %>">
        <h2><%= Resources.Messages.ConfigDialogTitle %></h2>
        <form method="post" name="form1" id="form2">
            <div class="answerImageMaxSize">
                <label><%= Resources.Messages.AnswerImageMaxSizeCaption %></label>
            </div>
            <br />
            <div class="answerImageMaxSize">
                <div class="answerImageMaxSizeHeader">
                    <label for="answerImageMaxWidth"><%= Resources.Messages.AnswerImageMaxWidthCaption %></label>
                </div>
                <input id="answerImageMaxWidth" type="text" class="answerImageMaxSizeValue" />
            </div>
            <br />
            <div class="answerImageMaxSize">
                <div class="answerImageMaxSizeHeader">
                    <label for="answerImageMaxHeight"><%= Resources.Messages.AnswerImageMaxHeightCaption %></label>
                </div>
                <input id="answerImageMaxHeight" type="text" class="answerImageMaxSizeValue" />
            </div>
            <br />
            <br />
            <div class="answerImageMaxSize">
                <label><%= Resources.Messages.AnswerImageSentenceMaxSizeCaption %></label>
            </div>
            <br />
            <div class="answerImageMaxSize">
                <div class="answerImageMaxSizeHeader">
                    <label for="answerImageMaxWidth"><%= Resources.Messages.AnswerImageMaxWidthCaption %></label>
                </div>
                <input id="answerImageSentenceMaxWidth" type="text" class="answerImageMaxSizeValue" />
            </div>
            <br />
            <div class="answerImageMaxSize">
                <div class="answerImageMaxSizeHeader">
                    <label for="answerImageMaxHeight"><%= Resources.Messages.AnswerImageMaxHeightCaption %></label>
                </div>
                <input id="answerImageSentenceMaxHeight" type="text" class="answerImageMaxSizeValue" />
            </div>
        </form>
        
        <button  class="cancle ModalWindowButton" id="selectFormClose"><%= Resources.Messages.CancelButtonCaption %></button>
        <button class="ModalWindowButton"  id="selectFormOK"><%= Resources.Messages.OkButtonCaption %></button>
    </div>

    <div id="columnPopup">
        <h2 id="columnPopupTitel"></h2>
        <div id="columnPopupSortButton" ></div>
        <div id="columnPopupItems"></div>
        <div id="columnPopupButtonDiv" style="float: right;margin-bottom: 15px;">

        </div>
    </div>
    <div id="dialog-confirm">
        <h2></h2>
        <div></div> 
        <button type="button" id="dialog-confirm-close">キャンセル</button>
        <button type="button" id="dialog-confirm-ok">OK</button>
    </div>
</body>
</html>
 <script>
     $("#applyButton, #applyButtonTop").xuxButton();
     $("#cancelButton, #cancelButtonTop").xuxButton();
     $("#scanPageExpandButtonEnable").xuxButton();
     $("#scanPageExpandButtonEnable").xuxButton("option", "type", "details");

     $("#scanPageReduceButtonDisable").xuxButton();
     $("#scanPageReduceButtonEnable").xuxButton();
     $("#scanPageExpandButtonDisable").xuxButton();
     $("#applyButton, #applyButtonTop").xuxButton("option", "type", "default");

     $("#prevRecordButtonEnable").xuxButton();
     $("#prevRecordButtonDisable").xuxButton();
     $("#nextRecordButtonEnable").xuxButton();
     $("#nextRecordButtonDisable").xuxButton();
 </script>