﻿<%@ Page Language="C#" AutoEventWireup="true" EnableEventValidation="false"
    CodeBehind="LedgerList.aspx.cs" Inherits="QuestionnaireConfirm.LedgerList" %>

<%@ Import Namespace="QuestionnaireConfirm.Util" %>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" style="background-color: #f5f5f5;" lang="ja">
<head runat="server">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <title>
        <%= Resources.Messages.AppTitle %>
    </title>
    <link rel="SHORTCUT ICON" href="image/record_operator_favicon.ico" />
  <%--  <link rel="stylesheet" href="css/redmond/jquery-ui-1.11.2.min.css" />--%>
    <link rel="stylesheet" href="css/style.css?date=<%=DateTime.Now.ToString("yyyyMMddHHmmss")%>" />
    <style>
        #headerFunction1 {
            margin: 10px 0px;
        }

        /*
        #createNewRecordButton {
            margin-right: 10px;
        }
        */
        .recordOperationArea {
            float: left;
        }

        .refreshButtonArea {
            float: right;
            text-align: right;
        }

        .paginateArea {
            float: right;
            text-align: right;
        }

        .dataTables_length {
            width: auto;
            text-align: right;
            font-family: "Arial Negreta", "Arial";
            font-size: 12px;
            font-style: normal;
            font-weight: 400;
            margin-top: 1px;
            margin-right: 7px;
        }

        .dataTables_info {
            height: 29px;
            text-align: left;
            font-family: "Arial Negreta", "Arial";
            font-size: 12px;
            font-style: normal;
            font-weight: 400;
            margin-top: 7px;
            margin-right: 7px;
            float: right;
        }

        .dataTables_paginate {
            float: right;
        }

        #sortColumnAddButton, #sortColumnRemoveButton {
            font-size: .4em;
        }

        .sortColumn {
            position: relative;
            left: 20px;
            width: 160px;
        }

        .sortDirection {
            position: relative;
            left: 30px;
            width: 60px;
        }

        #footerFunction {
            margin: 8px;
            text-align: right;
        }


        .ui-tabs-anchor {
            font-size: .6rem;
        }

        .fg-button {
            margin: 1px;
            width: 10px;
            font-size: 10px;
            background-color: #FFFFFF;
        }

        #amount {
            /*text-align: right;*/
            margin-left: 5px;
        }

        .pageLength {
            position: relative;
            left: 20px;
            width: 160px;
        }

        #pageLength {
            display: none;
        }

        #unknownPageLength {
            display: none;
        }

        .dialogLine {
            border-top: 1px solid #aaaaaa;
            bottom: 43px;
            position: absolute;
            right: 0;
            text-align: right;
            width: 100%;
        }

        #formDlgButtons {
            text-align: right;
        }
        /*
        #unknownDlgButtons {
            text-align: right;
            position: absolute;
            bottom: 7px;
            right: 6px;
        }*/

        .label1 {
            /* color: #555555;
            font-family: "Arial Negreta", "Arial";
            font-size: 14px;
            font-style: normal;
            font-weight: 700;*/
            margin-top: 10px;
        }

        .label2 {
            /*color: #4f4f4f;
            font-family: "Arial Negreta", "Arial";
            font-size: 13px;
            font-style: normal;
            font-weight: 400;
            float: right;
            padding: 15px 0px 0px 0px;
            */
        }

        .hide {
            display: none;
        }
        /*
        #businessList {
            color: #555555;
            font-family: "Arial Negreta", "Arial";
            font-size: 14px;
            font-style: normal;
            font-weight: 700;
        }

        #confirmCorrectList {
            font-family: "Arial Negreta", "Arial";
            font-size: 12px;
            font-style: normal;
            font-weight: 400;
        }

        #unknownDeleteFunction {
            position: absolute;
            top: 1px;
            left: 7px;
        }

        #unknownTable_length {
            margin-left: 50%;
            width: 80px;
            padding: 3px 0 0;
        }

        #unknownTable_info {
            width: 20%;
        }

        #unknownTable {
            width: 100%;
        }

        #unknownTable_paginate {
            margin: 0 4px 8px;
        }*/

        .elementError {
            color: red;
        }

        #recordTable {
            width: 100%;
        }

        #recordTableViewMode {
            width: 100%;
        }

        #mfpTable {
            width: 100%;
            margin: 4px 0;
        }

        #elementsTable_length select {
            margin: 0px 4px;
        }

        #unknownTable_length select {
            margin: 0px 4px;
        }

        #errorTable {
            width: 100%;
        }

        #elementsTable_wrapper > div > div > div > div > table {
            table-layout: fixed;
        }

        .DataTables_sort_wrapper {
            height: 15px;
        }

        .FilterDialog {
            /* display: inline-block;*/
            margin: 0px;
            padding: 0px;
            text-align: left;
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
            -webkit-text-overflow: ellipsis; /* Safari */
            -o-text-overflow: ellipsis; /* Opera */
        }

        .UnknownFilterDialog {
            white-space: nowrap;
        }

        table#elementsTable {
            table-layout: fixed;
            width: 100%;
        }

            table#elementsTable td {
                text-align: left;
                white-space: nowrap;
                overflow: hidden;
                text-overflow: ellipsis;
                -webkit-text-overflow: ellipsis; /* Safari */
                -o-text-overflow: ellipsis; /* Opera */
                height: 16px;
            }

        #tabTempDiv .xux-decoratedTable-table {
            overflow: auto !important;
        }
        /* DataRange */
        #dataRangeButton {
            margin-left: 12px;
        }

        .marginLeftButton {
            margin-left: 6px;
        }

        #dataRangeStatus {
            margin-right: 16px;
            text-align: right;
            margin-top: -20px;
            white-space: pre-wrap;
        }
        /*
         #dataRangeDialog {
            display: none;
        }

            #dataRangeDialog div.inner {
                margin-top: 30px;
                margin-left: 10px;
                width: 540px;
                border: solid #BBB 1px;
                padding: 10px;
            }

            #dataRangeDialog td {
                padding-top: 15px;
            }

        #tblRecordCondition td {
            padding-bottom: 15px;
        }

        #dataRangeDialog label {
            margin-left: 7px;
        }

        #dataRangeDialog input[type="checkbox"] {
            vertical-align: middle;
        }

        #dataRangeDialog div span {
            margin-left: 0px;
            margin-top: 10px;
        }

        #tblRecordCondition select {
            width: 260px;
        }

        select.dataRangeItemSelect {
            width: 235px;
        }

        select.dataRangeValueSelect {
            width: 258px;
        }

        #tblRecordCondition input[type="text"] {
            width: 118px;
        }

        #tblItemCondition input[type="text"] {
            width: 95px;
        }

        #selectDataRangeRecord {
            width: 260px;
        }

        #dataRangeCountButton {
            margin-left: 10px;
        } */

        #updateMessage {
            /* color: #4f4f4f;
            font-family: "Arial Negreta", "Arial";
            font-size: 13px;
            font-style: normal;
            font-weight: 400;*/
            margin-left: 7px;
            margin-right: 7px;
        }

        .dn-icon {
            vertical-align: middle;
            margin-bottom: 4px;
            margin-left: 1px;
        }

        .mfpForm-padding {
            padding: 15px 0 2px;
        }

        #mfpForm input[type="checkbox"] {
            vertical-align: middle;
            margin-left: 0px;
        }

        /* .dataTable > tbody > tr > td {
            padding: 4px;
        }*/

        .xux-dropdown-header {
            /*background: white !important;*/
        }

        #tabTempDiv #elementsTable tbody {
            display: block;
            height: 300px;
            overflow-y: auto;
            overflow-x: hidden;
            width: fit-content;
        }

        #tabTempDiv #elementsTable thead {
            display: table;
            width: 100%;
            table-layout: fixed;
        }

        #tabTempDiv #elementsTable tbody tr {
            display: table;
            width: 100%;
            table-layout: fixed;
        }

        #tabTempDiv #elementsTable thead {
            /*width: calc( 100% - 1em )*/
        }

        #unknownTableDiv #unknownTable tbody {
            display: block;
            height: 300px;
            overflow-y: auto;
        }

        #unknownTableDiv #unknownTable thead {
            display: table;
            width: 100%;
            table-layout: fixed;
        }

        #unknownTableDiv #unknownTable tbody tr {
            display: table;
            width: 100%;
            table-layout: fixed;
        }

        #unknownTableDiv #unknownTable thead {
            width: calc( 100% - 1em )
        }

        #columnPopupItems, .ui-dialog-content #unknownColumnPopupItems {
            border: 1px solid #b2b2b2;
            margin: 20px 0;
            max-height: 350px;
            overflow-y: scroll;
        }

        #mfpFormButtonDiv {
            display: flex;
            justify-content: space-between;
        }

        #columnPopup, #unknownColumnPopup {
            width: 400px !important;
            margin: 0 auto;
        }

        #buttonfrmChgPWDDialog {
            display: flex;
            justify-content: flex-end;
        }

        #frmChgPWDDialog {
            width: 432px;
            margin: 0 auto;
        }

        .xux-modalWindow {
            box-shadow: none !important;
        }

        .xux-normalButton {
            min-width: 94px !important;
        }

        .ui-widget input {
            font-size: 15px !important;
        }
    </style>
    <script src="js/jquery-2.1.1.min.js"></script>

    <script src="xux/xux-js/xux-gfocal-middle-light-3.1.0-alpha-06.min.js"></script>
    <script>
         $("html").attr('lang', 'ja');
        xuxInitialize({
            prefix: "xux/",
        });
    </script>
    <script src="xux/xux-js/xux-gfocal-middle-fujifilmbi-3.1.0-alpha-06.min.js"></script>
    <script>
        <%-- ヘッダ用情報(Sessionに文字列配列で格納) --%>
        var headerTexts = [];
		<%
        string escapedName;
        if (Session["LedgerHeader"] != null)
        {
            string[] headerNames = (string[])Session["LedgerHeader"];
            foreach (string name in headerNames)
            {
                escapedName = HttpUtility.HtmlEncode(name);// 表示名のエスケープ処理
                escapedName = escapedName.Replace("\r\n", " ").Replace("\r", " ").Replace("\n", " ");// 改行コード潰し
		%>
        headerTexts.push("<%=escapedName%>");
		<%
            }
        }
		%>
        var columnsTempInfo = "<%=Session["LedgerColumnsInfo"]%>";
        var columnsInfo = columnsTempInfo.length > 0 ? columnsTempInfo.split(",") : [];   <%-- 可変部分で日付項目のものはtrue --%>
        var columnsName_ = [];
        for (var i = 0; i < columnsInfo.length + 3; i++) {
            columnsName_.push("DispItems" + i);
        }

        <%-- 日付ソート条件の格納用配列（動的ヘッダ項目数＋固定ヘッダ項目分を作成） --%>
        var filterToDate_ = new Array(columnsInfo.length + 3);
        var filterFromDate_ = new Array(filterToDate_.length);
        var sortFilterColumnIndexList_ = new Array(filterToDate_.length);

        <%-- 部分一致検索の格納用配列（動的ヘッダ項目数＋固定ヘッダ項目分を作成） --%>
        var editableFilter_ = new Array(columnsInfo.length + 3);
        var $filterDialogHeader_ = null, $filterDialogUnknownHeader_ = null;

        <%-- No列の開始、終了条件 --%>
        var startNoNumberFilter_ = '', endNoNumberFilter_ = '';
        var startUnknownNoNumberFilter_ = '', endUnknownNoNumberFilter_ = '';

        <%-- 抽出中の文字列 --%>
        var SCANNING = '<%= Resources.Messages.ScanningText %>';

        var isPrint = false;
        var isUpdating_ = false;

        var sortFilterColumn_ = null;
        var $elementsTable_;
        var $recordTable_;
        var $recordTableViewMode_;
        var elementRowsList_;
        var $errorTable_;
        var sortFilterColumnIndex_ = -1, sortFilterColumnUnknownIndex_ = -1;

        var $formTable_;
        var formRowsList_;
        var displayItems_;

        var unknownSortFilterColumn_ = null;
        var $unknownTable_;
        var $unknownListDlg_;
        var unknownRowsList_;
        var unknownImageWindow_ = null;
        var unknownWindowMode_ = 0;<%-- 不明帳票一覧のモード種別（0:通常, 1:紐付け） --%>
        var unknownMergeRecordIdList_ = [];

        var lastUpdateDate_ = null;<%-- レコード編集時の取得済み最終更新日時 --%>
        var updateUserId_ = null;<%-- レコード編集時の取得済み更新ユーザID --%>

        var windowHeight_ = window.innerHeight - 225 - 30;<%-- 画面上部の高さ - フッターのコピーライト分を減算 --%>
        if (windowHeight_ < 0) {
            windowHeight_ = 0;
        }
        var isSelectBusinessId_ = true;
        var ledgerColumnMaxWidth_ = Number('<%= ConfigurationManager.AppSettings["LedgerColumnMaxWidth"] %>');
        if (isNaN(ledgerColumnMaxWidth_)) {
            ledgerColumnMaxWidth_ = 130;
        }
        var freeEntryMaxLength_ = <%= QuestionnaireConfirm.Util.RecordUtil.GetFreeEntryMaxLength() %>;

        var itemsPerPageChoices = [5, 10, 20, 50, 100, 200];

        var COOKIENAME_LINES_PER_PAGE = 'LedgerList.LinesPerPage';
        var COOKIENAME_UNKNOWN_LINES_PER_PAGE = 'LedgerList.UnknownLinesPerPage';
        var COOKIENAME_CONFIRMATION_OPEN = 'ConfirmationOpen';

        var FILTER_ALLROWS_ID = 'allRows';
        var FILTER_ALLROWS_ID_SELECTOR = '#allRows';
        var FILTER_COND_CLASSNAME = 'filterCond';
        var FILTER_COND_CLASSNAME_SELECTOR = '.filterCond';
        var FILTER_RADIO_GROUP_NAME = 'filterRadioItem';
        var FILTER_ALLROWS_ID_UNKNOWN = 'allUnknownRows';
        var FILTER_ALLROWS_ID_UNKNOWN_SELECTOR = '#allUnknownRows';
        var FILTER_COND_CLASSNAME_UNKNOWN = 'unknownFilterCond';
        var FILTER_COND_CLASSNAME_UNKNOWN_SELECTOR = '.unknownFilterCond';
        var FILTER_RADIO_GROUP_NAME_UNKNOWN = 'unknownFilterRadioItem';
        var renderDataTableOptions = null;
        var renderUnknowTable = null;
        var createUnknownFilterDialog = null;
        var resetUnknownTableHeadercolor = null;
        var headerTextsLengthArray = [];
        var headerTextsWithdSum = 0;
        var recordTablePageCount = 15;
        var unknowRecordTablePageCount = 9;
        var buttonsInitDisable = null;
        var isClickFilter = false;
        var updateInnerForm = null;
        var clickHeaderCell = null;
        var clickUnknownHeaderCell = null;
        var clickHeaderCellWidth = 0;
        var clickUnknownHeaderCellWidth = 0;
        var DataTableOptions = null;
        var toggleRecordSort = null;
        var searchRecordTable = null;
        var throttleTime = null
        $(window).on("unload",function (e) {
            if (unknownImageWindow_ && !unknownImageWindow_.closed) {
                unknownImageWindow_.close();
            }
        });

        //ドキュメント全体にkeydownイベントを追加
        $(document).on("keydown", function (event) {
            checkboxSpacekeyDown(event);
        });

        $(window).resize(function () {
            if (0 < window.innerHeight - 231) {
                var tempTableHeight = window.innerHeight - 359;
                //$('#elementsTable').parent().height(tempTableHeight);
                //$('#elementsTable').find("tbody").first().css("height", tempTableHeight + "px");
            } else {
                //$('#elementsTable').parent().height(0);
            }
            var tempWidth = $("#tabTempDiv").width();
            var tempDecoratedTable = $("#tab").find('.xux-decoratedTable-table').first();
            $('#elementsTable').find(".xux-table-header").first().css("padding", "0px");
            tempDecoratedTable.width(tempWidth);
            tempDecoratedTable.css({
                overflow: 'auto hidden'

            });

            let tbodyHeight = document.documentElement.clientHeight - 333;
            if ($("#elementsTable").find("tbody")[0].clientWidth <= $("#elementsTable")[0].clientWidth ) { tbodyHeight += 16 }
            $("#elementsTable").find("tbody").css("height", tbodyHeight + "px");
       
        });

        <%-- 現在のレコード使用量の表示色設定 --%>
        function setAmountColor() {
            var maxValText = $('#useAmountLabelMax').text();
            if (maxValText == "") {
	            <%-- 上限値未設定なら何もしない --%>
                return;
            }
            var maxVal = parseInt(maxValText.split(',').join(''), 10);
            var crtVal = parseInt($('#useAmountLabelCurrent').text().split(',').join(''), 10);
            if (crtVal / maxVal >= 0.9) {
                $('#useAmountLabelCurrent').css('color', '#ff0000');
            }
            else {
                $('#useAmountLabelCurrent').css('color', '#000000');
            }
        }

        <%-- 現在のレコード使用量を取得 --%>
        function getAmountSize() {
            $.ajax({
                type: 'GET',
                url: 'api/RecordAmount',
                data: { business_id: null },
                success: function (data, dataType) {
                    $('#useAmountLabelCurrent').text(data.RecordCount.toLocaleString());
                     <%-- 現在のレコード使用量の表示色設定 --%>
                     setAmountColor();
                }
                , error: function (XMLHttpRequest, textStatus, errorThrown) {
                    // do nothing<%-- DB接続失敗時、レコード使用量取得とデータ更新で2回alertが表示される問題対応 --%>
                }
            });
        }

        <%-- 帳票一覧データ取得処理 --%>
        function loadSelectFormData() {
            var bizId = $('#businessList').val().split(':');
            $.ajax({
                type: 'GET',
                url: 'api/Form',
                data: { business_id: bizId[0] },
                async: false,
                dataType: "json",
                success: function (data, dataType) {
                    for (var i = 0; i < data.length; i++) {
                        var row = data[i];
                        data[i].dataIndex = i;
                        row.FormName = doSanitaizeEncode(row.FormName);
                        row.FormShortName = doSanitaizeEncode(row.FormShortName);
                    }
                    formRowsList_ = data;
                        <%-- 帳票選択ダイアログDataTablesオプションの定義 --%>

                    $("#selectTempFormDiv").html("");
                    var htmlTemp = '<div id="selectFormDiv"> ' +
                        '<table id = "selectFormTable"> ' +
                        '<thead> ' +
                        '    <th style="width: 15%"></th> ' +
                        '     <th style="width: 85%"><%= Resources.Messages.FormSelectDialogTableHeader %></th> ' +
                        '  </thead> ' +
                        '   <tbody></tbody> ' +
                        '    </table> ' +
                        ' </div>';
                    $("#selectTempFormDiv").html(htmlTemp);
                    var FormDataTableOptions = {
                        selectionUnit: "none",
                        pageNavigationPosition: "none",
                        clear: true,
                        data: {
                            "fields": ["FormId", 'FormShortName'],
                            "items": data
                        },
                        columns: [
                            {
                                field: "FormId",
                                render: function (td, item) {
                                    var id = "FormShortNameeRadio_" + item._data.FormId;
                                    var tempCheck = "";
                                    if (item.Selected) {
                                        tempCheck = "checked";
                                    } else {
                                        if (item._data.dataIndex == 0) {
                                            tempCheck = "checked";
                                        } else {
                                            tempCheck = "";
                                        }
                                    }

                                    var html = '<input name="FormShortName" type="radio" dataIndex="' + item._data.dataIndex + '" id="' + id + '" value="' + item._data.FormId + '" ' + tempCheck + '>';
                                    $(html).appendTo(td);

                                    $("#" + id).xuxRadio();
                                }
                            }, {
                                field: "FormShortName",
                                render: function (td, item) {
                                    var html = '<span>' + item._data.FormShortName + '</span>';
                                    $(html).appendTo(td);
                                }
                            }
                        ],
                        afterRender: function () {
                            $("input[name=FormShortName]").xuxRadio();
                            $("input[name=FormShortName]").click(function () {
                                var dataIndex = $(this).attr("dataIndex");
                                updateInnerForm(dataIndex);
                                $('#selectFormOK').prop('disabled', false);
                            });
                        }
                    }
                    $("#selectFormDiv").xuxDecoratedTable(FormDataTableOptions);
                    $("#selectForm").xuxModalWindow("open");
                },
                error: function (XMLHttpRequest, textStatus, errorThrown) {
                    if (XMLHttpRequest.status == 200) {
                        redirectLoginPage();
                        return;
                    }
                    alertMessageEror('<%= Resources.Messages.AjaxErrorMessage %>');
                }
            });
        }

        function loadSelectReportData() {
            var bizId = $('#businessList').val().split(':');
            $("#selectReport").xuxModalWindow({});
            $.ajax({
                type: 'GET',
                url: 'api/Form',
                data: { business_id: bizId[0] },
                async: false,
                dataType: "json",
                success: function (data, dataType) {
                    for (var i = 0; i < data.length; i++) {
                        var row = data[i];
                        data[i].dataIndex = i;
                        row.FormName = doSanitaizeEncode(row.FormName);
                        row.FormShortName = doSanitaizeEncode(row.FormShortName);
                    }
                    formRowsList_ = data;
                        <%-- 帳票選択ダイアログDataTablesオプションの定義 --%>

                    $("#confirmCorrectRadio2").xuxRadio();
                    $("#confirmCorrectRadio3").xuxRadio();
                    for (var i = 0; i < formRowsList_.length; i++) {
                        $("#selectReportPage").append('<option value ="' + formRowsList_[i].FormId + '">' + formRowsList_[i].FormShortName + '</option>')
                    }
                    $("#selectTempReportDiv").xuxDropdownBox();
                    $("#selectReport").xuxModalWindow("open");
                },
                error: function (XMLHttpRequest, textStatus, errorThrown) {
                    if (XMLHttpRequest.status == 200) {
                        redirectLoginPage();
                        return;
                    }
                    alertMessageEror('<%= Resources.Messages.AjaxErrorMessage %>');
                }
            });
        }

        <%-- (レコード一覧)データ件数のカウント取得処理 --%>
        function loadTabData(isFirstOnly) {
	        <%-- 初回表示の判定 --%>
            if (isFirstOnly) {
                dispLoading("<%= Resources.Messages.LedgerListLoadingMessage %>");
                var bizId = $('#businessList').val().split(':');
                var RecordListThresholdSize = '<%= Resources.Messages.RecordListThresholdSize %>';
		        <%-- データ件数のカウント取得（非同期通信） --%>
                $.ajax({
                    type: 'GET',
                    url: 'api/RecordAmount',
                    data: { business_id: bizId[0] },
                    dataType: "json",
                    success: function (data, dataType) {
                        if (bizId[0] == -1) {
                            renderDataTableOptions([]);
                            removeLoading();
                        } else {
	        		        <%-- しきい値超過チェック --%>
                            if (data.RecordCount > Number(RecordListThresholdSize)) {
                                loadTabDataEx(isFirstOnly, true);

                            } else {
                                loadTabDataEx(isFirstOnly, false);

                            }
                        }
                    }
                });
            } else {
                loadTabDataEx(isFirstOnly, false);
            }
        }

        <%-- (レコード一覧)データ取得処理 --%>
        function loadTabDataEx(isFirstOnly, isOverThresholdSize) {
            putPerformanceLog("レコード一覧情報の取得 開始");
            elementRowsList_ = [];
            var RecordListThresholdSize = '<%= Resources.Messages.RecordListThresholdSize %>';
            var bizId = $('#businessList').val().split(':');
            var isWarning = false;
            putPerformanceLog("レコード一覧情報の取得処理(非同期) 開始");
	        <%-- データ取得 --%>
            $.ajax({
                type: 'GET',
                url: 'api/LedgerList',
                data: { business_Id: bizId[0], isFirstOnly: isFirstOnly, thresholdSize: Number(RecordListThresholdSize) },
                dataType: "json",
                success: function (data, dataType) {
                    // $('#updateMessage').hide();
                    $("#refreshTips").css("display", "none")
                    putPerformanceLog("レコード一覧情報の取得処理(非同期) 終了");
                    putPerformanceLog("取得したレコード一覧の画面描画処理 開始");
					<%-- 動的表示項目が含まれるデータをJSON形式に変換する --%>
                    var dataList = [];
                    var dataLength = data.length;
                    for (var i = 0; i < dataLength; i++) {
                        var row = data[i];
                        if (row.HasWrong) {
                            isWarning = true;
                            continue;
                        }
                        var jsonDispItems = {};
                        jsonDispItems["BusinessRecordId"] = row.BusinessRecordId;
                        jsonDispItems["Selected"] = row.Selected;
                        jsonDispItems["Detail"] = row.Detail;
                        jsonDispItems["HasError"] = row.HasError;
                        jsonDispItems["DefectNoticeType"] = row.DefectNoticeType;
                        var itemsLength = row.DispItems.length;
						<%-- 動的表示項目の変換処理 --%>
                        for (var j = 0; j < itemsLength; j++) {
                            <%-- 日付型で変換可能なとき --%>
                            if (columnsInfo[j] === '0') {
                                if (row.DispItems[j] != "" && row.DispItems[j] != SCANNING) {
                                    row.DispItems[j] = new Date(row.DispItems[j]);
                                }
                            } else {
                                row.DispItems[j] = doSanitaizeEncode(row.DispItems[j]);
                            }
                            jsonDispItems[columnsName_[j + 3]] = row.DispItems[j];
                        }
                        jsonDispItems["dataIndex"] = i;
                        dataList.push($.parseJSON(JSON.stringify(jsonDispItems)));
                    }
                    elementRowsList_ = dataList;
                    if (clickHeaderCell != null) {
                        $elementsTable_.load = function () { }
                        if (DataTableOptions.columns[clickHeaderCell].searchTableColumnDirection == "desc") {
                            searchRecordTable(DataTableOptions, elementRowsList_);
                            //var tempDataTable = toggleRecordSort($elementsTable_, clickHeaderCell, 'desc', null);
                            //renderDataTableOptions(tempDataTable);
                        } else if (DataTableOptions.columns[clickHeaderCell].searchTableColumnDirection == "asc") {
                            searchRecordTable(DataTableOptions, elementRowsList_);
                            //var tempDataTable = toggleRecordSort($elementsTable_, clickHeaderCell, 'asc', null);
                            //renderDataTableOptions(tempDataTable);
                        }

                    } else {
                        renderDataTableOptions(elementRowsList_);
                    }

	                <%-- DataTablesを一旦クリアし、取得したデータを設定 --%>
                    //$elementsTable_.clear().rows.add(dataList);
	                <%-- DataTablesのカラム幅調整 --%>
                    //$elementsTable_.columns.adjust();
	                <%-- DataTablesの描画 --%>
                    //$elementsTable_.draw();
                    putPerformanceLog("取得したレコード一覧の画面描画処理 終了");
                },
                complete: function (XMLHttpRequest, textStatus) {
                    $("#refreshFunction").xuxButton({ "disabled": false });
	                <%-- しきい値超過時の全件データ取得処理 --%>
                    if (isOverThresholdSize) {
                        loadTabDataEx(false, false);
                    } else {
                        if (isFirstOnly && isWarning)
                            alertMessageInfo("<%= Resources.Messages.LedgerListWarningMessage %>");
                    }
                    putPerformanceLog("レコード一覧情報の取得 終了");
                }
            });
        }

        <%-- (不明な帳票一覧)データ件数のカウント取得処理 --%>
        function loadUnknownData(isFirstOnly) {
            $("#unknownDeleteButton").xuxButton({ "disabled": true });
	        <%-- 初回表示の判定 --%>
            if (isFirstOnly) {
                var RecordListThresholdSize = '<%= Resources.Messages.RecordListThresholdSize %>';
	            <%-- データ件数のカウント取得（非同期通信） --%>
                $.ajax({
                    type: 'GET',
                    url: 'api/UnknownList',
                    dataType: "json",
                    success: function (data, dataType) {
				        <%-- しきい値超過チェック --%>
                        if (data > Number(RecordListThresholdSize)) {
                            loadUnknownDataEx(isFirstOnly, true);
                        } else {
                            loadUnknownDataEx(isFirstOnly, false);
                        }
                    }
                    , error: function (XMLHttpRequest, textStatus, errorThrown) {
                        if (XMLHttpRequest.status == 200) {
                            redirectLoginPage();
                            return;
                        }
                        alertMessageEror('<%= Resources.Messages.AjaxErrorMessage %>');
                    }
                });
            } else {
                loadUnknownDataEx(isFirstOnly, false);
            }
        }

        <%-- (不明な帳票一覧)データ取得処理 --%>
        function loadUnknownDataEx(isFirstOnly, isOverThresholdSize) {
            unknownRowsList_ = [];
            var RecordListThresholdSize = '<%= Resources.Messages.RecordListThresholdSize %>';
            var bizId = $('#businessList').val().split(':');
            $.ajax({
                type: 'GET',
                url: 'api/UnknownList',
                data: { business_id: bizId[0], isFirstOnly: isFirstOnly, thresholdSize: Number(RecordListThresholdSize) },
                dataType: "json",
                success: function (data, dataType) {
                    for (var i = 0; i < data.length; i++) {
                        var row = data[i];
                        row.ScanDate = new Date(row.ScanDate);
                        row.FormShortName = doSanitaizeEncode(row.FormShortName);
                        row.IpAddress = doSanitaizeEncode(row.IpAddress);
                        data[i].rowIndex = i;
                    }
                    unknownRowsList_ = data;
                    renderUnknowTable(data);
                },
                complete: function (XMLHttpRequest, textStatus) {
	                <%-- しきい値超過時の全件データ取得処理 --%>
                    if (isOverThresholdSize) {
                        loadUnknownDataEx(false, false);
                    }
                }
            });
        }
        function createUnknowTable() {
            $("#unknownTableDivTemp").html("");
            var filterTextTemp = '<span  class="xux-icon xux-icon-size-medium xux-icon-funnel" style="font-size: 16px;position: absolute;padding-left:' + 10 + 'px"></span>';
            var tempUnknowCreateTable = ' <div id="unknownTableDiv"> ' +
                ' <table id = "unknownTable" > ' +
                ' <thead> ' +
                ' <tr> ' +
                ' <th style="width:40px"> ' +
                ' <span id="UnknownFormSelect" > ' +
                ' <input id="allUnknownCheckBox" type="checkbox" /></span> ' +
                ' </th > ' +
                ' <th class="headerUnknownRecord" style="width:70px" > ' +
                ' <span class="UnknownFilterDialog" columnIndex="1" id = "UnknownFormId"><%= Resources.Messages.UnknownNumberColumnName %></span > <span class="boxSpan"></span>' + filterTextTemp +
                ' </th > ' +
                ' <th class="headerUnknownRecord"> ' +
                ' <span class="UnknownFilterDialog" columnIndex="2" id = "FormShortName" ><%= Resources.Messages.UnknownDialogHeaderFormName %></span > <span class="boxSpan"></span>' + filterTextTemp +
                ' </th > ' +
                ' <th class="headerUnknownRecord"> ' +
                ' <span class="UnknownFilterDialog" columnIndex="3" id = "ErrorMessage"><%= Resources.Messages.UnknownDialogHeaderError %></span > <span class="boxSpan"></span>' + filterTextTemp +
                ' <th class="headerUnknownRecord"> ' +
                ' <span class="UnknownFilterDialog" columnIndex="4" id = "IpAddress" ><%= Resources.Messages.UnknownDialogHeaderIP %></span ><span class="boxSpan"></span> ' + filterTextTemp +
                ' </th > ' +
                ' <th class="headerUnknownRecord"> ' +
                ' <span class="UnknownFilterDialog" columnIndex="5" id = "ScanDate" ><%= Resources.Messages.UnknownDialogHeaderDatetime %></span > <span class="boxSpan"></span>' + filterTextTemp +
                ' </th > ' +
                ' </tr > ' +
                ' </thead > ' +
                ' <tbody > ' +
                ' </tbody > ' +
                ' </table > ' +
                ' </div > '
            $("#unknownTableDivTemp").html(tempUnknowCreateTable);


            $("#allUnknownCheckBox").xuxCheckbox();

              <%-- 不明な帳票一覧一括選択チェックボックス --%>
            $('#allUnknownCheckBox').click(function () {
                if (!unknownRowsList_ || unknownRowsList_.length === 0) {
                    //$('#unknownDeleteButton').prop('disabled', true);
                    $("#unknownDeleteButton").xuxButton({ "disabled": true });
                    //$('#unknownOKButton').prop('disabled', true);
                    $("#unknownOKButton").xuxButton({ "disabled": true });
                    return;
                }
                var isChecked = $(this).is(':checked');
                $('#unknownTable').find('[name=unknownCheckBox]').prop('checked', isChecked).trigger('change');
                $('[name=unknownCheckBox]').xuxCheckbox();
                if (isChecked) {
                    unknownButtonsDisable(false);
                }
            });
        }
        var UnknownDataTableOptions = null;
        var searchUnknownDisplayItems = null;
        renderUnknowTable = function (displayItems) {

            searchUnknownDisplayItems = displayItems;


            <%-- 不明な帳票一覧ダイアログDataTablesオプションの定義 --%>
            if (UnknownDataTableOptions == null) {
                createUnknowTable();
                UnknownDataTableOptions = {
                    pageNavigation: 'bottom',
                    columnResizable: false,
                    //size: 'full',
                    hoverState: true,
                    autoLoad: true,
                    labelLayout: 'leading',
                    selectionUnit: 'row',
                    selectionRemains: true,
                    itemId: 'elementImageId',
                    pageNumbers: true,
                    itemsPerPage: 9,
                    dropdown: false,
                    itemNumbers: true,
                    pagesPerLoad: 9,
                    endButtons: true,
                    //itemsPerPageChoices: [5, 10, 20, 50, 100, 200],
                    //itemsPerPagePosition: "both",
                    noRowMessage: '<%= Resources.Messages.DataTableZeroRecordsMessage %>',
                    multipleSelections: false,
                    clear: true,
                    sortOptions: {
                        column: 1,
                        order: 'asc'
                    },
                    data: function (params) {
					        var end = 0;
							<%-- 選択されたページでレコードの開始位置  --%>
                            var start = params.start;
							<%-- 表示ページの総件数 --%>
                            var count = params.count;
							<%-- 総件数 --%>
                            var sumNumber = searchUnknownDisplayItems.length;
							<%-- 総件数＜=総件数＜=選択されたページでレコードの開始位置　+　表示ページの総件数  --%>
                            if (sumNumber <= start + count) {
								<%-- 総件数は終了位置を設定する --%>
                                end = sumNumber;
                            } else {
							   <%-- 選択されたページでレコードの開始位置　+　表示ページの総件数は終了位置を設定する --%>
                                end = start + count;
                            }
							<%--　不明帳票のリストで開始位置から終了位置まで取得する --%>
                            var tempPageitems = searchUnknownDisplayItems.slice(start, end);
                        return {
                            "numberOfAllItems": searchUnknownDisplayItems.length,
                            "fields": ["UnknownFormId", 'FormShortName', 'ErrorMessage', 'IpAddress', 'ScanDate'],
                            "items": tempPageitems
                        }
                    },
                    columns: [
                        {
                            searchTableFilters: "",
                            field: "UnknownFormId",
                            render: function (td, item) {
                                td.css("width", "40px");
                                var id = "UnknownFormCheck_" + item._data.UnknownFormId;
                                var tempCheck = "";
                                if (item.Selected) {
                                    tempCheck = "checked";
                                } else {
                                    if (item._data.dataIndex == 0) {
                                        tempCheck = "checked";
                                    } else {
                                        tempCheck = "";
                                    }
                                }

                                var selectBox = $('<input type="checkbox" rowIndex="' + item._data.rowIndex + '" name="unknownCheckBox" value="' + item._data.UnknownFormId + '" />')
                                    .prop("checked", item._data.Selected)
                                    .change(function () {
                                        item._data.Selected = $(this).is(":checked");
                                        var temprowIndex = $(this).attr("rowIndex");
                                        updateInnerUnknown(temprowIndex, item._data.Selected);
                                        unknownSetAllSelectBox();
                                    });
                                $(selectBox).appendTo(td);
                            }
                        },
                        {
                            searchTableFilters: "",
                            //defaultSortOrder: "asc",
                            field: "UnknownFormId",
                            render: function (td, item) {
                                td.css("width", "70px");
                                var html = '<span>' + item._data.UnknownFormId + '</span>';
                                $(html).appendTo(td);
                            }
                        },
                        {
                            searchTableFilters: "",
                            //defaultSortOrder: "asc",
                            field: "FormShortName",
                            render: function (td, item) {
                                //td.css("width", "200px");
                                var formName = $('<a href="javascript:void(0);" style="color: blue;" id="unknownFormName">' + item._data.FormShortName + '</a>')
                                    .click(function () {
							        <%-- 画像ダウンロード処理 --%>
                                        downloadUnknownImage(item._data.UnknownFormId);
                                    });
                                $(formName).appendTo(td);
                            }
                        },
                        {
                            searchTableFilters: "",
                            //defaultSortOrder: "asc",
                            field: "ErrorMessage",
                            render: function (td, item) {
                                //td.css("width", "400px");
                                var html = '<span>' + item._data.ErrorMessage + '</span>';
                                $(html).appendTo(td);
                            }
                        },
                        {
                            searchTableFilters: "",
                            //defaultSortOrder: "asc",
                            field: "IpAddress",
                            render: function (td, item) {
                                //td.css("width", "80px");
                                var html = '<span>' + item._data.IpAddress + '</span>';
                                $(html).appendTo(td);
                            }
                        },
                        {
                            searchTableFilters: "",
                            //defaultSortOrder: "asc",
                            field: "ScanDate",
                            render: function (td, item) {
                                //td.css("width", "100px");
                                var tempUnknowDate = ('000' + item._data.ScanDate.getFullYear()).slice(-4) + '/' +
                                    ('0' + (1 + item._data.ScanDate.getMonth())).slice(-2) + '/' +
                                    ('0' + item._data.ScanDate.getDate()).slice(-2) + ' ' +
                                    ('0' + item._data.ScanDate.getHours()).slice(-2) + ':' +
                                    ('0' + item._data.ScanDate.getMinutes()).slice(-2);
                                var html = '<span>' + tempUnknowDate + '</span>';
                                $(html).appendTo(td);
                            }
                        }
                    ],
                    afterRender: function () {
                        $("input[name=unknownCheckBox]").xuxCheckbox();
                        $("#unknownList").find(".xux-decoratedTable-trailingBox").eq(1).css("display", "none");
                        var tempHtmp = $("#unknownTableDiv").find('.ui-helper-clearfix').first().html();
                        if (tempHtmp == "") {
                            if (unknownWindowMode_ == 0) {
                                $("#unknownOKButton").hide();
                                $("#unknownDeleteButton").show();
                            } else {
                                $("#unknownOKButton").show();
                                $("#unknownDeleteButton").hide();
                            }
                        }
                        var unknownCheckIds = [];
                        $("[name=unknownCheckBox]").each(function () {
                            var isChecked = $(this).is(':checked');
                            if (isChecked) {
                                unknownCheckIds.push($(this).val());
                            }
                        });
                        if (unknownCheckIds.length > 0) {
                            $("#unknownOKButton").xuxButton({ "disabled": false });
                            $("#unknownDeleteButton").xuxButton({ "disabled": false });
                        } else {
                            $("#unknownOKButton").xuxButton({ "disabled": true });
                            $("#unknownDeleteButton").xuxButton({ "disabled": true });
                        }
                        <%-- 不明な帳票一覧の削除ボタン --%>
                        $('#unknownDeleteButton').click(function () {
                            var isError = false;
                            var bizId = $('#businessList').val().split(':');
                            var unknownIdList = getCheckedRowsUnknown();
                            if (unknownIdList.length === 0)
                                return;

                            var confMessage = unknownIdList.length + "件のレコードが選択されています\r\nレコードを削除してもよろしいですか？";
                            //if (confirm(confMessage) == false)
                            //    return;
                            confirmMessageEror(confMessage, function () {
                                var $deleteButton = $('#unknownDeleteButton');
                                $deleteButton.prop('disabled', true);

                                isUpdating_ = true;

                                $.ajax({
                                    type: 'POST',
                                    url: 'api/UnknownList',
                                    contentType: 'application/json',
                                    data: JSON.stringify({ unknownFormIds: unknownIdList }),
                                    dataType: "text",
                                    success: function (data, dataType) {
                                        if (data.indexOf("btnLogin") != -1) {
                                            isError = true;
                                            redirectLoginPage();
                                            return;
                                        }
                                        isUpdating_ = false;
                                    },
                                    error: function (XMLHttpRequest, textStatus, errorThrown) {
                                        isError = true;
                                        if (XMLHttpRequest.status == 401) {
                                            isError = true;
                                            redirectLoginPage();
                                            return;
                                        }
                                        alertMessageEror("レコードを削除できませんでした。");
                                    },
                                    complete: function (XMLHttpRequest, textStatus) {
                                        $deleteButton.prop('disabled', false);

                                        if (isError === false) {
                                            //ローカルに保持したデータを更新して再表示
                                            for (var j = 0; j < unknownIdList.length; j++) {
                                                for (var i = 0; i < unknownRowsList_.length; i++) {
                                                    if (unknownRowsList_[i].UnknownFormId == unknownIdList[j]) {
                                                        unknownRowsList_.splice(i, 1);
                                                        break;
                                                    }
                                                }
                                            }
                                            loadUnknownData(true);
                                        }
                                    }
                                });
                            }, null, '<%= Resources.Messages.OkButtonCaption %>', '<%= Resources.Messages.CancelButtonCaption %>');


                        });

                        <%-- 不明な帳票一覧ダイアログのOKボタン --%>
                        $('#unknownOKButton').click(function () {
                            unknownMergeRecordIdList_ = [];
                            $('#unknownTable').find('[name=unknownCheckBox]').each(function () {
                                if ($(this).is(':checked')) {
                                    unknownMergeRecordIdList_.push($(this).val());
                                }
                            });
                            loadSelectFormData();
                            //$selectFormDlg.dialog('open');
                            $("#selectForm").xuxModalWindow("open");
                            //$("#ConfRecordId").val("");
                        });
                        //$('.UnknownFilterDialog').unbind("click");
                        //$('.UnknownFilterDialog').click(function () {
                        //    var clickColumn = parseInt($(this).attr("columnindex"));
                        //    var columnDef = UnknownDataTableOptions.columns[clickColumn];
                        //    if (columnDef.sortable === false) {
                        //        return;
                        //    }
                        //    if (columnDef.sortable !== false) {

                        //    }


                        //    if (UnknownDataTableOptions.columns[clickColumn].searchTableColumnDirection == "asc") {
                        //        toggleRecordSort($unknownTable_, clickColumn, 'desc', null, "unknownFilter");
                        //    } else if (UnknownDataTableOptions.columns[clickColumn].searchTableColumnDirection == "") {
                        //        toggleRecordSort($unknownTable_, clickColumn, 'asc', null, "unknownFilter");
                        //    } else {
                        //        toggleRecordSort($unknownTable_, clickColumn, 'asc', null, "unknownFilter");
                        //    }
                        //    //createUnknownFilterDialog(-1, $(this));
                        //    //$("input[type=checkbox]").xuxCheckbox();
                        //    //$("input[type=button]").xuxButton();
                        //    ////$("#unknownFilterToDate").xuxDateFieldBox();
                        //    ////$("#unknownFilterFromDate").xuxDateFieldBox();
                        //    //$("#unknownStartNoCondDiv").xuxTextFieldBox();
                        //    //$("#unknownFilterToDateDiv").xuxTextFieldBox();
                        //    //$("#unknownColumnPopup").xuxModalWindow({});
                        //    //$("#unknownColumnPopup").xuxModalWindow("open");
                        //    $("#unknownColumnPopupTitel").html($(this).html());
                        //});
                        unknownSetAllSelectBox();
                        resetUnknownTableHeadercolor();
                        $('#unknownTable').find(".xux-table-header").first().css("padding", "0px");
                        showUnknownSortFlag();
                    }
                };
                UnknownDataTableOptions.columns[1].searchTableColumnDirection = "asc";
                clickUnknownHeaderCell = 1;
                $unknownTable_ = $('#unknownTableDiv').xuxDecoratedTable(UnknownDataTableOptions);
            } else {
                $('#unknownTableDiv').xuxDecoratedTable('reload');
            }


            $unknownTable_.order = function (tempSortOptions) {

                if (tempSortOptions) {
                    UnknownDataTableOptions.sortOptions.column = tempSortOptions[0][0];
                    UnknownDataTableOptions.sortOptions.order = tempSortOptions[0][1];
                } else {
                    if ($unknownTable_) {
                        return [[UnknownDataTableOptions.sortOptions.column, UnknownDataTableOptions.sortOptions.order]];
                    } else {
                        return null;
                    }

                }
            }
        }
        function showUnknownSortFlag() {
            setTimeout(function () {
                if (clickUnknownHeaderCell != null) {
                    $(".UnknownFilterDialog").each(function () {
                        var columnindexTemp = $(this).attr("columnindex");
                        $(this).parent().parent().find(".xux-table-sort").remove();
                        if (UnknownDataTableOptions.columns[clickUnknownHeaderCell].searchTableColumnDirection == "desc") {
                            if (columnindexTemp == clickUnknownHeaderCell) {
                                var sortTextTemp = '<span class="xux-table-sort" aria-hidden="true" style="margin-left:30px"></span>';
                                $(this).parent().parent().append(sortTextTemp);
                                $(this).parent().parent().parent().attr("aria-sort", "descending");
                                $(this).parent().parent().parent().removeClass("xux-table-sort-asc");
                                $(this).parent().parent().parent().addClass("xux-table-sort-desc");
                            }
                        } else {
                            if (UnknownDataTableOptions.columns[clickUnknownHeaderCell].searchTableColumnDirection == "asc") {
                                if (columnindexTemp == clickUnknownHeaderCell) {
                                    var sortTextTemp = '<span class="xux-table-sort" aria-hidden="true" style="margin-left:30px"></span>';
                                    $(this).parent().parent().append(sortTextTemp);
                                    $(this).parent().parent().parent().attr("aria-sort", "ascending");
                                    $(this).parent().parent().parent().removeClass("xux-table-sort-desc");
                                    $(this).parent().parent().parent().addClass("xux-table-sort-asc");
                                }
                            }

                        }
                        //if ($(this).parent().parent().find(".xux-icon-funnel").length <= 0) {
                        //    var clickfilterCellWidth = $(this).first().width() + 30;
                        //    var filterTextTemp = '<span  class="xux-icon xux-icon-size-medium xux-icon-funnel" style="font-size: 16px;position: absolute;left:' + clickfilterCellWidth + 'px"></span>';
                        //    $(this).parent().parent().append(filterTextTemp);
                        //}                        
                    });
                    $('.headerUnknownRecord').click(function () {
                        if (unknownRowsList_) {
                            if (unknownRowsList_ != null && unknownRowsList_.length <= 0) {
                                return;
                            }
                            var clickColumn = parseInt($(this).find(".UnknownFilterDialog").first().attr("columnindex"));
                            resetUnknownTableHeadercolor();
                            //$(this).parent().parent().parent().first().css("background-color", '#B2B2B2');

                            var clickObj = $(this).find(".UnknownFilterDialog").first();
                            createUnknownFilterDialog(clickColumn, clickObj);
                            $("input[type=checkbox]").xuxCheckbox();
                            $("input[type=button]").xuxButton();
                            //$("#unknownFilterToDate").xuxDateFieldBox();
                            //$("#unknownFilterFromDate").xuxDateFieldBox();
                            $("#unknownStartNoCondDiv").xuxTextFieldBox();
                            $("#unknownFilterToDateDiv").xuxTextFieldBox();
                            $("#unknownColumnPopup").xuxModalWindow({});
                            $("#unknownColumnPopup").xuxModalWindow("open");
                            //showDiv($("#unknownColumnPopup"), $("#unknownColumnPopupItems"), $(this), $("#unknowDiv"), 200, "unknownFilter");
                            $("#unknownColumnPopupTitel").html(clickObj.html());

                            //$("#columnPopup").xuxModalWindow("open");
                            if ($(this).attr("columnindex") != "2") {
                                $("#columnPopupTitel").html(clickObj.html());
                            } else {
                                $("#columnPopupTitel").html("&nbsp;");
                            }
                        }



                    });
                    resetUnknownTableHeadercolor();

                }
            }, 0);

        }

        function saveUnknownSelectPageCount() {
            //unknowRecordTablePageCount = $("#unknownTableDiv").find(".xux-decoratedTable-dropdownForItems").first().find("select").val();
        }
        <%-- 不明帳票一覧の帳票名リンク --%>
        function downloadUnknownImage(formId) {
            unknownImageWindow_ = window.open("api/UnknownListImage?" + $.param({ unknownFormId: formId }), "UnknownImage", "width=400,height=500");
            unknownImageWindow_.focus();
        }
        var closeType = 0; <%-- 0:F5orアドレスバーEnterなど、1:製品ロゴor業務切替orログアウト、2:セッションタイムアウト --%>

        <%-- 不明な帳票一覧一覧で操作した選択の変更をDataTablesの実データに反映 --%>
        function updateInnerUnknown(rowIndex, value) {
            unknownButtonsDisable(!value);
            unknownRowsList_[rowIndex].Selected = value;
        }

        <%-- 不明な帳票一覧ボタンの活性制御 --%>
        function unknownSetAllSelectBox() {
            var checkBoxCount = $("[name=unknownCheckBox]").length;
            var checkCount = 0;
            $("[name=unknownCheckBox]").each(function () {
                var isChecked = $(this).is(':checked');
                if (isChecked) {
                    checkCount++;
                }

            });
            if (checkCount == checkBoxCount && checkBoxCount != 0) {
                $("#allUnknownCheckBox").prop('checked', true).xuxCheckbox("refresh");;
            } else {
                $("#allUnknownCheckBox").prop('checked', false).xuxCheckbox("refresh");;
            }
        }
        function unknownButtonsDisable(state) {
            var endNow = ($('#businessList').val().split(':'))[1] === '2';
            if (endNow) {
                //$('#unknownDeleteButton').prop('disabled', true);
                $("#unknownDeleteButton").xuxButton({ "disabled": true });
                //$('#unknownOKButton').prop('disabled', true);
                $("#unknownOKButton").xuxButton({ "disabled": true });
                return;
            }

            <%-- 非活性で呼ばれたとき、まだ１件でもチェックされていれば何もしない --%>
            var hasCheck = false;
            if (state) {
                var $filterCond = $('[name=unknownCheckBox]');
                $.each($filterCond, function (index, value) {
                    if ($(this).is(':checked')) {
                        hasCheck = true;
                        return false;   <%-- break --%>
                    }
                });

                if (hasCheck) {
                    return;
                }
            }
            var checkBoxCount = $("[name=unknownCheckBox]").length;
            if (checkBoxCount > 0) {
                //$('#unknownDeleteButton').prop('disabled', state);
                $("#unknownDeleteButton").xuxButton({ "disabled": state });
                //$('#unknownOKButton').prop('disabled', state);
                $("#unknownOKButton").xuxButton({ "disabled": state });
            }
        }

         <%-- 不明な帳票一覧チェックされた行のレコードID取得 List<int> --%>
        function getCheckedRowsUnknown() {
            var ids = [];
            for (var i = 0; i < unknownRowsList_.length; i++) {
                if (unknownRowsList_[i].Selected) {
                    ids.push(unknownRowsList_[i].UnknownFormId);
                }
            }
            return ids;
        }

         <%-- チェックされた行のレコードID取得 List<int> --%>
        function getCheckedRows() {
            var ids = [];
				<%-- 選択済みだけを対象とする --%>
            $('#elementsTable').find('[name=selectCheckBox]').each(function () {
                if ($(this).is(':checked')) {
                    ids.push($(this).val());
                }
            });
            return ids;
        }

        <%-- チェックされた行のレコードID取得 string --%>
        function getCheckedRowsIds() {
            var recordIdArray = getCheckedRows();
            var recordIds = "";
            if (recordIdArray.length > 0) {
                for (var i = 0; i < recordIdArray.length; i++) {
                    if (recordIds.length > 0) {
                        recordIds += ",";
                    }
                    recordIds += recordIdArray[i];
                }
            }
            return recordIds;
        }

        <%-- ログイン画面へのリダイレクト処理 --%>
        function redirectLoginPage() {
            closeType = 2;
            if (checkChanged(false)) {
                alertMessageInfo('<%= Resources.Messages.ConfirmWindowCloseMessageTimeout %>', function () {
                    window.location = "Login.aspx";
                });
            } else {
                alertMessageInfo('<%= Resources.Messages.AjaxSessionTimeoutMessage %>', function () {
                    window.location = "Login.aspx";
                });
            }

        }

        <%-- 確認訂正画面で変更されているかチェックする --%>
        function checkChanged(isUpdate) {
            if (winHandle_ == null && getCookie(COOKIENAME_CONFIRMATION_OPEN) != null) {
                winHandle_ = window.open("", "Confirmation");
            }

            if (winHandle_ == null) return false;

            if (winHandle_.closed) return false;

            if (!winHandle_.elementRowsList_) return false;

            var elementRowsListLength = winHandle_.elementRowsList_.length;
            if (!elementRowsListLength) return false;

            var isChanged = false;
            for (var i = 0; i < elementRowsListLength; i++) {
                if (winHandle_.elementRowsList_[i].isChanged) {
                    isChanged = true;
                    if (isUpdate) winHandle_.elementRowsList_[i].isChanged = false;
                }
            }
            return isChanged;
        }

        function putPerformanceLog(message) {
            if (window.console && console.log) {
                var date = new Date();
                console.log(message + "：" + date + "(" + date.getTime() + ")");
            }
        }

        /** 
         * フィルターダイアログの日付条件をセット。 
         * @param {int} mode  0:開始条件のみ, 1:終了条件のみ, 2:開始条件、終了条件
         * @param {int} index  対象インデックス
         * @param {string} date  日付文字列
         */
        function setFilterDateCondition(mode, index, date) {
            if (index < 0) {
                return;
            }
            if (mode === 0) {
                filterToDate_[index] = date;
            } else if (mode === 1) {
                filterFromDate_[index] = date;
            } else {
                filterToDate_[index] = date;
                filterFromDate_[index] = date;
            }
            // 日付条件でソートされたカラム情報を格納
            if (!filterToDate_[index] && !filterFromDate_[index] && filterToDate_[index] !== '' && filterFromDate_[index] !== '') {
                sortFilterColumnIndexList_[index] = null;
            } else {
                sortFilterColumnIndexList_[index] = index;
            }
        }

        /** 
         * フィルターダイアログの日付条件を取得。 
         * @param {int} mode  0:開始条件, 1:終了条件
         * @param {int} index  対象インデックス
         * @return {string} 日付文字列
         */
        function getFilterDateCondition(mode, index) {
            if (index < 0 || 1 < mode) {
                return null;
            }
            if (mode === 0) {
                return filterToDate_[index];
            } else {
                return filterFromDate_[index];
            }
        }

        function dateFormat(date) {
            let ret;
            let fmt = "YYYY-mm-dd";
            const opt = {
                "Y+": date.getFullYear().toString(),
                "m+": (date.getMonth() + 1).toString(),
                "d+": date.getDate().toString()

            };
            for (let k in opt) {
                ret = new RegExp("(" + k + ")").exec(fmt);
                if (ret) {
                    fmt = fmt.replace(ret[1], (ret[1].length == 1) ? (opt[k]) : (opt[k].padStart(ret[1].length, "0")))
                };
            };

            return fmt;
        }
        //------------------------------------2021-08-26-------------------------------------//
        // function DataRange
        var dataRange = null;

        var winHandle_ = null;
        var previewWinHandle_ = null;

        <%-- 確認訂正での更新通知処理 --%>
        function NoticeConfirmCorrectUpdate() {
            // $('#updateMessage').show();
            $("#refreshTips").css("display", "inline-block")
            // エラー通知ダイアログが表示されている場合は再読み込み
            if (errorWindowModel != null && errorWindowModel.xuxModalWindow("isOpen")) {
                var businessRecordId = $('#errInfo').attr("businessRecordId");
                if (businessRecordId) {
                    $("#errInfo").attr("businessRecordId", businessRecordId);
                    $("#clearErrDiv").html('');
                    $("#clearErrDiv").html('<div id = "recordTableErrDiv" ><table id="recordErrTable" style="width: 100%;"><thead><th style="width: 20%;">帳票名</th><th style="width: 60%;">内容</th><th style="width: 20%;">操作</th></thead><tbody></tbody></table></div >');
                    $("#modeErr").html("通知");
                    $("#consoleErrButton").show()
                    bindErrorList(businessRecordId);
                }
            }
        }
        //--------------------------------------------------------情報のアイコン begin------------------------------------------------------------//
        <%-- エラー通知一覧の再読み込み --%>
        var errorWindowModel = null;
        function LoadErrorList(businessRecordId) {
            $("#errInfo").attr("businessRecordId", businessRecordId);
            errorWindowModel = $("#errInfo").xuxModalWindow({
                open: function () {
                    //var businessId = $('#businessList').val().split(':')[0];
                    bindErrorList(businessRecordId);
                }
            });
            $("#errInfo").xuxModalWindow("open");
        }
        function bindErrorList(businessRecordId) {
            var businessId = $('#businessList').val().split(':')[0];
            $.ajax({
                type: 'GET',
                url: 'api/ErrorList',
                data: { businessId: businessId, businessRecordId: businessRecordId },
                dataType: "json",
                success: function (data, dataType) {
                    if (data.Code == 1) {
                        redirectLoginPage();
                        return;
                    } else if (data.Code == 9) {
                        alertMessageInfo(data.Message);
                        //$("#errInfo").dialog("close");
                        $("#errInfo").xuxModalWindow("close");
                        return;
                    }
                    displayItems_ = data.DefectNotices;
                    var DataTableErrViewOptions = getRecordTableViewMode(displayItems_);
                    $("#recordTableErrDiv").xuxDecoratedTable(DataTableErrViewOptions);
                    //$errorTable_.clear().rows.add(data.DefectNotices).draw();
                },
                error: function (XMLHttpRequest, textStatus, errorThrown) {
                    if (XMLHttpRequest.status == 200) {
                        redirectLoginPage();
                        return;
                    }
                    alertMessageEror('<%= Resources.Messages.AjaxErrorMessage %>');
                }
            });
        }
        function getRecordTableViewMode(displayItems_) {
            return {
                selectionUnit: "none",
                pageNavigationPosition: "none",
                clear: true,
                noRowMessage: '<%= Resources.Messages.DataTableZeroRecordsMessage %>',
                data: {
                    "fields": ["FormShortName", "ErrorMessage", "FormShortButton"],
                    "items": displayItems_
                },
                columns: [
                    {
                        field: "FormShortName",
                        render: function (td, item) {
                            var data = item._data;
                            var html = '<span>' + data.MForm.FormShortName + '</span>';
                            $(html).appendTo(td);
                        }
                    },
                    {
                        field: "ErrorMessage",
                        render: function (td, item) {
                            var data = item._data;
                            var html = '<span style="white-space: pre-wrap;">' + data.ErrorMessage + '</span>';
                            $(html).appendTo(td);
                        }
                    },
                    {
                        field: "FormShortButton",
                        render: function (td, item) {
                            var data = item._data;
                            if (data.ElementId != 0) {
                                var $correctButton = $('<input id="correctErrButton" class="correctButton" type="button" value="訂正" />')
                                    .button()
                                    .click(function () { transConfirmCorrect(data.FormId, data.MForm.FormName, data.ElementId, data.BusinessRecordId) });
                                // 業務ステータス対応
                                if (data.MBusiness.BusinessStatus != 1) {
                                    $correctButton.button("disable");
                                }
                                $correctButton.xuxButton();
                                $($correctButton).appendTo(td);
                            }
                        }
                    }
                ],

            }
        }
        function transConfirmCorrect(formId, formName, elementId, businessRecordIds, mode) {
            var bizId = $('#businessList').val().split(':');
            var localMode = -1, localBRID = -1;
            if (mode)
                localMode = mode;
            if (businessRecordIds)
                localBRID = businessRecordIds;
            $.ajax({
                type: 'POST',
                url: 'api/ErrorList',
                contentType: 'application/json',
                data: JSON.stringify({ BusinessId: bizId[0], FormId: formId, FormName: formName, ElementId: elementId, BusinessRecordIds: localBRID, Mode: localMode }),
                success: function (data, dataType) {
                    if (data.Code == 1) {
                        redirectLoginPage();
                    } else if (data.Code == 9) {
                        alertMessageInfo(data.Message);
                        //$("#errInfo").dialog("close");
                        $("#errInfo").xuxModalWindow("close");
                        return;
                    } else {
                        if (localMode === -1) {
                            openConfirmationWindow("FormsFormat.aspx");
                        } else {
                            if (localMode === '1') {
                                openConfirmationWindow("FormsFormat.aspx");
                            } else if (localMode === '2') {
                                openConfirmationWindow("QuestionnaireFormat.aspx");
                            }
                            //$('#confirmCorrectList').val(0);
                            //$($("#confirmCorrectListDiv div div a span span span")[0]).html($("#confirmCorrectList").text().split('\n\t')[1]);
                        }
                    }
                },
                error: function (XMLHttpRequest, textStatus, errorThrown) {
                    alertMessageEror('<%= Resources.Messages.AjaxErrorMessage %>');
                }
            });
        }
        function openConfirmationWindow(url) {
            var x = screen.width * 0.98;
            var y = screen.height * 0.9;
            if (isBrowserChrome())
                y = screen.height * 0.87;
            try {
                winHandle_ = window.open(url, "Confirmation", "screenX=0,screenY=0,left=0,top=0,width=" + x + ",height=" + y + ",scrollbars=yes,toolbar=no,menubar=no,staus=no,resizable=yes");
            } catch (e) {
                // do nothing.
            }
            if (winHandle_ != null) {
                winHandle_.focus();
            }
        }
        function setChangePass() {
            var tempOptions = $("#userMenuList").get(0).options;
            for (var i = 0; i < tempOptions.length; i++) {
                if (tempOptions[i].value == "1") {
                    var ariaControlsId = $(".xux-login").attr("aria-controls");
                    $("#" + ariaControlsId).append('<li class="xux-item-top xux-item-bottom ui-menu-item" ><a href="#" id="changePassword">' + tempOptions[i].text + '</a></li>');
                }
            }
        }
        <%-- ボタンの初期活性制御 --%>
        buttonsInitDisable = function (isChange) {
            var executeNow = ($('#businessList').val().split(':'))[1] == '1';
            if (executeNow) {
                $('#printButton').xuxButton({ "disabled": false });
            } else {
                $('#printButton').xuxButton({ "disabled": true });
            }

            var newState = true;
            if (isChange != null) {
	            <%-- (表示件数切替時)１件でもチェックされていれば活性 --%>
                var $filterCond = $('[name=selectCheckBox]');
                $.each($filterCond, function (index, value) {
                    if ($(this).is(':checked')) {
                        newState = false;
                        return false;   <%-- break --%>
                    }
                });
            }
            $('#CSVOutputButton').xuxButton({ "disabled": newState });
            $('#confirmCorrectList2').xuxButton({ "disabled": newState });
            $('#deleteButton').xuxButton({ "disabled": newState });
            //$('#confirmCorrectList3').xuxButton({ "disabled": newState });
            //$('#confirmCorrectListDiv').xuxDropdownBox({ "disabled": newState });
        }
        //--------------------------------情報のアイコン end------------------------------------------------------------//

        $(function () {
            $("#showDeviceSelect").addClass("ui-state-highlight");
            $("body").xuxPage({
                width: "full",
                loginout: true,
                login: function () {
                    var user = {
                        userName: "<%=(string)Session["USER_NAME"]%>",
                        userType: "NormalUser"
                    }
                    $("header").xuxHeader("utilityLinks").xuxUtilityLinks("option", "user", user);
                },
                logout: function () {
                    if (checkChanged(false)) {
                       <%-- if (!window.confirm('<%= Resources.Messages.ConfirmWindowCloseMessageLogout %>')) {
                            return;
                         }--%>
                        confirmMessageEror('<%= Resources.Messages.ConfirmWindowCloseMessageLogout %>', function () {
                            closeType = 1;
                            location.href = "Logout.aspx";
                        }, null, '<%= Resources.Messages.OkButtonCaption %>', '<%= Resources.Messages.CancelButtonCaption %>');
                    } else {
                        <%-- if (!window.confirm('<%= Resources.Messages.ConfirmLogoutMessage %>')) {
                             return;
                         }--%>
                        confirmMessageEror('<%= Resources.Messages.ConfirmLogoutMessage %>', function () {
                            closeType = 1;
                            location.href = "Logout.aspx";
                        }, null, '<%= Resources.Messages.OkButtonCaption %>', '<%= Resources.Messages.CancelButtonCaption %>');
                    }

                }
            });
            setTimeout(function () {
                var user = {
                    userName: "<%=(string)Session["USER_NAME"]%>",
                    userType: "NormalUser"
                }
                $("header").xuxHeader("utilityLinks").xuxUtilityLinks("option", "user", user);
                setChangePass();
                 <%-- ユーザーメニュー選択 --%>
                $('#changePassword').click(function () {
                    <%-- パスワード変更:1 --%>

                    $("#frmChgPWDDialog").xuxModalWindow({});
                    $("#frmChgPWDDialog").xuxModalWindow('open');
                    //$("input[type=button]").xuxButton();
                    //$("input[type=text]").xuxTextFieldBox();
                    $("#password").val("");
                    $("#newPWDDiv").val("");
                    $("#confPWDDDiv").val("");
                });
            }, 100);
            //$(".xux-stickyBar").css("min-width", "1000px");
            //$("header").css("min-width", "1000px");
            $(".staticXux").xuxButton();
            $("#printButton").xuxButton();
            $('#printButton').prop('disabled', false);
            $("#selectForm").xuxModalWindow({});
            $("#mfpFormClose").xuxButton();
            $("#mfpForm").xuxModalWindow({});
            $("#mfpFormprintPreview").xuxButton();
            $("#mfpFormConfirm1").xuxButton();
            $("#mfpFormConfirm1").xuxButton("option", "type", "default");
            $("#printNumDiv").xuxTextFieldBox();
            $("#colorModeDiv").xuxDropdownBox();
            $("#bothSideDiv").xuxDropdownBox();
            $("#layoutDiv").xuxDropdownBox();
            $("#tray").xuxCheckbox();
            $("#textDataRangeStartDate").xuxDateFieldBox();
            $("#textDataRangeEndDate").xuxDateFieldBox();
            $("#columnPopup").xuxModalWindow({});
            //$("#confirmCorrectListDiv").xuxDropdownBox({ width: 'narrow' });
            $("#confirmCorrectList2").xuxButton();
            //$("#confirmCorrectList3").xuxButton();
            $("#businessListDiv").xuxDropdownBox({ width: 'narrow' });

            <%-- 表示レコードの範囲設定 start --%>
            $("#dataRangeDialog").xuxModalWindow({});
            dataRange = new DataRange();
            $("#dataRangeButton").xuxButton();
            $("#chkDataRangeRecord").xuxCheckbox();
            $("#rangeSelectDiv").xuxDropdownBox({ width: 'narrow' });
            $("#textDataRangeRecordS").xuxTextFieldBox();
            $("#textDataRangeRecordE").xuxTextFieldBox();
            $("#chkDataRangeItem").xuxCheckbox();
            $("#consoleButton").xuxButton();
            $("#confirmButton").xuxButton();
            $("#confirmButton").xuxButton("option", "type", "default");
            $("#dataRangeCountButton").xuxButton();

            $("#frmChgPWDDialog").xuxModalWindow({});
            $(".close").click(function () {
                $("#dataRangeDialog").xuxModalWindow("close");
            });
            dataRange.setDataRange();
            dataRange.callAPIAsync(dataRange.ACTION_BUSINESS_ID, 0, -1, function (data) {
                dataRange.removeRangeCookieIf(data.Values);            // 不要なDataRangeクッキー削除
            });
            $("#dataRangeButton").click(dataRange.clickDataRange);
            var dl = document.getElementById('businessList');
            dl.onchange = dataRange.selectBusiness;     // onchangeを上書き
            dataRange.currentBusiness = $("#businessList").val();      // 現在の業務値を保存
            putPerformanceLog("DataRange:OnLoad 終了");
            <%-- 表示レコードの範囲設定 end --%>

            <%--不明な帳票一覧ダイアログ start --%>
            $("#unknownList").xuxModalWindow({
                width: "wide",
                close: function (event) {
                    $('#unknownCloseButton').trigger('click');
                }
            });
            $("#unknownCloseButton").xuxButton();
            $("#unknownOKButton").xuxButton();
            <%--不明な帳票一覧ダイアログ end --%>

            <%-- CSV出力 start --%>
            <%-- ボタンの初期活性制御 --%>
            buttonsInitDisable();
            <%-- CSV出力 end --%>

            <%-- パスワードの変更 start --%>
            $("#curPWDDiv").xuxPasswordFieldBox();
            $("#newPWDDiv").xuxPasswordFieldBox();
            $("#confPWDDDiv").xuxPasswordFieldBox();
            $("#confirmChgPWDButton").xuxButton();
            $("#confirmChgPWDButton").xuxButton("option", "type", "default");
            $("#consoleChgPWDButton").xuxButton();
            <%-- パスワードの変更 end --%>

            $("#consoleErrButton").hide();
            $("#recordTableErrDiv").hide();
            $("#errInfo").hide();

            $("#menulink").xuxContextMenuTrigger({
                menu: $("#utilmenu").xuxContextMenu(),
                context: "utilmenu"
            });
            $("#userNameHeader").html("<%=(string)Session["USER_NAME"]%>");
            $("#userAction").xuxContextMenuTrigger({
                menu: $("#userActionMenu").xuxContextMenu(),
                context: "userActionMenu"
            });
            $(".staticdropdoBox").xuxDropdownBox();
            $("input[type=button]").xuxButton();

            $("#selectReport").hide();
            <%-- ajaxの初期化 --%>
            $.ajaxSetup({
                cache: false,
                global: false,
                error: function (XMLHttpRequest, textStatus, errorThrown) {
                    if (XMLHttpRequest.status == 200) {
                        redirectLoginPage();
                        return;
                    }
                    alertMessageEror('<%= Resources.Messages.AjaxErrorMessage %>');
                    isUpdating_ = false;
                    removeLoading();
                }
            });


            <%-- ここからパスワードの変更 Start --%>
            $("#confirmCorrectList2").val($("#confirmCorrectList").text().split('\n\t')[1]);
            var userID = "<%=Session[ "USER_ID" ]%>";
            var curPWD = $("#curPWD");
            var newPWD = $("#newPWD");
            var confPWD = $("#confPWD");
            var errMsg = $(".CheckResult");
            $("#confirmChgPWDButton").click(function () {
                ChangePassword();
            });
            $("#consoleChgPWDButton").click(function () {
                ResetMsg(true);
                $("#frmChgPWDDialog").xuxModalWindow("close");
            });
            // パスワード変更処理
            function ChangePassword() {
                var bRcd = true;

                // エラーField Reset
                ResetMsg(false);

                // 現在のパスワード入力チェック
                bRcd = checkInput(curPWD, "現在のパスワード");
                if (bRcd != true) {
                    return (false);
                }

                // 新しいパスワード入力チェック
                bRcd = checkInput(newPWD, "新しいパスワード");
                if (bRcd != true) {
                    return (false);
                }

                // 現在のパスワードと比較
                if (curPWD.val() == newPWD.val()) {
                    SetMsg("新しいパスワードが、現在のパスワードと同一です。", newPWD);
                    return (false);
                }
                // 新しいパスワード（確認）入力チェック
                bRcd = checkInput(confPWD, "新しいパスワード（確認）");
                if (bRcd != true) {
                    return (false);
                }

                // 新パスワード比較
                bRcd = CompNewPwd(newPWD, confPWD);
                if (bRcd != true) {
                    return (false);
                }

                // 内部処理へ
                bRcd = UpdatePwd(userID, curPWD, newPWD);

                return (bRcd);
            }
            // 更新処理
            function UpdatePwd(userID, curPwd, newPwd) {
                var curPassword = curPwd.val();
                var newPassword = newPwd.val();

                $.ajax(
                    {
                        type: 'POST',
                        url: 'api/ChgPassword',
                        contentType: 'application/json',
                        data: JSON.stringify({ userId: userID, oldPassword: curPassword, newPassword: newPassword }),
                        success: function (data, dataType) {
                            // 認証タイムアウトチェック
                            if (typeof data.Code === "undefined") {
                                redirectLoginPage();
                                return false;
                            }
                            if (data.Code == '<%= QuestionnaireConfirm.ApiControllers.ChgPasswordController.ResultCodeSuccess %>') {
                                // 成功
                                alertMessageInfo("パスワードを変更しました。");
                                ResetMsg(true);
                                $("#frmChgPWDDialog").xuxModalWindow("close");
                                isChgErr = false;
                                return (true);
                            } else if (data.Code == '<%= QuestionnaireConfirm.ApiControllers.ChgPasswordController.ResultCodeSessionTimeOut %>') {
                                // セッションタイムアウトのためログイン画面へリダイレクト
                                redirectLoginPage();
                            } else {
                                alertMessageInfo(data.Message);
                            }
                        },
                        error: function (XMLHttpRequest, textStatus, errorThrown) {
                            alertMessageEror('<%= Resources.Messages.AjaxErrorMessage %>');
                            isChgErr = true;
                            return (false);
                        }
                    });
            }
            // 新パスワード比較
            function CompNewPwd(nPwd, cPwd) {
                var newPwd = nPwd.val();
                var confPWD = cPwd.val();

                if (newPwd != confPWD) {
                    // 確認パスワードと新パスワードが一致しない
                    SetMsg("新しいパスワードが正しくありません。", nPwd);
                    return (false);
                }

                return (true);
            }
            // パスワード入力チェック
            function checkInput(value, caption) {
                // 未入力か
                if (value.val().length == 0) {
                    // 未入力
                    SetMsg(caption + "を入力してください。", value);
                    return (false);
                }

                // 最大長を超えていないか
                if (value.val().length > 100) {
                    // 100文字を超えている
                    SetMsg("パスワードは100桁以内で入力してください。", value);
                    return (false);
                }

                // 使用可能文字以外を使用していないか
                var range = /^([0-9a-zA-Z\@\-_.])+$/;
                if (range.test(value.val()) != true) {
                    // 無効な文字を使用している
                    SetMsg("パスワードは半角英数、および\"@\"、\"_\"、\"-\"、\".\"で入力してください。", value);
                    return (false);
                }

                return (true);
            }
            // メッセージセット
            function SetMsg(t, target) {
                errMsg.text(t);
                target.addClass("ui-state-error");
            }
            // メッセージリセット
            function ResetMsg(bAll) {
                errMsg.text("");
                curPWD.removeClass("ui-state-error");
                newPWD.removeClass("ui-state-error");
                confPWD.removeClass("ui-state-error");

                if (bAll == true) {
                    $("#curPWD").val("");
                    $("#newPWD").val("");
                    $("#confPWD").val("");
                    $("#userMenuList").val(userID);
                }
            }
            //--------------------------------------------------------レコード一覧画面begin------------------------------------------------------------//
             <%-- レコードの新規作成ボタン --%>
            var $createNewRecordButton = $('#createNewRecordButton')
                .click(function () {
                    $("#ConfRecordId").val(0);
                    $("#clearDiv").html('');
                    $("#clearDiv").html('<div id = "recordTableDiv" ><table id="recordTable" style="border: 1px solid #ccc;"><thead><th style="width: 50%;">設問名</th><th style="width: 50%;">値</th></thead><tbody></tbody></table></div >' +
                        '<div id="recordTableViewModeDiv"><table id="recordTableViewMode" style="border: 1px solid #ccc;"><thead><th style="width: 50%;">設問名</th><th style="width: 50%;">値</th></thead><tbody></tbody></table></div>');
                    // レコード編集を表示、レコード詳細を非表示．
                    $("#recordTableDiv").show();
                    $("#recordTableViewModeDiv").hide();

                    $("#mode").html("レコードの新規作成");
                    $("#editMode1").hide();
                    $("#billPayment1").hide();
                    $("#console2").hide();
                    $("#confirm2").hide();
                    $("#console1").show();
                    $("#confirm1").show();
                    // int flg  :0 レコードの作成
                    createRecordDialog(0);

                });

                            <%-- レコードの削除ボタン --%>
            var $deleteButton = $('#deleteButton')
                //.prop('disabled', true)
                .click(function () {
                    var isError = false;
                    var bizId = $('#businessList').val().split(':');
                    var recordIds = getCheckedRows();
                    if (recordIds.length === 0)
                        return;

                    var confMessage = recordIds.length + "件のレコードが選択されています\r\nレコードを削除してもよろしいですか？";
                    //if (confirm(confMessage) == false)
                    //    return;
                    confirmMessageEror(confMessage, function () {
                        var $deleteButton = $('#deleteButton');
                        dispLoading("<%= Resources.Messages.ProcessingMessage %>");
                        isUpdating_ = true;
                        $.ajax({
                            type: 'POST',
                            url: 'api/BusinessRecord',
                            contentType: 'application/json',
                            data: JSON.stringify({ businessId: bizId[0], businessRecordIds: recordIds }),
                            success: function (data, dataType) {
                                if (data.indexOf("btnLogin") != -1) {
                                    isError = true;
                                    redirectLoginPage();
                                    return;
                                }
                                isUpdating_ = false;
                                //$('#CSVOutputButton').prop('disabled', true);
                                $("#CSVOutputButton").xuxButton({ "disabled": true });
                                //$('#confirmCorrectList').prop('disabled', true);
                                //$("#confirmCorrectListDiv").xuxDropdownBox({ "disabled": true });
                                $("#confirmCorrectList2").xuxButton({ "disabled": true });
                                //$("#confirmCorrectList3").xuxButton({ "disabled": true });
                                //$('#deleteButton').prop('disabled', true);
                                $("#deleteButton").xuxButton({ "disabled": true });
                            },
                            error: function (XMLHttpRequest, textStatus, errorThrown) {
                                isError = true;
                                if (XMLHttpRequest.status == 401) {
                                    redirectLoginPage();
                                    return;
                                }
                                var responseText = XMLHttpRequest.responseText;
                                var response;

                                try {
                                    response = JSON.parse(responseText);
                                } catch (e) {
                                    response = null;
                                }

                                var successCount = 0;
                                var failCount = 0;

                                if (response) {
                                    successCount = parseInt(response.SuccessCount) || 0;
                                    failCount = parseInt(response.FailCount) || 0;
                                }

                                if (successCount === 0 && failCount === 0) {
                                    failCount = recordIds.length;
                                }
                                if (successCount > 0) {
                                    isError = false;
                                }
                                
                                alertMessageEror("レコードを削除できませんでした。\r\n成功： " + successCount + "件\r\n失敗： " + failCount + "件");
                                //$('#CSVOutputButton').prop('disabled', false);
                                $("#CSVOutputButton").xuxButton({ "disabled": false });
                                //$('#confirmCorrectList').prop('disabled', false);
                                //$("#confirmCorrectListDiv").xuxDropdownBox({ "disabled": false });
                                $("#confirmCorrectList2").xuxButton({ "disabled": false });
                                //$("#confirmCorrectList3").xuxButton({ "disabled": false });
                                //$deleteButton.prop('disabled', false);
                                $deleteButton.xuxButton({ "disabled": false });
                            },
                            complete: function (XMLHttpRequest, textStatus) {
                                removeLoading();

                                if (isError === false) {
                                    <%--  ローカルに保持したデータを更新して再表示 --%>
                                      loadTabData(true);
                                    <%-- 現在の使用量も更新 --%>
                                      getAmountSize();
                                }
                            }
                        });
                    }, null, '<%= Resources.Messages.OkButtonCaption %>', '<%= Resources.Messages.CancelButtonCaption %>');

                });



            var displayOptionsItemsTemp = null;

            var noRowMessage = null;
            renderDataTableOptions = function (displayOptionsItems) {
                var bizId = $('#businessList').val().split(':');
                if (bizId[0] === "-1") {
                    noRowMessage = '<%= Resources.Messages.DataTableSelectBusinessIdMessage %>';
                } else {
                    noRowMessage = '<%= Resources.Messages.DataTableZeroRecordsMessage %>';
                }
                displayOptionsItemsTemp = displayOptionsItems;

                if (DataTableOptions == null) {
                    createOptionsTable();
                    DataTableOptions = {
                        data: function (params) {
						var end = 0;
							<%-- 選択されたページでレコードの開始位置 --%>
                            var start = params.start;
							<%-- 表示ページの総件数  --%>
                            var count = params.count;
							<%-- 総件数 --%>
                            var sumNumber = displayOptionsItemsTemp.length;
							<%-- 総件数＜=選択されたページでレコードの開始位置　+　表示ページの総件数  --%>
                            if (sumNumber <= start + count) {
								<%-- 総件数は終了位置を設定する --%>
                                end = sumNumber;
                            } else {
								<%-- 選択されたページでレコードの開始位置　+　表示ページの総件数は終了位置を設定する --%>
                                end = start + count;
                            }
							 <%--　レコードのリストで開始位置から終了位置まで取得する --%>
                            var tempPageitems = displayOptionsItemsTemp.slice(start, end);
                            return {
                                "numberOfAllItems": displayOptionsItemsTemp.length,
                                "fields": getTableFields(),
                                "items": tempPageitems
                            }
                        },
                        columns: getTableTbody(displayOptionsItems),
                        pageNavigation: 'bottom',
                        columnResizable: false,
                        //size: 'full',
                        hoverState: true,
                        autoLoad: true,
                        labelLayout: 'leading',
                        selectionUnit: 'row',
                        selectionRemains: true,
                        itemId: 'BusinessRecordId',
                        pageNumbers: true,
                        itemsPerPage: config.pageLength,
                        dropdown: false,
                        itemNumbers: true,
                        pagesPerLoad: config.pageLength,
                        endButtons: true,
                        itemsPerPageChoices: itemsPerPageChoices,
                        itemsPerPagePosition: "bottom",
                        clear: true,
                        sortOptions: {
                            column: 3,
                            order: 'asc'
                        },
                        multipleSelections: false,
                        //search: true,
                        noRowMessage: noRowMessage,
                        changeItemsPerPage: function (event, ui) {
                            $.cookie(COOKIENAME_LINES_PER_PAGE, ui.value)
                        },
                        afterRender: function () {

                            let tbodyHeight = document.documentElement.clientHeight - 333;
                            if ($("#elementsTable").find("tbody")[0].clientWidth <= $("#elementsTable")[0].clientWidth) { tbodyHeight += 16 }
                            $("#elementsTable").find("tbody").css("height", tbodyHeight + "px");

                            isClickFilter = false;
                            var tempWidth = $("#tabTempDiv").width();
                            var tempDecoratedTable = $("#tab").find('.xux-decoratedTable-table').first();
                            tempDecoratedTable.width(tempWidth);
                            $('#elementsTable').find(".xux-table-header").first().css("padding", "0px");

                            tempDecoratedTable.css({
                                overflow: 'auto hidden'
                            });
                            $("input[type=checkbox]").xuxCheckbox();
                            var executeNow = ($('#businessList').val().split(':'))[1] == '2';
                            if (executeNow) {
                                $("#createNewRecordButton").xuxButton({ "disabled": true });
                            } else {
                                $("#createNewRecordButton").xuxButton({ "disabled": false });
                            }
                            var selectCheckBoxIds = [];
                            $("[name=selectCheckBox]").each(function () {
                                var isChecked = $(this).is(':checked');
                                if (isChecked) {
                                    selectCheckBoxIds.push($(this).val());
                                }
                            });
                            if (selectCheckBoxIds.length > 0) {
                                $("#CSVOutputButton").xuxButton({ "disabled": false });
                                $("#confirmCorrectList2").xuxButton({ "disabled": false });
                                $("#deleteButton").xuxButton({ "disabled": false });
                            } else {
                                $("#CSVOutputButton").xuxButton({ "disabled": true });
                                $("#confirmCorrectList2").xuxButton({ "disabled": true });
                                $("#deleteButton").xuxButton({ "disabled": true });
                            }
                            //$('#createNewRecordButton').prop('disabled', false);
                            //$('#deleteButton').prop('disabled', false);
                            showSortFlag();
                            //$('.FilterDialog').unbind("click");
                            //$('.FilterDialog').click(function () {
                            //    var clickColumn = parseInt($(this).attr("columnindex"));
                            //    var columnDef = DataTableOptions.columns[clickColumn];
                            //    if (columnDef.sortable === false) {
                            //        return;
                            //    }
                            //    if (columnDef.sortable !== false) {

                            //    }


                            //    if (DataTableOptions.columns[clickColumn].searchTableColumnDirection == "asc") {
                            //        toggleRecordSort($elementsTable_, clickColumn, 'desc');
                            //    } else if (DataTableOptions.columns[clickColumn].searchTableColumnDirection == "") {
                            //        toggleRecordSort($elementsTable_, clickColumn, 'asc');
                            //    } else {
                            //        toggleRecordSort($elementsTable_, clickColumn, 'asc');
                            //    }
                            //});

                            setAllSelectBox();

                            setTimeout(setHeaderImage, 50);
                            removeLoading()

                        }
                    };
                    DataTableOptions.columns[3].searchTableColumnDirection = "asc";
                    clickHeaderCell = 3;
                    clickHeaderCellWidth = 36;
                    $elementsTable_ = $('#tab').xuxDecoratedTable(DataTableOptions);
                } else {
                    $('#tab').xuxDecoratedTable('reload');
                }

                var tempDecoratedTable = $("#tab").find('.xux-decoratedTable-table').first();
                tempDecoratedTable.css({
                    overflow: 'auto hidden'
                });
                //$("#tabTempDiv").find(".xux-decoratedTable-trailingBox").eq(1).css("display", "none");
                $elementsTable_.order = function (tempSortOptions) {

                    if (tempSortOptions) {
                        DataTableOptions.sortOptions.column = tempSortOptions[0][0];
                        DataTableOptions.sortOptions.order = tempSortOptions[0][1];
                    } else {
                        if ($elementsTable_) {
                            return [[DataTableOptions.sortOptions.column, DataTableOptions.sortOptions.order]];
                        } else {
                            return null;
                        }

                    }
                }
            }
            function setAllSelectBox() {
                var checkBoxCount = $("[name=selectCheckBox]").length;
                var checkCount = 0;
                $("[name=selectCheckBox]").each(function () {
                    var isChecked = $(this).is(':checked');
                    if (isChecked) {
                        checkCount++;
                    }

                });
                if (checkCount == checkBoxCount && checkBoxCount != 0) {
                    $("#allSelectCheckBox").prop('checked', true).xuxCheckbox("refresh");
                } else {
                    $("#allSelectCheckBox").prop('checked', false).xuxCheckbox("refresh");
                }
            }
            function showSortFlag() {
                setTimeout(function () {
                    if (clickHeaderCell != null) {
                        $(".FilterDialog").each(function () {
                            var columnindexTemp = $(this).attr("columnindex");
                            var clickSortHeaderCellWidth = 30;
                            if (columnindexTemp == "2") {
                                clickSortHeaderCellWidth = 30;
                            }
                            $(this).parent().parent().find(".xux-table-sort").remove();
                            if (DataTableOptions.columns[clickHeaderCell].searchTableColumnDirection == "desc") {
                                if (columnindexTemp == clickHeaderCell) {
                                    var sortTextTemp = '<span class="xux-table-sort" aria-hidden="true" style="margin-left:' + clickSortHeaderCellWidth + 'px"></span>';
                                    $(this).parent().parent().append(sortTextTemp);
                                    $(this).parent().parent().parent().attr("aria-sort", "descending");
                                    $(this).parent().parent().parent().removeClass("xux-table-sort-asc");
                                    $(this).parent().parent().parent().addClass("xux-table-sort-desc");
                                }
                            } else {
                                if (DataTableOptions.columns[clickHeaderCell].searchTableColumnDirection == "asc") {
                                    if (columnindexTemp == clickHeaderCell) {
                                        var sortTextTemp = '<span class="xux-table-sort" aria-hidden="true" style="margin-left:' + clickSortHeaderCellWidth + 'px"></span>';
                                        $(this).parent().parent().append(sortTextTemp);
                                        $(this).parent().parent().parent().attr("aria-sort", "ascending");
                                        $(this).parent().parent().parent().removeClass("xux-table-sort-desc");
                                        $(this).parent().parent().parent().addClass("xux-table-sort-asc");
                                    }
                                }

                            }
                            //var tempFilter = $(this).parent().parent().find(".xux-icon-funnel");
                            //if (tempFilter.length <= 0) {
                            //    var clickfilterCellWidth = $(this).find(".showText").first().width() + 30;
                            //    var filterTextTemp = '<span  class="xux-icon xux-icon-size-medium xux-icon-funnel" style="font-size: 16px;position: absolute;left:' + clickfilterCellWidth + 'px"></span>';
                            //    $(this).parent().parent().append(filterTextTemp);
                            //}

                        });
                        //$('.xux-icon-funnel').click(function () {
                        $('.headerRecord').click(function () {
                            if (elementRowsList_) {
                                if (elementRowsList_ != null && elementRowsList_.length <= 0) {
                                    return;
                                }
                                var clickColumn = parseInt($(this).find(".FilterDialog").first().attr("columnindex"));
                                //$(this).parent().parent().parent().first().css("background-color", '#B2B2B2');

                                var clickObj = $(this).find(".FilterDialog").first();
                                createFilterDialog(clickColumn, clickObj);
                                $("input[type=checkbox]").xuxCheckbox();
                                $("input[type=button]").xuxButton();
                                $("#filterEditBoxDiv").xuxTextFieldBox();
                                $("#startNoCondDiv").xuxTextFieldBox();
                                //showDiv($("#columnPopup"), $("#columnPopupItems"), $(this), $("#tabTempDiv"));
                                $("#columnPopup").xuxModalWindow("open");
                                if (clickObj.attr("columnindex") != "2") {
                                    $("#columnPopupTitel").html(clickObj.html());
                                } else {
                                    $("#columnPopupTitel").html("&nbsp;");
                                }
                            }



                        });
                        resetHeadercolor();
                    }
                }, 100);



            }
            function saveSelectPageCount() {
                //recordTablePageCount = $(".xux-decoratedTable-dropdownForItems").first().find("select").val();
            }
            function createOptionsTable() {
                $("#tabTempDiv").html("");
                var headerTextsLength = headerTexts.length;
                headerTextsWithdSum = 0;
                var filterTextTemp = '<span  class="xux-icon xux-icon-size-medium xux-icon-funnel" style="font-size: 16px;position: absolute;padding-left:' + 10 + 'px"></span>';
                var filterImageTemp = '<span  class="xux-icon xux-icon-size-medium xux-icon-funnel" style="font-size: 16px;position: absolute;padding-left:' + 10 + 'px"></span>';
                var textAndSpanAll = "";
                for (var i = 0; i < headerTextsLength; i++) {
                    var headerByteSize = CountLength(headerTexts[i]);
                    //var fontsize = 8;
                    //if (headerByteSize <= 6) {
                    //    fontsize = 12;
                    //}
                    var size = headerByteSize;
                    //if (size > ledgerColumnMaxWidth_ - 16) {
                    //    size = ledgerColumnMaxWidth_ - 16;
                    //}
                    var tempIndexColum = 4 + i;
                    size += 71;

                    headerTextsWithdSum = headerTextsWithdSum + size + 14;
                    headerTextsLengthArray.push(size);
                    var textAndSpan = '<th class="headerRecord" style="width:' + size + 'px"><span style="width:' + size + 'px" title="' + headerTexts[i] + '" columnIndex="' + tempIndexColum + '" class="FilterDialog" >'
                        + headerTexts[i] + '</span>' + ' <span class="boxSpan"></span>' + filterTextTemp + '</th>';
                    textAndSpanAll = textAndSpanAll + textAndSpan;

                    //DataTableColumns.push({ title: textAndSpan, data: columnsName_[i + 3], searchable: true, orderable: false, width: size + 'px' });
                }
                headerTextsWithdSum = headerTextsWithdSum + 40 + 20 + 40 + 70 + 56 + 70;
                var tempTable = '<div id="tab">' +
                    '<table id = "elementsTable">' +
                    ' <thead>' +
                    '<th style="width:40px"><input type="checkbox" id="allSelectCheckBox" /></th>' +
                    '<th style="width:20px"><img src="image/edit_normal_16_p24.png" title="レコードの詳細確認/編集" /></th>' +
                    '<th class="headerRecord" style="width:70px"><span  columnIndex="2" class="FilterDialog" title="通知あり"><img id="infoIcon" src="image/info_normal_16_p24.png" /></span><span class="boxSpan"></span>' + filterImageTemp + '</th>' +
                    '<th class="headerRecord" style="width:70px"><span title="<%= Resources.Messages.NumberColumnName %>" columnIndex="3" class="FilterDialog"><span class="showText"><%= Resources.Messages.NumberColumnName %></span></span><span class="boxSpan"></span>' + filterTextTemp + '</th>' + textAndSpanAll +
                    '</thead>' +
                    '<tbody></tbody>' +
                    '</table>' +
                    '</div>';
                $("#tabTempDiv").html(tempTable);
                $("#allSelectCheckBox").xuxCheckbox();

                <%-- 一括選択チェックボックス --%>
                $('#allSelectCheckBox').click(function () {
                    if (!elementRowsList_ || elementRowsList_.length === 0) {
                        return;
                    }
                    var isChecked = $(this).is(':checked');
                    $('#elementsTable').find('[name=selectCheckBox]').prop('checked', isChecked).trigger('change');
                    if (isChecked) {
                        buttonsDisable(false);
                    }
                });

                //$('.FilterDialog').mouseover(function () {
                //    $(this).parent().parent().parent().css("background-color", "#d8d8d8");
                //});
                //$('.FilterDialog').mouseup(function () {
                //    $(this).parent().parent().parent().css("background-color", "#d8d8d8");
                //});
                //$('.FilterDialog').mouseout(function () {
                //    $(this).parent().parent().parent().css("background-color", "#eaeaea");
                //});
                //$('.FilterDialog').mousedown(function () {
                //    $(this).parent().parent().parent().css("background-color", "#b2b2b2");
                //});

                var $infoIcon = $("#infoIcon");//$filterDialogHeader_.children('img');
                $infoIcon
                    .attr('src', 'image/info_normal_16_p24.png')
                    .hover(function () {
                        this.src = 'image/info_hover_16_p24.png';
                    }, function () {
                        this.src = 'image/info_normal_16_p24.png';
                    });
            }

            function getTableFields() {
                var temp = [];
                temp.push("Selected");
                temp.push("Detail");
                temp.push("DefectNoticeType");
                temp.push("BusinessRecordId");
                for (var ix = 3; ix < columnsName_.length; ix++) {
                    temp.push(columnsName_[ix]);
                }

                return temp;

            }
            function showEdit(item) {
                $("#ConfRecordId").val(item._data.BusinessRecordId);
                // レコード編集を非表示、レコード詳細を表示．
                $("#clearDiv").html('');
                $("#clearDiv").html('<div id = "recordTableDiv" ><table id="recordTable" style="border: 1px solid #ccc;"><thead><th style="width: 50%;">設問名</th><th style="width: 50%;">値</th></thead><tbody></tbody></table></div >' +
                    '<div id="recordTableViewModeDiv"><table id="recordTableViewMode" style="border: 1px solid #ccc;"><thead><th style="width: 50%;">設問名</th><th style="width: 50%;">値</th></thead><tbody></tbody></table></div>');
                $("#recordTableDiv").hide();
                $("#recordTableViewModeDiv").show();
                $("#mode").html("レコードの詳細確認 / 編集");
                $("#editMode1").show();
                $("#billPayment1").show();
                $("#console1").hide();
                $("#confirm1").hide();
                $("#console2").show();
                $("#confirm2").show()

                createRecordDialog(1);//int flg  1:レコードの編集
                var endNow = ($('#businessList').val().split(':'))[1] === '2';
                if (endNow) {
                    $("#editMode1").xuxButton("disable");//編集モード
                    $("#billPayment1").xuxButton("disable"); //帳票紐付
                }
            }
            function getTableTbody(displayItems) {
                var tableBody = [
                    {
                        searchTableFilters: "",
                        field: "Selected",
                        render: function (td, item) {
                            td.css("width", "40px")
                            var selectBox = $('<input type="checkbox" name="selectCheckBox" value="' + item._data.BusinessRecordId + '" />')
                                .prop('checked', item._data.Selected)
                                .change(function () {
                                    item._data.Selected = $(this).is(':checked');
                                    updateInnerValue(item._data.dataIndex, item._data.Selected);
                                    setAllSelectBox();
                                });
                            $(selectBox).appendTo(td);
                        }
                    },
                    {
                        searchTableFilters: "",
                        field: "Detail",
                        render: function (td, item) {
                            td.css("width", "20px")
                            var confIcon = $('<img src="image/edit_normal_16_p24.png" />')
                                .click(function () {
                                    if (item._data.HasError) {
                                        alertMessageInfo('<%= Resources.Messages.DefectNoticeMessage %>', function () {
                                            showEdit(item);
                                        });
                                    } else {
                                        showEdit(item);
                                    }

                                }).hover(function () {
                                    this.src = 'image/edit_hover_16_p24.png';
                                }, function () {
                                    this.src = 'image/edit_normal_16_p24.png';
                                });
                            $(confIcon).appendTo(td);
                        }
                    },
                    {
                        searchTableFilters: "",
                        field: "DefectNoticeType",
                        render: function (td, item) {
                            td.css("width", "70px")
                            var errIcon;
                            if (item._data.HasError) {
                                var imgSrc = 'image/ll_info_d_normal.png';
                                var imgSrcHorver = 'image/ll_info_d_hover.png';
                                if (item._data.DefectNoticeType == 2) {
                                    imgSrc = 'image/ll_info_e_normal.png';
                                    imgSrcHorver = 'image/ll_info_e_hover.png';
                                } else if (item._data.DefectNoticeType == 3) {
                                    imgSrc = 'image/ll_info_de_normal.png';
                                    imgSrcHorver = 'image/ll_info_de_hover.png';
                                }
                                errIcon = $("<img src='" + imgSrc + "' />")
                                    .click(function () {
                                        //$errInfoDlg.data("businessRecordId", item._data.BusinessRecordId).dialog('open');
                                        $("#clearErrDiv").html('');
                                        $("#clearErrDiv").html('<div id = "recordTableErrDiv" ><table id="recordErrTable" style="width: 100%;"><thead><th style="width: 20%;">帳票名</th><th style="width: 60%;">内容</th><th style="width: 20%;">操作</th></thead><tbody></tbody></table></div >');
                                        $("#modeErr").html("通知");
                                        $("#consoleErrButton").show()
                                        var businessRecordErrId = item._data.BusinessRecordId;
                                        LoadErrorList(businessRecordErrId);
                                    })
                                    .hover(function () {
                                        this.src = imgSrcHorver;
                                    }, function () {
                                        this.src = imgSrc;
                                    });
                            } else {
                                errIcon = $("<img src='image/ll_info_na.png' />");
                            }
                            $(errIcon).appendTo(td);
                        }
                    },
                    {
                        searchTableFilters: "",
                        field: "BusinessRecordId",
                        //defaultSortOrder: "asc",
                        render: function (td, item) {
                            td.css("width", "70px")
                            var html = '<span title="' + item._data.BusinessRecordId + '">' + item._data.BusinessRecordId + '</span>';
                            $(html).appendTo(td);
                        }
                    }
                ];
                <%-- 動的表示項目の描画 --%>
                var itemIndex = 0;
                <%-- 固定表示する項目が4件あるので、開始インデックスは3（0オリジン） --%>
                for (var ix = 3; ix < columnsName_.length; ix++) {
                    var tempColumnTable = {
                        field: columnsName_[ix],
                        searchTableFilters: "",
                        //defaultSortOrder: "asc",
                        render: function (td, item) {
                            var widthTemp = headerTextsLengthArray[td[0].cellIndex - 4];
                            td.css("width", widthTemp + "px");
                            var setText = "";
                            $.each(item._data, function (key, n) {
                                if (key == columnsName_[td[0].cellIndex - 1]) {
                                    setText = n;
                                    if (columnsInfo[td[0].cellIndex - 4] === '0' && n != "" && n != SCANNING) {
                                        n = new Date(n);<%-- 日付型に変換できないケースがあるので、ここでも作成 --%>
                                        setText =
                                            ('000' + n.getFullYear()).slice(-4) + '/' +
                                            ('0' + (1 + n.getMonth())).slice(-2) + '/' +
                                            ('0' + n.getDate()).slice(-2) + ' ' +
                                            ('0' + n.getHours()).slice(-2) + ':' +
                                            ('0' + n.getMinutes()).slice(-2) + ':' +
                                            ('0' + n.getSeconds()).slice(-2);
                                    } else {
                                        setText = doSanitaizeDecode(setText);
                                    }
                                }
                            });
                            var html = '<span style="width:' + widthTemp + 'px" title="' + setText + '">' + setText + '</span>';
                            $(html).appendTo(td);
                        }
                    }
                    tableBody.push(tempColumnTable);
                    //$td.eq(ix + 1).text(setText).attr('title', setText);
                }
                return tableBody;
            }
            loadTabData(true);
            <%-- 一覧で操作した選択の変更をDataTablesの実データに反映 --%>
            function updateInnerValue(rowIndex, value) {
                buttonsDisable(!value);
                elementRowsList_[rowIndex].Selected = value;
            }
            <%-- ボタンの活性制御 --%>
            function buttonsDisable(state) {
                <%-- 非活性で呼ばれたとき、まだ１件でもチェックされていれば何もしない --%>
                var hasCheck = false;
                if (state) {
                    var $filterCond = $('[name=selectCheckBox]');
                    $.each($filterCond, function (index, value) {
                        if ($(this).is(':checked')) {
                            hasCheck = true;
                            return false;
                        }
                    });

                    if (hasCheck) {
                        return;
                    }
                }
                var checkBoxCount = $("[name=selectCheckBox]").length;
                if (checkBoxCount > 0) {
                    //$('#CSVOutputButton').prop('disabled', state);
                    $("#CSVOutputButton").xuxButton({ "disabled": state });
	                <%-- 活性にするとき、業務のステータスが遂行中なら活性にする --%>
                    if (!state) {
                        var executeNow = ($('#businessList').val().split(':'))[1] == '1';
                        if (executeNow) {
                            //$('#confirmCorrectList').prop('disabled', state);
                            //$("#confirmCorrectListDiv").xuxDropdownBox({ "disabled": state });
                            $("#confirmCorrectList2").xuxButton({ "disabled": state });
                            //$("#confirmCorrectList3").xuxButton({ "disabled": state });
                            //$('#deleteButton').prop('disabled', state);
                            $("#deleteButton").xuxButton({ "disabled": state });
                        }
                    } else {
                        //$('#confirmCorrectList').prop('disabled', state);
                        //$("#confirmCorrectListDiv").xuxDropdownBox({ "disabled": state });
                        $("#confirmCorrectList2").xuxButton({ "disabled": state });
                        //$("#confirmCorrectList3").xuxButton({ "disabled": state });
                        //$('#deleteButton').prop('disabled', state);
                        $("#deleteButton").xuxButton({ "disabled": state });
                    }
                }
            }
            function createFilterDialog(columnIndexTemp, obj) {
                sortFilterColumnIndex_ = -1;
                sortFilterColumn_ = {};
                $filterDialogHeader_ = null;
                if (!elementRowsList_) {
                    return;
                }

                var $items = $('#columnPopupItems');
                $items.text('')

                var parentTag = obj;//$(this).parent().parent();
                sortFilterColumn_.search = function () { return ""; }//$elementsTable_.column(parentTag);
                var columnIndex = columnIndexTemp < 0 ? parseInt(parentTag.attr("columnIndex")) : columnIndexTemp;;
                sortFilterColumnIndex_ = columnIndex;
                var columnDef = DataTableOptions.columns[columnIndex];
                $filterDialogHeader_ = obj;

                var hasFunc = false;

                 <%-- ソート機能が無効の場合はスキップ --%>
                if (columnDef.sortable === false) {
                    $("#columnPopup").xuxModalWindow('close');
                    return;
                }

                <%-- ソート機能 --%>
                if (columnDef.sortable !== false) {
                    createRecordSort($items, $elementsTable_, columnIndex, '<%= Resources.Messages.SortDescCaption %>', '<%= Resources.Messages.SortAscCaption %>');
                    hasFunc = true;
                }

                <%-- フィルター機能 --%>
                var values = [];
                if (columnDef.searchable !== false) {
                    var isScanning = false;
                    values = $.map(elementRowsList_, function (n, i) {
                        if (n[columnDef.field] == SCANNING)
                            isScanning = true;
                        return n[columnDef.field];
                    });
                    values.sort();
                    values = $.map(values, function (n, i) { return '$' + doReplaceLineBreakToWhiteSpace(n); });
                    values = $.unique(values);
                    values = $.map(values, function (n, i) { return n.substring(1); });

                    <%-- すべて選択 --%>
                    var image = columnIndex === 2 ? $('<img class="dn-icon" src="image/ll_info_na.png" />') : "";
                    var $allRows;
                    if (columnsInfo[columnIndex - 4] === '2' || columnsInfo[columnIndex - 4] === '3') {
                        $allRows = $('<input id="' + FILTER_ALLROWS_ID + '" type="checkbox" />')
                            .change(function () {
                                //if ($(this).is(':checked')) {
                                //    $(FILTER_COND_CLASSNAME_SELECTOR).prop('checked', true);
                                //} else {
                                //    $(FILTER_COND_CLASSNAME_SELECTOR).prop('checked', false);
                                //}
                                var isChecked = $(this).is(':checked');
                                $('#columnPopupItems').find('[name=filterCondCheckBox]').prop('checked', isChecked).trigger('change');
                            });
                    } else {
                        $allRows = $('<input id="' + FILTER_ALLROWS_ID + '" type="radio" name="' + FILTER_RADIO_GROUP_NAME + '" />')
                            .change(function () {
                                var $filterDateRangeCond = $('#filterDateRangeCond');
                                if ($filterDateRangeCond) {
                                    $filterDateRangeCond.prop('checked', false).trigger('change');
                                }
                                var $filterEditSearchRadioButton = $('#filterEditSearchCond');
                                if ($filterEditSearchRadioButton) {
                                    $filterEditSearchRadioButton.prop('checked', false).trigger('change');
                                }
                                var $filterPeriodCond = $('#filterPeriodCond');
                                if ($filterPeriodCond) {
                                    $filterPeriodCond.prop('checked', false).trigger('change');
                                }
                            });
                    }
                    var $allRowsDiv = $('<div class="columnPopupItem"></div>')
                        .append($allRows)
                        .append(image)
                        .append('<span style="padding: 0 0 0 8px;vertical-align: middle;position: relative;top: 1px;" class="ui-button-text"><%= Resources.Messages.AllRowsCaption %></span>');
                    $items
                        //.append($('<hr class="FilterDialogHr" />'))
                        //.append($('<br>'))
                        .append($allRowsDiv);
                    if (columnIndex === 2) {
                        <%-- 不備通知列 --%>
                        var items = createDefectRadioItems(["1", "2", "3", "4"], function (value) {
                            if (value == '1') {
                                value = '<%= Resources.Messages.DefectCaption %>'
                            } else if (value == '2') {
                                value = '<%= Resources.Messages.ErrorCaption %>'
                            } else if (value == '3') {
                                value = '<%= Resources.Messages.DefAndErrCaption %>'
                            } else {
                                value = '<%= Resources.Messages.NoNoticeCaption %>';
                            }
                            return value;
                        });
                        $items.append(items);
                        hasFunc = true;
                    } else if (columnIndex === 3) {
                        <%-- No.列 --%>
                        var $dateRangeRadioButton = $('<input type="radio" id="filterDateRangeCond" value="<%= Resources.Messages.RecordNoRangeRadioButtonCaption %>" name="' + FILTER_RADIO_GROUP_NAME + '" />')
                            .change(function () {
                                if ($(this).is(':checked')) {
                                    $(FILTER_ALLROWS_ID_SELECTOR).prop('checked', false);
                                    $('#startNoCond, #endNoCond').prop('disabled', false);
                                    $("#startNoCondDiv").xuxTextFieldBox({ "disabled": false });
                                }
                                else {
                                    $(FILTER_ALLROWS_ID_SELECTOR).prop('checked', true);
                                    $('#startNoCond, #endNoCond').prop('disabled', true);
                                    $("#startNoCondDiv").xuxTextFieldBox({ "disabled": true });
                                }
                            });
                        var $dateRangeRadioButtonDiv = $('<div  class="columnPopupItem"></div>')
                            .append($dateRangeRadioButton)
                            .append('<span style="padding: 0 0 0 8px;" class="ui-button-text"><%= Resources.Messages.RecordNoRangeRadioButtonCaption %></span>');//.append('<%= Resources.Messages.RecordNoRangeRadioButtonCaption %>');
                        $items.append($dateRangeRadioButtonDiv);

                        var $startNoFilter = $('<input id="startNoCond" type="text" style="width: 65px;" value="' + doSanitaizeEncode(startNoNumberFilter_) + '" />');
                        var $endNoFilter = $('<input id="endNoCond" type="text" style="width: 65px;" value="' + doSanitaizeEncode(endNoNumberFilter_) + '" />');
                        var $NoFilterDiv = $('<div id="startNoCondDiv" class="columnPopupItem"></div>')
                            .append($startNoFilter)
                            .append(" - ")
                            .append($endNoFilter);
                        $items.append($NoFilterDiv);
                        hasFunc = true;
                    } else if (!columnsInfo[columnIndex - 4] || columnsInfo[columnIndex - 4] !== '0') {
                        <%-- エレメント列 --%>
                        if (columnsInfo[columnIndex - 4] === '2' || columnsInfo[columnIndex - 4] === '3') {
                            <%-- 選択肢/一文字数値 --%>
                            var $blankCheckBox = $('<input type="checkbox" class="' + FILTER_COND_CLASSNAME + '" name="filterCondCheckBox" value="" />')
                                .change(function () {
                                    changeCheckBox($(this), FILTER_ALLROWS_ID_SELECTOR, FILTER_COND_CLASSNAME_SELECTOR);
                                });
                            var $blankCheckBoxDiv = $('<div class="columnPopupItem"></div>')
                                .append($blankCheckBox)
                                .append('<span style="padding: 0 0 0 8px;vertical-align: middle;position: relative;top: 1px;" class="ui-button-text"><%= Resources.Messages.BlankRowsCheckBoxCaption %></span>');
                            $items.append($blankCheckBoxDiv);

                            var items = createRecordItems(values, function (value) {
                                return value !== '' ? value : text;
                            }, FILTER_ALLROWS_ID_SELECTOR, FILTER_COND_CLASSNAME, FILTER_COND_CLASSNAME_SELECTOR, "filterCondCheckBox");
                            $items.append(items);
                        } else {
                            <%-- 自由記入 --%>
                            var $blankRadioButton = $('<input type="radio" class="' + FILTER_COND_CLASSNAME + '" value="" name="' + FILTER_RADIO_GROUP_NAME + '" />')
                                .change(function () {
                                    var $filterEditSearchRadioButton = $('#filterEditSearchCond');
                                    if ($filterEditSearchRadioButton) {
                                        $filterEditSearchRadioButton.prop('checked', false).trigger('change');
                                    }
                                });
                            var $blankRadioButtonDiv = $('<div class="columnPopupItem"></div>')
                                .append($blankRadioButton)
                                .append('<span style="padding: 0 0 0 8px;vertical-align: middle;position: relative;top: 1px;" class="ui-button-text"><%= Resources.Messages.BlankRowsRadioButtonCaption %></span>');
                            $items.append($blankRadioButtonDiv);

                            var $notBlankRadioButton = $('<input type="radio" class="' + FILTER_COND_CLASSNAME + '" value="(^.+)" name="' + FILTER_RADIO_GROUP_NAME + '" />')
                                .change(function () {
                                    var $filterEditSearchRadioButton = $('#filterEditSearchCond');
                                    if ($filterEditSearchRadioButton) {
                                        $filterEditSearchRadioButton.prop('checked', false).trigger('change');
                                    }
                                });
                            var $notBlankRadioButtonDiv = $('<div class="columnPopupItem"></div>')
                                .append($notBlankRadioButton)
                                .append('<span style="padding: 0 0 0 8px;vertical-align: middle;position: relative;top: 1px;" class="ui-button-text"><%= Resources.Messages.NotBlankRowsRadioButtonCaption %></span>');
                            $items.append($notBlankRadioButtonDiv);
                            var $filterEditBox = $('<input type="text" id="filterEditBox" style="width: 95%;" value="" />');
                            var $filterEditBoxDiv = $('<div id="filterEditBoxDiv" class="columnPopupItem"></div>').append($filterEditBox);
                            var $filterEditSearchRadioButton = $('<input type="radio" id="filterEditSearchCond" value="<%= Resources.Messages.EditSearchRadioButtonCaption %>" name="' + FILTER_RADIO_GROUP_NAME + '" />')
                                .change(function () {
                                    if ($(this).is(':checked')) {
                                        $filterEditBox.prop('disabled', false);
                                        $("#filterEditBoxDiv").xuxTextFieldBox({ "disabled": false });
                                    }
                                    else {
                                        $filterEditBox.prop('disabled', true);
                                        $("#filterEditBoxDiv").xuxTextFieldBox({ "disabled": true });
                                    }
                                });
                            var $filterEditSearchRadioButtonDiv = $('<div class="columnPopupItem"></div>')
                                .append($filterEditSearchRadioButton)
                                .append('<span style="padding: 0 0 0 8px;vertical-align: middle;position: relative;top: 1px;" class="ui-button-text"><%= Resources.Messages.EditSearchRadioButtonCaption %></span>');
                            $items
                                .append($filterEditSearchRadioButtonDiv)
                                .append($filterEditBoxDiv);
                        }
                        hasFunc = true;
                    } else if (columnsInfo[columnIndex - 4] && columnsInfo[columnIndex - 4] === '0') {
                        <%-- アクション日時列 --%>
                        var $blankRadioButton = $('<input type="radio" class="' + FILTER_COND_CLASSNAME + '" value="" name="' + FILTER_RADIO_GROUP_NAME + '" />')
                            .change(function () {
                                var $filterPeriodCond = $('#filterPeriodCond');
                                if ($filterPeriodCond) {
                                    $filterPeriodCond.prop('checked', false).trigger('change');
                                }
                            });
                        var $blankRadioButtonDiv = $('<div class="columnPopupItem"></div>')
                            .append($blankRadioButton)
                            .append('<span style="padding: 0 0 0 8px;vertical-align: middle;position: relative;top: 1px;" class="ui-button-text"><%= Resources.Messages.BlankRowsRadioButtonCaption %></span>');
                        $items.append($blankRadioButtonDiv);

                        var $notBlankRadioButton = $('<input type="radio" class="' + FILTER_COND_CLASSNAME + '" value="(^.+)" name="' + FILTER_RADIO_GROUP_NAME + '" />')
                            .change(function () {
                                var $filterPeriodCond = $('#filterPeriodCond');
                                if ($filterPeriodCond) {
                                    $filterPeriodCond.prop('checked', false).trigger('change');
                                }
                            });
                        var $notBlankRadioButtonDiv = $('<div class="columnPopupItem"></div>')
                            .append($notBlankRadioButton)
                            .append('<span style="padding: 0 0 0 8px;vertical-align: middle;position: relative;top: 1px;" class="ui-button-text"><%= Resources.Messages.NotBlankRowsRadioButtonCaption %></span>');
                        $items.append($notBlankRadioButtonDiv);

                        if (isScanning) {
                            var $scanningRadioButton = $('<input type="radio" class="' + FILTER_COND_CLASSNAME + '" value="' + SCANNING + '" name="' + FILTER_RADIO_GROUP_NAME + '" />')
                                .change(function () {
                                    var $filterPeriodCond = $('#filterPeriodCond');
                                    if ($filterPeriodCond) {
                                        setFilterDateCondition(2, columnIndex, null);
                                        $filterPeriodCond.prop('checked', false).trigger('change');
                                    }
                                });
                            var $scanningRadioButtonDiv = $('<div class="columnPopupItem"></div>')
                                .append($scanningRadioButton)
                                .append('<span style="padding: 0 0 0 8px;vertical-align: middle;position: relative;top: 1px;" class="ui-button-text">' + SCANNING + '</span>');
                            $items.append($scanningRadioButtonDiv);
                        }

                        var $periodRadioButton = $('<input type="radio" id="filterPeriodCond" value="<%= Resources.Messages.PeriodRowsRadioButtonCaption %>" name="' + FILTER_RADIO_GROUP_NAME + '" />')
                            .change(function () {
                                if ($(this).is(':checked')) {
                                    $('#filterToDate, #filterToDateIcon, #filterFromDate, #filterFromDateIcon').prop('disabled', false);
                                } else {
                                    $('#filterToDate, #filterToDateIcon, #filterFromDate, #filterFromDateIcon').prop('disabled', true);
                                }
                            });
                        var $periodRadioButtonDiv = $('<div class="columnPopupItem"></div>')
                            .append($periodRadioButton)
                            .append('<span style="padding: 0 0 0 8px;vertical-align: middle;position: relative;top: 1px;" class="ui-button-text"><%= Resources.Messages.PeriodRowsRadioButtonCaption %></span>');
                        $items.append($periodRadioButtonDiv);

                        var filterToDate = getFilterDateCondition(0, columnIndex);
                        var startDateFilterTempValue = ""
                        if (filterToDate) {
                            startDateFilterTempValue = 'value="' + dateFormat(filterToDate) + '"';
                        }
                        var $toDate = $('<input id="filterToDate" type="date" ' + startDateFilterTempValue + ' style="width: 150px;" />');

                        var filterFromDate = getFilterDateCondition(1, columnIndex);
                        var endDateFilterTempValue = ""
                        if (filterFromDate) {
                            endDateFilterTempValue = 'value="' + dateFormat(filterFromDate) + '"';
                        }
                        var $fromDate = $('<input id="filterFromDate" ' + endDateFilterTempValue + ' type="date" style="width: 160px;" />');

                        var $termDiv = $('<div class="columnPopupItem"></div>')
                            .append($toDate)
                            .append(' - ')
                            .append($fromDate)
                        $items.append($termDiv);
                        hasFunc = true;
                    }
                    $("input[type=radio]").xuxRadio();
                    $("input[type=checkbox]").xuxCheckbox();
                    <%-- 起動時のチェックON処理 --%>
                    var editbleFilterValue = editableFilter_[columnIndex];
                    var searchFilters = DataTableOptions.columns[columnIndex].searchTableFilters ? DataTableOptions.columns[columnIndex].searchTableFilters : ""//sortFilterColumn_.search();      
                    if (columnIndex === 2) {
                        var count = 0;
                        $.each($(FILTER_COND_CLASSNAME_SELECTOR), function (index, value) {
                            var value = '(^' + doRegExEncode($(this).val()) + '$)';
                            if (0 <= searchFilters.indexOf(value)) {
                                $(this).prop('checked', true).xuxRadio("refresh");
                                count++;
                            }
                        });
                        if (count === 0) {
                            $(FILTER_ALLROWS_ID_SELECTOR).prop('checked', true).trigger('change');
                        }
                    } else if (columnIndex === 3) {
                        var $filterDateRangeCondRadioButton = $('#filterDateRangeCond');
                        if ((startNoNumberFilter_ !== '' || endNoNumberFilter_ !== '')) {
                            if ($filterDateRangeCondRadioButton) {
                                $filterDateRangeCondRadioButton.prop('checked', true).trigger('change');
                            }
                        } else {
                            $(FILTER_ALLROWS_ID_SELECTOR).prop('checked', true).trigger('change');
                        }
                    } else if (!columnsInfo[columnIndex - 4] || columnsInfo[columnIndex - 4] !== '0') {
                        if (columnsInfo[columnIndex - 4] === '2' || columnsInfo[columnIndex - 4] === '3') {
                            defaultCheckSelect(searchFilters, FILTER_ALLROWS_ID_SELECTOR, FILTER_COND_CLASSNAME_SELECTOR);
                        } else {
                            if (editbleFilterValue && editbleFilterValue.length !== 0) {
                                var $filterEditSearchRadioButton = $('#filterEditSearchCond');
                                if ($filterEditSearchRadioButton) {
                                    $filterEditSearchRadioButton.prop('checked', true).trigger('change');
                                    $('#filterEditBox').val(editbleFilterValue);
                                }
                            } else {
                                var count = setFilterCheck(searchFilters, FILTER_COND_CLASSNAME_SELECTOR);
                                if (count === 0) {
                                    $(FILTER_ALLROWS_ID_SELECTOR).prop('checked', true).trigger('change');
                                }
                            }
                        }
                    } else if (columnsInfo[columnIndex - 4] && columnsInfo[columnIndex - 4] === '0') {
                        if (searchFilters != '') {
                            var filterToDate = getFilterDateCondition(0, columnIndex);
                            var filterFromDate = getFilterDateCondition(1, columnIndex);
                            if (filterToDate || filterFromDate) {
                                var $filterPeriodCond = $('#filterPeriodCond');
                                if ($filterPeriodCond) {
                                    $filterPeriodCond.prop('checked', true).xuxRadio("refresh");
                                }
                            } else if (filterToDate === '' || filterFromDate === '' || filterToDate === null || filterFromDate === null) {
                                var count = setFilterCheck(searchFilters, FILTER_COND_CLASSNAME_SELECTOR);
                                if (count === 0) {
                                    $(FILTER_ALLROWS_ID_SELECTOR).prop('checked', true).trigger('change');
                                }

                            } else {
                                $(FILTER_ALLROWS_ID_SELECTOR).prop('checked', true).trigger('change');
                            }
                        } else {
                            var count = setFilterCheck(searchFilters, FILTER_COND_CLASSNAME_SELECTOR);
                            if (count === 0) {
                                $(FILTER_ALLROWS_ID_SELECTOR).prop('checked', true).trigger('change');
                            }
                        }
                    }
                }
                if (!hasFunc) {
                    return;
                }
                <%-- フィルターダイアログのスクロール有無判定 --%>
                var filterDialogHeight = 'auto';
                if (columnIndex !== 3 && (columnsInfo[columnIndex - 4] === '2' || columnsInfo[columnIndex - 4] === '3')) {
                    var filterDialogMaxHeight = parseInt('<%= ConfigurationManager.AppSettings["FilterDialogMaxHeight"] %>', 10);
                    var FilterColumnHeight = 23;
                    var SortButtonHeight = 75;
                    if ((values.length + 1) * FilterColumnHeight + SortButtonHeight > filterDialogMaxHeight) {
                        var TitleAndOkButtonGroupHeight = 91;
                        filterDialogHeight = filterDialogMaxHeight + TitleAndOkButtonGroupHeight;
                    }
                }

                //$items.append($('<hr class="FilterDialogHr" />'));
                //$items.append($('<br>'));
                var columnPopupDiv = $("#columnPopupButtonDiv");
                $("#columnPopupButtonDiv").html("");
                var cancel = '<button type="button" class="cancle xux-normalButton" columnIndex="' + columnIndex + '" id="filterDialogClose"><%= Resources.Messages.CancelButtonCaption %></button>';
                columnPopupDiv.append($(cancel))
                columnPopupDiv.append("&nbsp;")
                var okstring = '<button type="button" class="ModalWindowButton" columnIndex="' + columnIndex + '" id="filterDialogOK" ><%= Resources.Messages.OkButtonCaption %></button>';
                columnPopupDiv.append($(okstring))
                $("#filterDialogOK").xuxButton();
                $("#filterDialogOK").xuxButton("option", "type", "default");

                // $("input[type=checkbox]").xuxCheckbox();
                $("input[type=text]").xuxTextFieldBox();

                $("input[type=button]").xuxButton();
                $("#filterDialogClose").xuxButton();

                $("#filterDialogClose").click(function () {
                    $("#columnPopup").xuxModalWindow("close");
                    //closeDiv($("#columnPopup"));
                    resetHeadercolor();
                });
                $("#filterDialogOK").click(function () {
                    isClickFilter = true;
                    saveSelectPageCount();
                    if ($("#sortAscButton").is(':checked')) {
                        DataTableOptions.sortOptions.column = columnIndex;
                        DataTableOptions.sortOptions.order = $("#sortAscButton").val()
                    }
                    if ($("#sortDescButton").is(':checked')) {
                        DataTableOptions.sortOptions.column = columnIndex;
                        DataTableOptions.sortOptions.order = $("#sortDescButton").val();
                    }
                    if (sortFilterColumnIndex_ === 3) {
                        var $filterDateRangeCond = $('#filterDateRangeCond');
                        if ($filterDateRangeCond && $filterDateRangeCond.is(':checked')) {
                            startNoNumberFilter_ = $('#startNoCond').val();
                            endNoNumberFilter_ = $('#endNoCond').val();
                            var min = parseFloat(startNoNumberFilter_, 10);
                            var max = parseFloat(endNoNumberFilter_, 10);
                            if (min > max) {
                                var temp = startNoNumberFilter_;
                                startNoNumberFilter_ = endNoNumberFilter_;
                                endNoNumberFilter_ = temp
                            }

                            if (startNoNumberFilter_ === '' && endNoNumberFilter_ === '') {
                                $(FILTER_ALLROWS_ID_SELECTOR).prop('checked', true);
                            }
                        }
                        if ($(FILTER_ALLROWS_ID_SELECTOR).is(':checked')) {
                            startNoNumberFilter_ = '';
                            endNoNumberFilter_ = '';
                        }
                    } else if (!columnsInfo[sortFilterColumnIndex_ - 4] || columnsInfo[sortFilterColumnIndex_ - 4] !== '0') {
                        if (!(columnsInfo[sortFilterColumnIndex_ - 4] === '2' || columnsInfo[sortFilterColumnIndex_ - 4] === '3')) {
                                <%-- 部分一致検索の入力値を取得 --%>
                            var $filterEditSearchRadioButton = $('#filterEditSearchCond');
                            var $filterEditBox = $('#filterEditBox');
                            if ($filterEditSearchRadioButton && $filterEditSearchRadioButton.is(':checked')) {
                                if ($filterEditBox) {
                                    editableFilter_[sortFilterColumnIndex_] = $filterEditBox.val();
                                } else {
                                    editableFilter_[sortFilterColumnIndex_] = '';
                                }
                                if (editableFilter_[sortFilterColumnIndex_] === '') {
                                    $(FILTER_ALLROWS_ID_SELECTOR).prop('checked', true);
                                }
                            } else {
                                if ($filterEditBox) {
                                    editableFilter_[sortFilterColumnIndex_] = '';
                                }
                            }
                        }
                    } else if (columnsInfo[sortFilterColumnIndex_ - 4] && columnsInfo[sortFilterColumnIndex_ - 4] === '0') {
                        var $filterPeriodCond = $('#filterPeriodCond');
                        if ($filterPeriodCond && $filterPeriodCond.is(':checked')) {
                            if ($('#filterToDate').val() == "" && $('#filterFromDate').val() == "") {
                                $(FILTER_ALLROWS_ID_SELECTOR).prop('checked', true);
                            }
                        }
                        else {
                            setFilterDateCondition(2, columnIndex, null);
                        }
                    }
                    if (DataTableOptions.columns[columnIndex].searchTableFiltersTeype) {
                        DataTableOptions.columns[columnIndex].searchTableFiltersTeype = "";
                    }
                    if ($(FILTER_ALLROWS_ID_SELECTOR).is(':checked')) {
                        //sortFilterColumn_.search('', true);
                        DataTableOptions.columns[columnIndex].searchTableFilters = "";
                        if (DataTableOptions.columns[columnIndex].searchTableFiltersTeype) {
                            DataTableOptions.columns[columnIndex].searchTableFiltersTeype = "";
                        }

                        searchRecordTable(DataTableOptions, elementRowsList_);
                        setFilterDateCondition(2, sortFilterColumnIndex_, null);
                        editableFilter_[sortFilterColumnIndex_] = '';
                        if (sortFilterColumnIndex_ === 2) {
                            var $infoIcon = $("#infoIcon");
                            $infoIcon
                                .attr('src', 'image/info_normal_16_p24.png')
                                .hover(function () {
                                    this.src = 'image/info_hover_16_p24.png';
                                }, function () {
                                    this.src = 'image/info_normal_16_p24.png';
                                });
                        } else {
                            $filterDialogHeader_.parent().parent().find(".xux-icon-funnel").first().css("color", '');
                        }
                    } else {
                        if (sortFilterColumnIndex_ === 2) {
                            var $infoIcon = $("#infoIcon");
                            $infoIcon
                                .attr('src', 'image/info_filter_16_p24.png')
                                .hover(function () {
                                    this.src = 'image/info_filter_hover_16_p24.png';
                                }, function () {
                                    this.src = 'image/info_filter_16_p24.png';
                                });
                        } else {
                            $filterDialogHeader_.parent().parent().parent().first().css("background-color", '#B2B2B2');
                            $filterDialogHeader_.parent().parent().find(".xux-icon-funnel").first().css("color", '#1b8f98');
                        }

                        if (sortFilterColumnIndex_ === 2) {
                            var filters = getFilter(FILTER_COND_CLASSNAME_SELECTOR);

                            if ($(FILTER_COND_CLASSNAME_SELECTOR + ':checked').val() == 3) {  // 不備/エラーあり
                                filters.push('(^1$)');
                                filters.push('(^2$)');
                            }

                            if (filters && filters.length !== 0) {
                                DataTableOptions.columns[columnIndex].searchTableFilters = filters.join('|');
                                searchRecordTable(DataTableOptions, elementRowsList_);
                                //sortFilterColumn_.search(filters.join('|'), true, false, false);
                            } else {
                                DataTableOptions.columns[columnIndex].searchTableFilters = "";
                                searchRecordTable(DataTableOptions, elementRowsList_);
                                //sortFilterColumn_.search(null, true);
                            }
                        } else if (sortFilterColumnIndex_ === 3) {
                            if (startNoNumberFilter_ !== '' || endNoNumberFilter_ !== '') {
                                DataTableOptions.columns[columnIndex].searchTableFilters = startNoNumberFilter_ + "-" + endNoNumberFilter_;
                                searchRecordTable(DataTableOptions, elementRowsList_);//sortFilterColumn_.search('', true, false);
                            }
                        } else if (!columnsInfo[sortFilterColumnIndex_ - 4] || columnsInfo[sortFilterColumnIndex_ - 4] !== '0') {
                            if (columnsInfo[sortFilterColumnIndex_ - 4] === '2' || columnsInfo[sortFilterColumnIndex_ - 4] === '3') {
                                var filters = getFilter(FILTER_COND_CLASSNAME_SELECTOR);
                                if (filters && filters.length !== 0) {
                                    DataTableOptions.columns[columnIndex].searchTableFilters = filters.join('|');
                                    searchRecordTable(DataTableOptions, elementRowsList_);
                                    //sortFilterColumn_.search(filters.join('|'), true, false, false);
                                } else {
                                    DataTableOptions.columns[columnIndex].searchTableFilters = "NoSelect";
                                    searchRecordTable(DataTableOptions, elementRowsList_);
                                    //sortFilterColumn_.search(null, true);
                                }
                            } else {
                                if (editableFilter_[sortFilterColumnIndex_] && editableFilter_[sortFilterColumnIndex_] !== '') {
                                    var filterStr = editableFilter_[sortFilterColumnIndex_];
                                    <%-- ダブルクォーテーションで囲まれている条件を抜き出す --%>
                                    var result = getSurroundedSearchCondition(filterStr);
                                    var filters = [];
                                    if (result["cutoutStrings"]) {
                                        var cutoutStringsLength = result["cutoutStrings"].length;
                                        for (var i = 0; i < cutoutStringsLength; i++) {
                                            if (result["cutoutStrings"][i].length === 0) {
                                                continue;
                                            }
                                            filters.push('(?=.*' + doRegExEncode(result["cutoutStrings"][i]) + '.*)');
                                        }
                                    }
                                    <%-- 部分一致検索条件のフィルタ追加（全角空白を半角空白に置換） --%>
                                    var editableFilterValueList = result["clippedValue"].replace(/　/g, ' ').split(' ');
                                    var editableFilterValueListLength = editableFilterValueList.length;
                                    for (var i = 0; i < editableFilterValueListLength; i++) {
                                        if (editableFilterValueList[i].length === 0) {
                                            continue;
                                        }
                                        filters.push('(?=.*' + doRegExEncode(editableFilterValueList[i]) + '.*)');
                                    }
                                    var filter = filters.join('');
                                    DataTableOptions.columns[columnIndex].searchTableFilters = filter;
                                    searchRecordTable(DataTableOptions, elementRowsList_);
                                    //sortFilterColumn_.search(filter, true, false, false);
                                } else {
                                    var filters = getFilter(FILTER_COND_CLASSNAME_SELECTOR);
                                    if (filters && filters.length !== 0) {
                                        DataTableOptions.columns[columnIndex].searchTableFilters = filters.join('|');
                                        searchRecordTable(DataTableOptions, elementRowsList_);
                                        //sortFilterColumn_.search(filters.join('|'), true, false, false);
                                    } else {
                                        DataTableOptions.columns[columnIndex].searchTableFilters = "";
                                        searchRecordTable(DataTableOptions, elementRowsList_);
                                    }
                                }
                            }
                        } else if (columnsInfo[sortFilterColumnIndex_ - 4] && columnsInfo[sortFilterColumnIndex_ - 4] === '0') {
                            var filters = getFilter(FILTER_COND_CLASSNAME_SELECTOR);
                            if (filters && filters.length !== 0) {
                                DataTableOptions.columns[columnIndex].searchTableFilters = filters.join('|');
                                searchRecordTable(DataTableOptions, elementRowsList_);
                                //sortFilterColumn_.search(filters.join('|'), true, false, false);
                            } else {
                                if ($filterPeriodCond && $filterPeriodCond.is(':checked')) {
                                    var toDate = new Date($('#filterToDate').val().replace(/-/g, '/'));
                                    var toDateSet = new Date($('#filterToDate').val().replace(/-/g, '/'));
                                    var fromDate = new Date($('#filterFromDate').val().replace(/-/g, '/'));
                                    var fromDateSet = new Date($('#filterFromDate').val().replace(/-/g, '/'));
                                    // フィルタ用の上限値日付と下限値日付が逆だったら入れ替える処理
                                    var swappedDates = swapDates(toDate, fromDate);
                                    toDate = swappedDates.toDateParam;
                                    fromDate = swappedDates.fromDateParam;
                                    // 画面表示用の上限値日付と下限値日付が逆だったら入れ替える処理
                                    var swappedDatesSet = swapDates(toDateSet, fromDateSet);
                                    toDateSet = swappedDatesSet.toDateParam;
                                    fromDateSet = swappedDatesSet.fromDateParam;

                                    if (!toDate) {
                                        toDate = '';
                                        toDateSet = '';
                                    }
                                    setFilterDateCondition(0, sortFilterColumnIndex_, toDateSet);
                                    if (fromDate) {
                                        setFilterDateCondition(1, sortFilterColumnIndex_, fromDateSet);
                                        fromDate.setDate(fromDate.getDate() + 1);
                                        fromDate.setSeconds(fromDate.getSeconds() - 1);
                                    } else {
                                        setFilterDateCondition(1, sortFilterColumnIndex_, '');
                                    }
                                    DataTableOptions.columns[columnIndex].fromDate = fromDate;
                                    DataTableOptions.columns[columnIndex].toDate = toDate;
                                    DataTableOptions.columns[columnIndex].searchTableFilters = fromDate + "-" + toDate;
                                    DataTableOptions.columns[columnIndex].searchTableFiltersTeype = "Date";
                                    searchRecordTable(DataTableOptions, elementRowsList_);
                                    //sortFilterColumn_.search('', true);
                                } else {
                                    DataTableOptions.columns[columnIndex].searchTableFilters = "";
                                    searchRecordTable(DataTableOptions, elementRowsList_);
                                    //setFilterDateCondition(2, sortFilterColumnIndex_, null);
                                    //sortFilterColumn_.search(null, true);
                                }
                            }
                        }

                    }

                    $("#columnPopup").xuxModalWindow("close");
                    //closeDiv($("#columnPopup"));
                    //-end
                });
            }

            /**
             * 上限値日付と下限値日付が逆だったら入れ替える処理
             * @param {Date} toDateParam - 上限値日付
             * @param {Date} fromDateParam - 下限値日付
             * @returns {Object} 交換された日付オブジェクト
             */
            function swapDates(toDateParam, fromDateParam) {
                // 両方の日付が存在するか確認
                if (toDateParam && fromDateParam) {
                    // fromDate が toDate より前の日付か確認
                    if (fromDateParam < toDateParam) {
                        // 日付を交換
                        var old = toDateParam;
                        toDateParam = fromDateParam;
                        fromDateParam = old;
                    }
                }
                // 入れ替えた日付を返す
                return { toDateParam, fromDateParam };
            }

            function setHeaderImage() {
                if ($filterDialogHeader_ != null) {
                    if ($(FILTER_ALLROWS_ID_SELECTOR).is(':checked')) {
                        if (sortFilterColumnIndex_ === 2) {
                            var $infoIcon = $("#infoIcon");//$filterDialogHeader_.children('img');
                            $infoIcon
                                .attr('src', 'image/info_normal_16_p24.png')
                                .hover(function () {
                                    this.src = 'image/info_hover_16_p24.png';
                                }, function () {
                                    this.src = 'image/info_normal_16_p24.png';
                                });
                        } else {
                            $filterDialogHeader_.parent().parent().find(".xux-icon-funnel").first().css("color", '');
                        }
                    } else {
                        if (sortFilterColumnIndex_ === 2) {
                            var $infoIcon = $("#infoIcon");//$filterDialogHeader_.children('img');
                            $infoIcon
                                .attr('src', 'image/info_filter_16_p24.png')
                                .hover(function () {
                                    this.src = 'image/info_filter_hover_16_p24.png';
                                }, function () {
                                    this.src = 'image/info_filter_16_p24.png';
                                });
                        } else {
                            $filterDialogHeader_.parent().parent().parent().first().css("background-color", '#B2B2B2');
                            $filterDialogHeader_.parent().parent().find(".xux-icon-funnel").first().css("color", '#1b8f98');
                        }
                    }
                }

            }

            function createDefectRadioItems(values, convertCaption) {
                return $.map(values, function (value, index) {
                    if (value === '') {
                        return null;
                    }
                    var sanitaizeValue = doSanitaizeEncode(doSanitaizeDecode(value));
                    var $radio = $('<input type="radio" class="' + FILTER_COND_CLASSNAME + '" value="' + sanitaizeValue + '" name="' + FILTER_RADIO_GROUP_NAME + '" />');

                    var image = $('<img style="padding: 0 0 0 8px;vertical-align: middle;position: relative;top: 1px;" class="dn-icon" src="image/ll_info_na.png" />');
                    if (value == '1') {
                        image = $('<img style="padding: 0 0 0 8px;vertical-align: middle;position: relative;top: 1px;" class="dn-icon" src="image/ll_info_d_normal.png" />');
                    } else if (value == '2') {
                        image = $('<img style="padding: 0 0 0 8px;vertical-align: middle;position: relative;top: 1px;" class="dn-icon" src="image/ll_info_e_normal.png" />');
                    } else if (value == '3') {
                        image = $('<img style="padding: 0 0 0 8px;vertical-align: middle;position: relative;top: 1px;" class="dn-icon" src="image/ll_info_de_normal.png" />');
                    }
                    var showImageText = convertCaption ? convertCaption(sanitaizeValue) : sanitaizeValue;
                    return $('<div class="columnPopupItem"></div>')
                        .append($radio)
                        .append(image)
                        .append('<span style="padding: 0 0 0 1px;vertical-align: middle;position: relative;top: 1px;" class="ui-button-text">' + showImageText + '</span>');
                });
            }

            // ソート作成
            function createRecordSort($items, $elementsTable, columnIndex, textDesc, testAsc, isCanceledFunc, typeSearch) {
                if (typeSearch == "unknownFilter") {
                    $("#unknownColumnPopupSort").html("");
                    $("#unknownColumnPopupSort").css("margin-left", "4px");
                    var $sortDescButton = $('<input type="radio" id="sortunknownDescButton" class="sortDescRadio" value="desc" name="sortunknownButtonGroupName" />');
                    var tempsortDescButtonDiv = $('<div id="sortDescButtonDiv"></div>');
                    tempsortDescButtonDiv.append($sortDescButton).append('<span style="padding: 0 0 0 8px;" class="ui-button-text">' + textDesc + '</span>');

                    var $sortAscButton = $('<input  id="sortunknownAscButton" class="sortAscRadio" type="radio"  value="asc" name="sortunknownButtonGroupName"/>');
                    var tempsortAscButtonDiv = $('<div id="sortAscButtonDiv"></div>');
                    tempsortAscButtonDiv.append($sortAscButton).append('<span style="padding: 0 0 0 8px;" class="ui-button-text">' + testAsc + '</span>');
                    $("#unknownColumnPopupSort").append(tempsortDescButtonDiv).append(tempsortAscButtonDiv);
                    changeRecordSortButtonColor($elementsTable, columnIndex);
                }
                else {
                    $("#columnPopupSortButton").html("");
                    $("#columnPopupSortButton").css("margin-left", "4px");
                    var $sortDescButton = $('<input type="radio" id="sortDescButton"  class="sortDescRadio" value="desc" name="sortButtonGroupName" />');
                    var tempsortDescButtonDiv = $('<div id="sortDescButtonDiv"></div>');
                    tempsortDescButtonDiv.append($sortDescButton).append('<span style="padding: 0 0 0 8px;" class="ui-button-text">' + textDesc + '</span>');

                    var $sortAscButton = $('<input  id="sortAscButton" class="sortAscRadio" type="radio"  value="asc" name="sortButtonGroupName"/>');
                    var tempsortAscButtonDiv = $('<div id="sortAscButtonDiv"></div>');
                    tempsortAscButtonDiv.append($sortAscButton).append('<span style="padding: 0 0 0 8px;" class="ui-button-text">' + testAsc + '</span>');
                    $("#columnPopupSortButton").append(tempsortDescButtonDiv).append(tempsortAscButtonDiv);
                    changeRecordSortButtonColor($elementsTable, columnIndex);
                }

            }
            // ソート処理
            toggleRecordSort = function ($elementsTable, columnIndex, direction, isCanceledFunc, typeSearch) {
                if (typeSearch == "unknownFilter") {
                    clickUnknownHeaderCell = columnIndex;
                    UnknownDataTableOptions.columns[clickUnknownHeaderCell].searchTableColumnDirection = direction;
                } else {
                    DataTableOptions.columns[columnIndex].searchTableColumnDirection = direction;
                    clickHeaderCell = columnIndex;
                    if (columnIndex >= 2) {
                        clickHeaderCellWidth = $("#elementsTable").find("[columnindex=" + columnIndex + "]").first().width() + 8;
                    }

                }

                isClickFilter = true;
                if (isCanceledFunc != null) {
                    isCanceledFunc();
                }
                var tempDataTable = null;
                if (typeSearch == "unknownFilter") {
                    tempDataTable = unknownRowsList_;
                    saveUnknownSelectPageCount();
                } else {
                    tempDataTable = elementRowsList_;
                    saveSelectPageCount();
                }

                var tempkey = getTableFields();
                if (typeSearch == "unknownFilter") {
                    tempkey = ["UnknownFormId", "UnknownFormId", 'FormShortName', 'ErrorMessage', 'IpAddress', 'ScanDate'];
                } else {
                    tempkey = getTableFields();
                }

                var sortPatam = {
                    sortKey: tempkey[columnIndex],
                    sortOrder: direction
                };
                var tempSortTable = sortObjectData(tempDataTable, sortPatam);
                if (typeSearch == "unknownFilter") {
                    unknownRowsList_ = tempSortTable;
                } else {
                    elementRowsList_ = tempSortTable;
                }

                var sortConds = $elementsTable.order();
                var sortCondIndex = indexOf(sortConds, function (cond) { return cond[0] === columnIndex; });
                if (0 <= sortCondIndex) {
                    if (sortConds[sortCondIndex][1] === direction) {
                        sortConds.splice(sortCondIndex, 1);
                        if (sortConds.length === 0) {
                            sortConds[0] = [columnIndex, direction];
                        }
                    }
                    else {
                        sortConds[sortCondIndex][1] = direction;
                    }
                }
                else {
                    sortConds = [[columnIndex, direction]];
                }

                if (typeSearch == "unknownFilter") {
                    //searchRecordTable(UnknownDataTableOptions, tempSortTable, "unknownFilter");
                } else {
                    //searchRecordTable(DataTableOptions, tempSortTable);
                }

                $elementsTable.order(sortConds);
                return tempSortTable;
                //$elementsTable.columns.adjust().draw();

                //changeRecordSortButtonColor($elementsTable, columnIndex);
            }
            // ソートボタンの色を変更する
            function changeRecordSortButtonColor($elementsTable, columnIndex) {
                var enable = 'background: #d8d8d8 none repeat scroll 0 0 !important;';
                var disable = '';
                var sortConds = $elementsTable.order();
                if (sortConds != null && 0 < sortConds.length) {
                    if (sortConds[0].length == 2) {
                        if (sortConds[0][0] == columnIndex) {
                            if (sortConds[0][1] == 'desc') {
                                $(".sortDescRadio").prop('checked', true).trigger('change');
                                //$('#sortDescButton.ui-button').css({ 'cssText': enable });
                                //$('#sortAscButton.ui-button').css({ 'cssText': disable });
                            } else if (sortConds[0][1] == 'asc') {
                                $(".sortAscRadio").prop('checked', true).trigger('change');
                                //$('#sortDescButton.ui-button').css({ 'cssText': disable });
                                //$('#sortAscButton.ui-button').css({ 'cssText': enable });
                            }
                        }
                    }
                }
            }
            function createRecordItems(values, convertCaption, idSelector, className, classNameSelector, inputName) {
                return $.map(values, function (value, index) {
                    if (value === '') {
                        return null;
                    }
                    var removeBRTag = value.replace(/<[Bb][rR]\/>/g, '');
                    var sanitaizeValue = doSanitaizeEncode(doSanitaizeDecode(removeBRTag));
                    var $checkbox = $('<input type="checkbox" class="' + className + '" value="' + sanitaizeValue + '" name="' + inputName + '" />')
                        .change(function () { changeCheckBox($(this), idSelector, classNameSelector); });
                    var showTextCheckBox = convertCaption ? convertCaption(sanitaizeValue) : sanitaizeValue;
                    return $('<div class="columnPopupItem"></div>')
                        .append($checkbox)
                        .append('<span style="padding: 0 0 0 8px;vertical-align: middle;position: relative;top: 1px;" class="ui-button-text">' + showTextCheckBox + '</span>');
                });
            }
            searchRecordTable = function (tempDataTableOptions, tempElementTableDataList, typeSearch) {
                //var returnRow = [];
                var tempRow = [];
                var elementTableDataList = [];
                var isSearchTable = false;
                var hasUnknownDateFilter = false;
                if (typeSearch == "unknownFilter") {
                    tempRow = toggleRecordSort($elementsTable_, tempDataTableOptions.sortOptions.column, tempDataTableOptions.sortOptions.order, null, typeSearch);
                    if (tempDataTableOptions && Array.isArray(tempDataTableOptions.columns)) {
                        hasUnknownDateFilter = tempDataTableOptions.columns.some(column => column.searchTableFiltersTeype === "Date");
                    }
                } else {
                    tempRow = toggleRecordSort($elementsTable_, tempDataTableOptions.sortOptions.column, tempDataTableOptions.sortOptions.order, null, typeSearch);
                }
                <%-- No列の開始条件、終了条件の判定処理 --%>
                for (var k = 0; k < tempElementTableDataList.length; k++) {
                    var tempSearckIdValue = "";
                    if (typeSearch == "unknownFilter") {
                        tempSearckIdValue = tempElementTableDataList[k].UnknownFormId;
                    } else {
                        tempSearckIdValue = tempElementTableDataList[k].BusinessRecordId;
                    }
                    if (searchTableColumnNo(tempSearckIdValue, typeSearch)) {
                        elementTableDataList.push(tempElementTableDataList[k]);
                    }
                }

                var tempDatetempList = elementTableDataList;
                elementTableDataList = [];
                var isSearchDate = false;
                for (var k = 0; k < tempDatetempList.length; k++) {
                    var tempScanDateValue = "";
                    if (typeSearch == "unknownFilter") {
                        if (!hasUnknownDateFilter) {
                            break;
                        }

                        tempScanDateValue = tempDatetempList[k].ScanDate;
                        if (searchTableColumnDate(tempScanDateValue, typeSearch)) {
                            elementTableDataList.push(tempDatetempList[k]);
                        }
                        isSearchDate = true;
                    } else {
                        var isDateOk = false;
                        for (var i = 0; i < tempDataTableOptions.columns.length; i++) {
                            if (tempDataTableOptions.columns[i].searchTableFiltersTeype == "Date") {
                                var tempDateField = tempDatetempList[k][tempDataTableOptions.columns[i].field];
                                isSearchDate = true;
                                if (tempDateField != "") {
                                    tempScanDateValue = new Date(tempDatetempList[k][tempDataTableOptions.columns[i].field]);
                                    if (searchTableColumnDate(tempScanDateValue, typeSearch, tempDataTableOptions.columns[i].fromDate, tempDataTableOptions.columns[i].toDate)) {

                                        isDateOk = true;
                                    } else {
                                        isDateOk = false;
                                        break;
                                    }
                                } else {
                                   isDateOk = false;
                                    break;
                                }
                            }
                        }
                        if (isDateOk) {
                            elementTableDataList.push(tempDatetempList[k]);
                        }

                    }

                }
                if (!isSearchDate) {
                    elementTableDataList = tempDatetempList;
                }

                for (var i = 0; i < tempDataTableOptions.columns.length; i++) {
                    if (typeSearch == "unknownFilter") {
                        if (i == 1) {
                            continue;
                        }
                        if (i == 5) {
                            if (tempDataTableOptions.columns[i].searchTableFilters != "") {

                            }
                            else {
                                continue;
                            }
                        }
                    } else {
                        if (i == 3) {
                            continue;
                        }
                    }

                    if (tempDataTableOptions.columns[i].searchTableFilters != "" && tempDataTableOptions.columns[i].searchTableFiltersTeype != "Date") {
                        tempRow = [];
                        isSearchTable = true;
                        for (var k = 0; k < elementTableDataList.length; k++) {
                            var keyTemp = tempDataTableOptions.columns[i].searchTableFilters.split("|");
                            for (var j = 0; j < keyTemp.length; j++) {
                                if (keyTemp[j] != "") {
                                    var re = new RegExp(keyTemp[j], "g");
                                    var columnsText = elementTableDataList[k][tempDataTableOptions.columns[i].field];
                                    if (re.test(columnsText)) {
                                        tempRow.push(elementTableDataList[k]);
                                    }
                                }

                            }

                        }
                    }
                    if (i == tempDataTableOptions.columns.length - 1) {
                        if (isSearchTable) {
                            elementTableDataList = tempRow;
                        }
                    } else if (tempRow.length > 0 && i < tempDataTableOptions.columns.length) {
                        if (isSearchTable) {
                            elementTableDataList = null;
                            elementTableDataList = tempRow;
                        }

                    } else {
                        if (isSearchTable) {
                            elementTableDataList = tempRow;
                        }
                    }
                }

                if (!isSearchTable) {
                    tempRow = elementTableDataList;
                }

                if (typeSearch == "unknownFilter") {
                    renderUnknowTable(tempRow)
                } else {
                    renderDataTableOptions(tempRow);
                    dataRange.callAPIAsync(dataRange.ACTION_INIT_DATA, dataRange.business_id, -1, function (dr_range_data) {
                        dataRange.callAPIAsync(dataRange.ACTION_RECORD_COUNT, dataRange.business_id, -1, function (dr_count) {
                            var message;
                            // 選択している業務のレコードの件数は表示レコード範囲設定でフィルターした件数はが一致する、且つフィルターした結果のレコードの件数も一致する場合
                            if (dr_range_data.Count == dr_count.Count && tempRow.length == dr_range_data.Count) {
                                message = dataRange.msgDataRangeDispAll;
                                $('#dataRangeStatus').css('margin-top', '-20px');
                            } else {
                                // 列のフィルター設定を実施しているとき
                                if (startNoNumberFilter_ !== '' || endNoNumberFilter_ !== '' || isSearchTable || isSearchDate) {
                                    var msgFiltered = "<%=Resources.Messages.DataTableInfoFilteredFormat%>" //  (_MAX_件からフィルタリングした結果です)
                                    var msgFilteredReplace = msgFiltered.replace("_MAX_", dr_range_data.Count);
                                    var msgDataRangeDispReplace = dataRange.msgDataRangeDispPart.replace("_DISP_COUNT_", "" + tempRow.length).replace("_ALL_COUNT_", "" + dr_count.Count);
                                    // 「x件/y件 表示中 <改行> （n件からフィルタリングした結果です）」
                                    message = msgDataRangeDispReplace + "\r\n" + msgFilteredReplace;
                                    $('#dataRangeStatus').css('margin-top', '-40px');
                                }
                                else {
                                    // 「x件/y件 表示中」
                                    message = dataRange.msgDataRangeDispPart.replace("_DISP_COUNT_", "" + tempRow.length).replace("_ALL_COUNT_", "" + dr_range_data.Count);
                                    $('#dataRangeStatus').css('margin-top', '-20px');
                                }
                            }

                            $("#dataRangeStatus").text(message);
                        });
                    });
                }
            }
            function searchTableColumnNo(tempNoNumberValue, typeSearch) {
                var startNoNumberFilterTemp = "";
                var endNoNumberFilterTemp = "";
                if (typeSearch == "unknownFilter") {
                    startNoNumberFilterTemp = startUnknownNoNumberFilter_;
                    endNoNumberFilterTemp = endUnknownNoNumberFilter_;
                } else {
                    startNoNumberFilterTemp = startNoNumberFilter_;
                    endNoNumberFilterTemp = endNoNumberFilter_;
                }
                if (startNoNumberFilterTemp !== '' || endNoNumberFilterTemp !== '') {
                    var value = tempNoNumberValue;
                    var min = parseInt(startNoNumberFilterTemp, 10);
                    var max = parseInt(endNoNumberFilterTemp, 10);
                    if (min > max) {
                        var changeValues = [];
                        changeValues.push(startNoNumberFilterTemp);
                        changeValues.push(min);
                        startNoNumberFilterTemp = endNoNumberFilterTemp;
                        min = max;
                        endNoNumberFilterTemp = changeValues[0];
                        max = changeValues[1];
                    }
                    if ((isNaN(min) && isNaN(max)) ||
                        (isNaN(min) && value <= max) ||
                        (min <= value && isNaN(max)) ||
                        (min <= value && value <= max)) {
                        return true;
                    } else {
                        return false;
                    }
                }
                return true;
            }
            function searchTableColumnDate(tempNoNumberValue, typeSearch, fromDate, toDate) {
                var tempFilterToDate = "";
                var tempFilterFromDate = ""
                if (typeSearch == "unknownFilter") {
                    tempFilterToDate = config.unknownFilterToDate;
                    tempFilterFromDate = config.unknownFilterFromDate;
                } else {
                    tempFilterToDate = toDate;
                    tempFilterFromDate = fromDate;
                }
                if (tempFilterToDate && tempNoNumberValue.getTime() < tempFilterToDate.getTime()) {
                    return false;
                }
                if (tempFilterFromDate && tempFilterFromDate.getTime() < tempNoNumberValue.getTime()) {
                    return false;
                }

                return true;
            }
            function resetHeadercolor() {
                $(".FilterDialog").each(function () {
                    var $infoIcon = $("#infoIcon");
                    var columnindexTemp = $(this).attr("columnindex");
                    if (DataTableOptions.columns[columnindexTemp].searchTableFilters == "") {
                        $(this).parent().parent().find(".xux-icon-funnel").first().css("color", '');
                        $(this).parent().parent().parent().first().css("background-color", '');
                        if (columnindexTemp == 2) {
                            $infoIcon
                                .attr('src', 'image/info_normal_16_p24.png')
                                .hover(function () {
                                    this.src = 'image/info_hover_16_p24.png';
                                }, function () {
                                    this.src = 'image/info_normal_16_p24.png';
                                });
                        }

                    } else {
                        $(this).parent().parent().find(".xux-icon-funnel").first().css("color", '#1b8f98');
                        $(this).parent().parent().parent().first().css("background-color", '#B2B2B2');
                        if (columnindexTemp == 2) {
                            $infoIcon
                                .attr('src', 'image/info_filter_16_p24.png')
                                .hover(function () {
                                    this.src = 'image/info_filter_hover_16_p24.png';
                                }, function () {
                                    this.src = 'image/info_filter_16_p24.png';
                                });
                        }

                    }
                });
            }
            //--------------------------------------------------------レコード一覧画面end  ------------------------------------------------------------//

            //--------------------------------------------------------レコードの新規作成、詳細確認 / 編集begin------------------------------------------------------------//            
            $("#newConf").xuxModalWindow({});

            //レコードの新規作成ボタン
            $('#createNewRecordButton').click(function () {
                $("#ConfRecordId").val(0);
                $("#clearDiv").html('');
                $("#clearDiv").html('<div id = "recordTableDiv" ><table id="recordTable" style="border: 1px solid #ccc;"><thead><th style="width: 50%;">設問名</th><th style="width: 50%;">値</th></thead><tbody></tbody></table></div >' +
                    '<div id="recordTableViewModeDiv"><table id="recordTableViewMode" style="border: 1px solid #ccc;"><thead><th style="width: 50%;">設問名</th><th style="width: 50%;">値</th></thead><tbody></tbody></table></div>');
                // レコード編集を表示、レコード詳細を非表示．
                $("#recordTableDiv").show();
                $("#recordTableViewModeDiv").hide();

                $("#mode").html("レコードの新規作成");
                $("#editMode1").hide();
                $("#billPayment1").hide();
                $("#console2").hide();
                $("#confirm2").hide();
                $("#console1").show();
                $("#confirm1").show();
                // int flg  :0 レコードの作成
                createRecordDialog(0);
            });

            //キャンセル1ボタン
            $("#console1").click(function () {
                $("#newConf").xuxModalWindow("close");
            });

            // OK1ボタン
            $("#confirm1").click(function () {
                saveSelectPageCount();
                var record = registRecordAjax(0);
                if (record != null) {
                    addNewRecord(record);
                }
            });

            // 編集モードボタン
            $("#editMode1").click(function (event) {
                $("#recordTableViewModeDiv").hide();
                $("#recordTableDiv").show();

                // 日付を更新する．
                var mi = new Date();
                yy = mi.getYear();
                mm = mi.getMonth() + 1;
                dd = mi.getDate();
                hh = mi.getHours();
                mt = mi.getMinutes();
                se = mi.getSeconds();
                if (yy < 2000) { yy += 1900; } // ←ブラウザ依存
                if (mm < 10) { mm = "0" + mm; }
                if (dd < 10) { dd = "0" + dd; }
                if (hh < 10) { hh = "0" + hh; }
                if (mt < 10) { mt = "0" + mt; }
                if (se < 10) { se = "0" + se; }
                $(".display_type_last_modify").val(yy + "/" + mm + "/" + dd + " " + hh + ":" + mt + ":" + se);
                $("#editMode1").xuxButton("disable"); // 押せないようにする 編集モード
                $("#billPayment1").xuxButton("disable");//帳票紐付
            });

            // 帳票紐付ボタン
            $("#billPayment1").click(function (event) {
                unknownWindowMode_ = 1;
                unknownMergeRecordIdList_ = [];
                UnknownDataTableOptions = null;
                startUnknownNoNumberFilter_ = endUnknownNoNumberFilter_ = '';
                $('#unknownDeleteButton').css('display', 'none');
                $('#unknownOKButton').css('display', 'inline-block');
                $('#unknownCloseButton').val('<%= Resources.Messages.CancelButtonCaption %>');
                //$unknownListDlg_.dialog('open');
                $("#unknownList").xuxModalWindow("open");
                loadUnknownData(true);<%-- ダイアログ表示後に一覧表示 --%>

            });

            // キャンセル2ボタン
            $("#console2").click(function () {
                var editable = $('#recordTableDiv').is(':visible');
                if (editable) {
                    $("#recordTableViewModeDiv").show();
                    $("#recordTableDiv").hide();
                    $("#editMode1").xuxButton("enable");//編集モード
                    $("#billPayment1").xuxButton("enable");//帳票紐付
                } else {
                    $("#newConf").xuxModalWindow("close");
                    $("#ConfRecordId").val("");
                }
            });

            //OK2ボタン
            $("#confirm2").click(function () {
                saveSelectPageCount();
                var editable = $('#recordTableDiv').is(':visible');
                if (editable) {
                    dispLoading("<%= Resources.Messages.ProcessingMessage %>");
						<%-- 排他チェック処理 --%>
                    $.ajax({
                        type: 'GET',
                        url: 'api/UpdateExclusiveCheck',
                        data: { businessRecodeId: $("#ConfRecordId").val(), lastUpdateDate: lastUpdateDate_, updateUserId: updateUserId_ },
                        dataType: "json",
                        success: function (data, dataType) {
                            if (data !== 0 && data !== 1 && data !== 2) {
                                redirectLoginPage();
                                return;
                            }
                            if (data === 1) {
                                <%--if (!confirm('<%= Resources.Messages.OverwriteCofirmMessage %>')) {
                                    removeLoading();
                                    return;
                                }--%>
                                confirmMessageEror('<%= Resources.Messages.OverwriteCofirmMessage %>', function () {
                                    // 更新処理
                                    var record = registRecordAjax(1);
                                    removeLoading();
                                    if (record != null) {
                                        replaceUpdateRecord(record);
                                        $("#ConfRecordId").val("");
                                    }
                                }, null, '<%= Resources.Messages.OkButtonCaption %>', '<%= Resources.Messages.CancelButtonCaption %>');
                            } else if (data === 2) {
                                alertMessageInfo('<%= Resources.Messages.FailedToUpdateMsg %>', function () {
                                    $("#newConf").xuxModalWindow("close");
                                });
                                removeLoading();
                                return;
                            } else if (data === 0) {
                                // 更新処理
                                var record = registRecordAjax(1);
                                removeLoading();
                                if (record != null) {
                                    replaceUpdateRecord(record);
                                    $("#ConfRecordId").val("");
                                }
                            }

                        },
                        error: function (XMLHttpRequest, textStatus, errorThrown) {
                            if (XMLHttpRequest.status == 200 || XMLHttpRequest.status == 401) {
                                redirectLoginPage();
                                return;
                            }
                            alertMessageEror('<%= Resources.Messages.AjaxErrorMessage %>');
                        },
                        complete: function (XMLHttpRequest, textStatus) {
                        }
                    });
                } else {
                    $("#newConf").xuxModalWindow("close");
                }

            });
            // レコードの新規作成
            function getRecordTable(displayItems_) {
                return {
                    selectionUnit: "none",
                    pageNavigationPosition: "none",
                    focusUnit: "none",
                    clear: true,
                    data: {
                        "fields": ["displayName", "displayItemId"],
                        "items": displayItems_
                    },
                    columns: [
                        {
                            field: "displayName",
                            render: function (td, item) {
                                var html = '<span>' + item._data.displayName + '</span>';
                                $(html).appendTo(td);
                            }
                        },
                        {
                            field: "displayItemId",
                            render: function (td, item) {
                                var data = item._data;
                            <%-- 値設定 --%>
                                var object = "";
                                if (data.mElement == null) {
                                    var id = 'display_item_' + data.displayItemId;
                                    var text = data.actionLog.ActionDate;
                                    if (text == null) {
                                        text = '';
                                    }
                                    // アクション日付．アクション日付編集フラグが立っている場合
                                    if ('<%= RecordUtil.IsEditableActionDate() %>' == 'True') {
                                        var div = $('<div class="editItemDiv" />');
                                        var actionClass = "";
                                        if (data.actionLog.DispItemType == '<%= (int)RecordUtil.DisplayType.LastModify %>') {
                                            // 最終更新日の判別のためクラス付与
                                            actionClass = "display_type_last_modify";
                                        }
                                        div.append($('<input type="text" id="' + id + '" class="text_xux ' + actionClass + '" style="width:216px; box-sizing:border-box" maxlength="19" value="' +
                                            text + '"/>'));
                                        div.append($('<div id="display_item_error_' + data.displayItemId + '" class="elementError" />'));
                                        object = div;
                                    } else {
                                        // 行削除
                                        this.fnDeleteRow(dataIndex);
                                        // hiddenに値を埋めておく．
                                        var hidden = $('<input type="hidden" id="' + id + '" />');
                                        hidden.val(text);
                                        this.append(hidden);
                                    }
                                } else {
                                    // 入力欄の種類によってオブジェクトを作り変える。
                                    switch (String(data.mElement.elementType)) {
                                        case '<%= (int)RecordUtil.ElementType.DivString %>':
                                            var div = $('<div class="editItemDiv"/>');
                                            var table = $('<table width="100%" class="divStringTable dataTable no-footer" role="grid" style="width: 100%;"><thead style="display: none;"><tr role="row"><th class="ui-state-default sorting_disabled" style="width: 0px;" rowspan="1" colspan="1"><div class="DataTables_sort_wrapper"><span class="DataTables_sort_icon"></span></div></th><th class="ui-state-default sorting_disabled" style="width: 0px;" rowspan="1" colspan="1"><div class="DataTables_sort_wrapper"><span class="DataTables_sort_icon"></span></div></th></tr></thead>' +
                                                '<tbody id="tbodyId"> </tbody></table>');
                                            var tbody = table.find('#tbodyId');
                                            for (var i = 0; i < data.mElement.mSubElement.length; i++) {

                                                var subElement = data.mElement.mSubElement[i];
                                                var rowClass = (i + 1) % 2 === 0 ? 'even' : 'odd';
                                                var label = subElement.subElementName || '';
                                                var elementData = subElement.elementData.elementData != null ? subElement.elementData.elementData : '';
                                                var id = 'element_' + data.elementId + '_' + subElement.subElementId;

                                                var row = $('<tr style = "border:solid #ccc 1px;" class="' + rowClass + '" role = "row" ><td>' + label + '</td><td><div class="editItemDiv"><input id="' + id + '" class="text_xux" style="width: 100%; box-sizing: border-box;" type="text" maxlength="300" value=' + elementData + '><div class="elementError1" ></div></div></td></tr>');
                                                tbody.append(row);
                                            }

                                            div.append(table);
                                            table.find("thead").hide();
                                            div.append($('<div id="element_error_' + data.mElement.elementId + '_0" class="elementError" />'));

                                            object = div;
                                            break;
                                        case '<%= (int)RecordUtil.ElementType.Selector %>':
                                            object = $('<div />');
                                            for (var sub in data.mElement.mSubElement) {
                                                var id = 'element_' +
                                                    data.mElement.elementId + '_' +
                                                    data.mElement.mSubElement[sub].subElementId;
                                                div = $('<div/>');
                                                if (data.mElement.mSubElement[sub].elementData.selectStatus == 1) {
                                                    div.append($('<input type="checkbox" class="checkBox_xux" id="' + id + '" checked="checked" />'));
                                                } else {
                                                    div.append($('<input type="checkbox" class="checkBox_xux" id="' + id + '" />'));
                                                }
                                                $('#' + id).xuxCheckbox();
                                                div.append($('<label/>').text(data.mElement.mSubElement[sub].subElementName));
                                                object.append(div);
                                            }
                                            <%-- エラー表示枠 --%>
                                            object.append($('<div id="element_error_' + data.mElement.elementId + '_0" class="elementError" />'));
                                            break;
                                        case '<%= (int)RecordUtil.ElementType.OneNumber %>':
                                            var div = $('<div  class="option_xux" />');

                                            var id = 'element_' +
                                                data.mElement.elementId + '_' +
                                                data.mElement.mSubElement[0].subElementId;
                                            var select = $('<select id="' + id + '" />');
                                        <%-- △、1-9のプルダウンを作成 --%>
                                            select.append($('<option />').val('').html('<%= Resources.Messages.NumXTabCaption %>'));
                                            select.append($('<option />').val(<%= Resources.Messages.Num0TabCaption %>).html('<%= Resources.Messages.Num0TabCaption %>'));
                                            select.append($('<option />').val(<%= Resources.Messages.Num1TabCaption %>).html('<%= Resources.Messages.Num1TabCaption %>'));
                                            select.append($('<option />').val(<%= Resources.Messages.Num2TabCaption %>).html('<%= Resources.Messages.Num2TabCaption %>'));
                                            select.append($('<option />').val(<%= Resources.Messages.Num3TabCaption %>).html('<%= Resources.Messages.Num3TabCaption %>'));
                                            select.append($('<option />').val(<%= Resources.Messages.Num4TabCaption %>).html('<%= Resources.Messages.Num4TabCaption %>'));
                                            select.append($('<option />').val(<%= Resources.Messages.Num5TabCaption %>).html('<%= Resources.Messages.Num5TabCaption %>'));
                                            select.append($('<option />').val(<%= Resources.Messages.Num6TabCaption %>).html('<%= Resources.Messages.Num6TabCaption %>'));
                                            select.append($('<option />').val(<%= Resources.Messages.Num7TabCaption %>).html('<%= Resources.Messages.Num7TabCaption %>'));
                                            select.append($('<option />').val(<%= Resources.Messages.Num8TabCaption %>).html('<%= Resources.Messages.Num8TabCaption %>'));
                                            select.append($('<option />').val(<%= Resources.Messages.Num9TabCaption %>).html('<%= Resources.Messages.Num9TabCaption %>'));
                                            select.val(String(data.mElement.mSubElement[0].elementData.elementData));
                                            div.append(select);
                                            div.append($('<div id="element_error_' + data.mElement.elementId +
                                                '_' + data.mElement.mSubElement[0].subElementId + '" class="elementError" />'));
                                            div.append($('<div id="element_error_' + data.mElement.elementId + '_0" class="elementError" />'));
                                            object = div;
                                            break;
                                        default:
                                            var id = 'element_' +
                                                data.mElement.elementId + '_' +
                                                data.mElement.mSubElement[0].subElementId;
                                            var div = $('<div class="editItemDiv" />');


                                            var text = data.mElement.mSubElement[0].elementData.elementData;
                                            if (text == null) {
                                                text = '';
                                            }
                                            var sanitaizeValue = doSanitaizeEncode(text);
                                            div.append($('<input type="text" id="' + id + '" style="width:216px; box-sizing:border-box" maxlength="' + freeEntryMaxLength_ + '" value="' +
                                                sanitaizeValue + '"/>').xuxDropdownBox());//
                                            div.append($('<div id="element_error_' + data.mElement.elementId +
                                                '_' + data.mElement.mSubElement[0].subElementId + '" class="elementError" />'));
                                            div.append($('<div id="element_error_' + data.mElement.elementId + '_0" class="elementError" />'));
                                            object = div;

                                            break;
                                    }

                                }
                                $(object).appendTo(td);
                            }
                        }
                    ],
                    afterRender: function () {
                        $(".text_xux").xuxDropdownBox();
                        $(".checkBox_xux").xuxCheckbox();
                        $(".editItemDiv").xuxTextFieldBox();
                        $(".option_xux").xuxDropdownBox();
                    }
                };

            }
            //レコードの詳細確認/編集
            function getRecordTableViewMode(displayItems_) {
                return {
                    selectionUnit: "none",
                    pageNavigationPosition: "none",
                    clear: true,
                    data: {
                        "fields": ["displayName", "displayItemId"],
                        "items": displayItems_
                    },
                    columns: [
                        {
                            field: "displayName",
                            render: function (td, item) {
                                var html = '<span>' + item._data.displayName + '</span>';
                                $(html).appendTo(td);
                            }
                        },
                        {
                            field: "displayItemId",
                            render: function (td, item) {
                                var data = item._data;
                            <%-- 値設定 --%>
                                var object = null;
                                if (data.mElement == null) {
                                    if ('<%= RecordUtil.IsEditableActionDate() %>' == 'True') {
                                        var div = $('<div />');
                                        var text = data.actionLog.ActionDate;
                                        if (text == null) {
                                            text = '';
                                        }
                                        div.append($('<label/>').text(text));
                                        object = div;
                                    } else {
                                        // 行削除
                                        this.fnDeleteRow(dataIndex);
                                    }
                                } else {
                                    // 入力欄の種類によってオブジェクトを作り変える。
                                    switch (String(data.mElement.elementType)) {
                                        case '<%= (int)RecordUtil.ElementType.DivString %>':
                                            var div = $('<div />');
                                            var table = $('<table width="100%" class="divStringTable dataTable no-footer" id="DataTables_Table_24" style="width: 100%;"><thead style="display: none;"><tr role="row"><th class="ui-state-default sorting_disabled" style="width: 0px;" rowspan="1" colspan="1"><div class="DataTables_sort_wrapper"><span class="DataTables_sort_icon"></span></div></th><th class="ui-state-default sorting_disabled" style="width: 0px;" rowspan="1" colspan="1"><div class="DataTables_sort_wrapper"><span class="DataTables_sort_icon"></span></div></th></tr></thead>' +
                                                '<tbody id="tbodyId"></tbody></table>');
                                            var tbody = table.find('#tbodyId');

                                            for (var i = 0; i < data.mElement.mSubElement.length; i++) {
                                                var subElement = data.mElement.mSubElement[i];
                                                var rowClass = (i + 1) % 2 === 0 ? 'even' : 'odd';
                                                var label = subElement.subElementName || '';
                                                var elementData = subElement.elementData.elementData != null ? subElement.elementData.elementData : '';

                                                var row = $('<tr class="' + rowClass + '" role="row"><td>' + label + '</td><td><div><label>' + elementData + '</label></div></td></tr>');
                                                tbody.append(row);
                                            }
                                            table.find("thead").hide();
                                            div.append(table);
                                            div.append($('<div id="element_error_' + data.mElement.elementId + '" class="elementError" />'));
                                            object = div;
                                            break;
                                        case '<%= (int)RecordUtil.ElementType.Selector %>':
                                            object = $('<div />');
                                            for (var sub in data.mElement.mSubElement) {
                                                div = $('<div/>');
                                                if (data.mElement.mSubElement[sub].elementData.selectStatus == 1) {
                                                    div.append($('<label/>').text(data.mElement.mSubElement[sub].subElementName));
                                                }
                                                object.append(div);
                                            }
                                            object.append($('<div id="element_error_' + data.mElement.elementId + '" class="elementError" />'));
                                            break;
                                        default: // その他はラベル．
                                            var div = $('<div />');
                                            var text = data.mElement.mSubElement[0].elementData.elementData;
                                            if (text == null) {
                                                text = '';
                                            }
                                            div.append($('<label/>').text(text));
                                            div.append($('<div id="element_error_' + data.mElement.elementId + '" class="elementError" />'));
                                            object = div;
                                            break;
                                    }
                                }
                                $(object).appendTo(td);
                            }
                        }
                    ],
                    afterRender: function () {

                    }
                };
            }

            // レコード作成/変更、詳細ダイアログ作成
            // int flg  :0 レコードの作成、1:レコードの編集
            function createRecordDialog(flg) {
                lastUpdateDate_ = null;
                updateUserId_ = null;
                $("#newConf").xuxModalWindow({
                    open: function () {
                        var div = $("#editMode1").parent("div");
                        if (flg != 0) {
                            div.css("float", "none");
                            div.children().eq(1).css("float", "none");
                            div.children().eq(2).css("float", "right");
                            div.children().eq(3).css("float", "right");
                        }
                        // 初期表示のボタンは非活性todo
                        if (flg == 0) {
                            $("#confirm1").xuxButton("disable");//OK
                        } else {
                            $("#confirm2").xuxButton("enable");//OK
                            $("#editMode1").xuxButton("disable");//編集モード
                            $("#billPayment1").xuxButton("disable"); //帳票紐付
                        }

                        $.ajax({
                            type: 'GET',
                            url: 'api/Record',
                            data: { business_Id: $('#businessList').val().split(':', 1)[0], record_Id: $("#ConfRecordId").val() },
                            dataType: "json",
                            clear: true,
                            success: function (data, dataType) {
                                if (data.Code == '<%= PrintUtil.ResultSuccess %>' || data.Code == '<%= RecordUtil.ResultScanning %>' || data.Code == '<%= RecordUtil.ResultNotExecuteNow %>') {
                                    recordInvalids_ = data.RecordInvalids;
                                    displayItems_ = data.MDisplayItems;
                                    lastUpdateDate_ = data.lastUpdateDate;
                                    updateUserId_ = data.updateUserId;

                                    var DataTableRecordViewOptions = getRecordTableViewMode(displayItems_);
                                    var DataTableRecordOptions = getRecordTable(displayItems_);

                                    $("#recordTableViewModeDiv").xuxDecoratedTable(DataTableRecordViewOptions);
                                    $("#recordTableDiv").xuxDecoratedTable(DataTableRecordOptions);

                                    // 不備通知の内容を反映
                                    setTimeout(function () {
                                        if (recordInvalids_.length > 0) {
                                            $.each(recordInvalids_, function () {
                                                id = "#element_error_" + this.ElementId + "_0";
                                                idView = "#element_error_" + this.ElementId;
                                                $(id).text(this.Message);
                                                $(idView).text(this.Message);
                                            });
                                        }
                                    }, 100);

                                    var isButtonEnable = true;
                                    // 業務ステータスが「遂行中」ではない場合は「編集」ボタン、「OK」ボタン（新規作成のみ）を非活性にする．
                                    if (data.Code == '<%= RecordUtil.ResultNotExecuteNow %>') {
                                        isButtonEnable = false;
                                    }
                                    // スキャン中の場合は「編集」ボタンを非活性にする．
                                    if (data.Code == '<%= RecordUtil.ResultScanning %>') {
                                        isButtonEnable = false;
                                    }
                                    // 各ボタンの活性化
                                    if (isButtonEnable) {
                                        if (flg == 0) {
                                            $("#confirm1").xuxButton("enable").focus();//OK
                                            // $('#newConf').parent().children(".ui-dialog-buttonpane").find('button:contains("OK")').button("enable").focus();
                                        } else {
                                            $("#editMode1").xuxButton("enable").focus();//編集モード
                                            $("#billPayment1").xuxButton("enable"); //帳票紐付
                                        }
                                    }
                                } else if (data.Code == '<%= RecordUtil.ResultSessionTimeOut %>') {
                                    // ログイン画面へリダイレクト
                                    redirectLoginPage();
                                } else {
                                    alertMessageInfo(data.Message);
                                }
                            },
                            error: function (XMLHttpRequest, textStatus, errorThrown) {
                                if (XMLHttpRequest.status == 200) {
                                    redirectLoginPage();
                                    return;
                                }
                                alertMessageEror('<%= Resources.Messages.AjaxErrorMessage %>');
                            }
                        });
                    }
                });
                $("#newConf").xuxModalWindow("open");
                $("#confirm2").xuxButton("option", "type", "default");
            }

            <%-- ログイン画面へのリダイレクト処理 --%>
            function redirectLoginPage() {
                closeType = 2;
                if (checkChanged(false)) {
                    alertMessageInfo('<%= Resources.Messages.ConfirmWindowCloseMessageTimeout %>', function () {
                        window.location = "Login.aspx";
                    });
                } else {
                    alertMessageInfo('<%= Resources.Messages.AjaxSessionTimeoutMessage %>', function () {
                        window.location = "Login.aspx";
                    });
                }

            }

            /** 
            * 新規作成したレコードをレコード一覧に追加する。 
            * @param {object} record 新規作成したレコードのJSONオブジェクト
            * @return {void} 戻り値なし
            */
            function addNewRecord(record) {
                if (!record) {
                    return;
                }
                <%--ローカルに保持したデータを更新して再表示--%>
                loadTabData(true);
                <%-- 現在の使用量で更新 --%>
                getAmountSize();
            }

            <%-- レコードの新規登録、更新を行う。--%>
            function registRecordAjax(flg) {
                // エラーを除去
                $('#recordTableDiv .elementError').each(function () {
                    $(this).text("");
                });

                var records = null;
                for (var item in displayItems_) {
                    if (displayItems_[item].mElement == null) {
                        id = '#display_item_' + displayItems_[item].displayItemId;
                        var object = $(id);
                        if (object != null) {
                            displayItems_[item].actionLog.ActionDate = object.val();
                        }
                    } else {
                        for (var sub in displayItems_[item].mElement.mSubElement) {
                            id = '#element_' + displayItems_[item].mElement.elementId + '_' +
                                displayItems_[item].mElement.mSubElement[sub].subElementId;
                            var object = $(id);
                            if (object != null) {
                                switch (String(displayItems_[item].mElement.elementType)) {
                                    case '<%= (int)RecordUtil.ElementType.Selector %>':
                                        if (object.prop('checked')) {
                                            displayItems_[item].mElement.mSubElement[sub].elementData.selectStatus = 1;
                                            displayItems_[item].mElement.mSubElement[sub].elementData.elementData =
                                                displayItems_[item].mElement.mSubElement[sub].subElementName;
                                        } else {
                                            displayItems_[item].mElement.mSubElement[sub].elementData.selectStatus = 0;
                                            displayItems_[item].mElement.mSubElement[sub].elementData.elementData = "";
                                        }
                                        break;
                                    case '<%= (int)RecordUtil.ElementType.OneNumber %>':
                                        displayItems_[item].mElement.mSubElement[sub].elementData.selectStatus = 0;
                                        displayItems_[item].mElement.mSubElement[sub].elementData.elementData = object.val();
                                        break;
                                    default: // その他は自由入力
                                        displayItems_[item].mElement.mSubElement[sub].elementData.selectStatus = 0;
                                        displayItems_[item].mElement.mSubElement[sub].elementData.elementData = object.val();
                                        break;
                                }
                            }
                        }
                    }
                }
                // 情報抽出に失敗したレコードのレコード更新が行われない
                var recordId = flg == 0 ? 0 : $("#ConfRecordId").val();

                $.ajax({
                    type: 'POST',
                    url: 'api/Record',
                    cache: false,
                    contentType: 'application/json',
                    data: JSON.stringify({ BusinessId: $('#businessList').val().split(':', 1)[0], UserId: "user", Mdisplays: displayItems_, RecordId: recordId }),
                    async: false,
                    success: function (data, dataType) {
                        if (data.Code == '<%= RecordUtil.ResultSuccess %>') {
                            // recordを作成．
                            records = {};
                            records["BusinessRecordId"] = data.MDisplayItems[0].mElement.mSubElement[0].elementData.businessRecordId;
                            records["Selected"] = false;
                            records["Detail"] = false;
                            records["HasError"] = false;
                            records["DefectNoticeType"] = 0;
                            $.each(data.MDisplayItems, function () {
                                if (0 < this.displayOrder) {
                                    var key = "DispItems" + (this.displayOrder + 2);
                                    var val = "";
                                    if (this.mElement == null) {
                                        if (this.actionLog.ActionDate == null) {
                                            val = '';
                                        } else {
                                            val = this.actionLog.ActionDate;
                                        }
                                    } else {
                                        var elementType = this.mElement.elementType;
                                        if (elementType == '<%= (int)RecordUtil.ElementType.Selector %>') {
                                            var vals = [];
                                            $.each(this.mElement.mSubElement, function () {
                                                if (this.elementData.selectStatus == 1) {
                                                    vals.push(doSanitaizeEncode(this.elementData.elementData));
                                                }
                                            });
                                            val = vals.join('/');

                                        } else if (elementType == '<%= (int)RecordUtil.ElementType.DivString %>') {
                                            var vals = [];
                                            $.each(this.mElement.mSubElement, function () {
                                                if (this.elementData.elementData.length !== 0) {
                                                    vals.push(doSanitaizeEncode(this.elementData.elementData));
                                                }
                                            });
                                            val = vals.join('/');
                                        } else {
                                            val = doSanitaizeEncode(this.mElement.mSubElement[0].elementData.elementData);
                                        }
                                    }
                                    records[key] = val;
                                }
                            });


                            alertMessageInfo("<%= Resources.Messages.MessageRegistSuccess %>", function () {
                                $("#newConf").xuxModalWindow("close");
                            });

                        } else if (data.Code == '<%= RecordUtil.ResultInvalid %>') {
                            // 対象エレメントにエラーメッセージを設定．
                            for (var error in data.RecordInvalids) {
                                var id = '#element_error_' + data.RecordInvalids[error].ElementId + '_' +
                                    data.RecordInvalids[error].SubElementId;
                                $(id).text(data.RecordInvalids[error].Message);
                                var displayId = '#display_item_error_' + data.RecordInvalids[error].displayItemId;
                                $(displayId).text(data.RecordInvalids[error].Message);
                            }

                            removeLoading();
                            alertMessageInfo('<%= Resources.Messages.RecordRegistInvalidMessage %>');
                            // 対象アクション日付にエラーメッセージを設定
                        } else if (data.Code == '<%= RecordUtil.ResultScanning %>' || data.Code == '<%= RecordUtil.ResultNotExecuteNow %>') {
                            alertMessageInfo(data.Message);
                            
                        } else if (data.Code == '<%= RecordUtil.ResultSessionTimeOut %>') {
                            // ログイン画面へリダイレクト
                            redirectLoginPage();
                        } else {
                            if (!data || !data.Code) {
                                redirectLoginPage();
                                return;
                            }
                            alertMessageInfo(data.Message);
                        }
                    },
                    error: function (XMLHttpRequest, textStatus, errorThrown) {
                        if (XMLHttpRequest.status == 200) {
                            redirectLoginPage();
                            return;
                        }
                        alertMessageEror('<%= Resources.Messages.AjaxErrorMessage %>');
                    }
                });
                return records;
            }

            /** 
            * 更新したレコードをレコード一覧に反映する。 
            * @param {object} record 更新したレコードのJSONオブジェクト
            * @return {void} 戻り値なし
            */
            function replaceUpdateRecord(record) {
                if (!record) {
                    return;
                }
                <%--ローカルに保持したデータを更新して再表示--%>
                loadTabData(true);
                <%-- 現在の使用量で更新 --%>
                getAmountSize();
            }
            //--------------------------------------------------------レコードの新規作成、詳細確認 / 編集end------------------------------------------------------------//

            //--------------------------------------------------------確認訂正画面begin------------------------------------------------------------//
            $('#notSelected').xuxModalWindow({});
            <%-- 確認訂正 --%>
            <%-- $('#confirmCorrectList').change(function () {
                // 確認訂正に戻されたときは何もしない
                if ($('#confirmCorrectList').val() == 0) {
                    return;
                }
                var ariaControlsSelect =$("#confirmCorrectListDiv").find("a").first().attr("aria-controls");
                $("#" + ariaControlsSelect+" li").each(function (i, item) {
                    $(item).removeClass("xux-sel-selected");

                });
                $($("#" + ariaControlsSelect+" li")[0]).addClass("xux-sel-selected");
                var recordIds = getCheckedRows();
                if (recordIds.length === 0) {
                    $('#notSelected').xuxModalWindow("open");
                    return;
                }

                isPrint = false;
                loadSelectFormData();
                
            }); --%>
            $('#confirmCorrectList2').click(function () {
                $('#selectButtom').val(1);
                var recordIds = getCheckedRows();
                if (recordIds.length === 0) {
                    $('#notSelected').xuxModalWindow("open");
                    return;
                }
                loadSelectReportData();
            });
            $('#confirmCorrectList3').click(function () {
                $('#selectButtom').val(2);
                var recordIds = getCheckedRows();
                if (recordIds.length === 0) {
                    $('#notSelected').xuxModalWindow("open");
                    return;
                }
                isPrint = false;
                loadSelectReportData();
            });
            function getCheckedRows() {
                var ids = [];
				<%-- 選択済みだけを対象とする --%>
                $('#elementsTable').find('[name=selectCheckBox]').each(function () {
                    if ($(this).is(':checked')) {
                        ids.push($(this).val());
                    }
                });
                return ids;
            }
            $("#notSelectedClose").click(function () {
                $("#notSelected").xuxModalWindow("close");
            });

            <%-- 画面遷移が発生した場合の処理 --%>
            $(window).bind('beforeunload', function (e) {
                if (winHandle_ != null) {
                    if (!winHandle_.closed && closeType != 0) {
                        checkChanged(true);

                        winHandle_.isParentClosed_ = true;
                        winHandle_.close();
                        winHandle_ = null;
                    }
                }
                if (previewWinHandle_ != null) {
                    if (!previewWinHandle_.closed) {
                        previewWinHandle_.close();
                        previewWinHandle_ = null;
                    }
                }
            });
            function transConfirmCorrect(formId, formName, elementId, businessRecordIds, mode) {
                var bizId = $('#businessList').val().split(':');
                var localMode = -1, localBRID = -1;
                if (mode)
                    localMode = mode;
                if (businessRecordIds)
                    localBRID = businessRecordIds;
                $.ajax({
                    type: 'POST',
                    url: 'api/ErrorList',
                    contentType: 'application/json',
                    data: JSON.stringify({ BusinessId: bizId[0], FormId: formId, FormName: formName, ElementId: elementId, BusinessRecordIds: localBRID, Mode: localMode }),
                    success: function (data, dataType) {
                        if (data.Code == 1) {
                            redirectLoginPage();
                        } else if (data.Code == 9) {
                            alertMessageInfo(data.Message);
                            $("#errInfo").dialog("close");
                            return;
                        } else {
                            if (localMode === -1) {
                                openConfirmationWindow("FormsFormat.aspx");
                            } else {
                                if (localMode === '1') {
                                    openConfirmationWindow("FormsFormat.aspx");
                                } else if (localMode === '2') {
                                    openConfirmationWindow("QuestionnaireFormat.aspx");
                                }
                                //$('#confirmCorrectList').val(0);
                                //$($("#confirmCorrectListDiv div div a span span span")[0]).html($("#confirmCorrectList").text().split('\n\t')[1]);
                            }
                        }
                    },
                    error: function (XMLHttpRequest, textStatus, errorThrown) {
                        alertMessageEror('<%= Resources.Messages.AjaxErrorMessage %>');
                    }
                });
            }



            function openConfirmationWindow(url) {
                var x = screen.width * 0.98;
                var y = screen.height * 0.9;
                if (isBrowserChrome())
                    y = screen.height * 0.87;
                try {
                    winHandle_ = window.open(url, "Confirmation", "screenX=0,screenY=0,left=0,top=0,width=" + x + ",height=" + y + ",scrollbars=yes,toolbar=no,menubar=no,staus=no,resizable=yes");
                } catch (e) {
                    // do nothing.
                }
                if (winHandle_ != null) {
                    winHandle_.focus();
                }
            }
            <%-- 確認訂正画面で変更されているかチェックする --%>
            function checkChanged(isUpdate) {
                if (winHandle_ == null && getCookie(COOKIENAME_CONFIRMATION_OPEN) != null) {
                    winHandle_ = window.open("", "Confirmation");
                }

                if (winHandle_ == null) return false;

                if (winHandle_.closed) return false;

                if (!winHandle_.elementRowsList_) return false;

                var elementRowsListLength = winHandle_.elementRowsList_.length;
                if (!elementRowsListLength) return false;

                var isChanged = false;
                for (var i = 0; i < elementRowsListLength; i++) {
                    if (winHandle_.elementRowsList_[i].isChanged) {
                        isChanged = true;
                        if (isUpdate) winHandle_.elementRowsList_[i].isChanged = false;
                    }
                }
                return isChanged;
            }
            //--------------------------------------------------------確認訂正画面end  ------------------------------------------------------------//

            //--------------------------------------------------------帳票選択begin------------------------------------------------------------//
            <%-- 帳票選択一覧で操作した選択の変更をDataTablesの実データに反映 --%>
            updateInnerForm = function (rowIndex) {
                for (var i = 0; i < formRowsList_.length; i++) {
                    if (i == rowIndex) {
                        formRowsList_[i].Selected = true;
                    } else {
                        formRowsList_[i].Selected = false;
                    }
                }
            }
            <%-- 帳票選択チェック行の帳票ID取得 --%>
            function getCheckedFormId() {
                if (!formRowsList_) {
                    return null;
                }
                var id = null;
                for (var i = 0; i < formRowsList_.length; i++) {
                    if (formRowsList_[i].Selected) {
                        id = formRowsList_[i].FormId;
                    }
                }
                return id;
            }
            <%-- 帳票選択チェック行の帳票名取得 --%>
            function getCheckedFormName() {
                if (!formRowsList_) {
                    return null;
                }
                var id = null;
                for (var i = 0; i < formRowsList_.length; i++) {
                    if (formRowsList_[i].Selected) {
                        id = formRowsList_[i].FormName;
                    }
                }
                return id;
            }
            //--------------------------------------------------------帳票選択end  ------------------------------------------------------------//

            //--------------------------------------------------------Menu begin  ------------------------------------------------------------//
            <%-- ログアウト --%>
            $('a.logout').click(function () {
                if (checkChanged(false)) {
                    <%--if (!window.confirm('<%= Resources.Messages.ConfirmWindowCloseMessageLogout %>')) {
                        return;
                    }--%>
                    confirmMessageEror('<%= Resources.Messages.ConfirmWindowCloseMessageLogout %>', function () {
                        closeType = 1;
                        location.href = "Logout.aspx";
                    }, null, '<%= Resources.Messages.OkButtonCaption %>', '<%= Resources.Messages.CancelButtonCaption %>');
                } else {
                    <%--if (!window.confirm('<%= Resources.Messages.ConfirmLogoutMessage %>')) {
                        return;
                    }--%>
                    confirmMessageEror('<%= Resources.Messages.ConfirmLogoutMessage %>', function () {
                        closeType = 1;
                        location.href = "Logout.aspx";
                    }, null, '<%= Resources.Messages.OkButtonCaption %>', '<%= Resources.Messages.CancelButtonCaption %>');
                }

            });
            <%-- 製品情報表示 --%>
            $('a.products').click(function () {
                var isAlive = (function () {
                    var result = false;
                    $.ajax({
                        type: 'GET',
                        url: 'api/QuestionnaireFormatElementRows',
                        async: false,
                        success: function (data, dataType) {
                            if (data !== '0' && data !== '1') {
                                return;
                            } else if (data === '0') {
                                return;
                            }
                            result = true;
                            return true;
                        }
                        , error: function (XMLHttpRequest, textStatus, errorThrown) {
                            if (XMLHttpRequest.status == 200) {
                                return;
                            }
                        }
                    });
                    return result;
                })();
                if (isAlive) {
                    var windowHeight = isBrowserFirefox() ? 460 : 440;
                    openWindow('Products.aspx', 'Products', 512, windowHeight);
                } else {
                    redirectLoginPage();
                }
            });
            //--------------------------------------------------------Menu end  ------------------------------------------------------------//
            //--------------------------------------------------------表示レコードの範囲設定 begin  ------------------------------------------------------------//
            <%-- 表示レコードの範囲設定 --%>
            function DataRange() {
                var dataRangeSelf_ = this;
                var currentBusiness = null;
                this.debug = false;
                $("#dataRangeDialog").xuxModalWindow({});
                // default values
                this.ledgerDataAlertThresholdRecord_ = "<%=ConfigurationManager.AppSettings["LedgerDataAlertThresholdRecord"]%>";
                this.ledgerDataAlertThresholdElement_ = "<%=ConfigurationManager.AppSettings["ledgerDataAlertThresholdElement"]%>";
                this.ledgerDataRangeRecordUse_ = "<%=ConfigurationManager.AppSettings["LedgerDataRangeRecordUse"]%>";
                this.ledgerDataRangeItemUse_ = "<%=ConfigurationManager.AppSettings["LedgerDataRangeItemUse"]%>";
                this.msgDataRangeDispAll = "<%=Resources.Messages.DataRangeDispAll%>";         // (全件表示中)
                this.msgDataRangeDispPart = "<%=Resources.Messages.DataRangeDispPart%>";       // (_DISP_COUNT_件 / _ALL_COUNT_件 表示中)

                this.ACTION_INIT_DATA = 1;             // business_idの業務に関する範囲設定情報取得
                this.ACTION_RECORD_COUNT = 2;                  // クッキー値の条件で検索したレコード件数取得
                this.ACTION_ELEMENT_VALUE = 3;              // element_id で指定された項目値のリスト取得
                this.ACTION_ELEMENT_COUNT = 4;          // business_idの業務のエレメント数取得
                this.ACTION_BUSINESS_ID = 5;            // 全業務ID取得

                this.RECORD_TYPE_NUMBER = "n";          // レコード番号
                this.RECORD_TYPE_COUNT = "c";           // レコード件数
                this.ACTION_DATE = "d";                 // 操作日付
                this.DEFECT_NOTICE = "dn";              // 不備通知通知
                this.ITEM_TYPE_FP = "type14";           // 自由記入/分割文字列
                this.ITEM_TYPE_S = "type3";             // 選択肢
                this.ITEM_TYPE_N = "type2";             // １文字数値
                //
                // Ajax Defferred
                //
                this.ajaxDeferreds = [];                // Ajax Deferred リスト
                this.ajaxDeferreding = false;           // Ajax Deferred フラグ
                this.cleanDeferreds = function () {
                    dataRangeSelf_.ajaxDeferreds.length = 0;
                }
                this.startDeferred = function () {
                    dataRangeSelf_.ajaxDeferreding = true;
                }
                this.doneDeferred = function (func) {
                    dataRangeSelf_.ajaxDeferreding = false;
                    $.when.apply($, dataRangeSelf_.ajaxDeferreds).done(function () {
                        dataRangeSelf_.cleanDeferreds();
                        func();
                    });
                }

	            <%-- this.postBack = "<%= /*Page.ClientScript.GetPostBackEventReference(); */ %>"; --%>
                // Web.Config値チェック
                this.cookieExpires = 365;
                try {
                    this.ledgerDataAlertThresholdRecord = parseInt(this.ledgerDataAlertThresholdRecord_);
                    if (this.ledgerDataAlertThresholdRecord < 0) {
                        this.ledgerDataAlertThresholdRecord = 10000;
                    }
                } catch (e) {
                    this.ledgerDataAlertThresholdRecord = 10000;
                }
                try {
                    this.ledgerDataAlertThresholdElement = parseInt(this.ledgerDataAlertThresholdElement_);
                    if (this.ledgerDataAlertThresholdElement < 0) {
                        this.ledgerDataAlertThresholdElement = 100000;
                    }
                } catch (e) {
                    this.ledgerDataAlertThresholdElement = 100000;
                }
                if (this.ledgerDataRangeRecordUse_ == "1") {
                    this.ledgerDataRangeRecordUse = true;
                } else if (this.ledgerDataRangeRecordUse_ == "0") {
                    this.ledgerDataRangeRecordUse = false;
                } else {
                    this.ledgerDataRangeRecordUse = true;      // デフォルト true
                }
                if (this.ledgerDataRangeItemUse_ == "1") {
                    this.ledgerDataRangeItemUse = true;
                } else if (this.ledgerDataRangeItemUse_ == "0") {
                    this.ledgerDataRangeItemUse = false;
                } else {
                    this.ledgerDataRangeItemUse = false;      // デフォルト false
                }
                // 現在エレメント数
                // ※disable/enable切り替え時にenableの可否を判断するために、範囲設定ダイアログ作成時に保存しておく。

                this.type14_element_count = 0;                  // Type1,4 エレメント数
                this.type3_elment_count = 0;                    // Type3 エレメント数
                this.type_2_element_count = 0;                  // Type2 エレメント数

                this.escape = function (str) {
                    return str.replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;').replace(/"/g, '&quot;').replace(/'/g, '&#39;');
                }
                this.unescape = function (str) {
                    return str.replace(/&lt;/g, '<').replace(/&gt;/g, '>').replace(/&quot;/g, '"').replace(/&#39;/g, '\'').replace(/&amp;/g, '&');
                }
                /**
                * 表示レコード範囲設定ダイアログに現在値を反映する。
                * @method setupDataRangeDialog
                * @param {integer} businessId
                * @return void
                */
                this.setupDataRangeDialog = function (businessId) {
                    dataRangeSelf_.doneDeferred(function () {
                        dataRangeSelf_.startDeferred();
                        // 現在のクッキー値を反映する。
                        dataRangeSelf_.reflectRangeCookieOrDefault(businessId);
                        dataRangeSelf_.doneDeferred(function () {
                            // 現在の条件での件数を表示する。
                            dataRangeSelf_.getRecordCountInDataRange();
                        });
                    });
                }
                /**
                * 業務の表示レコード範囲設定画面を作成する。
                * @method makeDataRangeDialog
                * @param {integer} businessId
                * @param {object} range_data
                * @param {boolean} callBySelect
                * @return void
                */
                this.makeDataRangeDialog = function (businessId, range_data, callBySelect) {
                    if (dataRangeSelf_.debug) console.log("makeDataRangeDialog:", "businessId", businessId);
                    var dialog_opt = {
                        title: "<%=Resources.Messages.DataRangeDialogTitle%>",
                        autoOpen: false,
                        width: 665,
                        height: 620,
                        modal: true,
                        buttons: {
                            "<%=Resources.Messages.OkButtonCaption%>": function () {        // OK
                                if (dataRangeSelf_.debug) console.log("DataRange: OKボタンが押されました。");

                                if (dataRangeSelf_.checkDataRangeCondition() == false) return;

                                // 現在の設定値をクッキー dr_<業務ID> に保存する。
                                dataRangeSelf_.setDataRangeCookie(dataRangeSelf_.business_id);
                                //
                                // 閾値チェック
                                //
                                dataRangeSelf_.callAPIAsync(dataRangeSelf_.ACTION_RECORD_COUNT, dataRangeSelf_.business_id, -1, function (dr_count) {
                                    if (dataRangeSelf_.ledgerDataAlertThresholdRecord < dr_count.Count) {
                                        // 閾値超え => 確認メッセージ
                                       <%-- if (window.confirm("<%= Resources.Messages.WarningRecordOver %>".replace("_RECORD_COUNT_", dataRangeSelf_.ledgerDataAlertThresholdRecord))) {
                                            // OK => 一覧表示
                                            dataRangeSelf_.reloadLedgerList();
                                        } else {
                                            // NG => 表示データの範囲設定ダイアログに戻る。
                                            if (dataRangeSelf_.debug) console.log("DataRange: レコード閾値超え警告でキャンセルが押されました。");
                                        }--%>
                                        confirmMessageEror("<%= Resources.Messages.WarningRecordOver %>".replace("_RECORD_COUNT_", dataRangeSelf_.ledgerDataAlertThresholdRecord), function () {
                                            // OK => 一覧表示
                                            dataRangeSelf_.reloadLedgerList();
                                        }, function () {
                                            // NG => 表示データの範囲設定ダイアログに戻る。
                                            if (dataRangeSelf_.debug) console.log("DataRange: レコード閾値超え警告でキャンセルが押されました。");
                                        }, '<%= Resources.Messages.OkButtonCaption %>', '<%= Resources.Messages.CancelButtonCaption %>');
                                    } else {
                                        dataRangeSelf_.callAPIAsync(dataRangeSelf_.ACTION_ELEMENT_COUNT, dataRangeSelf_.business_id, -1, function (dr_element_count) {
                                            if (dataRangeSelf_.ledgerDataAlertThresholdElement < (dr_count.Count * dr_element_count.Count)) {
                                                // 閾値超え => 確認メッセージ
                                               <%-- if (window.confirm('<%= Resources.Messages.WarningTimeToDisplay %>')) {

                                                    // OK => 一覧表示
                                                    dataRangeSelf_.reloadLedgerList();
                                                } else {
                                                    // NG => 表示データの範囲設定ダイアログに戻る。
                                                    if (dataRangeSelf_.debug) console.log("DataRange: 閾値超え警告でキャンセルが押されました。");
                                                }--%>
                                                confirmMessageEror('<%= Resources.Messages.WarningTimeToDisplay %>', function () {
                                                    // OK => 一覧表示
                                                    dataRangeSelf_.reloadLedgerList();
                                                }, function () {
                                                    // NG => 表示データの範囲設定ダイアログに戻る。
                                                    if (dataRangeSelf_.debug) console.log("DataRange: 閾値超え警告でキャンセルが押されました。");
                                                }, '<%= Resources.Messages.OkButtonCaption %>', '<%= Resources.Messages.CancelButtonCaption %>');
                                            } else {
                                                // 閾値内 => 一覧表示
                                                dataRangeSelf_.reloadLedgerList();
                                            }
                                        });
                                    }
                                });

                            },
                            "<%=Resources.Messages.CancelButtonCaption%>": function () {    // キャンセル
                                $(this).dialog("close");
                            }
                        },
                        close: function () {
                            if (callBySelect) {
                                // 業務選択をキャンセルする。
                                dataRangeSelf_.cancelBusinessSelect();
                            }
                        }
                    };
                    // エレメント項目をtype別に分類する。
                    var element_type14 = [], element_type2 = [], element_type3 = [];
                    for (var i = 0; i < range_data.Elements.length; i++) {
                        if (range_data.Elements[i].Type == 2) {
                            element_type2.push(range_data.Elements[i]);
                        } else if (range_data.Elements[i].Type == 3) {
                            element_type3.push(range_data.Elements[i]);
                        } else {
                            element_type14.push(range_data.Elements[i]);
                        }
                    }
                    if (dataRangeSelf_.debug) {
                        console.log("makeDataRangeDialog:", "Elements", range_data.Elements.length);
                        console.log("makeDataRangeDialog:", "element_type14", element_type14.length);
                        console.log("makeDataRangeDialog:", "element_type2", element_type2.length);
                        console.log("makeDataRangeDialog:", "element_type3", element_type3.length);
                    }
                    // ダイアログを作成する。
                    $("#tblItemCondition").empty();           // table
                    // アクションログ日付
                    if (range_data.ActionLogDisplayItems.length > 0) {

                        $("#tblItemCondition").append('<tr><td></td><td></td><td></td></tr>');
                        var $tr = $("#tblItemCondition tr:last");
                        $("td:eq(0)", $tr).append('<input type="radio" name="radioItem" id="radioActionLog" value="actionlog" checked="checked" >');
                        $("#radioActionLog").xuxRadio();
                        var $dataRangeActionLogDic = $('<div id="selectDataRangeActionLogDiv">');
                        var $select = $('<select id="selectDataRangeActionLog" class="dataRangeItemSelect"></select>').change(function () {
                            $("#radioActionLog").prop("checked", true).xuxRadio("refresh");
                        });
                        for (var i = 0; i < range_data.ActionLogDisplayItems.length; i++) {
                            var option = '<option value="' + range_data.ActionLogDisplayItems[i].DisplayItemId + '"';
                            if (i == 0) {
                                option += ' selected="selected"';
                            }
                            option += '>' + range_data.ActionLogDisplayItems[i].DisplayItemName + '</option>';
                            $select.append(option);
                        }
                        $dataRangeActionLogDic.append($select);
                        $("td:eq(1)", $tr).append($dataRangeActionLogDic);

                        var $fromDate = $('<input id="textDataRangeStartDate" style="width:166px;height: 28px;" type="date" />')
                            .change(function () {
                                $("#radioActionLog").prop("checked", true);
                                var v = dataRangeSelf_.isValidDate($("#textDataRangeStartDate").val());
                                if (v === false) {
                                    alertMessageInfo("<%=Resources.Messages.DataRangeInvalidDate%>");
                                $("#textDataRangeStartDate").val("");
                                return false;
                            } else {
                                var new_date = dataRangeSelf_.dateFormat(new Date(v + " 00:00:00"));
                                if ($("#textDataRangeStartDate").val() != new_date) {
                                    $("#radioActionLog").prop("checked", true);
                                }
                                $("#textDataRangeStartDate").val(v.replace(/\//g, '-'));
                            }
                        });
                        //    .datepicker({
                        //    onSelect: function (dateText, inst) {
                        //        var new_date = dataRangeSelf_.dateFormat(new Date(dateText + " 00:00:00"));
                        //        if (inst.lastVal != new_date) {
                        //            $("#radioActionLog").prop("checked", true);
                        //        }
                        //    }
                        //});
                        $("td:eq(2)", $tr).append("： ").append($fromDate).append("&nbsp;&nbsp;");

                        //var $fromDateIcon = $('<img src="image/calender_normal_16_p24.png" class="calenderIcon">').click(function () {
                        //    var $filterToDate = $('#textDataRangeStartDate');
                        //    if (!$filterToDate.prop('disabled')) {
                        //        $filterToDate.datepicker('show');
                        //    }
                        //})
                        //    .hover(function () {
                        //        this.src = 'image/calender_hover_16_p24.png';
                        //    }, function () {
                        //        this.src = 'image/calender_normal_16_p24.png';
                        //    });
                        //$("td:eq(2)", $tr).append($fromDateIcon).append("&nbsp;&nbsp;-&nbsp;&nbsp;");

                        var $toDate = $('<input id="textDataRangeEndDate" style="width:166px;height: 28px;" type="date" />')
                            .change(function () {
                                $("#radioActionLog").prop("checked", true);
                                var v = dataRangeSelf_.isValidDate($("#textDataRangeEndDate").val());
                                if (v === false) {
                                    alertMessageInfo("<%=Resources.Messages.DataRangeInvalidDate%>");
                                $("#textDataRangeEndDate").val("");
                                return false;
                            } else {
                                var new_date = dataRangeSelf_.dateFormat(new Date(v + " 00:00:00"));
                                if ($("#textDataRangeEndDate").val() != new_date) {
                                    $("#radioActionLog").prop("checked", true);
                                }
                                $("#textDataRangeEndDate").val(v.replace(/\//g, '-'));
                            }
                        });
                        //    .datepicker({
                        //    onSelect: function (dateText, inst) {
                        //        var new_date = dataRangeSelf_.dateFormat(new Date(dateText + " 00:00:00"));
                        //        if (inst.lastVal != new_date) {
                        //            $("#radioActionLog").prop("checked", true);
                        //        }
                        //    }
                        //});
                        $("td:eq(2)", $tr).append($toDate).append("&nbsp;&nbsp;");

                        //var $toDateIcon = $('<img src="image/calender_normal_16_p24.png" class="calenderIcon">').click(function () {
                        //    var $filterToDate = $('#textDataRangeEndDate');
                        //    if (!$filterToDate.prop('disabled')) {
                        //        $filterToDate.datepicker('show');
                        //    }
                        //})
                        //    .hover(function () {
                        //        this.src = 'image/calender_hover_16_p24.png';
                        //    }, function () {
                        //        this.src = 'image/calender_normal_16_p24.png';
                        //    });
                        //$("td:eq(2)", $tr).append($toDateIcon);
                    }
                    // Type1 or Type4
                    $("#tblItemCondition").append('<tr><td></td><td></td><td></td></tr>');
                    var $tr = $("#tblItemCondition tr:last");
                    $("td:eq(0)", $tr).append('<input type="radio" name="radioItem" id="radioTypeFP" value="Type14">');
                    $("#radioTypeFP").xuxRadio();
                    var selected = false;
                    var $selectDataRangeTypeFPDic = $('<div id="selectDataRangeTypeFPDiv">');
                    var $select = $('<select id="selectDataRangeTypeFP" class="dataRangeItemSelect"></select>').change(function () {
                        $("#radioTypeFP").prop("checked", true).xuxRadio("refresh");
                    });
                    for (var i = 0; i < element_type14.length; i++) {
                        var option = '<option value="' + element_type14[i].ElementId + ':' + element_type14[i].Type + '"';
                        if (i == 0) {
                            option += ' selected="selected"';
                            selected = true;
                        }
                        option += '>' + dataRangeSelf_.escape(element_type14[i].Name) + '</option>';
                        $select.append(option);
                    }
                    $selectDataRangeTypeFPDic.append($select);
                    $("td:eq(1)", $tr).append($selectDataRangeTypeFPDic);
                    // （注）changeイベントはフォーカスアウト時にしか通知されない。
                    $("td:eq(2)", $tr).append("：").append('<div id="textDataRangeFreeDiv" style="float: right;"><input type="text" id="textDataRangeFree" style="width:360px;" /></div>').change(function () {
                        $("#radioTypeFP").prop("checked", true).xuxRadio("refresh");
                    }).change(function () {
                        $("#radioTypeFP").prop("checked", true).xuxRadio("refresh");
                    });

                    // 該当項目が存在しない => disable
                    dataRangeSelf_.type14_element_count = element_type14.length;
                    if (dataRangeSelf_.type14_element_count == 0) {
                        //$("#selectDataRangeTypeFP").prop("disabled", true);
                        $("#textDataRangeFree").prop("disabled", true);
                        $("#textDataRangeFreeDiv").xuxTextFieldBox({ "disabled": true });
                        //$("#radioTypeFP").prop("disabled", true);
                        $("#selectDataRangeTypeFPDiv").xuxDropdownBox({ "disabled": true , "width": "narrow"});
                        $("#radioTypeFP").xuxRadio({ "disabled": false });
                    }
                    // Type3
                    $("#tblItemCondition").append('<tr><td></td><td></td><td></td></tr>');
                    var $tr = $("#tblItemCondition tr:last");
                    $("td:eq(0)", $tr).append('<input type="radio" name="radioItem" id="radioTypeS" value="type3">');
                    $("#radioTypeS").xuxRadio();

                    var $selectDataRangeTypeSDic = $('<div id="selectDataRangeTypeSDiv">');
                    var $select = $('<select id="selectDataRangeTypeS" class="dataRangeItemSelect"></select>').change(function () {
                        $("#radioTypeS").prop("checked", true).xuxRadio("refresh");
                        dispLoading("<%=Resources.Messages.DataRangeTypeSSelectionMsg%>");

                        var element_id = $("#selectDataRangeTypeS").val().split(':', 1)[0];
                        // 選択されたエレメントの選択肢を取得する。
                        dataRangeSelf_.callAPIAsync(dataRangeSelf_.ACTION_ELEMENT_VALUE, businessId, -1, function (data_range) {

                            $sel = $("#selectDataRangeTypeSValue");
                            $sel.empty();
                            // 「選択無し」
                            var option = '<option value="" selected="selected"><%=Resources.Messages.DataRangeNoSelected%></option>';
                            $sel.append(option);
                            for (var i = 0; i < data_range.Values.length; i++) {
                                if (dataRangeSelf_.debug) console.log("makeDataRangeDialog:", "Type3Value(2)", data_range.Values[i]);
                                var option = '<option value="' + data_range.Values[i] + '">' + dataRangeSelf_.escape(data_range.Values[i]) + '</option>';
                                $sel.append(option);
                            }
                            removeLoading();
                            $("#selectDataRangeTypeSValueDiv").xuxDropdownBox("refresh");
                        }, element_id, 3);
                    });
                    $selectDataRangeTypeSDic.append($select);
                    $("td:eq(1)", $tr).append($selectDataRangeTypeSDic);


                    var $selectDataRangeTypeSValueDic = $('<div id="selectDataRangeTypeSValueDiv" style="float: right;">');
                    var $selectValue = $('<select id="selectDataRangeTypeSValue" class="dataRangeValueSelect"></select>').change(function () {
                        $("#radioTypeS").prop("checked", true).xuxRadio("refresh");
                    });


                    for (var i = 0; i < element_type3.length; i++) {

                        var option = '<option value="' + element_type3[i].ElementId + ':' + element_type3[i].Type + '"';
                        if (i == 0) {
                            option += ' selected="selected"';
                            dataRangeSelf_.callAPIAsync(dataRangeSelf_.ACTION_ELEMENT_VALUE, businessId, -1, function (data_range) {

                                var $sel = $("#selectDataRangeTypeSValue");
                                $sel.empty();
                                // 「選択無し」
                                var option = '<option value="" selected="selected"><%=Resources.Messages.DataRangeNoSelected%></option>';
                                $sel.append(option);
                                for (var i = 0; i < data_range.Values.length; i++) {
                                    if (dataRangeSelf_.debug) console.log("makeDataRangeDialog:", "Type3Value(1)", data_range.Values[i]);
                                    var option = '<option value="' + data_range.Values[i] + '">' + dataRangeSelf_.escape(data_range.Values[i]) + '</option>';
                                    $sel.append(option);
                                }

                                $("#selectDataRangeTypeSValueDiv").xuxDropdownBox({ width: 'wide' });
                                $("#selectDataRangeTypeSValueDiv").xuxDropdownBox("refresh");
                            }, element_type3[i].ElementId, 3);
                        }
                        option += '>' + dataRangeSelf_.escape(element_type3[i].Name) + '</option>';
                        $select.append(option);
                    }
                    $selectDataRangeTypeSValueDic.append($selectValue)
                    $("td:eq(2)", $tr).append(" ：").append($selectDataRangeTypeSValueDic);
                    // 該当項目が存在しない => disable
                    dataRangeSelf_.type3_elment_count = element_type3.length;
                    $("#selectDataRangeTypeSDiv").xuxDropdownBox({ width: 'narrow' });
                    $("#selectDataRangeTypeSValueDiv").xuxDropdownBox({ width: 'wide' });
                    if (dataRangeSelf_.type3_elment_count == 0) {
                        //$("#selectDataRangeTypeS").prop("disabled", true);
                        //$("#selectDataRangeTypeSValue").prop("disabled", true);
                        //$("#radioTypeS").prop("disabled", true);
                        $("#selectDataRangeTypeSDiv").xuxDropdownBox({ "disabled": true });
                        $("#selectDataRangeTypeSValueDiv").xuxDropdownBox({ "disabled": true });
                        $("#radioTypeS").xuxRadio({ "disabled": true });
                    }
                    // Type2
                    $("#tblItemCondition").append('<tr><td></td><td></td><td></td></tr>');
                    var $tr = $("#tblItemCondition tr:last");
                    $("td:eq(0)", $tr).append('<input type="radio" name="radioItem" id="radioTypeN" value="type2">');
                    var $selectDataRangeTypeNDic = $('<div id="selectDataRangeTypeNDiv">');
                    var $select = $('<select id="selectDataRangeTypeN" class="dataRangeItemSelect"></select>').change(function () {
                        $("#radioTypeN").prop("checked", true).xuxRadio("refresh");
                    });
                    for (var i = 0; i < element_type2.length; i++) {
                        var option = '<option value="' + element_type2[i].ElementId + ':' + element_type2[i].Type + '"';
                        if (i == 0) {
                            option += ' selected="selected"';
                        }
                        option += '>' + element_type2[i].Name + '</option>';
                        $select.append(option);
                    }
                    $selectDataRangeTypeNDic.append($select);
                    $("td:eq(1)", $tr).append($selectDataRangeTypeNDic);
                    var $selectDataRangeTypeNValueDic = $('<div id="selectDataRangeTypeNValueDiv" style="float: right;">');
                    $select = $('<select id="selectDataRangeTypeNValue" class="dataRangeValueSelect"></select>').change(function () {
                        $("#radioTypeN").prop("checked", true).xuxRadio("refresh");
                    });

                    if (element_type2.length > 0) {
                        var type2_val = [-1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9];
                        for (var i = 0; i < type2_val.length; i++) {
                            var opt = '<option value="' + (type2_val[i] == -1 ? "" : "" + type2_val[i]) + '"';
                            if (i == 0) {
                                opt += ' selected="selected"';
                            }
                            opt += '>' + (type2_val[i] == -1 ? "△" : "" + type2_val[i]) + '</option>';
                            $select.append(opt);
                        }
                    }
                    $selectDataRangeTypeNValueDic.append($select);
                    $("td:eq(2)", $tr).append("：").append($selectDataRangeTypeNValueDic);
                    $("#selectDataRangeTypeNValueDiv").xuxDropdownBox({ width: 'wide' });
                    $("#selectDataRangeActionLogDiv").xuxDropdownBox({ width: 'narrow' });
                    $("#selectDataRangeTypeFPDiv").xuxDropdownBox({ width: 'narrow' });
                    $("#textDataRangeFree").xuxTextFieldBox();
                    $("#textDataRangeFreeDiv").xuxTextFieldBox();
                    $("#selectDataRangeTypeNDiv").xuxDropdownBox({ width: 'narrow' });
                    $("#radioTypeN").xuxRadio();
                    // 該当項目が存在しない => disable
                    dataRangeSelf_.type_2_element_count = element_type2.length;
                    if (dataRangeSelf_.type_2_element_count == 0) {
                        //$("#selectDataRangeTypeN").prop("disabled", true);
                        //$("#selectDataRangeTypeNValue").prop("disabled", true);
                        //$("#radioTypeN").prop("disabled", true);
                        $("#selectDataRangeTypeNDiv").xuxDropdownBox({ "disabled": true });
                        $("#selectDataRangeTypeNValueDiv").xuxDropdownBox({ "disabled": true });
                        $("#radioTypeN").xuxRadio({ "disabled": true });
                    }
                    // 不備通知
                    $("#tblItemCondition").append('<tr><td></td><td></td><td></td></tr>');
                    var $tr = $("#tblItemCondition tr:last");
                    $("td:eq(0)", $tr).append('<input type="radio" name="radioItem" id="radioDefectNotice" value="dn">');
                    $("td:eq(1)", $tr).append('不備通知：');
                    var $selectDefectNoticeValueDic = $('<div id="selectDefectNoticeValueDiv" style="margin-left: 20px;">');
                    $select = $('<select id="selectDefectNoticeValue" class="dataRangeValueSelect"></select>').change(function () {
                        $("#radioDefectNotice").prop("checked", true).xuxRadio("refresh");
                    });

                    $selectDefectNoticeValueDic.append($select);
                    $select.append('<option value="1" selected="selected"><%= Resources.Messages.DefectCaption %></option>');
                    $select.append('<option value="2"><%= Resources.Messages.ErrorCaption %></option>');
                    $select.append('<option value="3"><%= Resources.Messages.DefAndErrCaption %></option>');
                    $select.append('<option value="0"><%= Resources.Messages.NoNoticeCaption %></option>');

                    $("td:eq(2)", $tr).append($selectDefectNoticeValueDic);
                    $("#dataRangeDialog").xuxModalWindow("open");
                    $("#radioDefectNotice").xuxRadio();
                    $("#selectDefectNoticeValueDiv").xuxDropdownBox({ width: 'wide' });
                    //$("#dataRangeDialog").dialog(dialog_opt);
                    // イベント
                    $("#dataRangeCountButton").unbind("click", dataRangeSelf_.getRecordCountInDataRange)
                        .click(dataRangeSelf_.getRecordCountInDataRange);
                    $("#chkDataRangeRecord").click(function () {
                        if ($(this).is(':checked')) {
                            $("#tblRecordCondition input, #tblRecordCondition select").prop("disabled", false);
                            $("#rangeSelectDiv").xuxDropdownBox({ "disabled": false });
                            $("#textDataRangeRecordDiv").xuxTextFieldBox({ "disabled": false });
                        } else {
                            $("#tblRecordCondition input, #tblRecordCondition select").prop("disabled", true);
                            $("#rangeSelectDiv").xuxDropdownBox({ "disabled": true });
                            $("#textDataRangeRecordDiv").xuxTextFieldBox({ "disabled": true });
                        }
                        $("#chkDataRangeRecord").xuxCheckbox();
                    });
                    $("#chkDataRangeItem").click(function () {
                        if ($(this).is(':checked')) {
                            $("#tblItemCondition input, #tblItemCondition select").prop("disabled", false);
                            $("#selectDataRangeActionLogDiv").xuxDropdownBox({ "disabled": false });
                            $("#selectDataRangeTypeFPDiv").xuxDropdownBox({ "disabled": false });
                            $("#selectDataRangeTypeSDiv").xuxDropdownBox({ "disabled": false });
                            $("#selectDataRangeTypeSValueDiv").xuxDropdownBox({ "disabled": false });
                            $("#selectDataRangeTypeNDiv").xuxDropdownBox({ "disabled": false });
                            $("#selectDataRangeTypeNValueDiv").xuxDropdownBox({ "disabled": false });
                            $("#radioTypeN").xuxRadio({ "disabled": false });
                            $("#selectDefectNoticeValueDiv").xuxDropdownBox({ "disabled": false });
                            $("#radioActionLog").xuxRadio({ "disabled": false });
                            $("#radioTypeFP").xuxRadio({ "disabled": false });
                            $("#radioTypeS").xuxRadio({ "disabled": false });
                            $("#radioDefectNotice").xuxRadio({ "disabled": false });
                            // 当該項目の存在しない場合は、disableのままにする。
                            dataRangeSelf_.disableNoElementCond();
                        } else {
                            $("#tblItemCondition input, #tblItemCondition select").prop("disabled", true);
                            $("#selectDataRangeActionLogDiv").xuxDropdownBox({ "disabled": true });
                            $("#selectDataRangeTypeFPDiv").xuxDropdownBox({ "disabled": true });
                            $("#selectDataRangeTypeSDiv").xuxDropdownBox({ "disabled": true });
                            $("#selectDataRangeTypeSValueDiv").xuxDropdownBox({ "disabled": true });
                            $("#selectDataRangeTypeNDiv").xuxDropdownBox({ "disabled": true });
                            $("#selectDataRangeTypeNValueDiv").xuxDropdownBox({ "disabled": true });
                            $("#radioTypeN").xuxRadio({ "disabled": true });
                            $("#selectDefectNoticeValueDiv").xuxDropdownBox({ "disabled": true });
                            $("#radioActionLog").xuxRadio({ "disabled": true });
                            $("#radioTypeFP").xuxRadio({ "disabled": true });
                            $("#radioTypeS").xuxRadio({ "disabled": true });
                            $("#radioDefectNotice").xuxRadio({ "disabled": true });
                        }
                        $("#chkDataRangeItem").xuxCheckbox();
                    });
                    //$("#dataRangeCountButton").prop("disabled", false);
                    $("#dataRangeCountButton").xuxButton({ "disabled": false });
                    $("#dataRangeCount").text("");
                    $("#textDataRangeRecordS").change(function () {
                        var val = $("#textDataRangeRecordS").val();
                        if (!dataRangeSelf_.isValidRecordNumber(val)) {
                            setTimeout(function () { $("#textDataRangeRecordS").focus(); }, 0);
                            alertMessageInfo('<%= Resources.Messages.DataRangeInvalidNumber %>');
                            return false;
                        }
                    });
                    $("#textDataRangeRecordE").change(function () {
                        var val = $("#textDataRangeRecordE").val();
                        if (!dataRangeSelf_.isValidRecordNumber(val)) {
                            setTimeout(function () { $("#textDataRangeRecordE").focus(); }, 0);
                            alertMessageInfo('<%= Resources.Messages.DataRangeInvalidNumber %>');
                            return false;
                        }
                    });
                }

                $("#confirmButton").click(function () {
                    getDataRangeList();
                });
                function getDataRangeList() {
                    if (dataRangeSelf_.debug) console.log("DataRange: OKボタンが押されました。");

                    if (dataRangeSelf_.checkDataRangeCondition() == false) return;

                    // 現在の設定値をクッキー dr_<業務ID> に保存する。
                    dataRangeSelf_.setDataRangeCookie(dataRangeSelf_.business_id);
                    //
                    // 閾値チェック
                    //
                    dataRangeSelf_.callAPIAsync(dataRangeSelf_.ACTION_RECORD_COUNT, dataRangeSelf_.business_id, -1, function (dr_count) {
                        if (dataRangeSelf_.ledgerDataAlertThresholdRecord < dr_count.Count) {
                            // 閾値超え => 確認メッセージ
                            <%--if (window.confirm("<%= Resources.Messages.WarningRecordOver %>".replace("_RECORD_COUNT_", dataRangeSelf_.ledgerDataAlertThresholdRecord))) {
                                // OK => 一覧表示
                                dataRangeSelf_.reloadLedgerList();
                            } else {
                                // NG => 表示データの範囲設定ダイアログに戻る。
                                if (dataRangeSelf_.debug) console.log("DataRange: レコード閾値超え警告でキャンセルが押されました。");
                            }--%>
                            confirmMessageEror("<%= Resources.Messages.WarningRecordOver %>".replace("_RECORD_COUNT_", dataRangeSelf_.ledgerDataAlertThresholdRecord), function () {
                                // OK => 一覧表示
                                dataRangeSelf_.reloadLedgerList();
                            }, function () {
                                // NG => 表示データの範囲設定ダイアログに戻る。
                                if (dataRangeSelf_.debug) console.log("DataRange: レコード閾値超え警告でキャンセルが押されました。");
                            }, '<%= Resources.Messages.OkButtonCaption %>', '<%= Resources.Messages.CancelButtonCaption %>');
                        } else {
                            dataRangeSelf_.callAPIAsync(dataRangeSelf_.ACTION_ELEMENT_COUNT, dataRangeSelf_.business_id, -1, function (dr_element_count) {
                                if (dataRangeSelf_.ledgerDataAlertThresholdElement < (dr_count.Count * dr_element_count.Count)) {
                                    // 閾値超え => 確認メッセージ
                                    <%--if (window.confirm('<%= Resources.Messages.WarningTimeToDisplay %>')) {

                                        // OK => 一覧表示
                                        dataRangeSelf_.reloadLedgerList();
                                    } else {
                                        // NG => 表示データの範囲設定ダイアログに戻る。
                                        if (dataRangeSelf_.debug) console.log("DataRange: 閾値超え警告でキャンセルが押されました。");
                                    }--%>
                                    confirmMessageEror('<%= Resources.Messages.WarningTimeToDisplay %>', function () {
                                        // OK => 一覧表示
                                        dataRangeSelf_.reloadLedgerList();
                                    }, function () {
                                        // NG => 表示データの範囲設定ダイアログに戻る。
                                        if (dataRangeSelf_.debug) console.log("DataRange: 閾値超え警告でキャンセルが押されました。");
                                    }, '<%= Resources.Messages.OkButtonCaption %>', '<%= Resources.Messages.CancelButtonCaption %>');
                                } else {
                                    // 閾値内 => 一覧表示
                                    dataRangeSelf_.reloadLedgerList();
                                }
                            });
                        }
                    });
                }
                /**
                * レコード番号の値として適正な場合は、true を返す。
                * @method isValidRecordNumber
                * @param {string} val
                * @return true|false
                */
                this.isValidRecordNumber = function (val) {
                    if (!dataRangeSelf_._isEmpty(val)) {
                        if (!val.match(/^[0-9]+$/)) {
                            return false;
                        }
                        if (parseInt(val) < 1) {
                            return false;
                        }
                    }
                    return true;
                }
                /**
                * 日付の値として適正な場合は、YYYY/MM/DD 形式に整形して返す。
                * Dateオブジェクトだけでは、不正な形式はチェックできない。
                * @method isValidRecordNumber
                * @param {string} val
                * @return false 形式不正
                */
                this.isValidDate = function (val) {
                    if (dataRangeSelf_._isEmpty(val)) {
                        return "";
                    }
                    var dtu = val.split('-');
                    if (dtu.length != 3) {
                        return false;
                    }
                    if (dtu[0].length != 4) {
                        return false;
                    }
                    var dt = new Date(dtu[0], (dtu[1] - 1), dtu[2]);
                    if (isNaN(dt)) {
                        return false;
                    } else {
                        if (dt.getFullYear() == dtu[0] && dt.getMonth() == (dtu[1] - 1) && dt.getDate() == dtu[2]) {
                            return dataRangeSelf_.dateFormat(dt);
                        } else {
                            return false;
                        }
                    }
                }
                $("#consoleButton").click(function () {
                    if (dataRangeSelf_.isCallBySelect) {
                        dataRangeSelf_.cancelBusinessSelect();
                    }
                });
                /**
                * 業務選択をキャンセルする。
                * @method cancelBusinessSelect
                * @return void
                */
                this.cancelBusinessSelect = function () {
                    if (dataRangeSelf_._isEmpty(dataRangeSelf_.currentBusiness)) {
                        // 現在の業務IDが保存されていない場合は、何もしない。
                        return;
                    }
                    $('#businessListDiv').find('select').val(dataRangeSelf_.currentBusiness).xuxDropdown('refresh');
                }
                /**
                * エレメントが存在しない条件をdisableにする。
                * @method disableNoElementCond
                * @return void
                */
                this.disableNoElementCond = function () {
                    // 当該項目の存在しない場合は、disableのままにする。
                    if (dataRangeSelf_.type14_element_count == 0) {
                        //$("#selectDataRangeTypeFP").prop("disabled", true);
                        $("#textDataRangeFree").prop("disabled", true);
                        $("#textDataRangeFreeDiv").xuxTextFieldBox({ "disabled": true });
                        //$("#radioTypeFP").prop("disabled", true);
                        $("#selectDataRangeTypeFPDiv").xuxDropdownBox({ "disabled": true });
                        $("#radioTypeFP").xuxRadio({ "disabled": true });
                    }
                    if (dataRangeSelf_.type3_elment_count == 0) {
                        //$("#selectDataRangeTypeS").prop("disabled", true);
                        //$("#selectDataRangeTypeSValue").prop("disabled", true);
                        //$("#radioTypeS").prop("disabled", true);
                        $("#selectDataRangeTypeSDiv").xuxDropdownBox({ "disabled": true });
                        $("#selectDataRangeTypeSValueDiv").xuxDropdownBox({ "disabled": true });
                        $("#radioTypeS").xuxRadio({ "disabled": true });
                    }
                    if (dataRangeSelf_.type_2_element_count == 0) {
                        //$("#selectDataRangeTypeN").prop("disabled", true);
                        //$("#selectDataRangeTypeNValue").prop("disabled", true);
                        //$("#radioTypeN").prop("disabled", true);
                        $("#selectDataRangeTypeNDiv").xuxDropdownBox({ "disabled": true });
                        $("#selectDataRangeTypeNValueDiv").xuxDropdownBox({ "disabled": true });
                        $("#radioTypeN").xuxRadio({ "disabled": true });
                    }
                }
                /**
                * 業務の表示レコード範囲設定画面にクッキー値またはデフォルト値を反映する。
                * @method reflectRangeCookieOrDefault
                * @param {integer} businessId
                * @param {object} drCookie (option)
                * @return void
                 */
                this.reflectRangeCookieOrDefault = function (businessId, drCookie) {
                    var dataRangeCookie = null;
                    if (typeof drCookie == "undefined") {
                        dataRangeCookie = dataRangeSelf_.getDataRangeCookie(businessId);
                    } else {
                        dataRangeCookie = drCookie;
                    }

                    var cookie = null;
                    if (dataRangeCookie != null) {
                        var userId = "<%=Session[ "USER_ID" ]%>";
                        for (var i = 0; i < dataRangeCookie.length; i++) {
                            if (dataRangeCookie[i].user == userId) {
                                cookie = dataRangeCookie[i].setting;
                                break;
                            }
                        }
                    }

                    if (cookie == null) {
                        // クッキーなし => デフォルト値 (Web.Config値)
                        if (dataRangeSelf_.ledgerDataRangeRecordUse) {
                            $("#chkDataRangeRecord").prop('checked', true).xuxCheckbox("refresh");
                            $("#tblRecordCondition input, #tblRecordCondition select").prop("disabled", false);
                            $("#rangeSelectDiv").xuxDropdownBox({ "disabled": false });
                            $("#textDataRangeRecordDiv").xuxTextFieldBox({ "disabled": false });
                        } else {
                            $("#chkDataRangeRecord").prop('checked', false).xuxCheckbox("refresh");
                            $("#tblRecordCondition input, #tblRecordCondition select").prop("disabled", true);
                            $("#rangeSelectDiv").xuxDropdownBox({ "disabled": true });
                            $("#textDataRangeRecordDiv").xuxTextFieldBox({ "disabled": true });
                        }
                        if (dataRangeSelf_.ledgerDataRangeItemUse) {
                            $("#chkDataRangeItem").prop('checked', true).xuxCheckbox("refresh");
                            $("#tblItemCondition input, #tblItemCondition select").prop("disabled", false);
                            $("#selectDataRangeActionLogDiv").xuxDropdownBox({ "disabled": false });
                            $("#selectDataRangeTypeFPDiv").xuxDropdownBox({ "disabled": false });
                            $("#selectDataRangeTypeSDiv").xuxDropdownBox({ "disabled": false });
                            $("#selectDataRangeTypeSValueDiv").xuxDropdownBox({ "disabled": false });
                            $("#selectDataRangeTypeNDiv").xuxDropdownBox({ "disabled": false });
                            $("#selectDataRangeTypeNValueDiv").xuxDropdownBox({ "disabled": false });
                            $("#radioTypeN").xuxRadio({ "disabled": true });
                            $("#selectDefectNoticeValueDiv").xuxDropdownBox({ "disabled": false });
                            $("#radioActionLog").xuxRadio({ "disabled": true });
                            $("#radioTypeFP").xuxRadio({ "disabled": true });
                            $("#radioTypeS").xuxRadio({ "disabled": true });
                            $("#radioDefectNotice").xuxRadio({ "disabled": true });
                            // 当該項目の存在しない場合は、disableのままにする。
                            dataRangeSelf_.disableNoElementCond();
                        } else {
                            $("#chkDataRangeItem").prop('checked', false).xuxCheckbox("refresh");
                            $("#tblItemCondition input, #tblItemCondition select").prop("disabled", true);
                            $("#selectDataRangeActionLogDiv").xuxDropdownBox({ "disabled": true });
                            $("#selectDataRangeTypeFPDiv").xuxDropdownBox({ "disabled": true });
                            $("#selectDataRangeTypeSDiv").xuxDropdownBox({ "disabled": true });
                            $("#selectDataRangeTypeSValueDiv").xuxDropdownBox({ "disabled": true });
                            $("#selectDataRangeTypeNDiv").xuxDropdownBox({ "disabled": true });
                            $("#selectDataRangeTypeNValueDiv").xuxDropdownBox({ "disabled": true });
                            $("#radioTypeN").xuxRadio({ "disabled": true });
                            $("#selectDefectNoticeValueDiv").xuxDropdownBox({ "disabled": true });
                            $("#radioActionLog").xuxRadio({ "disabled": true });
                            $("#radioTypeFP").xuxRadio({ "disabled": true });
                            $("#radioTypeS").xuxRadio({ "disabled": true });
                            $("#radioDefectNotice").xuxRadio({ "disabled": true });
                        }
                    } else {
                        // クッキー値を反映
                        if (cookie.drrt == dataRangeSelf_.RECORD_TYPE_COUNT) {
                            $("#selectDataRangeRecord").val(dataRangeSelf_.RECORD_TYPE_COUNT).xuxDropdown("refresh");
                        } else if (cookie.drrt == dataRangeSelf_.RECORD_TYPE_NUMBER) {
                            $("#selectDataRangeRecord").val(dataRangeSelf_.RECORD_TYPE_NUMBER).xuxDropdown("refresh");
                        }
                        if (!dataRangeSelf_._isEmpty(cookie.drr)) {
                            var n = cookie.drr.split(":", 2);
                            if (n.length == 2) {
                                $("#textDataRangeRecordS").val(n[0]);
                                $("#textDataRangeRecordE").val(n[1]);
                            }
                        }
                        if (cookie.drit == "d") {
                            $("#radioActionLog").prop('checked', true).xuxRadio("refresh");
                            if (!dataRangeSelf_._isEmpty(cookie.adt)) {
                                $("#selectDataRangeActionLog").val(cookie.adt).xuxDropdown("refresh");
                            }
                            if (!dataRangeSelf_._isEmpty(cookie.ad)) {
                                var d = cookie.ad.split(":", 2);
                                if (!dataRangeSelf_._isEmpty(d[0])) {
                                    $("#textDataRangeStartDate").val(getDateMethod(d[0]));
                                }
                                if (!dataRangeSelf_._isEmpty(d[1])) {
                                    $("#textDataRangeEndDate").val(getDateMethod(d[1]));
                                }
                            }
                        } else if (cookie.drit == dataRangeSelf_.ITEM_TYPE_FP) {
                            $("#radioTypeFP").prop('checked', true).xuxRadio("refresh");
                            if (!dataRangeSelf_._isEmpty(cookie.eid) && !dataRangeSelf_._isEmpty(cookie.et)) {
                                $("#selectDataRangeTypeFP").val(cookie.eid + ":" + cookie.et).xuxDropdown("refresh");
                            }
                            if (!dataRangeSelf_._isEmpty(cookie.ev)) {
                                $("#textDataRangeFree").val(cookie.ev);
                            }
                        } else if (cookie.drit == dataRangeSelf_.ITEM_TYPE_N) {
                            $("#radioTypeN").prop('checked', true).xuxRadio("refresh");
                            if (!dataRangeSelf_._isEmpty(cookie.eid) && !dataRangeSelf_._isEmpty(cookie.et)) {
                                $("#selectDataRangeTypeN").val(cookie.eid + ":" + cookie.et).xuxDropdown("refresh");
                            }
                            $("#selectDataRangeTypeNValue").val(cookie.ev).xuxDropdown("refresh"); // 値リストは固定

                        } else if (cookie.drit == dataRangeSelf_.ITEM_TYPE_S) {
                            $("#radioTypeS").prop('checked', true).xuxRadio("refresh");
                            if (!dataRangeSelf_._isEmpty(cookie.eid) && !dataRangeSelf_._isEmpty(cookie.et)) {
                                $("#selectDataRangeTypeS").val(cookie.eid + ":" + cookie.et).xuxDropdown("refresh");
                            }
                            //
                            // 値のリストを取得する。
                            //
                            var element_id = $("#selectDataRangeTypeS").val().split(':', 1)[0];
                            // 選択されたエレメントの選択肢を取得する。
                            dataRangeSelf_.callAPIAsync(dataRangeSelf_.ACTION_ELEMENT_VALUE, businessId, -1, function (data_range) {
                                $sel = $("#selectDataRangeTypeSValue");
                                $sel.empty();
                                // 「選択無し」
                                var option = '<option value="" selected="selected"><%=Resources.Messages.DataRangeNoSelected%></option>';
                                $sel.append(option);
                                for (var i = 0; i < data_range.Values.length; i++) {
                                    var option = '<option value="' + data_range.Values[i] + '"';
                                    option += '>' + data_range.Values[i] + '</option>';
                                    $sel.append(option);
                                }
                                $("#selectDataRangeTypeSValue").val(cookie.ev).xuxDropdown("refresh");
                            }, cookie.eid, 3);
                        } else if (cookie.drit == dataRangeSelf_.DEFECT_NOTICE) {
                            $("#radioDefectNotice").prop('checked', true).xuxRadio("refresh");
                            $("#selectDefectNoticeValue").val(cookie.dnv).xuxDropdown("refresh");
                        }

                        if (cookie.drru == "1") {
                            $("#chkDataRangeRecord").prop('checked', true).xuxCheckbox("refresh");
                            $("#tblRecordCondition input, #tblRecordCondition select").prop("disabled", false);
                            $("#rangeSelectDiv").xuxDropdownBox({ "disabled": false });
                            $("#textDataRangeRecordDiv").xuxTextFieldBox({ "disabled": false });
                        } else {
                            $("#chkDataRangeRecord").prop('checked', false).xuxCheckbox("refresh");
                            $("#tblRecordCondition input, #tblRecordCondition select").prop("disabled", true);
                            $("#rangeSelectDiv").xuxDropdownBox({ "disabled": true });
                            $("#textDataRangeRecordDiv").xuxTextFieldBox({ "disabled": true });
                        }
                        if (cookie.driu == "1") {
                            $("#chkDataRangeItem").prop('checked', true).xuxCheckbox("refresh");
                            $("#tblItemCondition input, #tblItemCondition select").prop("disabled", false);
                            $("#selectDataRangeActionLogDiv").xuxDropdownBox({ "disabled": false });
                            $("#selectDataRangeTypeFPDiv").xuxDropdownBox({ "disabled": false });
                            $("#selectDataRangeTypeSDiv").xuxDropdownBox({ "disabled": false });
                            $("#selectDataRangeTypeSValueDiv").xuxDropdownBox({ "disabled": false });
                            $("#selectDataRangeTypeNDiv").xuxDropdownBox({ "disabled": false });
                            $("#selectDataRangeTypeNValueDiv").xuxDropdownBox({ "disabled": false });
                            $("#radioTypeN").xuxRadio({ "disabled": false });
                            $("#selectDefectNoticeValueDiv").xuxDropdownBox({ "disabled": false });
                            $("#radioActionLog").xuxRadio({ "disabled": false });
                            $("#radioTypeFP").xuxRadio({ "disabled": false });
                            $("#radioTypeS").xuxRadio({ "disabled": false });
                            $("#radioDefectNotice").xuxRadio({ "disabled": false });

                            // 当該項目の存在しない場合は、disableのままにする。
                            dataRangeSelf_.disableNoElementCond();

                        } else {
                            $("#chkDataRangeItem").prop('checked', false).xuxCheckbox("refresh");
                            $("#tblItemCondition input, #tblItemCondition select").prop("disabled", true);
                            $("#selectDataRangeActionLogDiv").xuxDropdownBox({ "disabled": true });
                            $("#selectDataRangeTypeFPDiv").xuxDropdownBox({ "disabled": true });
                            $("#selectDataRangeTypeSDiv").xuxDropdownBox({ "disabled": true });
                            $("#selectDataRangeTypeSValueDiv").xuxDropdownBox({ "disabled": true });
                            $("#selectDataRangeTypeNDiv").xuxDropdownBox({ "disabled": true });
                            $("#selectDataRangeTypeNValueDiv").xuxDropdownBox({ "disabled": true });
                            $("#radioTypeN").xuxRadio({ "disabled": true });
                            $("#selectDefectNoticeValueDiv").xuxDropdownBox({ "disabled": true });
                            $("#radioActionLog").xuxRadio({ "disabled": true });
                            $("#radioTypeFP").xuxRadio({ "disabled": true });
                            $("#radioTypeS").xuxRadio({ "disabled": true });
                            $("#radioDefectNotice").xuxRadio({ "disabled": true });
                        }
                    }
                }
                /**
                 * 時間書式変換
                 * @param dateTime
                 */
                function getDateMethod(dateTime) {
                    var da = new Date(dateTime).getTime();
                    da = new Date(da);
                    var year = da.getFullYear();
                    var month = da.getMonth() + 1;
                    var date = da.getDate();
                    var startTime = year + '-' + getZero(month) + '-' + getZero(date);
                    return startTime;
                }

                function getZero(num) {
                    if (parseInt(num) < 10) {
                        num = '0' + num;
                    }
                    return num;
                }
                /**
                * 業務の表示レコード範囲設定画面を表示する。
                * @method showDataRangeDialog
                * @param {integer} businessId
                * @param {boolean} callBySelect
                * @return void
                 */
                this.showDataRangeDialog = function (businessId, callBySelect) {
                    dataRangeSelf_.isCallBySelect = callBySelect;
                    if (dataRangeSelf_.debug) console.log("showDataRangeDialog:", "businessId", businessId);
                    dataRangeSelf_.startDeferred();
                    dataRangeSelf_.callAPIAsync(dataRangeSelf_.ACTION_INIT_DATA, businessId, -1, function (data_range) {
                        dataRangeSelf_.verifyRangeCookie(businessId, data_range);   // クッキーをverify

                        dataRangeSelf_.makeDataRangeDialog(businessId, data_range, callBySelect);
                        dataRangeSelf_.setupDataRangeDialog(businessId);    // 現在値を反映

                        //$("#dataRangeDialog").dialog('open');
                    });
                }
                /**
                 * api/DataRangeController を呼び、結果を返す（非同期）
                 * @method callAPIAsync
                 * @param {integer} action      (必須) see ACTION_INIT_DATA etc.
                 * @param {integer} businessId  (必須)
                 * @param {func} callback  (必須)
                 * @param {integer} element_id
                 * @param {integer} element_type
                 * @param {func} error_callback
                 * @return void
                 */
                this.callAPIAsync = function (action, business_id, record_threshold, callback, element_id, element_type, error_callback) {
                    if (dataRangeSelf_.debug) console.log("callAPIAsync:", "action", action, "business_id", business_id, "element_id", element_id, "element_type", element_type);
                    if (dataRangeSelf_._isEmpty(record_threshold)) { record_threshold = -1; }
                    if (dataRangeSelf_._isEmpty(element_id)) { element_id = -1; }
                    if (dataRangeSelf_._isEmpty(element_type)) { element_type = -1; }

                    var dataRange = null;
                    putPerformanceLog("レコード表示の範囲設定情報の取得処理(action=" + action + ") 開始");
                    var deferred = $.ajax({
                        type: 'GET',
                        url: 'api/DataRange',
                        cache: false,
                        data: { action: action, business_id: business_id, element_id: element_id, element_type: element_type, record_threshold: record_threshold },
                        dataType: "json",
                        async: true,
                        success: function (data, dataType) {
                            putPerformanceLog("レコード表示の範囲設定情報の取得処理(action=" + action + ") 終了");
                            dataRange = data;
                            if (dataRangeSelf_.debug) console.log("callAPIAsync:", "dataRange.Success", dataRange.Success);
                            if (dataRange.Success != 1) {
                                if (dataRange.Reason == "session_timeout") {
                                    redirectLoginPage();
                                } else {
                                    alertMessageInfo('<%= Resources.Messages.DataRangeError %>', function () {
                                        removeLoading();
                                        //$("#dataRangeCountButton").prop("disabled", false);
                                        $("#dataRangeCountButton").xuxButton({ "disabled": false });
                                    });

                                }
                            } else {
                                callback(dataRange);
                            }
                        },
                        error: function (XMLHttpRequest, textStatus, errorThrown) {
                            if (XMLHttpRequest.status == 200) {
                                redirectLoginPage();
                                return;
                            }
                            alertMessageEror('<%= Resources.Messages.AjaxErrorMessage %>', function () {
                                if (!dataRangeSelf_._isEmpty(error_callback)) {
                                    error_callback();
                                }
                            });

                        },
                        complete: function (XMLHttpRequest, textStatus) {
                        }
                    });
                    // 完了待ち合わせ用に保存する。
                    if (dataRangeSelf_.ajaxDeferreding) {
                        dataRangeSelf_.ajaxDeferreds.push(deferred);
                    }
                }
                /**
                 * 業務の表示レコード範囲設定ボタン押下
                 * @method clickDataRange
                 * @return {boolean}
                 */
                this.clickDataRange = function () {
                    if (dataRangeSelf_.debug) console.log("DataRange:表示レコード範囲設定が押下されました。id=" + dataRangeSelf_.business_id);
                    dataRangeSelf_.showDataRangeDialog(dataRangeSelf_.business_id, false);
                    return false;
                }
                /**
                 * 日付をyyyy/MM/dd 形式に整形する。
                 * @method dateFormat
                 * @param {Date} d
                 * @return {string} yyyy/MM/dd 形式の文字列。
                 */
                this.dateFormat = function (d) {
                    if (dataRangeSelf_._isEmpty(d)) {
                        return "";
                    }
                    var yyyy = d.getFullYear();
                    var MM = d.getMonth() + 1;
                    if (MM < 10) {
                        MM = '0' + MM;
                    }
                    var dd = d.getDate();
                    if (dd < 10) {
                        dd = '0' + dd;
                    }
                    return yyyy + "/" + MM + "/" + dd;
                }
                /**
                * 表示レコード範囲設定条件をチェックする。
                * @method checkDataRangeCondition
                * @return {boolean} OK=>true
                */
                this.checkDataRangeCondition = function () {
                    //
                    // 入力データチェック
                    //
                    if ($("#chkDataRangeRecord").is(':checked')) {
                        var val1 = $("#textDataRangeRecordS").val();
                        var val2 = $("#textDataRangeRecordE").val();
                        if (!dataRangeSelf_.isValidRecordNumber(val1)) {
                            alertMessageInfo('<%= Resources.Messages.DataRangeInvalidNumber %>');
                            $("#textDataRangeRecordS").focus();
                            return false;
                        }
                        if (!dataRangeSelf_.isValidRecordNumber(val2)) {
                            alertMessageInfo('<%= Resources.Messages.DataRangeInvalidNumber %>');
                            $("#textDataRangeRecordE").focus();
                            return false;
                        }
                    }
                    return true;
                }
                /**
                 * 業務の表示レコード範囲設定条件によるレコード件数を取得する。
                 * @method getRecordCountInDataRange
                 * @return {integer} レコード件数
                 */
                this.getRecordCountInDataRange = function () {
                    if (dataRangeSelf_.debug) console.log("getRecordCountInDataRange:");

                    if (dataRangeSelf_.checkDataRangeCondition() == false) return;

                    //$("#dataRangeCountButton").prop("disabled", true);  // ボタン非活性
                    $("#dataRangeCountButton").xuxButton({ "disabled": true });
                    // dr_<業務ID>のクッキーが存在する場合は、一時領域に保存する。
                    var currentCookie = dataRangeSelf_.getDataRangeCookie(dataRangeSelf_.business_id);

                    // 現在の設定値をクッキー dr_<業務ID> に保存する。
                    dataRangeSelf_.setDataRangeCookie(dataRangeSelf_.business_id);

                    // 読み込み中画像を表示し、ajaxでレコード件数を取得する
                    $("#dataRangeCount").text("<%=Resources.Messages.DataRangeCounting%>");   // 「件数取得中...」
                    dataRangeSelf_.callAPIAsync(dataRangeSelf_.ACTION_RECORD_COUNT, dataRangeSelf_.business_id, -1, function (data) {
                        // レコード件数を表示する。
                        $("#dataRangeCount").text("" + data.Count + " <%=Resources.Messages.DataTableLengthMenuCaption%>");
                        // 退避したクッキーがあれば、復元する。
                        if (currentCookie != null) {
                            dataRangeSelf_.saveDataRangeCookie(dataRangeSelf_.business_id, currentCookie);
                        } else {
                            // 退避したクッキーが存在しない場合は（元々Cookieがない)、保存したCookieを削除する。
                            var key = "LedgerList.DR_" + dataRangeSelf_.business_id;
                            $.removeCookie(key);
                        }
                        //$("#dataRangeCountButton").prop("disabled", false);
                        $("#dataRangeCountButton").xuxButton({ "disabled": false });
                    }, -1, -1, function () {
                        //$("#dataRangeCountButton").prop("disabled", false);
                        $("#dataRangeCountButton").xuxButton({ "disabled": false });
                    });
                }
                /**
                    * 業務選択コールバック
                    * @method selectBusiness
                    * @return void
                    */
                this.selectBusiness = function () {
                    dataRangeSelf_.business_id = $('#businessList').val().split(':', 1)[0];
                    if (dataRangeSelf_.debug) console.log("selectBusiness: 業務が選択されました。id=" + dataRangeSelf_.business_id);

                    if (dataRangeSelf_.business_id == "-1") {   // 未選択状態に戻る
                        dataRangeSelf_.reloadLedgerList();
                        return false;
                    }

                    // 業務IDのクッキーを取得
                    var dataRangeCookie = dataRangeSelf_.getDataRangeCookie(dataRangeSelf_.business_id);

                    var cookie = null;
                    if (dataRangeCookie != null) {
                        var userId = "<%=Session[ "USER_ID" ]%>";
                        for (var i = 0; i < dataRangeCookie.length; i++) {
                            if (dataRangeCookie[i].user == userId) {
                                cookie = dataRangeCookie[i].setting;
                                break;
                            }
                        }
                    }

                    if (cookie == null) {
                        // 表示データの範囲設定ダイアログを表示
                        dataRangeSelf_.showDataRangeDialog(dataRangeSelf_.business_id, true);
                    } else {
                        //
                        // 閾値チェック
                        //
                        dataRangeSelf_.callAPIAsync(dataRangeSelf_.ACTION_RECORD_COUNT, dataRangeSelf_.business_id, -1, function (dr_count) {
                            if (dataRangeSelf_.ledgerDataAlertThresholdRecord < dr_count.Count) {
                                // 閾値超え => 確認メッセージ
                                <%--if (window.confirm("<%= Resources.Messages.WarningRecordOver %>".replace("_RECORD_COUNT_", dataRangeSelf_.ledgerDataAlertThresholdRecord))) {
                                    // OK => 一覧表示
                                    dataRangeSelf_.reloadLedgerList();
                                } else {
                                    // NG => 表示データの範囲設定ダイアログを表示
                                    dataRangeSelf_.showDataRangeDialog(dataRangeSelf_.business_id, true);
                                }--%>
                                confirmMessageEror("<%= Resources.Messages.WarningRecordOver %>".replace("_RECORD_COUNT_", dataRangeSelf_.ledgerDataAlertThresholdRecord), function () {
                                    // OK => 一覧表示
                                    dataRangeSelf_.reloadLedgerList();
                                }, function () {
                                    // NG => 表示データの範囲設定ダイアログを表示
                                    dataRangeSelf_.showDataRangeDialog(dataRangeSelf_.business_id, true);
                                }, '<%= Resources.Messages.OkButtonCaption %>', '<%= Resources.Messages.CancelButtonCaption %>');
                            } else {
                                dataRangeSelf_.callAPIAsync(dataRangeSelf_.ACTION_ELEMENT_COUNT, dataRangeSelf_.business_id, -1, function (dr_element_count) {
                                    if (dataRangeSelf_.ledgerDataAlertThresholdElement < (dr_count.Count * dr_element_count.Count)) {
                                        // 閾値超え => 確認メッセージ
                                        <%--if (window.confirm('<%= Resources.Messages.WarningTimeToDisplay %>')) {

                                            // OK => 一覧表示
                                            dataRangeSelf_.reloadLedgerList();
                                        } else {
                                            // NG => 表示データの範囲設定ダイアログを表示
                                            dataRangeSelf_.showDataRangeDialog(dataRangeSelf_.business_id, true);
                                        }--%>
                                        confirmMessageEror('<%= Resources.Messages.WarningTimeToDisplay %>', function () {
                                            // OK => 一覧表示
                                            dataRangeSelf_.reloadLedgerList();
                                        }, function () {
                                            // NG => 表示データの範囲設定ダイアログを表示
                                            dataRangeSelf_.showDataRangeDialog(dataRangeSelf_.business_id, true);
                                        }, '<%= Resources.Messages.OkButtonCaption %>', '<%= Resources.Messages.CancelButtonCaption %>');
                                    } else {
                                        // 閾値内 => 一覧表示
                                        dataRangeSelf_.reloadLedgerList();
                                    }
                                });
                            }
                        });
                    }
                }
                /**
                   * 業務一覧にポストバックする
                   * @method reloadLedgerList
                   * @return void
                   */
                this.reloadLedgerList = function () {
                    <%--if (checkChanged(false)) {
                        if (!window.confirm('<%= Resources.Messages.ConfirmWindowCloseMessageBusinessChange %>')) {
                            $('#businessList').val(dataRangeSelf_.currentBusiness);
                            var tempUIID = $("#businessListDiv").find("a").first().attr("aria-controls");
                            var tempSelectBusinessListText = ""; 
                            $('#businessList').find("option").each(function () {
                                if ($(this).attr("selected") == "selected") {
                                    tempSelectBusinessListText = $(this).html();
                                    $($("#businessListDiv div div a span span span")[0]).html($(this).html());
                                }
                            });

                            $("#" + tempUIID + " li").each(function (i, item) {
                                $(item).removeClass("xux-sel-selected");

                            });
                            $("#" + tempUIID + " li").each(function (i, item) {
                                if ($(item).find("span").html() == tempSelectBusinessListText) {
                                    $(item).addClass("xux-sel-selected");
                                }
                            });
                            return;
                        }
                    }
                    closeType = 1;
                    setTimeout(__doPostBack('businessList', ''), 0);--%>
                    if (checkChanged(false)) {
                        confirmMessageEror('<%= Resources.Messages.ConfirmWindowCloseMessageBusinessChange %>', function () {
                            closeType = 1;
                            setTimeout(__doPostBack('businessList', ''), 0)
                        }, function () {
                            $('#businessListDiv').find('select').val(dataRangeSelf_.currentBusiness).xuxDropdown('refresh');
                        }, '<%= Resources.Messages.OkButtonCaption %>', '<%= Resources.Messages.CancelButtonCaption %>');
                    } else {
                        closeType = 1;
                        setTimeout(__doPostBack('businessList', ''), 0);
                    }

                }

                var winHandle_ = null;
                var previewWinHandle_ = null;
	            <%-- 画面遷移が発生した場合の処理 --%>
                $(window).bind('beforeunload', function (e) {

                    if (winHandle_ != null) {
                        if (!winHandle_.closed && closeType != 0) {
                            checkChanged(true);

                            winHandle_.isParentClosed_ = true;
                            winHandle_.close();
                            winHandle_ = null;
                        }
                    }
                    if (previewWinHandle_ != null) {
                        if (!previewWinHandle_.closed) {
                            previewWinHandle_.close();
                            previewWinHandle_ = null;
                        }
                    }
                });

                <%-- 確認訂正画面で変更されているかチェックする --%>
                function checkChanged(isUpdate) {
                    if (winHandle_ == null && getCookie(COOKIENAME_CONFIRMATION_OPEN) != null) {
                        winHandle_ = window.open("", "Confirmation");
                    }

                    if (winHandle_ == null) return false;

                    if (winHandle_.closed) return false;

                    if (!winHandle_.elementRowsList_) return false;

                    var elementRowsListLength = winHandle_.elementRowsList_.length;
                    if (!elementRowsListLength) return false;

                    var isChanged = false;
                    for (var i = 0; i < elementRowsListLength; i++) {
                        if (winHandle_.elementRowsList_[i].isChanged) {
                            isChanged = true;
                            if (isUpdate) winHandle_.elementRowsList_[i].isChanged = false;
                        }
                    }
                    return isChanged;
                }

                /**
                 * 業務の表示レコード範囲設定画面の設定値をクッキーに設定する
                 * @method setDataRangeCookie
                 * @param {integer} businessId
                 * @return void
                 */
                this.setDataRangeCookie = function (businessId) {
                    if (dataRangeSelf_.debug) console.log("setDataRangeCookie:", "businessId", businessId);
                    var cookie = { drru: "0", drrt: "", drr: "", driu: "0", drit: "", adt: "", ad: "", eid: "", et: "", ev: "", dnv: "" };
                    //
                    // 画面の設定内容を取得する。
                    //
                    if ($("#chkDataRangeRecord").is(':checked')) {
                        cookie.drru = "1";
                        cookie.drrt = $("#selectDataRangeRecord").val();
                        cookie.drr = $("#textDataRangeRecordS").val() + ":" + $("#textDataRangeRecordE").val();
                    }
                    if ($("#chkDataRangeItem").is(':checked')) {
                        cookie.driu = "1";
                        if ($("#radioActionLog").is(':checked')) {
                            cookie.drit = "d";
                            cookie.adt = $("#selectDataRangeActionLog").val();
                            cookie.ad = $("#textDataRangeStartDate").val().replace(/-/g, '/') + ":" + $("#textDataRangeEndDate").val().replace(/-/g, '/');
                        } else if ($("#radioTypeFP").is(':checked')) {
                            cookie.drit = dataRangeSelf_.ITEM_TYPE_FP;
                            var v = $("#selectDataRangeTypeFP").val().split(":", 2);
                            cookie.eid = v[0];
                            cookie.et = v[1];
                            cookie.ev = $("#textDataRangeFree").val();
                        } else if ($("#radioTypeN").is(':checked')) {
                            cookie.drit = dataRangeSelf_.ITEM_TYPE_N;
                            cookie.eid = $("#selectDataRangeTypeN").val().split(":", 1)[0];
                            cookie.et = "2";
                            cookie.ev = $("#selectDataRangeTypeNValue").val();
                        } else if ($("#radioTypeS").is(':checked')) {
                            cookie.drit = dataRangeSelf_.ITEM_TYPE_S;
                            cookie.eid = $("#selectDataRangeTypeS").val().split(":", 1)[0];
                            cookie.et = "3";
                            cookie.ev = $("#selectDataRangeTypeSValue").val();
                        } else if ($("#radioDefectNotice").is(':checked')) {
                            cookie.drit = dataRangeSelf_.DEFECT_NOTICE;
                            cookie.dnv = $("#selectDefectNoticeValue").val();
                        }
                    }

                    var userId = "<%=Session[ "USER_ID" ]%>";
                    var dataRangeCookie = dataRangeSelf_.getDataRangeCookie(businessId);
                    if (dataRangeCookie == null) {
                        dataRangeCookie = [{ user: userId, setting: cookie }];
                    } else {
                        var isExistedUser = false;
                        for (var i = 0; i < dataRangeCookie.length; i++) {
                            if (dataRangeCookie[i].user == userId) {
                                isExistedUser = true;
                                dataRangeCookie[i].setting = cookie;
                            }
                        }
                        if (!isExistedUser) {
                            dataRangeCookie.push({ user: userId, setting: cookie });
                        }
                    }

                    // 保存する。
                    dataRangeSelf_.saveDataRangeCookie(businessId, dataRangeCookie);
                }
                /**
                * 業務の表示レコード範囲設定画面の設定値をクッキーに保存する
                * @method saveDataRangeCookie
                * @param {integer} businessId
                * @param {object} cookie
                * @return void
                */
                this.saveDataRangeCookie = function (businessId, cookie) {
                    var key = "LedgerList.DR_" + businessId;
                    var cs = JSON.stringify(cookie);
                    if (dataRangeSelf_.debug) console.log("saveDataRangeCookie:", "cs", cs);
                    var en = encodeURIComponent(cs);
                    if (dataRangeSelf_.debug) console.log("saveDataRangeCookie:", "businessId", businessId, "saved size", en.length);
                    $.cookie(key, en, { expires: dataRangeSelf_.cookieExpires });
                }
                /**
                * 値有り無し判定
                * @method _isEmpty
                * @param {any} d
                * @return {boolean}
                */
                this._isEmpty = function (d) { return (typeof d == "undefined" || d === null || (typeof d == "string" && d.length == 0)); }
                /**
                * 表示レコード範囲設定の表示状態をセットする。
                * @method setDataRange
                * @return void
                */
                this.setDataRange = function () {
                    if (dataRangeSelf_.debug) console.log("setDataRange:");
                    dataRangeSelf_.business_id = $('#businessList').val().split(':', 1)[0];
                    $('#dataRangeStatus').css('margin-top', '-20px');
                    if (!dataRangeSelf_._isEmpty(dataRangeSelf_.business_id) && dataRangeSelf_.business_id === "-1") {
                        // 業務未選択
                        //$("#dataRangeButton").prop('disabled', true);
                        $("#dataRangeButton").xuxButton({ "disabled": true });
                        $("#CSVOutputButton").xuxButton({ "disabled": true });
                        //$("#confirmCorrectListDiv").xuxDropdownBox({ "disabled": true });
                        $("#confirmCorrectList2").xuxButton({ "disabled": true });
                        //$("#confirmCorrectList3").xuxButton({ "disabled": true });
                        $("#dataRangeStatus").html("&nbsp;");
                    } else {
                        // 業務選択済み
                        //$("#dataRangeButton").prop('disabled', false);
                        $("#dataRangeButton").xuxButton({ "disabled": false });
                        dataRangeSelf_.callAPIAsync(dataRangeSelf_.ACTION_INIT_DATA, dataRangeSelf_.business_id, -1, function (dr_range_data) {
                            dataRangeSelf_.callAPIAsync(dataRangeSelf_.ACTION_RECORD_COUNT, dataRangeSelf_.business_id, dataRangeSelf_.ledgerDataAlertThresholdRecord, function (dr_count) {
                                var all_count = dr_range_data.Count;
                                disp_count = dr_count.Count;
                                if (dataRangeSelf_.debug) console.log("setDataRange:all_count", all_count, "disp_count", disp_count);
                                if (!dataRangeSelf_._isEmpty(all_count) && !dataRangeSelf_._isEmpty(disp_count)) {
                                    if (all_count == disp_count) {
                                        $("#dataRangeStatus").text(dataRangeSelf_.msgDataRangeDispAll);
                                    } else {
                                        var t = dataRangeSelf_.msgDataRangeDispPart.replace("_DISP_COUNT_", "" + disp_count).replace("_ALL_COUNT_", "" + all_count);
                                        $("#dataRangeStatus").text(t);
                                    }
                                } else {
                                    $("#dataRangeStatus").html("&nbsp;");
                                }
                            });
                        });
                    }
                }
                /**
                * 業務一覧の業務IDにないdr_<業務ID>クッキーがあれば削除する。
                * @method removeRangeCookieIf
                * @method {array} business_ids
                * @return void
                */
                this.removeRangeCookieIf = function (business_ids) {
                    if (dataRangeSelf_.debug) console.log("removeRangeCookieIf:");
                    // 全クッキーチェック
                    var cookies = $.cookie();
                    for (var key in cookies) {
                        if (cookies.hasOwnProperty(key)) {
                            var bid = null;
                            if (bid = key.match(/^dr_(\d+)$/)) {
                                if (business_ids.indexOf("" + bid[1]) == -1) {
                                    $.removeCookie(key);        // cookie 削除
                                    if (dataRangeSelf_.debug) console.log("removeRangeCookieIf:クッキーを削除しました。key=" + key, "bid", bid[1]);
                                }
                            }
                        }
                    }
                }
                /**
                * dr_<業務ID>クッキーを取得しオブジェクトにして返す。
                * @method getDataRangeCookie
                * @param {integer} businessId
                * @return {object} cookie value or null
                */
                this.getDataRangeCookie = function (business_id) {
                    if (dataRangeSelf_.debug) console.log("getDataRangeCookie:", "business_id", business_id);
                    var cookie_name = "LedgerList.DR_" + business_id;
                    if (cookie = $.cookie(cookie_name)) {
                        var de = decodeURIComponent(cookie);
                        return $.parseJSON(de);
                    } else {
                        return null;
                    }
                }
                /**
                * 現在の業務のエレメント等の情報でクッキーを検証する。
                * ※エレメントが削除されている場合は、クッキーの値を消す。
                * @method verifyRangeCookie
                * @param {integer} business_id
                * @param {object} rangeData
                * @return void
                */
                this.verifyRangeCookie = function (business_id, rangeData) {
                    var changed = false;
                    if (dataRangeSelf_.debug) console.log("verifyRangeCookie:", "business_id", business_id);
                    var dataRangeCookie = dataRangeSelf_.getDataRangeCookie(business_id);
                    if (dataRangeCookie == null) {
                        return;
                    } else {
                        var userId = "<%=Session[ "USER_ID" ]%>";
                        for (var i = 0; i < dataRangeCookie.length; i++) {
                            if (dataRangeCookie[i].user == userId) {
                                if (dataRangeCookie[i].setting["driu"] == "1") {
                                    if (dataRangeCookie[i].setting["drit"] == "d") {
                                        // 表示項目IDチェック
                                        if (!dataRangeSelf_._isEmpty(dataRangeCookie[i].setting["adt"])) {
                                            var b = false;
                                            for (var j = 0; j < rangeData.ActionLogDisplayItems.length; j++) {
                                                if (rangeData.ActionLogDisplayItems[j].DisplayItemId == dataRangeCookie[i].setting["adt"]) {
                                                    b = true;
                                                    break;
                                                }
                                            }
                                            if (!b) {
                                                dataRangeCookie[i].setting["adt"] = "";         // 該当する表示項目IDはない。
                                                dataRangeCookie[i].setting["ad"] = "";          // 日付
                                                dataRangeCookie[i].setting["driu"] = "";        // 項目による設定
                                                dataRangeCookie[i].setting["drit"] = "";        // 項目タイプ
                                                changed = true;
                                            }
                                        }
                                    } else {
                                        // エレメントIDチェック
                                        if (dataRangeCookie[i].setting["eid"]) {
                                            var b = false;
                                            for (var j = 0; j < rangeData.Elements.length; j++) {
                                                if (rangeData.Elements[j].ElementId == dataRangeCookie[i].setting["eid"]) {
                                                    b = true;
                                                    break;
                                                }
                                            }
                                            if (!b) {
                                                dataRangeCookie[i].setting["eid"] = "";         // 該当するエレメントIDはない。
                                                dataRangeCookie[i].setting["et"] = "";          // エレメントタイプ
                                                dataRangeCookie[i].setting["ev"] = "";          // エレメント値
                                                dataRangeCookie[i].setting["driu"] = "";        // 項目による設定
                                                dataRangeCookie[i].setting["drit"] = "";        // 項目タイプ
                                                changed = true;
                                            }
                                        }
                                    }
                                }
                                if (changed) {
                                    dataRangeSelf_.saveDataRangeCookie(business_id, dataRangeCookie);
                                }
                            }
                        }
                    }
                }
            }
            //--------------------------------------------------------表示レコードの範囲設定 end  ------------------------------------------------------------//
            //--------------------------------------------------------エラー情報ダイアログ begin  ----------------------------------------------------------//
            $('#consoleErrButton').click(function () {
                $("#errInfo").xuxModalWindow("close");
            });
            //--------------------------------------------------------エラー情報ダイアログ end  ------------------------------------------------------------//
            //--------------------------------------------------------CSV出力 begin  ------------------------------------------------------------//
            <%-- CSV出力 --%>
            $('#CSVOutputButton').click(function () {
                var $CSVOutputButton = $('#CSVOutputButton');
                $CSVOutputButton.xuxButton({ "disabled": true });

        		<%-- ダウンロード中メッセージを表示 --%>
                dispCsvLoading("<%= Resources.Messages.DownloadingMessage %>");

                var bizId = $('#businessList').val().split(':');
                var recordIds = getCheckedRowsIds();
                if (recordIds.length === 0) {
       		        <%-- 対象未選択のとき --%>
                    //$notSelectDlg.dialog('open');
                    $CSVOutputButton.xuxButton({ "disabled": false });
                    removeLoading();
                    return;
                }

                var filename;
				<%-- POST対応 --%>
                $.ajax({
                    type: 'POST',
                    url: 'api/Csv',
                    contentType: 'application/json',
                    data: JSON.stringify({ businessId: bizId[0], businessRecordIds: recordIds }),
                    success: function (data, dataType) {
                        if (!data || data.length > 100) {
                            redirectLoginPage();
                            return;
                        }
                        filename = data;
                        if (filename) {
                            window.location = 'api/download?fileName=' + filename;
                            downloadStatus(filename);
                        }
                    },
                    error: function (XMLHttpRequest, textStatus, errorThrown) {
                        if (XMLHttpRequest.status == 200) {
                            redirectLoginPage();
                            return;
                        }
                        alertMessageEror("CSVダウンロードに失敗しました。");
                    },
                    complete: function (XMLHttpRequest, textStatus) {
                        $CSVOutputButton.xuxButton({ "disabled": false });
            			<%-- ダウンロード中メッセージを解除 --%>
                        removeLoading();
                    }
                });
            });

            <%-- CSVダウンロードのステータス確認 --%>
            function downloadStatus(filename) {
                if (!filename) {
                    return;
                }
                $.ajax({
                    type: 'GET',
                    url: 'api/download/GetDownloadStatus',
                    success: function (data, dataType) {
                        if (data === '1') {
                            deleteFile(filename);
                        } else if (data === '0') {
                            var interval = '<%= ConfigurationManager.AppSettings["CsvDownloadStatusCheckInterval"] %>';
                            if (interval === '' || isNaN(Number(interval))) {
                                interval = 3000;
                            }
                            window.setTimeout(function () { downloadStatus(filename); }, interval);
                        } else {
                            redirectLoginPage();
                            return;
                        }
                    }
                });
            }

            <%-- CSVダウンロードファイルの削除 --%>
            function deleteFile(filename) {
                if (!filename) {
                    return;
                }
                $.ajax({
                    type: 'POST',
                    url: 'api/download',
                    contentType: 'application/json',
                    data: JSON.stringify({ fileName: filename }),
                    success: function (data, dataType) {
                    }
                });
            }
            //--------------------------------------------------------CSV出力 end  ------------------------------------------------------------//
            //--------------------------------------------------------不明な帳票一覧 begin  ------------------------------------------------------------//
            $("#refreshFunction").xuxButton();

            $("#refreshFunction").click(function () {
                clearTimeout(throttleTime)
                throttleTime = setTimeout(function () {
                    //$("#refreshFunction").xuxButton({ "disabled": true });
                    isClickFilter = true;
                    <%--ローカルに保持したデータを更新して再表示--%>
                    loadTabData(true);
                    <%-- 現在の使用量で更新 --%>
                    getAmountSize();
                    buttonsInitDisable();
                }, 300)


            });
            <%-- 不明な帳票 --%>
            $('#unknownFormButton').click(function () {
                $("#unknownList").xuxModalWindow("open");
                unknownWindowMode_ = 0;
                unknownMergeRecordIdList_ = [];
                UnknownDataTableOptions = null;
                startUnknownNoNumberFilter_ = endUnknownNoNumberFilter_ = '';
                $('#unknownDeleteButton').css('display', 'inline-block');
                $('#unknownOKButton').css('display', 'none');
                $('#unknownCloseButton').val('<%= Resources.Messages.CloseButtonCaption %>');
                //$unknownListDlg_.dialog('open');
                loadUnknownData(true);<%-- ダイアログ表示後に一覧表示 --%>
            });
            <%-- 不明な帳票一覧ダイアログの閉じる --%>
            $('#unknownCloseButton').click(function () {
                var $filterToDate = $('#unknownFilterToDate');
                if ($filterToDate) {
                    $filterToDate.datepicker('hide');
                }
                var $filterFromDate = $('#unknownFilterFromDate');
                if ($filterFromDate) {
                    $filterFromDate.datepicker('hide');
                }
                //$("#unknownColumnPopup").xuxModalWindow("close");
                if (unknownSortFilterColumn_) {
                    unknownSortFilterColumn_.search('', true);
                }
                config.unknownFilterToDate = null;
                config.unknownFilterFromDate = null;
                unknownWindowMode_ = 0;
                //$unknownListDlg_.xuxModalWindow({'close');
                $("#unknownList").xuxModalWindow("close");
                if (unknownImageWindow_ && !unknownImageWindow_.closed) {
                    unknownImageWindow_.close();
                }
            });

            <%--  画面表示設定をCookieから読み込み(または初期値使用) --%>
            var config = $('#config').val();
            config = config !== '' ? JSON.parse(config) : {};

            if (!config.pageLength) {
                config.pageLength = validateAndSet($.cookie(COOKIENAME_LINES_PER_PAGE), Number('<%= ConfigurationManager.AppSettings["ConfirmPageLength"] %>'), itemsPerPageChoices);
            }
            if (!config.unknownPageLength) {
                config.unknownPageLength = '<%= ConfigurationManager.AppSettings["ConfirmPageLength"] %>';
            }
            if (config.unknownFilterToDate) {
                config.unknownFilterToDate = new Date(config.unknownFilterToDate);
            }
            if (config.unknownFilterFromDate) {
                config.unknownFilterFromDate = new Date(config.unknownFilterFromDate);
            }
            var setUnknownPageLength = Number(config.unknownPageLength);
            if ($.cookie(COOKIENAME_UNKNOWN_LINES_PER_PAGE)) {
                setUnknownPageLength = Number($.cookie(COOKIENAME_UNKNOWN_LINES_PER_PAGE));
            }
            <%-- 不明な帳票一覧表示件数切替 --%>
            //$('#unknownTable_length').change(function () {

            //    var options = { expires: 365 };
            //    $.cookie(COOKIENAME_UNKNOWN_LINES_PER_PAGE, $('#unknownTable_length').find('option:selected').val(), options);
            //    $unknownTable_.columns.adjust().draw();
            //});

            createUnknownFilterDialog = function (columnIndexTemp, obj) {
                unknownSortFilterColumn_ = {};
                sortFilterColumnUnknownIndex_ = -1;
                $filterDialogUnknownHeader_ = null;
                if (!unknownRowsList_) {
                    return;
                }
                var $items = $('#unknownColumnPopupItems');
                $items.text('');

                var parentTag = obj;//$(this).parent().parent();
                unknownSortFilterColumn_.search = function () { return ""; }// $unknownTable_.column(parentTag);
                var columnIndex = columnIndexTemp < 0 ? parseInt(parentTag.attr("columnIndex")) : columnIndexTemp;//unknownSortFilterColumn_.index();
                sortFilterColumnUnknownIndex_ = columnIndex;
                var columnDef = UnknownDataTableOptions.columns[columnIndex];
                $filterDialogUnknownHeader_ = obj;

                var hasFunc = false;

                <%-- ソート機能が無効の場合はスキップ --%>
                if (columnDef.sortable === false) {
                    $("#unknownColumnPopup").xuxModalWindow('close');
                    //closeDiv($("#unknownColumnPopup"));
                    return;
                }

                <%-- ソート機能 --%>
                if (columnDef.sortable !== false) {
                    createRecordSort($items, $unknownTable_, columnIndex, '<%= Resources.Messages.SortDescCaption %>', '<%= Resources.Messages.SortAscCaption %>', null, "unknownFilter");
                    hasFunc = true;
                }

                <%-- フィルター機能 --%>
                var values = [];
                if (columnDef.searchable !== false) {
                    values = $.map(unknownRowsList_, function (n, i) {
                        return n[columnDef.field];
                    });
                    values.sort();
                    values = $.map(values, function (n, i) { return '$' + doReplaceLineBreakToWhiteSpace(n); });
                    values = $.unique(values);
                    values = $.map(values, function (n, i) { return n.substring(1); });

                    <%-- すべて選択 --%>
                    var $allRows;
                    if (columnIndex === 1 || columnIndex === 5) {
                        $allRows = $('<input id="' + FILTER_ALLROWS_ID_UNKNOWN + '" type="radio" name="' + FILTER_RADIO_GROUP_NAME_UNKNOWN + '" />')
                            .change(function () {
                                var $$unknownFilterDateRangeCond = $('#unknownFilterDateRangeCond');
                                if ($$unknownFilterDateRangeCond) {
                                    $$unknownFilterDateRangeCond.prop('checked', false).trigger('change');
                                }
                                var $unknownFilterPeriodCond = $('#unknownFilterPeriodCond');
                                if ($unknownFilterPeriodCond) {
                                    $unknownFilterPeriodCond.prop('checked', false).trigger('change');
                                }
                            });
                    } else {
                        $allRows = $('<input id="' + FILTER_ALLROWS_ID_UNKNOWN + '" type="checkbox" />')
                            .change(function () {
                                if ($(this).is(':checked')) {
                                    $(FILTER_COND_CLASSNAME_UNKNOWN_SELECTOR).prop('checked', true).xuxCheckbox("refresh");
                                } else {
                                    $(FILTER_COND_CLASSNAME_UNKNOWN_SELECTOR).prop('checked', false).xuxCheckbox("refresh");
                                }
                            });
                    }
                    var $allRowsDiv = $('<div class="columnPopupItem"></div>')
                        .append($allRows)
                        .append('<span style="padding: 0 0 0 8px;vertical-align: middle;position: relative;top: 1px;" class="ui-button-text"><%= Resources.Messages.AllRowsCaption %></span>');
                    $items
                        //.append($('<hr class="FilterDialogHr" />'))
                        //.append($('<br>'))
                        .append($allRowsDiv);

                    if (columnIndex === 1) {
                        <%-- No --%>
                        var $filterDateRangeRadioButton = $('<input type="radio" id="unknownFilterDateRangeCond" value="<%= Resources.Messages.UnknownIdRangeRadioButtonCaption %>" name="' + FILTER_RADIO_GROUP_NAME_UNKNOWN + '" />')
                            .change(function () {
                                if ($(this).is(':checked')) {
                                    $(FILTER_ALLROWS_ID_UNKNOWN_SELECTOR).prop('checked', false);
                                    $('#unknownStartNoCond, #unknownEndNoCond').prop('disabled', false);
                                    $("#unknownStartNoCondDiv").xuxTextFieldBox({ "disabled": false });
                                } else {
                                    $(FILTER_ALLROWS_ID_UNKNOWN_SELECTOR).prop('checked', true);
                                    $('#unknownStartNoCond, #unknownEndNoCond').prop('disabled', true);
                                    $("#unknownStartNoCondDiv").xuxTextFieldBox({ "disabled": true });
                                }
                            });
                        var $filterDateRangeRadioButtonDiv = $('<div class="columnPopupItem"></div>')
                            .append($filterDateRangeRadioButton)
                            .append('<span style="padding: 0 0 0 8px;vertical-align: middle;position: relative;top: 1px;" class="ui-button-text"><%= Resources.Messages.UnknownIdRangeRadioButtonCaption %></span>');
                        $items.append($filterDateRangeRadioButtonDiv);

                        var $startUnknownNoFilter = $('<input id="unknownStartNoCond" type="text" style="width: 65px;" value="' + doSanitaizeEncode(startUnknownNoNumberFilter_) + '" />');
                        var $endUnknownNoFilter = $('<input id="unknownEndNoCond" type="text" style="width: 65px;" value="' + doSanitaizeEncode(endUnknownNoNumberFilter_) + '" />');
                        var $NoFilterDiv = $('<div id="unknownStartNoCondDiv" class="columnPopupItem"></div>')
                            .append($startUnknownNoFilter)
                            .append(" - ")
                            .append($endUnknownNoFilter);
                        $items.append($NoFilterDiv);
                        hasFunc = true;
                    } else if (columnIndex === 5) {
                        <%-- 日時 --%>
                        var $blankRadioBox = $('<input type="radio" class="' + FILTER_COND_CLASSNAME_UNKNOWN + '" value="" name="' + FILTER_RADIO_GROUP_NAME_UNKNOWN + '" />')
                            .change(function () {
                                var $unknownFilterPeriodCond = $('#unknownFilterPeriodCond');
                                if ($unknownFilterPeriodCond) {
                                    $unknownFilterPeriodCond.prop('checked', false).trigger('change');
                                }
                            });
                        var $blankRadioBoxDiv = $('<div class="columnPopupItem"></div>')
                            .append($blankRadioBox)
                            .append('<span style="padding: 0 0 0 8px;vertical-align: middle;position: relative;top: 1px;" class="ui-button-text"><%= Resources.Messages.BlankRowsRadioButtonCaption %></span>');
                        $items.append($blankRadioBoxDiv);

                        var $notBlankRadioButton = $('<input type="radio" class="' + FILTER_COND_CLASSNAME_UNKNOWN + '" value="(^.+)" name="' + FILTER_RADIO_GROUP_NAME_UNKNOWN + '" />')
                            .change(function () {
                                var $unknownFilterPeriodCond = $('#unknownFilterPeriodCond');
                                if ($unknownFilterPeriodCond) {
                                    $unknownFilterPeriodCond.prop('checked', false).trigger('change');
                                }
                            });
                        var $notBlankRadioButtonDiv = $('<div class="columnPopupItem"></div>')
                            .append($notBlankRadioButton)
                            .append('<span style="padding: 0 0 0 8px;vertical-align: middle;position: relative;top: 1px;" class="ui-button-text"><%= Resources.Messages.NotBlankRowsRadioButtonCaption %></span>');
                        $items.append($notBlankRadioButtonDiv);

                        var $periodRadioButton = $('<input type="radio" id="unknownFilterPeriodCond" value="<%= Resources.Messages.PeriodRowsRadioButtonCaption %>" name="' + FILTER_RADIO_GROUP_NAME_UNKNOWN + '" />')
                            .change(function () {
                                if ($(this).is(':checked')) {
                                    $('#unknownFilterToDate, #unknownFilterToDateIcon, #unknownFilterFromDate, #unknownFilterFromDateIcon').prop('disabled', false);
                                } else {
                                    $('#unknownFilterToDate, #unknownFilterToDateIcon, #unknownFilterFromDate, #unknownFilterFromDateIcon').prop('disabled', true);
                                }
                            });
                        var $periodRadioButtonDiv = $('<div class="columnPopupItem"></div>')
                            .append($periodRadioButton)
                            .append('<span style="padding: 0 0 0 8px;vertical-align: middle;position: relative;top: 1px;" class="ui-button-text"><%= Resources.Messages.PeriodRowsRadioButtonCaption %></span>');
                        $items.append($periodRadioButtonDiv); var endDateTempValue = ""
                        if (config.unknownFilterToDate) {

                            endDateTempValue = 'value="' + dateFormat(config.unknownFilterToDateTemp) + '"';
                        }
                        var $toDate = $('<input id="unknownFilterToDate" ' + endDateTempValue + ' type="date" />');
                        var startDateTempValue = ""
                        if (config.unknownFilterFromDate) {
                            startDateTempValue = 'value="' + dateFormat(config.unknownFilterFromDateTemp) + '"';
                        }
                        var $fromDate = $('<input id="unknownFilterFromDate" ' + startDateTempValue + ' type="date" />');
                       
                        var $termDiv = $('<div id="unknownFilterToDateDiv" class="columnPopupItem"></div>')
                            .append($toDate)
                            //.append($toDateIcon)
                            .append(' - ')
                            .append($fromDate)
                        //.append($fromDateIcon);
                        $items.append($termDiv);

                        hasFunc = true;
                    } else {
                        var $blankCheckBox = $('<input type="checkbox" class="' + FILTER_COND_CLASSNAME_UNKNOWN + '" value="" />')
                            .change(function () {
                                changeCheckBox($(this), FILTER_ALLROWS_ID_UNKNOWN_SELECTOR, FILTER_COND_CLASSNAME_UNKNOWN_SELECTOR);
                            });
                        var $blankCheckBoxDiv = $('<div class="columnPopupItem"></div>')
                            .append($blankCheckBox)
                            .append('<span style="padding: 0 0 0 8px;vertical-align: middle;position: relative;top: 1px;" class="ui-button-text"><%= Resources.Messages.BlankRowsCheckBoxCaption %></span>');
                        $items.append($blankCheckBoxDiv);

                        var items = createRecordItems(values, function (value) {
                            return value !== '' ? value : text;
                        }, FILTER_ALLROWS_ID_UNKNOWN_SELECTOR, FILTER_COND_CLASSNAME_UNKNOWN, FILTER_COND_CLASSNAME_UNKNOWN_SELECTOR, "filterCondCheckBox");
                        $items.append(items);
                        hasFunc = true;
                    }
                    $("input[type=radio]").xuxRadio();
                    $("input[type=checkbox]").xuxCheckbox();
                    <%-- 起動時のチェックON処理 --%>
                    var searchFilters = UnknownDataTableOptions.columns[columnIndex].searchTableFilters ? UnknownDataTableOptions.columns[columnIndex].searchTableFilters : ""//unknownSortFilterColumn_.search();
                    if (columnIndex === 1) {
                        var $unknownFilterDateRangeCond = $('#unknownFilterDateRangeCond');
                        if ((startUnknownNoNumberFilter_ !== '' || endUnknownNoNumberFilter_ !== '')) {
                            if ($unknownFilterDateRangeCond) {
                                $unknownFilterDateRangeCond.prop('checked', true).trigger('change');
                            }
                        } else {
                            $(FILTER_ALLROWS_ID_UNKNOWN_SELECTOR).prop('checked', true).trigger('change');
                        }
                    } else if (columnIndex === 5) {
                        if (searchFilters != '') {
                            if (config.unknownFilterToDate || config.unknownFilterFromDate) {
                                $('#unknownFilterPeriodCond').prop('checked', true).xuxRadio("refresh");
                            } else if (config.unknownFilterToDate == null && config.unknownFilterFromDate == null) {
                                defaultCheckSelect(searchFilters, FILTER_ALLROWS_ID_UNKNOWN_SELECTOR, FILTER_COND_CLASSNAME_UNKNOWN_SELECTOR);
                            } else {
                                $(FILTER_ALLROWS_ID_UNKNOWN_SELECTOR).prop('checked', true).trigger('change');
                            }
                        } else {
                            var count = setFilterCheck(searchFilters, FILTER_COND_CLASSNAME_UNKNOWN_SELECTOR);
                            if (count === 0) {
                                $(FILTER_ALLROWS_ID_UNKNOWN_SELECTOR).prop('checked', true).trigger('change');
                            }
                        }
                    } else {
                        defaultCheckSelect(searchFilters, FILTER_ALLROWS_ID_UNKNOWN_SELECTOR, FILTER_COND_CLASSNAME_UNKNOWN_SELECTOR);
                    }

                }
                if (!hasFunc) {
                    return;
                }

                <%-- フィルターダイアログのスクロール有無判定 --%>
                var filterDialogHeight = 'auto';
                if (columnIndex !== 1 && columnIndex !== 5) {
                    var filterDialogMaxHeight = parseInt('<%= ConfigurationManager.AppSettings["FilterDialogMaxHeight"] %>', 10);
                    var FilterColumnHeight = 23;
                    var SortButtonHeight = 75;
                    if ((values.length + 1) * FilterColumnHeight + SortButtonHeight > filterDialogMaxHeight) {
                        var TitleAndOkButtonGroupHeight = 91;
                        filterDialogHeight = filterDialogMaxHeight + TitleAndOkButtonGroupHeight;
                    }
                }

                //$items.append($('<hr class="FilterDialogHr" />'));
                //$items.append($('<br>'));
                var unknownColumnPopupButtonDiv = $("#unknownColumnPopupButtonDiv");
                $("#unknownColumnPopupButtonDiv").html("");
                var cancel = '<button type="button" class="cancle ModalWindowButton" columnIndex="' + columnIndex + '" id="filterUnknownDialogClose"><%= Resources.Messages.CancelButtonCaption %></button>';
                unknownColumnPopupButtonDiv.append($(cancel))
                unknownColumnPopupButtonDiv.append("&nbsp;")
                var okstring = '<button type="button" class="ModalWindowButton" columnIndex="' + columnIndex + '" id="filterUnknownDialogOK"><%= Resources.Messages.OkButtonCaption %></button>';
                unknownColumnPopupButtonDiv.append($(okstring))
                $("#filterUnknownDialogOK").xuxButton();
                $("#filterUnknownDialogOK").xuxButton("option", "type", "default");

                $("input[type=text]").xuxTextFieldBox();
                $("input[type=radio]").xuxRadio();
                $("input[type=button]").xuxButton();
                $("#filterUnknownDialogClose").xuxButton();

                $("#filterUnknownDialogClose").click(function () {
                    resetUnknownTableHeadercolor();
                    $("#unknownColumnPopup").xuxModalWindow("close");
                    //closeDiv($("#unknownColumnPopup"));
                });
                $("#filterUnknownDialogOK").click(function () {
                    saveUnknownSelectPageCount();
                    if ($("#sortunknownAscButton").is(':checked')) {
                        UnknownDataTableOptions.sortOptions.column = columnIndex;
                        UnknownDataTableOptions.sortOptions.order = $("#sortunknownAscButton").val()
                    }
                    if ($("#sortunknownDescButton").is(':checked')) {
                        UnknownDataTableOptions.sortOptions.column = columnIndex;
                        UnknownDataTableOptions.sortOptions.order = $("#sortunknownDescButton").val();
                    }
                    var $filterDateRangeRadioButton = $('#unknownFilterDateRangeCond');
                    if ($filterDateRangeRadioButton && $filterDateRangeRadioButton.is(':checked')) {
                        startUnknownNoNumberFilter_ = $('#unknownStartNoCond').val();
                        endUnknownNoNumberFilter_ = $('#unknownEndNoCond').val();
                        var min = parseFloat(startUnknownNoNumberFilter_, 10);
                        var max = parseFloat(endUnknownNoNumberFilter_, 10);
                        if (min > max) {
                            var temp = startUnknownNoNumberFilter_;
                            startUnknownNoNumberFilter_ = endUnknownNoNumberFilter_;
                            endUnknownNoNumberFilter_ = temp
                        }
                        if (startUnknownNoNumberFilter_ === '' && endUnknownNoNumberFilter_ === '') {
                            $(FILTER_ALLROWS_ID_UNKNOWN_SELECTOR).prop('checked', true);
                        }
                    }

                    if ($(FILTER_ALLROWS_ID_UNKNOWN_SELECTOR).is(':checked')) {
                        startUnknownNoNumberFilter_ = '';
                        endUnknownNoNumberFilter_ = '';
                    }

                    if ($(FILTER_ALLROWS_ID_UNKNOWN_SELECTOR).is(':checked')) {
                        //unknownSortFilterColumn_.search('', true);
                        UnknownDataTableOptions.columns[columnIndex].searchTableFilters = "";
                        UnknownDataTableOptions.columns[columnIndex].searchTableFiltersTeype = "";
                        searchRecordTable(UnknownDataTableOptions, unknownRowsList_, "unknownFilter");
                        if (sortFilterColumnUnknownIndex_ === 5) {
                            config.unknownFilterToDate = null;
                            config.unknownFilterFromDate = null;
                        }
                        $filterDialogUnknownHeader_.removeClass('SortedFilterDialog');
                    } else {
                        $filterDialogUnknownHeader_.addClass('SortedFilterDialog');

                        var filters = getFilter(FILTER_COND_CLASSNAME_UNKNOWN_SELECTOR);
                        UnknownDataTableOptions.columns[columnIndex].searchTableFiltersTeype = "";
                        if (filters && filters.length !== 0) {
                            config.unknownFilterToDate = null;
                            config.unknownFilterFromDate = null;
                            //unknownSortFilterColumn_.search(filters.join('|'), true, false, false);
                            UnknownDataTableOptions.columns[columnIndex].searchTableFilters = filters.join('|');
                            searchRecordTable(UnknownDataTableOptions, unknownRowsList_, "unknownFilter");
                        } else {
                            if (sortFilterColumnUnknownIndex_ === 1 && (startUnknownNoNumberFilter_ !== '' || endUnknownNoNumberFilter_ !== '')) {
                                UnknownDataTableOptions.columns[columnIndex].searchTableFilters = startUnknownNoNumberFilter_ + "-" + endUnknownNoNumberFilter_;
                                searchRecordTable(UnknownDataTableOptions, unknownRowsList_, "unknownFilter");
                            } else {
                                var $unknownFilterPeriodCond = $('#unknownFilterPeriodCond');
                                if ($unknownFilterPeriodCond && $unknownFilterPeriodCond.is(':checked')) {
                                    var toDate = new Date($('#unknownFilterToDate').val().replace(/-/g, '/'));
                                    var toDateSet = new Date($('#unknownFilterToDate').val().replace(/-/g, '/'));
                                    var fromDate = new Date($('#unknownFilterFromDate').val().replace(/-/g, '/'));
                                    var fromDateSet = new Date($('#unknownFilterFromDate').val().replace(/-/g, '/'));
                                    // フィルタ用の上限値日付と下限値日付が逆だったら入れ替える処理
                                    var swappedDates = swapDates(toDate, fromDate);
                                    toDate = swappedDates.toDateParam;
                                    fromDate = swappedDates.fromDateParam;
                                    // 画面表示用の上限値日付と下限値日付が逆だったら入れ替える処理
                                    var swappedDatesSet = swapDates(toDateSet, fromDateSet);
                                    toDateSet = swappedDatesSet.toDateParam;
                                    fromDateSet = swappedDatesSet.fromDateParam;

                                    config.unknownFilterToDate = toDate;
                                    config.unknownFilterToDateTemp = toDateSet;
                                    config.unknownFilterFromDate = fromDate;
                                    config.unknownFilterFromDateTemp = fromDateSet;
                                    if (fromDate) {
                                        fromDate.setDate(fromDate.getDate() + 1);
                                        fromDate.setSeconds(fromDate.getSeconds() - 1);
                                    }
                                    if (!config.unknownFilterToDate && !config.unknownFilterFromDate) {
                                        $filterDialogUnknownHeader_.removeClass('SortedFilterDialog');
                                    }
                                    UnknownDataTableOptions.columns[columnIndex].searchTableFilters = fromDate + "-" + toDate;
                                    UnknownDataTableOptions.columns[columnIndex].searchTableFiltersTeype = "Date";
                                    searchRecordTable(UnknownDataTableOptions, unknownRowsList_, "unknownFilter");
                                } else {
                                    UnknownDataTableOptions.columns[columnIndex].searchTableFilters = "NoSelect";
                                    UnknownDataTableOptions.columns[columnIndex].searchTableFiltersTeype = "";
                                    searchRecordTable(UnknownDataTableOptions, unknownRowsList_, "unknownFilter");
                                }
                            }
                        }
                    }
                    $("#unknownColumnPopup").xuxModalWindow("close");
                    //closeDiv($("#unknownColumnPopup"));
                });
                //end

            }

            resetUnknownTableHeadercolor = function () {
                $(".UnknownFilterDialog").each(function () {
                    var columnindexTemp = $(this).attr("columnindex");
                    if (UnknownDataTableOptions.columns[columnindexTemp].searchTableFilters == "") {
                        $(this).parent().parent().find(".xux-icon-funnel").first().css("color", '');
                        $(this).parent().parent().parent().first().css("background-color", '');
                    } else {
                        $(this).parent().parent().find(".xux-icon-funnel").first().css("color", '#1b8f98');
                        $(this).parent().parent().parent().first().css("background-color", '#B2B2B2');
                    }
                });
            }

            //--------------------------------------------------------不明な帳票一覧 end  ------------------------------------------------------------//


            $('#printButton').click(function () {

                var recordIds = getCheckedRowsIds();
                $('#selectedRecordIds').val(recordIds);
                isPrint = true;
                loadSelectFormData();
                $("#selectForm").xuxModalWindow("open");
            });
            $("#selectFormClose").click(function () {
                $("#selectForm").xuxModalWindow("close");
            });
            $("#selectReportClose").click(function () {
                $("#selectReport").xuxModalWindow("close");
            });
            $("#selectFormOK").click(function () {
                var formId = getCheckedFormId();
                var formName = getCheckedFormName();
                if (formId == null) {
                    alertMessageInfo('帳票を選択してください。');
                    return false;
                }

                <%-- 不明帳票のレコード紐付け --%>
                if (unknownWindowMode_ === 1) {
                    <%--if (!confirm('<%= Resources.Messages.MargeUnknownRecordConfirmMessage %>'))
                        return;
                    dispLoading("<%= Resources.Messages.ProcessingMessage %>");
                    var recordId = $("#ConfRecordId").val();
                    var bizId = $('#businessList').val().split(':');
                    $.ajax({
                        type: 'POST',
                        url: 'api/UnknownListMarge',
                        contentType: 'application/json',
                        data: JSON.stringify({ businessId: bizId[0], businessRecordId: recordId, formId: formId, formName: formName, unknownFormIds: unknownMergeRecordIdList_ }),
                        success: function (data, dataType) {
                            if (data.length !== 0) {
                                redirectLoginPage();
                                return;
                            }
                        },
                        error: function (XMLHttpRequest, textStatus, errorThrown) {
                            if (XMLHttpRequest.status == 200) {
                                redirectLoginPage();
                                return;
                            }
                            alertMessageEror('<%= Resources.Messages.MargeUnknownRecordFailedMessage %>');
                        },
                        complete: function (XMLHttpRequest, textStatus) {
                            removeLoading();
                            $("#selectForm").xuxModalWindow("close");
                            //$unknownListDlg_.dialog('close');
                            //$newConfDlg.dialog('close');
                            $("#unknownList").xuxModalWindow("close");
                            $("#newConf").xuxModalWindow("close");
                        }
                    });
                    return;--%>
                    confirmMessageEror('<%= Resources.Messages.MargeUnknownRecordConfirmMessage %>', function () {
                        dispLoading("<%= Resources.Messages.ProcessingMessage %>");
                        var recordId = $("#ConfRecordId").val();
                        var bizId = $('#businessList').val().split(':');
                        $.ajax({
                            type: 'POST',
                            url: 'api/UnknownListMarge',
                            contentType: 'application/json',
                            data: JSON.stringify({ businessId: bizId[0], businessRecordId: recordId, formId: formId, formName: formName, unknownFormIds: unknownMergeRecordIdList_ }),
                            success: function (data, dataType) {
                                if (data.length !== 0) {
                                    redirectLoginPage();
                                    return;
                                }
                                $("#selectForm").xuxModalWindow("close");
                                $("#unknownList").xuxModalWindow("close");
                                $("#newConf").xuxModalWindow("close");
                            },
                            error: function (XMLHttpRequest, textStatus, errorThrown) {
                                if (XMLHttpRequest.status == 200) {
                                    redirectLoginPage();
                                    return;
                                }
                                alertMessageEror('<%= Resources.Messages.MargeUnknownRecordFailedMessage %>', function () {
                                    $("#selectForm").xuxModalWindow("close");
                                    $("#unknownList").xuxModalWindow("close");
                                    $("#newConf").xuxModalWindow("close");
                                });
                            },
                            complete: function (XMLHttpRequest, textStatus) {
                                removeLoading();
                                //$("#selectForm").xuxModalWindow("close");
                                //$unknownListDlg_.dialog('close');
                                //$newConfDlg.dialog('close');
                                //$("#unknownList").xuxModalWindow("close");
                                //$("#newConf").xuxModalWindow("close");
                            }
                        });
                        return;
                    }, null, '<%= Resources.Messages.OkButtonCaption %>', '<%= Resources.Messages.CancelButtonCaption %>');
                    return;
                }
                $('#selectedFormId').val(formId);
                var recordIds = getCheckedRowsIds();
                $('#selectedRecordIds').val(recordIds);

                <%-- 印刷のときはここまで --%>
                if (isPrint) {
                    $("#mfpForm").xuxModalWindow("open");
                    $("#selectForm").xuxModalWindow("close");
                    return;
                }

                <%-- 以下、帳票/アンケートのときだけ行う処理(印刷のときはやらない) --%>
                if (isPrint == false) {
                    var bizId = $('#businessList').val().split(':');
                    var existsScan = true;      <%-- スキャン記録有無 --%>
                    var contaisNoScan = false;  <%-- スキャン記録なしを含むか --%>
                    var dataIdList = null;
                    var authTimeout = false;
					<%-- POST対応 --%>
                    $.ajax({
                        type: 'POST',
                        url: 'api/ScanRecordCheck',
                        contentType: 'application/json',
                        data: JSON.stringify({ businessId: bizId[0], ids: recordIds, formId: formId }),
                        success: function (data, dataType) {
                            if (data.indexOf("btnLogin") != -1) {
                                authTimeout = true;
                                redirectLoginPage();
                                return;
                            }
                            var isExists = true;
                            dataIdList = data.split(",");
                            if (recordIds.length === data.length) {
                                var recordIdList = recordIds.split(",");
                                var i, ength, dataLength = dataIdList.length;
                                for (var i = 0; i < dataLength; i++) {
                                    if ($.inArray(dataIdList[i], recordIdList) === -1) {
                                        isExists = false;
                                        break;
                                    }
                                }
                            } else {
                                isExists = false;
                            }
		                    <%-- スキャン結果のあるレコードIDを連結して返却してくる --%>
                            if (isExists) {
                                existsScan = true;      <%-- スキャン記録有 --%>
                                contaisNoScan = false;  <%-- スキャン記録なしを含まない --%>
                            } else if (data == "") {
                                existsScan = false;     <%-- スキャン記録なし --%>
                            } else {
                                existsScan = true;
                                contaisNoScan = true;  <%-- スキャン記録なしを含む --%>
                            }
                        },
                        error: function (XMLHttpRequest, textStatus, errorThrown) {
                            if (XMLHttpRequest.status == 200 || XMLHttpRequest.status == 401) {
                                authTimeout = true;
                                redirectLoginPage();
                                return;
                            }
                            alertMessageEror('<%= Resources.Messages.AjaxErrorMessage %>');
                            existsScan = false;
                            contaisNoScan = false;
                        },
                        complete: function (XMLHttpRequest, textStatus) {
                            if (authTimeout) {
                                return;
                            }
                            if (existsScan) {
                                if (contaisNoScan) {
								    <%-- スキャン記録がないものを含む --%>
                                    alertMessageInfo('<%= Resources.Messages.ContainsNoScanRecord %>', function () {
                                        showRecord(formId, formName, dataIdList);
                                    });
                                } else {
                                    showRecord(formId, formName, dataIdList);
                                }
                            } else {
		                        <%-- 全てスキャン記録がない --%>
                                alertMessageInfo('<%= Resources.Messages.NoDisplayRecord %>');
                                $("#selectForm").xuxModalWindow("close");
                            }
                        }
                    });
                }

                //$("#selectForm").xuxModalWindow("close");
            });
            $("#selectReportClose").click(function () {
                $("#selectReport").xuxModalWindow("close");
            });
            $("#selecReportOK").click(function () {
                if ($("#confirmCorrectRadio2").is(':checked')) {
                    $('#selectButtom').val(1);
                    isPrint = false;
                } else {
                    $('#selectButtom').val(2);
                    isPrint = false;
                }
                var formId = $("#selectReportPage").val();
                var formName = $("#selectReportPage").text();
                if (formId == null) {
                    alertMessageInfo('帳票を選択してください。');
                    return false;
                }

                <%-- 不明帳票のレコード紐付け --%>
                if (unknownWindowMode_ === 1) {
                    confirmMessageEror('<%= Resources.Messages.MargeUnknownRecordConfirmMessage %>', function () {
                        dispLoading("<%= Resources.Messages.ProcessingMessage %>");
                        var recordId = $("#ConfRecordId").val();
                        var bizId = $('#businessList').val().split(':');
                        $.ajax({
                            type: 'POST',
                            url: 'api/UnknownListMarge',
                            contentType: 'application/json',
                            data: JSON.stringify({ businessId: bizId[0], businessRecordId: recordId, formId: formId, formName: formName, unknownFormIds: unknownMergeRecordIdList_ }),
                            success: function (data, dataType) {
                                if (data.length !== 0) {
                                    redirectLoginPage();
                                    return;
                                }
                            },
                            error: function (XMLHttpRequest, textStatus, errorThrown) {
                                if (XMLHttpRequest.status == 200) {
                                    redirectLoginPage();
                                    return;
                                }
                                alertMessageEror('<%= Resources.Messages.MargeUnknownRecordFailedMessage %>');
                            },
                            complete: function (XMLHttpRequest, textStatus) {
                                removeLoading();
                                $("#selectForm").xuxModalWindow("close");
                                //$unknownListDlg_.dialog('close');
                                //$newConfDlg.dialog('close');
                                $("#unknownList").xuxModalWindow("close");
                                $("#newConf").xuxModalWindow("close");
                            }
                        });
                        return;
                    }, null, '<%= Resources.Messages.OkButtonCaption %>', '<%= Resources.Messages.CancelButtonCaption %>');
                }
                $('#selectedFormId').val(formId);
                var recordIds = getCheckedRowsIds();
                $('#selectedRecordIds').val(recordIds);

                <%-- 以下、帳票/アンケートのときだけ行う処理(印刷のときはやらない) --%>
                if (isPrint == false) {
                    var bizId = $('#businessList').val().split(':');
                    var existsScan = true;      <%-- スキャン記録有無 --%>
                    var contaisNoScan = false;  <%-- スキャン記録なしを含むか --%>
                    var dataIdList = null;
                    var authTimeout = false;
					<%-- POST対応 --%>
                    $.ajax({
                        type: 'POST',
                        url: 'api/ScanRecordCheck',
                        contentType: 'application/json',
                        data: JSON.stringify({ businessId: bizId[0], ids: recordIds, formId: formId }),
                        success: function (data, dataType) {
                            if (data.indexOf("btnLogin") != -1) {
                                authTimeout = true;
                                redirectLoginPage();
                                return;
                            }
                            var isExists = true;
                            dataIdList = data.split(",");
                            if (recordIds.length === data.length) {
                                var recordIdList = recordIds.split(",");
                                var i, ength, dataLength = dataIdList.length;
                                for (var i = 0; i < dataLength; i++) {
                                    if ($.inArray(dataIdList[i], recordIdList) === -1) {
                                        isExists = false;
                                        break;
                                    }
                                }
                            } else {
                                isExists = false;
                            }
		                    <%-- スキャン結果のあるレコードIDを連結して返却してくる --%>
                            if (isExists) {
                                existsScan = true;      <%-- スキャン記録有 --%>
                                contaisNoScan = false;  <%-- スキャン記録なしを含まない --%>
                            } else if (data == "") {
                                existsScan = false;     <%-- スキャン記録なし --%>
                            } else {
                                existsScan = true;
                                contaisNoScan = true;  <%-- スキャン記録なしを含む --%>
                            }
                        },
                        error: function (XMLHttpRequest, textStatus, errorThrown) {
                            if (XMLHttpRequest.status == 200 || XMLHttpRequest.status == 401) {
                                authTimeout = true;
                                redirectLoginPage();
                                return;
                            }
                            alertMessageEror('<%= Resources.Messages.AjaxErrorMessage %>');
                            existsScan = false;
                            contaisNoScan = false;
                        },
                        complete: function (XMLHttpRequest, textStatus) {
                            if (authTimeout) {
                                return;
                            }
                            if (existsScan) {
                                if (contaisNoScan) {
								    <%-- スキャン記録がないものを含む --%>
                                    alertMessageInfo('<%= Resources.Messages.ContainsNoScanRecord %>', function () {
                                        showRecord(formId, formName, dataIdList);
                                    });
                                } else {
                                    showRecord(formId, formName, dataIdList);
                                }
                            } else {
		                        <%-- 全てスキャン記録がない --%>
                                alertMessageInfo('<%= Resources.Messages.NoDisplayRecord %>');
                                $("#selectReport").xuxModalWindow("close");
                            }
                        }
                    });
                }

                //$("#selectForm").xuxModalWindow("close");
            });
            function showRecord(formId, formName, dataIdList) {
                if (checkChanged(false)) {
                                    <%--if (!window.confirm('<%= Resources.Messages.ConfirmWindowCloseMessageReOpen %>')) {
                                        return;
                                    }--%>
                    confirmMessageEror('<%= Resources.Messages.ConfirmDataChangedMessage %>', function () {
                        checkChanged(true);
                        transConfirmCorrect(formId, formName, -1, dataIdList.join(','), $('#selectButtom').val());
                        $("#selectReport").xuxModalWindow("close");
                    }, null, '<%= Resources.Messages.OkButtonCaption %>', '<%= Resources.Messages.CancelButtonCaption %>');
                } else {
                    checkChanged(true);
                    transConfirmCorrect(formId, formName, -1, dataIdList.join(','), $('#selectButtom').val());
                    $("#selectReport").xuxModalWindow("close");
                }
            }

            $('#mfpForm').xuxModalWindow({
                width: 400,
                height: 300,
                open: function () {
                    var div = $("#mfpFormButtonDiv");
                    //div.css("float", "none");
                    //div.children().eq(2).css("float", "right");
                    //div.children().eq(1).css("float", "right");

                    var dialog = $('#mfpForm');
                    $.ajax({
                        type: 'GET',
                        url: 'api/Print',
                        data: { formId: getCheckedFormId() },
                        dataType: "json",
                        cache: false,
                        success: function (data, dataType) {
                            if (data.Code == '<%= PrintUtil.ResultSuccess %>') {
                                var tempRow = [];
                                for (var i = 0; i < data.Printers.length; i++) {
                                    var printersName = data.Printers[i];
                                    tempRow.push({
                                        Name: printersName,
                                        dataIndex: i
                                    });
                                }
                                var DataTableMfpOptions = {
                                    selectionUnit: "none",
                                    pageNavigationPosition: "none",
                                    clear: true,
                                    data: {
                                        "fields": ["Name"],
                                        "items": tempRow
                                    },
                                    columns: [
                                        {
                                            field: "Name",
                                            render: function (td, item) {
                                                var id = "mfpNameRadio_" + item._data.dataIndex;
                                                var tempCheck = "";
                                                if (item._data.dataIndex == 0) {
                                                    tempCheck = "checked";
                                                } else {
                                                    tempCheck = "";
                                                }
                                                var html = '<input name="mfpName" type="radio" dataIndex="' + item._data.dataIndex + '" id="' + id + '" value="' + item._data.Name + '" ' + tempCheck + ' >';
                                                $(html).appendTo(td);

                                                $("#" + id).xuxRadio();
                                            }
                                        }, {
                                            field: "Name",
                                            render: function (td, item) {
                                                var html = '<span>' + item._data.Name + '</span>';
                                                $(html).appendTo(td);
                                            }
                                        }
                                    ],
                                    afterRender: function () {
                                        $("input[name=mfpName]").xuxRadio();
                                    }
                                }
                                $('#mfpTableDiv').xuxDecoratedTable(DataTableMfpOptions);
                                $('#colorMode').val(0);
                                $('#bothSide').val(data.ScanDivision);
                                $('#layout').val(0);
                                $('#tray').removeAttr("checked");

                                // レコードが選択されていない場合は部数枠をDisableに．
                                var recordIds = getCheckedRowsIds();
                                if (recordIds.length == 0) {
                                    $('#printNum').val(1).removeAttr("disabled");
                                } else {
                                    $('#printNum').val(1).attr("disabled", "disabled");
                                }
                            } else if (data.Code == '<%= PrintUtil.ResultSessionTimeOut %>') {
                                // ログイン画面へリダイレクト
                                redirectLoginPage();
                            } else {
                                // 複合機一覧取得失敗
                                alertMessageInfo(data.Message, function () { dialog.xuxModalWindow("close"); });

                            }
                        },
                        error: function (XMLHttpRequest, textStatus, errorThrown) {
                            if (XMLHttpRequest.status == 200) {
                                redirectLoginPage();
                                return;
                            }
                            alertMessageEror('<%= Resources.Messages.AjaxErrorMessage %>');
                        }
                    });
                }
            });

            $("#mfpFormClose").click(function () {
                $("#mfpForm").xuxModalWindow("close");
            });
            $("#mfpFormprintPreview").click(function () {
                var isOpened = false;
                if (previewWinHandle_ != null) {
                    if (!previewWinHandle_.closed) {
                        isOpened = true;
                    }
                }
                if (!isOpened) {
                    var x = screen.width * 0.98;
                    var y = screen.height * 0.9;
                    if (isBrowserChrome())
                        y = screen.height * 0.87;
                    previewWinHandle_ = window.open("", "preview", "screenX=0,screenY=0,left=0,top=0,width=" + x + ",height=" + y + "resizable=yes,scrollbars=yes");
                }
                previewWinHandle_.focus();
                var recordIds = getCheckedRowsIds();
                recordIds = recordIds == "" ? "0" : recordIds;
                // セッションに帳票IDとレコードリストを登録
                $.ajax({
                    type: 'POST',
                    url: 'api/Preview',
                    data: JSON.stringify({
                        formId: getCheckedFormId(),
                        businessRecordIds: recordIds
                    }),
                    contentType: 'application/json',
                    cache: false,
                    success: function (data, dataType) {
                        if (data === "1") {
                            previewWinHandle_.location.href = "Preview.aspx";
                            return;
                        }
                        alertMessageInfo('<%= Resources.Messages.AjaxErrorMessage %>');
                    },
                    error: function (XMLHttpRequest, textStatus, errorThrown) {
                        if (XMLHttpRequest.status == 200) {
                            window.location = "Login.aspx";
                            return;
                        }
                        alertMessageEror('<%= Resources.Messages.AjaxErrorMessage %>');
                    }
                });
            });
            $("#mfpFormConfirm1").click(function () {
                var formId = getCheckedFormId();
                var formName = getCheckedFormName();
                var strRecordIdList = getCheckedRowsIds();

                var dialog = $(this);
                var mfpName = $('#mfpTable input:radio:checked').val();
                var printNum = $('#printNum').val();
                var colorMode = $('#colorMode').val();
                var both = $('#bothSide').val();
                var layout = $('#layout').val();
                var tray = $('#tray').is(':checked') ? "1" : "0";
                $.ajax({
                    type: 'GET',
                    url: 'api/Print',
                    data: {
                        printer: mfpName,
                        num: printNum,
                        color: colorMode,
                        layout: layout,
                        side: both,
                        tray: tray
                    },
                    dataType: "json",
                    cache: false,
                    async: false,
                    success: function (data, dataType) {
                        if (data.Code == '<%= PrintUtil.ResultSuccess %>') {
                            var bizId = $('#businessList').val().split(':');
                            $.ajax({
                                type: 'POST',
                                url: 'api/Print',
                                cache: false,
                                contentType: 'application/json',
                                data: JSON.stringify({
                                    businessId: bizId[0],
                                    formId: formId,
                                    formName: formName,
                                    printer: mfpName,
                                    num: printNum,
                                    color: colorMode,
                                    layout: layout,
                                    side: both,
                                    tray: tray,
                                    businessRecordIds: strRecordIdList.split(',')
                                }),
                                async: true,
                                success: function (data, dataType) {
                                    if (data.Code == '<%= PrintUtil.ResultSuccess %>') {
                                        // 非同期処理となるため成功時は何もしない．
                                    } else if (data.Code == '<%= PrintUtil.ResultSessionTimeOut %>') {
                                        // ログイン画面へリダイレクト
                                        redirectLoginPage();
                                    } else if (data.Code == '<%= PrintUtil.ResultInputCheckError %>' || data.Code == '<%= PrintUtil.ResultOriginalPrintError %>') {
                                        // 入力チェックエラー
                                        alertMessageInfo(data.Message);
                                    } else {
                                        // その他エラー．
                                    }
                                },
                                error: function (XMLHttpRequest, textStatus, errorThrown) {
                                    if (XMLHttpRequest.status == 200) {
                                        redirectLoginPage();
                                        return;
                                    }
                                    alertMessageEror('<%= Resources.Messages.AjaxErrorMessage %>');
                                }
                            });
                            // ダイアログを閉じる．
                            $("#mfpForm").xuxModalWindow("close");
                        } else if (data.Code == '<%= PrintUtil.ResultSessionTimeOut %>') {
                            // ログイン画面へリダイレクト
                            redirectLoginPage();
                        } else {
                            alertMessageInfo(data.Message);
                        }
                    },
                    error: function (XMLHttpRequest, textStatus, errorThrown) {
                        if (XMLHttpRequest.status == 200) {
                            redirectLoginPage();
                            return;
                        }
                        alertMessageEror('<%= Resources.Messages.AjaxErrorMessage %>');
                    }
                });
            });
            setTimeout(function () {
                $(".xux-ci").css("top", "22px");
                $(".xux-ci").css("height", "25px");
                $(".xux-mainNavigationPanel").css("background-color", "");
            }, 10);
        });


    </script>
   
    <script src="js/common.js?date=<%=DateTime.Now.ToString("yyyyMMddHHmmss")%>"></script>
    <script src="js/filter.js?date=<%=DateTime.Now.ToString("yyyyMMddHHmmss")%>"></script>
    <script src="js/jquery.cookie.js"></script>
</head>
<body>
    <div style="height: 50px;top: 15px;left: 10px;position: absolute;z-index: 99;"><a href="#" title="Home"><img id="u0_img" class="systemName" src="image/log-in/u20.png"/></a></div>
    <header>
        <nav>
            <ul >
                
                <%--<li id="userAction"><a href="#" class="xux-loginout xux-contextMenu-trigger xux-has-tenant xux-login"
                    aria-haspopup="true" role="button" tabindex="0" aria-controls="ui-id-1"><span
                        id="userTenetNameHeader" class="xux-user-tenantText"></span><span class="xux-user-text"
                            id="userNameHeader"></span><span
                                class="xux-user-icon xux-userIcon xux-size-medium xux-icon xux-icon-user xux-unauthenticated"
                                aria-hidden="true"></span></a></li>--%>
                <%--<li><a id="menulink" href="#"><span class="xux-icon xux-icon-gear"></span>Menu</a></li>--%>
            </ul>
        </nav>
    </header>
    <nav>
            <ul id="menuMainHeader">
                <li id="showDeviceSelect"><a id="showHome" style="left: 10px;" href="#">レコード一覧</a></li>
                <%--<li id="userAction"><a href="#" class="xux-loginout xux-contextMenu-trigger xux-has-tenant xux-login"
                    aria-haspopup="true" role="button" tabindex="0" aria-controls="ui-id-1"><span
                        id="userTenetNameHeader" class="xux-user-tenantText"></span><span class="xux-user-text"
                            id="userNameHeader"></span><span
                                class="xux-user-icon xux-userIcon xux-size-medium xux-icon xux-icon-user xux-unauthenticated"
                                aria-hidden="true"></span></a></li>--%>
                <%--<li><a id="menulink" href="#"><span class="xux-icon xux-icon-gear"></span>Menu</a></li>--%>
            </ul>
        </nav>
    <ul id='utilmenu'>       
        <li><a href="#" class="products">製品情報</a></li>
    </ul>
    <ul id='userActionMenu'>
        <li><a href="#" class="logout"><%= Resources.Messages.LogoutCaption %></a></li>
    </ul>
    <form id="form1" runat="server" style="margin: 0 10px;min-width: 1000px;">
        <div>
            <asp:HiddenField ID="userId" runat="server" />
            <input type="hidden" name="selectButtom" id="selectButtom"/>
            <asp:HiddenField ID="userName" runat="server" />
            <asp:HiddenField ID="config" runat="server" />
            <asp:HiddenField ID="selectedRecordIds" runat="server" />
            <asp:HiddenField ID="selectedFormId" runat="server" />
            <%--<asp:HiddenField ID="hdnHeaderText" runat="server" />--%>
        </div>
        <div id="listHeader" style="display: none">
            <div style="padding: 5px 0px">
                <span>
                    <asp:DropDownList ID="userMenuList" runat="server" /></span>
                <span><a href="javascript:void(0);" class="logout"><%= Resources.Messages.LogoutCaption %></a></span>
                <span><a href="javascript:void(0);" class="products"><%= Resources.Messages.ProductsCaption %></a></span>
            </div>
        </div>
        <div style="margin-top:9px;margin-left: 4px;">
            <%-- <div style="width: 100px; float:left;margin-top: 7px;"> <span><%= Resources.Messages.ScreenLedgerListCaption %> -</span></div> --%>
            <div id="businessListDiv" style="width: 137px; float:left;right:4px"   >
                <asp:DropDownList ID="businessList" runat="server" AutoPostBack="true" OnSelectedIndexChanged="businessList_SelectedIndexChanged" />
                   <%-- 表示データの範囲設定 --%>
            </div>
            <input id="dataRangeButton" type="button" value="<%= Resources.Messages.DataRangeButtonCaption %>" style="margin-left: 12px;"/>
            <input id="printButton" type="button" value="<%= Resources.Messages.PrintButtonCaption %>" style="width: 100px;margin-left: 6px;"/>
            <input id="unknownFormButton" type="button" value="<%= Resources.Messages.UnknownButtonCaption %>" style="width: 140px;margin-left: 6px;"/>
            <input type="button" id="refreshFunction" value="<%= Resources.Messages.RefreshButtonCaption %>" style="width: 100px;margin-left: 6px;"/>
            <span id="amount" class="label2">
            <span><%= Resources.Messages.CurrentAmountCaption %></span>
            <asp:Label ID="useAmountLabelCurrent" runat="server" /><asp:Label
                ID="useAmountLabelCurrentLabel" runat="server" /><asp:Label
                    ID="useAmountLabelSeparator" runat="server" /><asp:Label
                        ID="useAmountLabelMax" runat="server" /><asp:Label
                            ID="useAmountLabelMaxLabel" runat="server" />
            </span>
        </div>

        <div id="headerFunction1">
            <input type="button" id="createNewRecordButton" value="<%= Resources.Messages.NewRecordButtonCaption %>" style="width: 170px;"/>
            <input id="CSVOutputButton" type="button" value="<%= Resources.Messages.CsvOutputButtonCaption %>" style="width: 100px;margin-left: 6px;"/>
            <input id="confirmCorrectList2" type="button" value="帳票ビュー" style="width: 140px;margin-left: 6px;"/>
            <%--<input id="confirmCorrectList3" type="button" value="アンケートビュー" style="width: 140px;margin-left: 6px;"/>--%>
            <input type="button" id="deleteButton" value="<%= Resources.Messages.DeleteButtonCaption %>" style="width: 100px;margin-left: 6px;"/>
			 <span id="refreshTips" style="margin-left:47px;display:none">確認訂正あり</span>
            <%--<input id="insertPrintButton" type="button" value="<%= Resources.Messages.InsertPrintButtonCaption %>" class="ui-button ui-widget ui-state-default ui-corner-all" />--%>
            <span id="confirmCorrectListDiv" style="display:none">
                <asp:DropDownList ID="confirmCorrectList" runat="server" />
            </span>
            <div id="dataRangeStatus">&nbsp;</div>
        </div>
        <div id="tabTempDiv" >
            <div id="tab">
                <table id="elementsTable"></table>
            </div>
        </div>

        <div>
            <asp:DropDownList ID="pageLength" runat="server" CssClass="pageLength"></asp:DropDownList>
            <asp:DropDownList ID="unknownPageLength" runat="server" CssClass="pageLength"></asp:DropDownList>
            <asp:Button ID="resetBackButton" Text="<%$ Resources:Messages, BackToJobListButtonCaption %>" OnClick="resetBackButton_Click" runat="server" />
        </div>
       
        <!-- 帳票選択ダイアログ -->
        <div id="selectForm">
            <h2><%= Resources.Messages.FormSelectDialogTitle %></h2>
            <form method="POST" name="form1" id="form2">
                <div style="height: 300px; overflow-y: auto;">
                    <section id="section1">
                        <div id="selectTempFormDiv">
                            <div id="selectFormDiv">
                            <table id="selectFormTable">
                                <thead>
                                    <th style="width: 15%"></th>
                                    <th style="width: 85%"><%= Resources.Messages.FormSelectDialogTableHeader %></th>
                                </thead>
                                <tbody></tbody>
                            </table>
                        </div>
                        </div>
                        
                    </section>
                </div>
            </form>
            <button type="button" class="cancle ModalWindowButton" id="selectFormClose"><%= Resources.Messages.CancelButtonCaption %></button>
            <button type="button" class="ModalWindowButton" id="selectFormOK"><%= Resources.Messages.OkButtonCaption %></button>
        </div>
        <div id="selectReport">
            <%--<h2><%= Resources.Messages.FormSelectDialogTitle %></h2>--%>
            <form method="POST" name="form1" id="form3">
                <div style="height: 150px;">
                    <section id="section2">
                        <div id="confirmCorrectRadioDiv">
                            <input type="radio" id="confirmCorrectRadio2" name="radio" checked /><label for="confirmCorrectRadio2">帳票ビュー</label>
                            <br />
                            <input type="radio" id="confirmCorrectRadio3" name="radio" /><label for="confirmCorrectRadio3">アンケートビュー</label>
                        </div>
                        <br />
                        <div id="selectTempReportDiv">
                            <label>帳票</label>
                            <select id="selectReportPage"></select>
                        </div>
                    </section>
                </div>
            </form>
            <button type="button" class="cancle ModalWindowButton" id="selectReportClose"><%= Resources.Messages.CancelButtonCaption %></button>
            <button type="button" class="ModalWindowButton" id="selecReportOK"><%= Resources.Messages.OkButtonCaption %></button>
        </div>

    </form>
     <div id="footer" class="copyRight">
            <%= Resources.Messages.CopyrightCaption %>
      </div>
    <!-- 複合機選択ダイアログ -->
    <div id="mfpForm" title="印刷設定">
        <h2>印刷設定</h2>
        <form method="POST" name="form1" id="formMfp">
            <section id="sectionMfp">
                <div style="height: 300px; overflow: auto">
                    複合機選択
                    <br />
                    <div id="mfpTableDiv">
                        <table id="mfpTable">
                            <thead>
                                <th style="width: 15%"></th>
                                <th style="width: 85%">複合機名</th>
                            </thead>
                            <tbody></tbody>
                        </table>
                    </div>

                    <table width="100%">
                        <tr>
                            <td width="50%" class="ui-button-text"><label>部数</label>
                            </td>
                            <td width="50%" class="ui-button-text"><label>カラーモード</label>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <div id="printNumDiv">
                                    <input id="printNum" value="1" style="text-align: right; width: 218px;" />
                                </div>
                            </td>
                            <td>
                                <div id="colorModeDiv">

                                    <select id="colorMode" style="width: 130px;">
                                    <% for (int i = 0; i < PrintUtil.ColorMode.Length; i++)
                                        { %>
                                    <option value="<%= i %>"><%= PrintUtil.ColorMode[i] %></option>
                                    <% } %>
                                </select>
                                </div>
                                
                            </td>
                        </tr>
                        <tr>
                            <td width="50%" class="mfpForm-padding">両面
                            </td>
                            <td width="50%" class="mfpForm-padding">まとめて1枚
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <div id="bothSideDiv">
                                    <select id="bothSide" style="width: 130px;">
                                    <% for (int i = 0; i < PrintUtil.BothSide.Length; i++)
                                        { %>
                                    <option value="<%= i %>"><%= PrintUtil.BothSide[i] %></option>
                                    <% } %>
                                </select>
                                </div>
                                
                            </td>
                            <td>
                                <div id="layoutDiv">
                                    <select id="layout" style="width: 130px;">
                                    <% for (int i = 0; i < PrintUtil.Layout.Length; i++)
                                        { %>
                                    <option value="<%= i %>"><%= PrintUtil.Layout[i] %></option>
                                    <% } %>
                                </select>
                                </div>
                                
                            </td>
                        </tr>
                        <tr>
                            <td class="mfpForm-padding">
                                <input id="tray" type="checkbox" value="1" /><label for="tray"><%= Resources.Messages.ManualFeedTrayCaption %></label>
                            </td>
                        </tr>
                    </table>
                </div>
            </section>
        </form>


        <br />
        <div id="mfpFormButtonDiv">
            <button type="button" class="ModalWindowButton" id="mfpFormprintPreview" ><%= Resources.Messages.PreviewButtonCaption %></button>
            <div>
                <button type="button" class="close ModalWindowButton" id="mfpFormClose" ><%= Resources.Messages.CancelButtonCaption %></button>
                <button type="button" class="ModalWindowButton" id="mfpFormConfirm1"><%= Resources.Messages.OkButtonCaption %></button>
            </div>

        </div>

    </div>
    <!-- フィルタダイアログ -->
	<div id="columnPopup">
        <h2 id="columnPopupTitel"></h2>
        <div id="columnPopupSortButton" ></div>
		<div id="columnPopupItems"></div>
        <div id="columnPopupButtonDiv" style="float: right;margin-bottom: 15px;">

        </div>
	</div>
    <div id="unknownColumnPopup" style="display:none;">
        <h2 id="unknownColumnPopupTitel"></h2>
        <div id="unknownColumnPopupSort"></div>
		<div id="unknownColumnPopupItems"></div>
         <div id="unknownColumnPopupButtonDiv" style="float: right;margin-bottom: 15px;">

        </div>
	</div>
    <!-- 対象未選択ダイアログ -->
    <div id="notSelected">
        <div style="height: 300px">
            <span><%= Resources.Messages.NotSelected %></span>
        </div>
        <button type="button" class="cancle ModalWindowButton" id="notSelectedClose"><%= Resources.Messages.CancelButtonCaption %></button>
    </div>

    <!-- 新規＆確認訂正ダイアログ -->
    <div id="newConf">
        <h2 id="mode"></h2>
        <article class="centerAlign">
            <section>
                <form method="POST" name="formy1" id="formy2" style="overflow: scroll; overflow-x: hidden; height: 300px">
                    <div id="clearDiv">
                        <div id="recordTableDiv">
                            <table id="recordTable">
                                <thead>
                                    <th style="width: 50%;">設問名</th>
                                    <th style="width: 50%;">値</th>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>
                        </div>
                        <div id="recordTableViewModeDiv">
                            <table id="recordTableViewMode">
                                <thead>
                                    <th style="width: 50%;">設問名</th>
                                    <th style="width: 50%;">値</th>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <input type="hidden" id="ConfRecordId" />
                </form>
            </section>
            <hr>
        </article>
        <button type="button" class="ModalWindowButton" id="editMode1">編集モード</button>
        <button type="button" class="ModalWindowButton" id="billPayment1" style="margin-right: 150px;">帳票紐付</button>
        <button type="button" class="close ModalWindowButton" id="console2">キャンセル</button>
        <button type="button" class="ModalWindowButton" id="confirm2">OK</button>
        <button type="button" class="close ModalWindowButton" id="console1">キャンセル</button>
        <button type="button" class="ModalWindowButton" id="confirm1">OK</button>
    </div>


    <!-- 不明な帳票一覧ダイアログ-->
    <div id="unknownList" title="<%= Resources.Messages.UnknownDialogTitle %>">
        <h2>不明な帳票一覧</h2>
        <article class="centerAlign">
            <input id="unknownDeleteButton" class="close ModalWindowButton" type="button" value="<%= Resources.Messages.DeleteButtonCaption %>" />
            <input id="unknownOKButton" class="close ModalWindowButton" type="button" value="<%= Resources.Messages.OkButtonCaption %>" />
            <div id="unknowDiv" style="padding: 5px 0px;width: 100%;">
                <div id="unknownTableDivTemp">
                    <div id="unknownTableDiv">
                        <table id="unknownTable">
                            <thead>
                                <tr>
                                    <th>
                                        <span id="UnknownFormSelect"><input id="allUnknownCheckBox" type="checkbox" /></span>
                                    </th>
                                    <th>
                                        <span id="UnknownFormId"><%= Resources.Messages.UnknownNumberColumnName %></span>
                                    </th>
                                    <th>
                                        <span id="FormShortName"><%= Resources.Messages.UnknownDialogHeaderFormName %></span>
                                    </th>
                                    <th>
                                        <span id="ErrorMessage"><%= Resources.Messages.UnknownDialogHeaderError %></span>
                                    </th>
                                    <th>
                                        <span id="IpAddress"><%= Resources.Messages.UnknownDialogHeaderIP %></span>
                                    </th>
                                    <th>
                                        <span id="ScanDate"><%= Resources.Messages.UnknownDialogHeaderDatetime %></span>
                                    </th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
                <div id="unknownDlgButtons" style="float: right;margin-top: 15px;margin-bottom: 15px;">
                    <input id="unknownCloseButton" type="button" value="<%= Resources.Messages.CloseButtonCaption %>" />
                </div>
            </div>
        </article>
    </div>

    <!-- エラー情報ダイアログ -->
    <div id="errInfo">
        <h2 id="modeErr"></h2>
        <article class="centerAlign">
            <section>
                <form style="overflow: auto;overflow-x: hidden;height: 300px;background-color: #eaeaea;">
                    <div id="clearErrDiv">
                        <div id="recordTableErrDiv">
                            <table id="recordErrTable">
                                <thead>
                                    <th style="width: 20%;">帳票名</th>
                                    <th style="width: 60%;">内容</th>
                                    <th style="width: 20%;">操作</th>
                                </thead>
                                <tbody>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <input type="hidden" id="ConfRecordErrId" />
                </form>
            </section>
            <hr>
        </article>
        <button type="button" class="close ModalWindowButton" id="consoleErrButton">閉じる</button>
    </div>

    <!-- 表示レコード範囲設定 -->
    <div id="dataRangeDialog" style="width: 606px;">
		<h2>表示レコード範囲設定</h2>
		<article class="centerAlign" >
            <section>
			    <form name="form1">
                    <div>
                        <input type="checkbox" id="chkDataRangeRecord" value="1"/>
						<lable for="chkDataRangeRecord"><%= Resources.Messages.DataRangeRecordCaption %></lable>
					</div>
                    <table id="tblRecordCondition">
                        <tr>
                            <td>
                                <div id="rangeSelectDiv" style="margin-top: 5px;">
                                    <select id="selectDataRangeRecord">
                                        <option selected="selected" value="n"><%= Resources.Messages.DaraRangeRecordNumber %></option>
                                        <option value="c"><%= Resources.Messages.DataRangeRecordCount %></option>
                                    </select>：
                                 </div>
                            </td>
                            <td>
                                <div id="textDataRangeRecordDiv">
                                    <input type="text" id="textDataRangeRecordS" style="width: 185px;margin-top: 5px;"/>&nbsp;-&nbsp;
                                    <input type="text" id="textDataRangeRecordE" style="width: 185px;margin-top: 5px;"/>
                                </div>
                            </td>
                        </tr>
                    </table>
					<div id="rangeCheckbox02" style="margin-top: 5px;">
						<input type="checkbox" id="chkDataRangeItem" value="1"" />
                        <label for="chkDataRangeItem"><%= Resources.Messages.DataRangeItemCaption %></label>
					</div>

					<table id="tblItemCondition"></table>
			    </form>
		    </section>
            <button type="button" class="ModalWindowButton"  id="dataRangeCountButton"><%= Resources.Messages.DataRangeCountButtonCaption %></button>
            <span><%= Resources.Messages.DataRangeCountCaption %></span><span id="dataRangeCount" style="margin-right: 5px;"></span>
		    <hr>
		</article>
        <div id="buttonDiv" style="margin-left: 66%;">
		    <button type="button" class="close ModalWindowButton" id="consoleButton">キャンセル</button>
            <button type="button" class="ModalWindowButton" id="confirmButton">OK</button>
        </div>
    </div>
    <!-- パスワード変更ダイアログ -->
    <!-- パスワード変更ダイアログの中身の設定 -->
    <div id="frmChgPWDDialog">
        <h2>パスワードの変更</h2>
        
            
                <div id="frmChgPWD" >
                <form >
                    <!-- sample各入力項目やボタン -->
                    <p class="CheckResult" style="font-size: 12px; color: red"></p>

                    <%-- <fieldset style="font-family: Meiryo; font-size: 12px; font-weight: 700"> --%>
                    <label for="curPWD">現在のパスワード</label><br/>
                    <div id="curPWDDiv">
                        <input type="password" name="curPWD" id="curPWD" style="width: 400px;" maxlength="100" />
                    </div>
                    <br/><br/>
                    <label for="newPWD">新しいパスワード</label><br/>
                    <div id="newPWDDiv">
                        <input type="password" name="newPWD" id="newPWD" style="width: 400px;" maxlength="100"/>
                    </div>
                    <br/><br/>
                    <label for="confPWD">新しいパスワード（確認）</label><br/>
                    <div id="confPWDDDiv">
                        <input type="password" name="confPWD" id="confPWD" style="width: 400px;"  maxlength="100"/>
                    </div>
                    <br/><br/>
                    <%-- <input type="hidden" name="uID" id="uID" value="<%=Session["USER_ID"]%>" /> --%>
                    <%-- </fieldset> --%>
                </form>
            </div>
           
       <br />
        <div id="buttonfrmChgPWDDialog" style="margin-left: 55%;">
		    
		    <button type="button" id="consoleChgPWDButton" style="margin-right:5px;">キャンセル</button>
            <button type="button"  id="confirmChgPWDButton">OK</button>
        </div>
    </div>
    
</body>
</html>
