﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Preview.aspx.cs" Inherits="QuestionnaireConfirm.Preview" %>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" lang="ja">
<head runat="server">
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<meta http-equiv="X-UA-Compatible" content="IE=edge" />
	<title>
        <%= Resources.Messages.AppTitle %>
	</title>
	<link rel="stylesheet" href="css/redmond/jquery-ui-1.11.2.min.css" />
	<link rel="stylesheet" href="css/style.css?date=<%=DateTime.Now.ToString("yyyyMMddHHmmss")%>" />
    
	<style>
        #imgPanel {
            border: 1px solid #dddddd;
            background-color: #dddddd;
            overflow:hidden;
        }
        #previewImage {
	        transform-origin: left top;
	        -moz-transform-origin: left top;
	        -webkit-transform-origin: left top;
	        -o-transform-origin: left top;
	        -ms-transform-origin: left top;
        }
        #nowPage {
            width: 30px;
            height: 25px;
            text-align: right;
        }
	    #nowPage, #totalPage {
            color: #333333;
            font-family: "Arial Negreta","Arial";
            font-size: 12px;
            font-style: normal;
            font-weight: 400;
	    }

        .paging {
            text-align: center;
        }
		.va-bottom {
			height: 32px;
			background: #eaeaea none repeat scroll 0 0 !important;
			border: 1px solid silver !important;
		}
		.xux-button {
			display: inline !important;
		}

        
	</style>
    
	<script src="js/jquery-2.1.1.min.js"></script>
	<script src="xux/xux-js/xux-gfocal-middle-light-3.1.0-alpha-06.min.js"></script>
    <script>
        xuxInitialize({
            prefix: "xux/",
        });
    </script>
   
	<script type="text/javascript">
		$(function () {            
	        var currentPage = 1;
	        var endPage = Number($('#pageCount').val());
	        $('#totalPage').text(endPage);
	        var winWidth = $(window).width();
	        var winHeight = $(window).height();
	        $('#imgPanel').width(winWidth - 30);
	        $('#imgPanel').height(winHeight - 90);
	        $('.paging').width(winWidth - 30);

            <%-- プレビュー画像表示処理 --%>
	        function showPreviewImage(page) {
	            dispLoading("<%= Resources.Messages.PreviewProcessingMessage %>");
	            $('#previewImage').remove();
	            var img = $(new Image());
	            img.attr('id', 'previewImage');
	            img.bind('load', function(){
	                var imageWidth = this.width.toFixed(0);
	                var imageHeight = this.height.toFixed(0);
	                var widthScaleSize = (Number($('#imgPanel').css('width').slice(0, -2)) / imageWidth).toFixed(2) * 100;
	                var heightScaleSize = (Number($('#imgPanel').css('height').slice(0, -2)) / imageHeight).toFixed(2) * 100;
                    <%-- 表示枠に合わせてサイズを変更 --%>
	                var scaleParam = 0;
	                if (widthScaleSize > heightScaleSize) {
	                    scaleParam = heightScaleSize;
	                } else {
	                    scaleParam = widthScaleSize;
	                }
	                scaleParam = scaleParam / 100;
                    <%-- 表示枠の中央に画像を移動 --%>
	                var afterWidthSize = Number(imageWidth) * scaleParam;
	                var afterHeightSize = Number(imageHeight) * scaleParam;
	                var silideHorizonPx = (Number($('#imgPanel').css('width').slice(0, -2)) - afterWidthSize) / 2;
	                var silideVerticalPx = (Number($('#imgPanel').css('height').slice(0, -2)) - afterHeightSize) / 2;
	                silideHorizonPx = (silideHorizonPx / scaleParam).toFixed(0);
	                silideVerticalPx = (silideVerticalPx / scaleParam).toFixed(0);

	                $(this).css('-webkit-transform', 'scale(' + scaleParam + ') translate(' + silideHorizonPx + 'px, ' + silideVerticalPx + 'px)');
	                $(this).css('-moz-transform', 'scale(' + scaleParam + ') translate(' + silideHorizonPx + 'px, ' + silideVerticalPx + 'px)');
	                $(this).css('-o-transform', 'scale(' + scaleParam + ') translate(' + silideHorizonPx + 'px, ' + silideVerticalPx + 'px)');
	                $(this).css('-ms-transform', 'scale(' + scaleParam + ') translate(' + silideHorizonPx + 'px, ' + silideVerticalPx + 'px)');
	                $(this).css('transform', 'scale(' + scaleParam + ') translate(' + silideHorizonPx + 'px, ' + silideVerticalPx + 'px)');

	                $('#imgPanel').append(this);
	                removeLoading();
	            }).bind('error', function () {
                    alertMessageInfo('<%= Resources.Messages.PreviewFailMessage %>')
	                removeLoading();
	            });
	            var date = new Date();
	            var dispTime = "";
	            dispTime += String(date.getFullYear());
	            dispTime += ("0" + String(date.getMonth() + 1)).slice(-2);
	            dispTime += ("0" + String(date.getDate())).slice(-2);
	            dispTime += ("0" + String(date.getHours())).slice(-2);
	            dispTime += ("0" + String(date.getMinutes())).slice(-2);
	            dispTime += ("0" + String(date.getSeconds())).slice(-2);
	            img.attr('src', 'api/Preview?pageNo=' + page + '&' + dispTime);
	            $('#nowPage').val(page);

	            <%-- ボタン制御 --%>
	            var disableFlgPrev = false;
	            var diableFlgNext = false;
	            if (1 < endPage) {
	                if (endPage <= page) {
	                    disableFlgPrev = false;
	                    diableFlgNext = true;
	                } else if (page <= 1) {
	                    disableFlgPrev = true;
	                    diableFlgNext = false;
	                } else {
	                    disableFlgPrev = false;
	                    diableFlgNext = false;
	                }
	            } else {
	                disableFlgPrev = true;
	                diableFlgNext = true;
	            }
	            
	            if (disableFlgPrev) {
	                $('#topPageE').hide();
	                $('#topPageD').show();
	                $('#previousPageE').hide();
	                $('#previousPageD').show();
	            } else {
	                $('#topPageE').show();
	                $('#topPageD').hide();
	                $('#previousPageE').show();
	                $('#previousPageD').hide();
	            }
	            if (diableFlgNext) {
	                $('#nextPageE').hide();
	                $('#nextPageD').show();
	                $('#endPageE').hide();
	                $('#endPageD').show();
	            } else {
	                $('#nextPageE').show();
	                $('#nextPageD').hide();
	                $('#endPageE').show();
	                $('#endPageD').hide();
	            }

	        }

            <%-- 初期表示 --%>
	        showPreviewImage(1);
	        if (endPage < 2) {
	            $('#nowPage').prop('disabled', true);
	        }
	        
            <%-- 次ページボタン押下 --%>
	        $('#nextPageE').click(function () {
	            showPreviewImage(currentPage + 1);
	            currentPage++;
	        });
	        <%-- 最終ページボタン押下 --%>
	        $('#endPageE').click(function () {
	            showPreviewImage(endPage);
	            currentPage = endPage;
	        });
            <%-- 前ページ押下 --%>
	        $('#previousPageE').click(function () {
	            showPreviewImage(currentPage - 1);
	            currentPage--;
	        });
	        <%-- 先頭ページ押下 --%>
	        $('#topPageE').click(function () {
	            showPreviewImage(1);
	            currentPage = 1;
	        });

	        <%-- テキストボックス変更処理 --%>
	        $('#nowPage').keypress(function (event) {
	            if (event.which !== 13) {
	                <%-- Enterキー以外は無効 --%>
	                return;
	            }
	            var pageVal = $('#nowPage').val();
	            var errFlg = false;
	            var msg = '印刷プレビュー範囲は1～' + endPage + 'を指定してください。';
	            if (pageVal == null || pageVal == '') {
	                errFlg = true;
	                msg = null;
	            } else if (!pageVal.match(/^[0-9]+$/)) {
	                errFlg = true;
	            } else {
	                pageVal = Number(pageVal);
	                if (pageVal < 1 || endPage < pageVal) {
	                    errFlg = true;
	                }
	            }
	            if (errFlg) {
	                if (msg != null) {
                        alertMessageInfo(msg);
	                }
                    $('#nowPage').val(currentPage);
	                return;
	            }
	            showPreviewImage(pageVal);
	            currentPage = pageVal;
	        });
		});
    </script>
	<script>
		$("body").xuxPage();
        $("#nowPage").xuxPage();
        
    </script>
	 <script src="js/common.js?date=<%=DateTime.Now.ToString("yyyyMMddHHmmss")%>"></script>
</head>
    <body>
        <form runat="server">
            <asp:HiddenField ID="pageCount" runat="server" />
        </form>
        
        <div id="imgPanel"></div><br/>
        <div class="paging">
         <span id="topPage">
                <button id="topPageE" class="va-bottom add-cursor">
					 <span class="xux-icon xux-icon-size-medium xux-icon-navigationfirst" style="font-size: 16px; position: relative;color:#8c8c8c" ></span>
                </button>
             <button id="topPageD" class="va-bottom" disabled="disabled">
                 <span class="xux-icon xux-icon-size-medium xux-icon-navigationfirst" style="font-size: 16px; position: relative; color: #8c8c8c"></span>
             </button>

         </span>
		
            <span id="previousPage">
                <button id="previousPageE" class="va-bottom  add-cursor"> 
					 <span class="xux-icon xux-icon-size-medium xux-icon-leftarrowhead" style="font-size: 16px; position: relative;color:#8c8c8c" ></span>
                </button>
                <button id="previousPageD" class="va-bottom" disabled="disabled">
					 <span class="xux-icon xux-icon-size-medium xux-icon-leftarrowhead" style="font-size: 16px; position: relative;color:#8c8c8c" ></span>
                </button>
            </span>
            
			<input id="nowPage" type="text" maxlength="3" />
			/ 
            <span id="totalPage" ></span>
            <span id="nextPage">
                <button id="nextPageE" class="va-bottom add-cursor">
					 <span class="xux-icon xux-icon-size-medium xux-icon-rightarrowhead" style="font-size: 16px; position: relative;color:#8c8c8c" ></span>
                </button>
                <button id="nextPageD" class="va-bottom" disabled="disabled">
					 <span class="xux-icon xux-icon-size-medium xux-icon-rightarrowhead" style="font-size: 16px; position: relative;color:#8c8c8c" ></span>
                </button>
            </span>
          <span id="endPage">
                <button id="endPageE" class="va-bottom add-cursor">
						<span class="xux-icon xux-icon-size-medium xux-icon-navigationlast" style="font-size: 16px; position: relative;color:#8c8c8c" ></span>

                </button>
                <button id="endPageD" class="va-bottom" disabled="disabled">
						<span class="xux-icon xux-icon-size-medium xux-icon-navigationlast" style="font-size: 16px; position: relative;color:#8c8c8c" ></span>
                </button>
            </span>
        </div>
		<input type="button" id="deleteButton" value="" style="display:none"/>
    </body>
</html>
<script>
    $("button").xuxButton();
</script>
