﻿<%@ Page Language="C#" AutoEventWireup="true" EnableEventValidation="false" CodeBehind="QuestionnaireFormat.aspx.cs"
    Inherits="QuestionnaireConfirm.QuestionnaireFormat" %>

<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" lang="ja">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <title>
        <%= Resources.Messages.AppTitle %>
    </title>
    <link rel="SHORTCUT ICON" href="image/record_operator_favicon.ico" />
    <link rel="stylesheet" href="css/style.css?date=<%=DateTime.Now.ToString("yyyyMMddHHmmss")%>" />
    <style>
         html,body{
            background-color:#f5f5f5 !important;
        }
        #headerFunction {
            margin: 8px;
        }

        .sortColumn {
            position: relative;
            left: 20px;
            width: 160px;
        }

        .sortDirection {
            position: relative;
            left: 30px;
            width: 60px;
        }

        #footerFunction {
            margin: 8px;
            text-align: right;
        }


        .ui-tabs-anchor {
          /*  font-size: .6rem;*/
        }

        .fg-button {
            margin: 1px;
            width: 10px;
            font-size: 10px;
        }

        .displayCountArea {
            float: left;
            text-align: left;
            height: 35px;
        }

        .dataTable_paginate {
            float: right;
            text-align: right;
            height: 35px;
        }

        .dataTables_length {
            width: auto;
            text-align: right;
            font-family: "Arial Negreta", "Arial";
            font-size: 12px;
            font-style: normal;
            font-weight: 400;
            margin-top: 1px;
            margin-right: 7px;
        }

        .dataTables_info {
            width: auto;
            text-align: left;
            font-family: "Arial Negreta", "Arial";
            font-size: 12px;
            font-style: normal;
            font-weight: 400;
            margin-top: 5px;
            margin-right: 7px;
            float: right;
        }

        .dataTables_paginate {
            float: right;
        }

        #configButton {
            margin-left: 7px;
        }

        #pageLength {
            display: none;
        }

        #tabs {
           /* border: none;*/
           min-width: 550px;
        }

        #elementsTable_length select {
            margin: 0px 4px;
        }

        #allVerifiedCheckBox {
            vertical-align: middle;
        }

        #previewVisibleDisable {
            position: absolute;
        }

        .sizeControl {
           /* float: left;*/
            
        }

        .pageControl {
            float: right;
            padding-right: 5px;
            white-space: nowrap;
        }

        .scanPageArea {
            width: 43%;
            max-width: 43%;
            border: 0px;
            padding: 0;
            vertical-align: top;
            background-color: #D8D8D8;
            overflow: hidden;
           /* border-radius: 5px;*/
           /* border: 1px solid #808080;*/
        }

        .scanPageFunction {
            padding: 5px;
            box-sizing: border-box;
            display: flex;
            width: 100%;
            align-items: center;
            justify-content: space-between;
        }

        .dataTable > tbody > tr > td {
            padding: 7px;
        }
        button.va-middle {
            height: 32px;
            background: #eaeaea none repeat scroll 0 0 !important;
        }

        #columnPopupItems {
            border: 1px solid #b2b2b2;
            margin: 20px 0;
            max-height: 350px;
            overflow-y: scroll;
        }
        .layoutFormat {
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            min-height: 100vh;
        }
        #scanPageScalingListSpan .xux-dropdown-header{
			width: 175px
		}
         .xux-modalWindow.xux-width-normal{
            width:400px !important;
        }
        .xux-decoratedTable-table table tbody {
            display:block;
            height:632px;
            overflow-y:auto;
        }
 
        .xux-decoratedTable-table table thead {
            display:table;
            width:100%;
            table-layout:fixed;
        }

        .xux-decoratedTable-table table tbody tr {
            display: table;
            width: 100%;
            table-layout: fixed;
        }

        .xux-normalButton {
            width: 94px !important;
        }

        .xux-button {
            display: inline !important;
        }
        .xux-pageNavigation-cell > .xux-page-number {
            color: #333;
        }

        #footer {
            margin-top: 10px;
        }
        #tabs .xux-tabbedSet-header{
            display:flex;
            flex-wrap:wrap;
            min-width:445px;
        }
        .xux-tabbedSet .xux-tabbedSet-header .xux-tab-item>a{
            border-style:solid !important;
        }
        .xux-textArea{
            overscroll-behavior: unset !important
        }
        /*   .xux-decoratedTable-table table thead {
            width: calc( 100% - 1em )
        }*/
        /*  .copyRight .xux-normalButton {
        width: 82px!important;
        height: 26px!important;
        line-height: 25px !important;
     }*/
    </style>
    <% QuestionnaireConfirm.Util.ExportDataUtil expUtil = new QuestionnaireConfirm.Util.ExportDataUtil(Session.SessionID, (string)Session["USER_ID"], (string)Session["USER_NAME"], Convert.ToInt32(Session["businessId"]), System.DateTime.Now); %>
    <script src="js/jquery-2.1.1.min.js"></script>

    <script>
        var userId_;
        var jobIds_;
        var formId_;
        var formName_;
        var scanPageInfo_ = [];
        var scanPageIndex_ = 0;
        var $elementsTable_;
        var elementRowsList_ = [];
        var tempData = [];
        var tabIndex_ = 0;
        var isUpdating_ = false;
        var statusCond_ = {};
        var verifiedCount_ = 0, unverifiedCount_ = 0;
        var isChangeTab_ = false;
        var scalingSize_ = -1;
        var originalTop_ = 0;
        var originalLeft_ = 0;
        var originalWidth_ = 0;
        var originalHeight_ = 0;
        var scalingList_ = [17, 67, 100, 133, 167, 200, 300, 400];
        var itemsPerPageChoices = [3, 5, 10, 20, 50, 100, 200];
        var sortFilterColumn_ = null;<%-- フィルターダイアログ用 --%>
        var windowHeight_ = window.innerHeight - 300;<%-- 画面上部の高さ - フッターのコピーライト分を減算 --%>
        if (windowHeight_ < 100) {
            windowHeight_ = 300;
        }
        var scanImageAreaHeight_ = window.innerHeight - 195;<%-- 画面上部の高さ - フッターのコピーライト分を減算 --%>
        if (scanImageAreaHeight_ < 100) {
            scanImageAreaHeight_ = 450;
        }
        var scaledScanPageImageWidth_ = 0;
        var scaledScanPageImageHeight_ = 0;
        var scanPagePanelWidth_ = 0;
        var scanPagePanelHeight_ = 0;
        var moveX_ = 0;
        var moveY_ = 0;
        var isOperationCanceled_ = false;<%-- 同一タブ内での変更内容破棄イベントフラグ。 --%>
        var backupPageLength_freeEntryTab= 0;<%-- 一覧表示件数の変更前データ。 --%>
        var backupPageLength_otherTab= 0;
        var backupPageNumber_ = 0;<%-- 現在表示ページのの変更前データ。 --%>
        var backupSearchFilter_ = '';<%-- フィルターダイアログの変更前データ。 --%>
        var $filterDialogHeader_ = null;
        var freeEntryMaxLength_ = <%= QuestionnaireConfirm.Util.RecordUtil.GetFreeEntryMaxLength() %>;
        var isParentClosed_ = false;
        var answerImageDafaultWidth = 240;
        var answerImageDafaultHeight = 60;
        var expScaleFlg = false;
        var redScaleFlg = false;
        var prevScanPageFlg = false;
        var nextScanPageFlg = false;
        var previewSpaceWidth_ = 0;
        var tmpScalingParam_ = 1;
        var prevData_;
        var selectedElementDataId_ = -1;
        <%-- レコードデータ出力機能 --%>
        var messageConfirmExportData_ = '<%= Resources.Messages.ConfirmExportDataMessage %>';
        var messageConfirmExportDataAndDelete_ = '<%= Resources.Messages.ConfirmExportDataAndDeleteMessage %>';
        var titleConfirmEndFormat_ = '<%= Resources.Messages.ConfirmEndFormatTitle %>';
        var isExportCsv_ = '<%= expUtil.IsSetExportData() %>' == 'True';
        var isDelete_ = '<%= expUtil.IsSetDeleteAfter() %>' == 'True';
        var remainRecordIds_ = null;
        var businessId_;
        var DataTableOptions = null;
        var COOKIENAME_PREVIEW_SETTING = 'Questionnaire.PreviewSetting';
        var COOKIENAME_ANSWER_IMAGE_SETTING = 'Questionnaire.AnswerImageSetting';
        var COOKIENAME_PAGE_LENGTH_OTHER_TAB = 'Questionnaire.LinesPerPage.otherTab';
        var COOKIENAME_PAGE_LENGTH_FREE_ENTRY_TAB =  'Questionnaire.LinesPerPage.freeEntryTab';
        var COOKIENAME_CONFIRMATION_OPEN = 'ConfirmationOpen';

        var FILTER_ALLROWS_ID = 'allRows';
        var FILTER_ALLROWS_ID_SELECTOR = '#allRows';
        var FILTER_COND_CLASSNAME = 'filterCond';
        var FILTER_COND_CLASSNAME_SELECTOR = '.filterCond';
        var FILTER_RADIO_GROUP_NAME = 'filterRadioItem';
        var TABLE_WIDTH_QUESTION = 100;
        var TABLE_WIDTH_SELECT = 100;
        var TABLE_WIDTH_VALUE = 23;
        var TABLE_WIDTH_CONFIRM = 60;
        var aoData = [];
        var recordTablePageCount = 10;
        var allVerifiedCheckBoxValue = null;
        var clickHeaderCell = null;
        var clickHeaderCellWidth = 0;
        var currentPage = 1;
        var isApplyButton = false;
		
		var windowGlobal = $(window);
	    <%-- 画面遷移が発生した場合の処理 --%>
        $(window).bind('beforeunload', function (e) {
            if (isParentClosed_) return;

            setPreviewSetting();

            var changedRows = getChangedElementRows();
            if (0 < changedRows.length || isUpdating_) {
                return '<%= Resources.Messages.ConfirmDataChangedMessage %>';
            }
        });
        $(window).load(function () {
            setCookie(COOKIENAME_CONFIRMATION_OPEN, "1");
        });
        $(window).unload(function () {
            $.removeCookie(COOKIENAME_CONFIRMATION_OPEN);
        });

        //ドキュメント全体にkeydownイベントを追加
        $(document).on("keydown", function (event) {
            checkboxSpacekeyDown(event);
        });

        function timeout() {
            alertMessageInfo('<%= Resources.Messages.ConfirmWindowCloseMessageTimeout %>', function () {
                isParentClosed_ = true;
                window.close();
            });
           
        }
		<%-- 拡縮プルダウン作成 --%>
        function createScalingCombobox(defaultSize, heightScaleSize, widthScaleSize, previewSetting) {
			<%-- 既存の拡縮プルダウンを削除 --%>
            var $scanPageScalingListSpan = $('#scanPageScalingListSpan');
            $scanPageScalingListSpan.children().remove();
			<%-- 新しい拡縮プルダウンの作成 --%>
            $scanPageScalingListSpan.append('<select id="scanPageScalingList" class="scanPageScalingList"></select>');
            var $scanPageScalingList = $('#scanPageScalingList');
			<%-- 拡縮プルダウンの倍率リスト作成 --%>
            var append = '';
            scalingSize_ = 0;
            for (var i = 0; i < scalingList_.length; i++) {
                append = '<option value="' + scalingList_[i] + '" ';
                if (previewSetting.size == scalingList_[i]) {
                    append += 'selected';
                    scalingSize_ = scalingList_[i];
                }
                append += '>' + scalingList_[i] + '%</option>';
                $scanPageScalingList.append(append);
            }

            append = '<option value="scalling" ';
            if (scalingSize_ == 0 && !(previewSetting.size == 0 || previewSetting.size == -1 || previewSetting.size == -2)) {
                append += 'selected';
                scalingSize_ = previewSetting.size;
            }
            append += '><%= Resources.Messages.ScalingImageSizeCaption %></option>';
            $scanPageScalingList.append(append);

            var cookie = isPreviewSetting(scanPageInfo_[scanPageIndex_].pageNumber);
            append = '<option value="' + defaultSize + '" ';
            if (previewSetting.size == 0 && cookie) {
                append += 'selected';
                scalingSize_ = defaultSize;
            }
            append += '><%= Resources.Messages.EntireImageSizeCaption %></option>';
            $scanPageScalingList.append(append);

            append = '<option value="' + heightScaleSize + '" ';
            if (previewSetting.size == -1 || (!cookie && widthScaleSize < heightScaleSize)) {<%-- AR67831 --%>
                append += 'selected';
                scalingSize_ = heightScaleSize;
            }
            append += '><%= Resources.Messages.HeightImageSizeCaption %></option>';
            $scanPageScalingList.append(append);

            append = '<option value="' + widthScaleSize + '" ';
            if (previewSetting.size == -2 || (!cookie && heightScaleSize < widthScaleSize)) {<%-- AR67831 --%>
                append += 'selected';
                scalingSize_ = widthScaleSize;
            }
            append += '><%= Resources.Messages.WidthImageSizeCaption %></option>';
            $scanPageScalingList.append(append);

            $scanPageScalingList.change(function () {
                var selectVal = $("#scanPageScalingList option:selected").val();
                if (selectVal === 'scalling') {
                    return;
                }
                selectVal = Number(selectVal);
                if (selectVal === 400) {
                    expScaleFlg = false;
                    redScaleFlg = true;
                } else if (selectVal === 17) {
                    expScaleFlg = true;
                    redScaleFlg = false;
                } else {
                    expScaleFlg = true;
                    redScaleFlg = true;
                }
                showPreviewScaleButton(expScaleFlg, redScaleFlg);
                scalingSize_ = selectVal;
                onChangeScaling(scalingSize_);
            });
	        <%-- 表示済み設問色づけのサイズ変更 --%> 
            onChangeScalingForQuestionColoring(scalingSize_);
            showPreviewScaleButton(true, true);
            $("#scanPageScalingList").xuxDropdown();
            $("#scanPageScalingList").xuxDropdown("refresh");
        }

		<%-- スキャン結果一覧で操作した内容（値、確認の変更）をDataTablesの実データに反映 --%>
        function onChangeScaling(scalingSize) {
            var scaleParam = scalingSize / 100;
            var $scanPageImage = $('#scanPageImage');
            $scanPageImage.css('-webkit-transform', 'scale(' + scaleParam + ')');
            $scanPageImage.css('-moz-transform', 'scale(' + scaleParam + ')');
            $scanPageImage.css('-o-transform', 'scale(' + scaleParam + ')');
            $scanPageImage.css('-ms-transform', 'scale(' + scaleParam + ')');
            $scanPageImage.css('transform', 'scale(' + scaleParam + ')');
            scaledScanPageImageWidth_ = scanPageInfo_[scanPageIndex_].width.toFixed(0) * scaleParam;
            scaledScanPageImageHeight_ = scanPageInfo_[scanPageIndex_].height.toFixed(0) * scaleParam;
		    <%-- 拡大・縮小前の画像の大きさ --%> 
            var pastPreviewImageSizeX = parseInt($('#scanPageImage').css('width').slice(0, -2), 10) * tmpScalingParam_;
            var pastPreviewImageSizeY = parseInt($('#scanPageImage').css('height').slice(0, -2), 10) * tmpScalingParam_;
		    <%-- プレビュー枠の大きさ --%> 
            var previewPanelSizeX = parseInt($('#scanPagePanel').css('width').slice(0, -2), 10);
            var previewPanelSizeY = parseInt($('#scanPagePanel').css('height').slice(0, -2), 10);

            if (pastPreviewImageSizeX + moveX_ < previewPanelSizeX / 2 ||
                pastPreviewImageSizeY + moveY_ < previewPanelSizeY / 2) {
		        <%-- プレビュー枠の中心に画像がなかった場合は、原点表示 --%> 
                moveX_ = moveY_ = 0;
            } else {
		        <%-- 前回の拡大・縮小率との比率を算出 --%> 
                var changeRatio = scaleParam / tmpScalingParam_;
		        <%-- 比率 * 移動距離 + (プレビュー枠の大きさ分を補正) --%> 
                moveX_ = (changeRatio * moveX_) + (previewPanelSizeX * (changeRatio - 1) / 2);
                moveY_ = (changeRatio * moveY_) + (previewPanelSizeY * (changeRatio - 1) / 2);
                if (moveX_ < 0) {
                    moveX_ = 0;
                } else {
		            <%-- プレビューの枠に画像(X方向)が収まる場合は、原点から表示 --%> 
                    var imageSizeX = parseInt($('#scanPageImage').css('width').slice(0, -2), 10) * scaleParam;
                    if (imageSizeX < previewPanelSizeX) moveX_ = 0;
                }
                if (moveY_ < 0) {
                    moveY_ = 0;
                } else {
                    <%-- プレビューの枠に画像(Y方向)が収まる場合は、原点から表示 --%> 
                    var imageSizeY = parseInt($('#scanPageImage').css('height').slice(0, -2), 10) * scaleParam;
                    if (imageSizeY < previewPanelSizeY) moveY_ = 0;
                }
            }
            $('#scanPagePanel').scrollLeft(moveX_).scrollTop(moveY_);
		    <%-- 次回の比率算出のため保存 --%> 
            tmpScalingParam_ = scaleParam;
			<%-- 表示済み設問色づけのサイズ変更 --%> 
            onChangeScalingForQuestionColoring(scalingSize);
        }

		<%-- 表示済み設問色づけのサイズ変更 --%>
        function onChangeScalingForQuestionColoring(scalingSize) {
            var scaleParam = scalingSize / 100;
	        <%-- 表示済み設問色づけのサイズ変更 --%> 
            var $questionColoringBorder = $('#questionColoringBorder');
            var $questionColoringArea = $('#questionColoringArea');
            if (!$questionColoringBorder || !$questionColoringArea) {
                return;
            }
			<%-- 設問色づけdivタグ情報を作成 --%>
            $questionColoringBorder.css('top', (originalTop_ * scaleParam) + 'px');
            $questionColoringBorder.css('left', (originalLeft_ * scaleParam) + 'px');
            $questionColoringBorder.css('width', (originalWidth_ * scaleParam) + 'px');
            $questionColoringBorder.css('height', (originalHeight_ * scaleParam) + 'px');

            $questionColoringArea.css('top', (originalTop_ * scaleParam) + 'px');
            $questionColoringArea.css('left', (originalLeft_ * scaleParam) + 'px');
            $questionColoringArea.css('width', (originalWidth_ * scaleParam) + 'px');
            $questionColoringArea.css('height', (originalHeight_ * scaleParam) + 'px');
        }

		<%-- 設問色づけdivタグの表示 --%>
        function SetQuestionColoring(data, config) {
			<%-- 拡縮サイズの計算および変更前のサイズを保存 --%>
            var scaleParam = scalingSize_ / 100;
            originalLeft_ = data.positionX * 96 / 25.4;
            originalTop_ = data.positionY * 96 / 25.4;
            originalWidth_ = data.width * 96 / 25.4;
            originalHeight_ = data.height * 96 / 25.4;

	        <%-- 設問色づけdivタグ情報（線）を作成 --%>
            var $questionColoringBorder = $('<div id="questionColoringBorder" class="questionColoring" />')
                .css('top', (originalTop_ * scaleParam) + 'px')
                .css('left', (originalLeft_ * scaleParam) + 'px')
                .css('width', (originalWidth_ * scaleParam) + 'px')
                .css('height', (originalHeight_ * scaleParam) + 'px')
                .css('opacity', + config.borderOpacity)
                .css('border', '2px solid ' + config.borderColor);

	        <%-- 設問色づけdivタグ情報（塗りつぶし）を作成 --%>
            var $questionColoringArea = $('<div id="questionColoringArea" class="questionColoring" />')
                .css('top', (originalTop_ * scaleParam) + 'px')
                .css('left', (originalLeft_ * scaleParam) + 'px')
                .css('width', (originalWidth_ * scaleParam) + 'px')
                .css('height', (originalHeight_ * scaleParam) + 'px')
                .css('background-color', config.areaColor)
                .css('opacity', + config.areaOpacity)
                .css('padding', '2px');

		    <%-- 設問色づけdivタグの表示 --%>
            $('#scanPagePanel').append($questionColoringArea);
            $('#scanPagePanel').append($questionColoringBorder);
        }

		<%-- 回答画像の読み込み完了監視処理 --%>
        function doCheckImageLoadComplete() {
            var $thumb = $('img.thumb, img.thumbSentence');
            if (!$thumb) {
                return;
            }
            var thumbLength = $thumb.length;
            var completeImageCount = 0;
            for (var i = 0; i < thumbLength; i++) {
                $($thumb[i]).bind("load", function () {
                    completeImageCount++;
                    if (thumbLength === completeImageCount) {
                        $elementsTable_.columns.adjust();
                        return;
                    }
                });
            }
        }

        <%-- セッションチェック --%>
        function isAliveSession() {
            var result = false;
            $.ajax({
                type: 'GET',
                url: 'api/QuestionnaireFormatElementRows',
                async: false,
                success: function (data, dataType) {
                    if (data !== '0' && data !== '1') {
                        timeout();
                        return false;
                    }
                    result = true;
                }
                , error: function (XMLHttpRequest, textStatus, errorThrown) {
                    if (XMLHttpRequest.status == 200) {
                        timeout();
                        return false;
                    }
                }
            });
            return result;
        }

		<%-- 同一タブ内操作での変更内容破棄確認および破棄処理 --%>
        function isResetEditData() {
            if (isParentClosed_) window.close();

            if (!isAliveSession()) return false;

            var changedRows = getChangedElementRows();
            if (changedRows.length === 0 && !isUpdating_) {
                return true;
            }
            
            <%--if (!confirm('<%= Resources.Messages.ConfirmDataChangedMessage %>')) {
                return false;
            }--%>
            isUpdating_ = false;
			<%-- 画面上に表示している値の内容をバックアップ値に戻す --%>
            var $inputValue = $('.inputValue');
            $.each($inputValue, function (index, value) {
                var nodeName = $(this).prop('nodeName');
                var $backupValue = $(this).siblings('.backupValue');
                if (nodeName === 'TEXTAREA') {
                    $(this).val($backupValue.val()).trigger('change');
                } else if (nodeName === 'SELECT') {
                    if ($backupValue.val() != "") {
                        $(this).children('option[value=' + $backupValue.val() + ']').prop('selected', true).trigger('change');
                    }
                } else {
                    $(this).prop('checked', $backupValue.val() === 'true').trigger('change');
                }
            });
			<%-- 画面上に表示している確認チェックボックスをバックアップ値に戻す --%>
            var $verifiedCheckBox = $('*[name=VerifiedCheckBox]');
            $.each($verifiedCheckBox, function (index, value) {
                var $backupValue = $(this).siblings('[name="backupVerifiedValue"]');
                $(this).prop('checked', $backupValue.val() === 'true').trigger('change');
            });
			<%-- 変更フラグを全て初期化する --%>
            var i, elementRowsListLength = elementRowsList_.length;
            for (i = 0; i < elementRowsListLength; i++) {
                elementRowsList_[i].isChanged = false;
            }
            return true;
        }

		<%-- 画面表示設定の初期処理（をCookieから取得、無い場合は初期値使用) --%>
        function getConfig() {
            var config = $('#config').val();
            config = config !== '' ? JSON.parse(config) : {};

	        <%-- textareaのフォントサイズ --%>
            var fontSize = '<%= ConfigurationManager.AppSettings["ConfirmTextAreaFontSize"] %>';
            config.fontSize = checkFontSize(fontSize);

	        <%-- 塗りつぶし（色）ASPXで設定済 --%>

	        <%-- 塗りつぶし（透明度） --%>
            var areaOpacity = '<%= ConfigurationManager.AppSettings["ConfirmHighlightAreaOpacity"] %>';
            config.areaOpacity = checkHightlightOpacity(1, areaOpacity);

	        <%-- 線（色）ASPXで設定済 --%>

			<%-- 線（透明度） --%>
            var borderOpacity = '<%= ConfigurationManager.AppSettings["ConfirmHighlightBorderOpacity"] %>';
            config.borderOpacity = checkHightlightOpacity(2, borderOpacity);

			<%-- スキャン画像の表示(幅/高さ)の設定 --%>
            config.answerImageMaxWidth = '<%= ConfigurationManager.AppSettings["ConfirmAnswerImageMaxWidth"] %>';
            config.answerImageMaxHeight = '<%= ConfigurationManager.AppSettings["ConfirmAnswerImageMaxHeight"] %>';
            config.answerImageSentenceMaxWidth = '<%= ConfigurationManager.AppSettings["ConfirmAnswerSentenceImageMaxWidth"] %>';
            config.answerImageSentenceMaxHeight = '<%= ConfigurationManager.AppSettings["ConfirmAnswerSentenceImageMaxHeight"] %>';

            var answerImageSetting = getCookie(COOKIENAME_ANSWER_IMAGE_SETTING);
            if (answerImageSetting) {
                for (var i = 0; i < answerImageSetting.length; i++) {
                    var setting = answerImageSetting[i];
                    if (setting.user == userId_) {
                        if (setting.ai) {
                            if (setting.ai.width) config.answerImageMaxWidth = setting.ai.width;
                            if (setting.ai.height) config.answerImageMaxHeight = setting.ai.height;
                        }
                        if (setting.ais) {
                            if (setting.ais.width) config.answerImageSentenceMaxWidth = setting.ais.width;
                            if (setting.ais.height) config.answerImageSentenceMaxHeight = setting.ais.height;
                        }
                    }
                }
            }

            config.answerImageMaxWidth = checkAnswerImage(1, config.answerImageMaxWidth);
            config.answerImageMaxHeight = checkAnswerImage(2, config.answerImageMaxHeight);
            config.answerImageSentenceMaxWidth = checkAnswerImage(3, config.answerImageSentenceMaxWidth);
            config.answerImageSentenceMaxHeight = checkAnswerImage(4, config.answerImageSentenceMaxHeight);

			<%-- 表示件数の設定 --%>
            config.pageLength = validateAndSet($.cookie(COOKIENAME_PAGE_LENGTH_OTHER_TAB), 10, itemsPerPageChoices);
            if (config.pageLength) {
                backupPageLength_otherTab = Number(config.pageLength);
            }
            backupPageLength_freeEntryTab = validateAndSet($.cookie(COOKIENAME_PAGE_LENGTH_FREE_ENTRY_TAB),3, itemsPerPageChoices);

            return config
        }

		<%-- 該当ページのプレビュー設定情報(倍率/位置)を取得する --%>
        function getPreviewSetting() {
            var page = scanPageInfo_[scanPageIndex_].pageNumber;
            var result = { size: 0, x: 0, y: 0 };
            var previewSetting = getCookie(COOKIENAME_PREVIEW_SETTING);
            if (previewSetting) {
                var userId = userId_;
                for (var i = 0; i < previewSetting.length; i++) {
                    if (previewSetting[i].user == userId) {
                        var setting = previewSetting[i].setting;
                        for (var j = 0; j < setting.length; j++) {
                            if (setting[j].page == page) {
                                result.size = setting[j].size;
                                result.x = setting[j].x;
                                result.y = setting[j].y;
                            }
                        }
                    }
                }
            }
            return result;
        }

		<%-- 該当ページのプレビュー設定情報が存在するかチェックする --%>
        function isPreviewSetting(page) {
            var result = false;
            var previewSetting = getCookie(COOKIENAME_PREVIEW_SETTING);
            if (previewSetting) {
                var userId = userId_;
                for (var i = 0; i < previewSetting.length; i++) {
                    if (previewSetting[i].user == userId) {
                        var setting = previewSetting[i].setting;
                        for (var j = 0; j < setting.length; j++) {
                            if (setting[j].page == page) {
                                result = true;
                                break;
                            }
                        }
                    }
                    if (result) break;
                }
            }
            return result;
        }

		<%-- プレビュー設定情報(倍率/位置)を保存する --%>
        function setPreviewSetting() {
            var size;
            var page = scanPageInfo_[scanPageIndex_].pageNumber;

            var sizeText = $("#scanPageScalingList option:selected").text();
            if (sizeText == '<%= Resources.Messages.EntireImageSizeCaption %>') {
                size = 0;
            } else if (sizeText == '<%= Resources.Messages.HeightImageSizeCaption%>') {
                size = -1;
            } else if (sizeText == '<%= Resources.Messages.WidthImageSizeCaption %>') {
                size = -2;
            } else {
                size = scalingSize_;
            }

            var previewSetting = getCookie(COOKIENAME_PREVIEW_SETTING);
            var userId = userId_;
            if (previewSetting) {
                var isExistedUser = false;
                for (var i = 0; i < previewSetting.length; i++) {
                    if (previewSetting[i].user == userId) {
                        isExistedUser = true;
                        var isExistedSetting = false;
                        for (var j = 0; j < previewSetting[i].setting.length; j++) {
                            if (previewSetting[i].setting[j].page == page) {
                                isExistedSetting = true;
                                previewSetting[i].setting[j].size = size;
                                previewSetting[i].setting[j].x = moveX_;
                                previewSetting[i].setting[j].y = moveY_;
                            }
                        }
                        if (!isExistedSetting) {
                            previewSetting[i].setting.push({ page: page, size: size, x: moveX_, y: moveY_ });
                        }
                    }
                }
                if (!isExistedUser) {
                    previewSetting.push({
                        user: userId,
                        setting: [{ page: page, size: size, x: moveX_, y: moveY_ }]
                    });
                }
            } else {
                previewSetting = [
                    {
                        user: userId,
                        setting: [{ page: page, size: size, x: moveX_, y: moveY_ }]
                    }
                ];
            }
            setCookie(COOKIENAME_PREVIEW_SETTING, previewSetting);
        }

		<%-- 画面初期処理 --%>
        $(function () {
            userId_ = $('#userId').val();
            jobIds_ = $('#businessRecordIds').val().split(',');
            formId_ = $('#formId').val();
            formName_ = $('#formName').val();
            businessId_ = $('#businessId').val();

            $('#scanPagePanel').css('height', scanImageAreaHeight_);
            scanPagePanelWidth_ = parseInt($('#scanPagePanel').css('width').slice(0, -2), 10);
            scanPagePanelHeight_ = parseInt($('#scanPagePanel').css('height').slice(0, -2), 10);
            $("#tabs").xuxTabbedSet();
            $("#configDialog").xuxModalWindow({});
			<%-- ajaxの初期化 --%>
            $.ajaxSetup({
                cache: false,
                global: false,
                error: function (XMLHttpRequest, textStatus, errorThrown) {
                    if (XMLHttpRequest.status == 200) {
                        timeout();
                        return;
                    }
                    alertMessageEror('<%= Resources.Messages.AjaxErrorMessage %>');
                    isUpdating_ = false;
                    removeLoading();
                }
            });

			<%-- スキャンページ読み込み --%>
            function loadScanPageImage() {
                if (!scanPageInfo_ || scanPageInfo_.length == 0) {
                    return;
                }
                $("#recordId").text(scanPageInfo_[scanPageIndex_].businessRecordId);

                var imageWidth = scanPageInfo_[scanPageIndex_].width.toFixed(0);
                var imageHeight = scanPageInfo_[scanPageIndex_].height.toFixed(0);
                var widthScaleSize = ((Number($('#scanPagePanel').css('width').slice(0, -2)) - 20) / imageWidth).toFixed(2) * 100;
                var heightScaleSize = ((Number($('#scanPagePanel').css('height').slice(0, -2)) - 20) / imageHeight).toFixed(2) * 100;

                <%-- Cookieより設定情報を取得する --%>
                var previewSetting = getPreviewSetting();

                <%-- 全体表示サイズを計測 --%>
                var defaultSize = 0;
                if (widthScaleSize > heightScaleSize) {
                    defaultSize = heightScaleSize;
                } else {
                    defaultSize = widthScaleSize;
                }

                <%-- 表示倍率設定 --%>
                var scaleParam = 0;
                if (previewSetting.size == 0) {
                    <%-- AR67831 --%>
                    if (isPreviewSetting(scanPageInfo_[scanPageIndex_].pageNumber)) {
                        <%-- Cookieあり --%>
                        scaleParam = defaultSize;
                    } else {
                        <%-- Cookieなし --%>
                        if (widthScaleSize > heightScaleSize) {
                            scaleParam = widthScaleSize;
                        } else {
                            scaleParam = heightScaleSize;
                        }
                    }
                } else if (previewSetting.size == -1) {
                    scaleParam = heightScaleSize;
                } else if (previewSetting.size == -2) {
                    scaleParam = widthScaleSize;
                } else {
                    scaleParam = previewSetting.size;
                }
                scaleParam = tmpScalingParam_ = scaleParam / 100;
                scaledScanPageImageWidth_ = scanPageInfo_[scanPageIndex_].width.toFixed(0) * scaleParam;
                scaledScanPageImageHeight_ = scanPageInfo_[scanPageIndex_].height.toFixed(0) * scaleParam;

                <%-- 表示位置設定 --%>
                moveX_ = previewSetting.x;
                moveY_ = previewSetting.y;
                $('#scanPagePanel').scrollLeft(moveX_).scrollTop(moveY_);

                createScalingCombobox(defaultSize, heightScaleSize, widthScaleSize, previewSetting);
                var $scanPageImage = $('#scanPageImage');
                $scanPageImage.css('-webkit-transform', 'scale(' + scaleParam + ')');
                $scanPageImage.css('-moz-transform', 'scale(' + scaleParam + ')');
                $scanPageImage.css('-o-transform', 'scale(' + scaleParam + ')');
                $scanPageImage.css('-ms-transform', 'scale(' + scaleParam + ')');
                $scanPageImage.css('transform', 'scale(' + scaleParam + ')');
                $scanPageImage.bind('load', function () {
                    var imageSizeX = parseInt($(this).css('width').slice(0, -2), 10) * scaleParam;
                    var imageSizeY = parseInt($(this).css('height').slice(0, -2), 10) * scaleParam;
                    <%-- 表示位置が無効な範囲の場合は原点表示 --%>
                    if (imageSizeX < moveX_ || imageSizeY < moveY_) moveX_ = moveY_ = 0;
                    $('#scanPagePanel').scrollLeft(moveX_).scrollTop(moveY_);

                    if (!$('.scanPageArea').is(':hidden')) {
                        <%-- プレビュー閉じるボタンの幅、プレビュー枠のpadding・borderを考慮して、プレビュー閉じるボタンを移動--%>
                        previewSpaceWidth_ = (parseInt($('#previewVisibleDisable').css('width').slice(0, -2), 10) / 2) - (parseInt($('#scanPagePanel').css('padding-left').slice(0, -2), 10) * 2) - 2 - (parseInt($('.scanPagePanel').css('margin-left').slice(0, -2), 10) * 2) - 2;
                        changePreviewCloseBtnPosition(previewSpaceWidth_);
                        $('#previewVisibleDisable').show();
                    }
                });
                $scanPageImage.attr('src', 'api/ScanPageImage?scanPageId=' + scanPageInfo_[scanPageIndex_].scanPageId);
                $('#scanPageIndex').text(1 + scanPageIndex_);
                var scanPageInfoLength = scanPageInfo_.length;
                if (scanPageInfoLength == 1) {
                    prevScanPageFlg = false;
                    nextScanPageFlg = false;
                } else {
                    if (0 === scanPageIndex_) {
                        prevScanPageFlg = false;
                        nextScanPageFlg = true;
                    } else if (scanPageIndex_ === scanPageInfoLength - 1) {
                        prevScanPageFlg = true;
                        nextScanPageFlg = false;
                    } else {
                        prevScanPageFlg = true;
                        nextScanPageFlg = true;
                    }
                }
                showPreviewPageButton(prevScanPageFlg, nextScanPageFlg);
            }

			<%-- スキャンページ情報取得 --%>
            $.ajax({
                type: 'POST',
                url: 'api/ScanPageInfo',
                contentType: 'application/json',
                data: JSON.stringify({ jobId: jobIds_, formId: formId_ }),
                success: function (data, dataType) {
                    scanPageInfo_ = data;
                    $('#scanPageCount').text(scanPageInfo_.length);
                    scanPageIndex_ = 0;
                    if (!scanPageInfo_ || scanPageInfo_.length == 0) {
                        $('#scanPageIndex').text(scanPageIndex_);
                        showPreviewScaleButton(false, false);
                        showPreviewPageButton(false, false);

                        return;
                    }
                    loadScanPageImage();
                }
            });

			<%-- 表示形式タブの定義 --%>
            var TabDefs = [
                { elementType: 3, elementValue: true },
                { elementType: 3, elementValue: false },
                { elementType: 2, elementValue: 0 },
                { elementType: 2, elementValue: 1 },
                { elementType: 2, elementValue: 2 },
                { elementType: 2, elementValue: 3 },
                { elementType: 2, elementValue: 4 },
                { elementType: 2, elementValue: 5 },
                { elementType: 2, elementValue: 6 },
                { elementType: 2, elementValue: 7 },
                { elementType: 2, elementValue: 8 },
                { elementType: 2, elementValue: 9 },
                { elementType: 2, elementValue: null },
                { elementType: 1, elementValue: '' }
            ];

            function loadTabData(isFirstOnly) {
                removeQuestionColoring();
                elementRowsList_ = [];
                //$elementsTable_.clear();
                //$elementsTable_.columns.adjust();
                //$elementsTable_.draw();
                verifiedCount_ = unverifiedCount_ = 0;
                isOperationCanceled_ = false;
                backupPageNumber_ = 0;
                backupSearchFilter_ = '';
                ElementImageIdIndex = 2;
                ElementValueIndex = 3;
                VerifiedIndex = 4;
                //$('#elementsTable').dataTable().fnSetColumnVis(SubElementNameIndex, true, false);
                //$('#elementsTable').dataTable().fnSetColumnVis(ElementValueIndex, true, false);
                $('#tabTitleScan').html('<%= Resources.Messages.ElementImageColumnName %>');
			        <%-- 列制御 --%>
                if (tabIndex_ == 13) {
		            <%-- 「選択肢」「値」非表示 --%>
                    //$('#elementsTable').dataTable().fnSetColumnVis(SubElementNameIndex, false, false);
                    //$('#elementsTable').dataTable().fnSetColumnVis(ElementValueIndex, false, false);
                    ElementImageIdIndex = 1;
                    ElementValueIndex = 2;
                    VerifiedIndex = 2;
                    $('#tabTitleScan').html('<%= Resources.Messages.ScanImageRecognitionResulsColumnName %>');
                } else if (tabIndex_ >= 2) {
			    	<%-- 「選択肢」非表示 --%>
                    //$('#elementsTable').dataTable().fnSetColumnVis(SubElementNameIndex, false, false);
                    //$('#elementsTable').dataTable().fnSetColumnVis(ElementValueIndex, true, false);

                    ElementImageIdIndex = 1;
                    ElementValueIndex = 2;
                    VerifiedIndex = 3;
                }
                dispFormatLoading("<%= Resources.Messages.ProcessingMessage %>");
				<%-- スキャン結果一覧の表示(POST対応) --%>
                $.ajax({
                    type: 'POST',
                    url: 'api/QuestionnaireFormatElementRows',
                    contentType: 'application/json',
                    data: JSON.stringify({ jobId: jobIds_, formId: formId_, elementType: TabDefs[tabIndex_].elementType, elementValue: TabDefs[tabIndex_].elementValue }),
                    success: function (data, dataType) {
                        
                        var dataLength = data.length;
                        for (var i = 0; i < dataLength; i++) {
                            var row = data[i];
					    	<%-- 業務レコードIDがundefinedの場合、セッションタイムアウトでログイン画面が返却されているためセッションタイムアウト処理を実施. --%>
                            if (typeof row.businessRecordId === "undefined") {
                                isParentClosed_ = true;
                                window.close();
                                return;
                            }
					    	<%-- 選択肢の場合は選択ステータスの値をbooleanに変換 --%>
                            if (row.elementType === 3) {
                                row.elementValue = row.elementValue === 'True';
                            } else if (row.elementType === 1 || row.elementType === 4 || row.elementType === 5) {
                                row.elementValue = doSanitaizeEncode(row.elementValue);
                            }
							<%-- 確認済、未確認の件数をカウント --%>
                            if (row.isVerified) {
                                verifiedCount_++;
                            } else {
                                unverifiedCount_++;
                            }

                            aoData[row.elementImageId] = {
                                _aFilterData: [row.elementName, row.subElementName, "", row.elementValue, row.isVerified]
                            };
                        }
                        
                        if (data.length <= 0) {
                            var tempNull = [];
                            elementRowsList_ = tempNull;
                        } else {
                            elementRowsList_ = data;
                        }
                        
						<%-- DataTablesを一旦クリアし、取得したデータを設定 --%>
                        //$elementsTable_.clear().rows.add(data);
                        //DataTableOptions = null;
                        
                        if (DataTableOptions == null) {
                            renderTable(elementRowsList_);
                        } else {
                 
                            var tempDataTable = toggleQuestionSort($elementsTable_, DataTableOptions.sortOptions.column, DataTableOptions.sortOptions.order, null);
                            
                            renderTable(tempDataTable);
                        }
                        
						<%-- DataTablesのカラム幅調整 --%>
                        //$elementsTable_.columns.adjust();
						<%-- DataTablesの描画 --%>
                        //$elementsTable_.draw();


						<%-- 行選択 --%>
                        if (prevData_ != null && 0 < prevData_.length) {
                            var prevIndex = -1;
                            for (var i = 0; i < prevData_.length; i++) {
                                if (prevData_[i].elementDataId == selectedElementDataId_) {
                                    prevIndex = i;
                                    break;
                                }
                            }
                            //if (prevIndex != -1) {
                            //    var currentData_ = $('#elementsTable').DataTable().rows({ filter: 'applied' }).data();
                            //    if (0 < currentData_.length) {
                            //        var targetRowIndex = -1;
                            //        for (var i = prevIndex; 0 <= i; i--) {
                            //            for (var j = 0; j < currentData_.length; j++) {
                            //                if (prevData_[i].elementDataId == currentData_[j].elementDataId) {
                            //                    targetRowIndex = j;
                            //                    break;
                            //                }
                            //            }
                            //            if (targetRowIndex != -1) {
                            //                var pageLength = $('#elementsTable').DataTable().page.info().length;

                            //                if (pageLength <= targetRowIndex) {
                            //                    var oSettings = $('#elementsTable').DataTable().settings()[0];
                            //                    oSettings._iDisplayStart = Math.floor(targetRowIndex / pageLength) * pageLength;
                            //                    oSettings.oApi._fnDraw(oSettings);

                            //                    targetRowIndex = targetRowIndex % pageLength;
                            //                }

                            //                var $oTable = $('#elementsTable').dataTable();
                            //                if ($oTable != null) {
                            //                    $oTable.find('tbody tr:nth-child(' + (targetRowIndex + 1) + ')').click();
                            //                }
                            //                break;
                            //            }
                            //        }
                            //    }
                            //}
                        }
                    },
                    complete: function (XMLHttpRequest, textStatus) {
                        //createFilterDialog(0, null);
                        $("#columnPopup").xuxModalWindow({});
                    }
                });
            }

			<%-- 表示形式タブ変更イベント --%>
            $('#tabs').xuxTabbedSet({
                active: 0,              
                activate: function (event, ui) {
                    for (var i = 0; i < DataTableOptions.columns.length; i++) {
                        DataTableOptions.columns[i].searchTableColumnDirection = "";
                    }
                    
                    if (isParentClosed_) window.close();
                    var clickUi = ui;
                    if (!isAliveSession()) return false;
                    /*clickUi.newTab.removeClass("ui-state-focus");*/
                    var changedRows = getChangedElementRows();
                    if (0 < changedRows.length || isUpdating_) {
                       <%-- if (!confirm('<%= Resources.Messages.ConfirmDataChangedMessage %>')) {
                            return false;
                        }--%>
                        if (tabIndex_ != ui.newTab.index()) {
                            confirmMessageEror('<%= Resources.Messages.ConfirmDataChangedMessage %>', function () {

                                tabClickBindTable(clickUi);
                            }, function () {
                                clickUi.oldTab.focus();
                                $('#tabs').xuxTabbedSet({ active: tabIndex_ });
                                var interval = setInterval(function () {
                                    clickUi.newTab.removeClass("ui-state-focus");
                                }, 50);
                                setTimeout(function () {
                                    clickUi.newTab.removeClass("ui-state-focus");
                                    clearInterval(interval);
                                }, 400);

                            }, '<%= Resources.Messages.OkButtonCaption %>', '<%= Resources.Messages.CancelButtonCaption %>');
                        }
                    } else {
                        tabClickBindTable(clickUi);
                    }
                   
                }
            });
            //$(".tabItem").click(function () {
            //    $(this).removeClass("ui-state-focus");
            //});
            function tabClickBindTable(ui) {
                $filterDialogHeader_ = null;
                currentPage = 1;
                isApplyButton = false;
                isChangeTab_ = true;
                var allVerifiedCheckBox = $('#allVerifiedCheckBox');
                if (allVerifiedCheckBox.is(':checked')) {
                    allVerifiedCheckBox.prop('checked', false).trigger('change');
                }
                isChangeTab_ = false;
                tabIndex_ = ui.newTab.index();

                prevData_ = null;
                DataTableOptions = null;
                loadTabData(true);
            }
            loadTabData(true);
            var config = getConfig();

			<%-- スキャン結果一覧のヘッダー部に表示する項目名の定義 --%>
            var DataTableColumns = [
				<%-- 設問名 --%>
                { title: '<span class="FilterDialog"><%= Resources.Messages.ElementNameColumnName %></span>', data: 'elementName', orderable: false, width: TABLE_WIDTH_QUESTION + 'px' },
				<%-- 選択肢 --%>
                { title: '<span class="FilterDialog"><%= Resources.Messages.SubElementNameColumnName %></span>', data: 'subElementName', orderable: false, width: TABLE_WIDTH_SELECT + 'px' },
				<%-- スキャン画像 --%>
                { title: '<span id="tabTitleScan"><%= Resources.Messages.ElementImageColumnName %></span>', data: 'elementImageId', searchable: false, sortable: false },
				<%-- 値 --%>
                { title: '<span class="FilterDialog"><%= Resources.Messages.ElementValueColumnName %></span>', data: 'elementValue', orderable: false, width: TABLE_WIDTH_VALUE + 'px' },
				<%-- 確認チェックボックス --%>
                { title: '<span class="FilterDialog"><%= Resources.Messages.VerifiedColumnName %></span>&nbsp;<input id="allVerifiedCheckBox" type="checkbox" class="confirmCheckBox">&nbsp;&nbsp;', data: 'isVerified', orderable: false, width: TABLE_WIDTH_CONFIRM + 'px' }
            ];

			<%-- 各ヘッダー部に表示する項目名のインデックス --%>
            var SubElementNameIndex = 1;
            var ElementImageIdIndex = 2;
            var ElementValueIndex = 3;
            var VerifiedIndex = 4;

			<%-- スキャン結果一覧で操作した内容（値、確認の変更）をDataTablesの実データに反映 --%>
            function updateInnerValue(rowIndex, valueIndex, value) {
                aoData[rowIndex]._aFilterData[valueIndex] = value;
                aoData[rowIndex]._aFilterData[valueIndex + 1] = value;
            }


			<%-- DataTablesの作成 --%>
            //$('#elementsTable').DataTable(DataTableOptions);
           
            <%-- 前ページ表示ボタン --%>
            $('#prevScanPageButtonEnable').click(function () {
                if (0 < scanPageIndex_) {
                    setPreviewSetting();

                    scanPageIndex_--;
                    removeQuestionColoring();
                    loadScanPageImage();
                    nextScanPageFlg = true;
                }
                prevScanPageFlg = scanPageIndex_ === 0 ? false : true;
                showPreviewPageButton(prevScanPageFlg, nextScanPageFlg);

                return false;
            });
            <%-- 次ページ表示ボタン --%>
            $('#nextScanPageButtonEnable').click(function () {
                if (scanPageIndex_ < scanPageInfo_.length - 1) {
                    setPreviewSetting();

                    scanPageIndex_++;
                    removeQuestionColoring();
                    loadScanPageImage();
                    prevScanPageFlg = true;
                }
                nextScanPageFlg = scanPageIndex_ === (scanPageInfo_.length - 1) ? false : true;
                showPreviewPageButton(prevScanPageFlg, nextScanPageFlg);

                return false;
            });
            <%-- 帳票イメージ拡大ボタン --%>
            $('#scanPageExpandButtonEnable').click(function () {
                var $scanPageScalingList = $('#scanPageScalingList');
                if (!$scanPageScalingList) {
                    return;
                }
                redScaleFlg = true;
                var selectVal = $scanPageScalingList.children('option:selected').val();
                var currentscalingSize = 0;
                if (selectVal !== 'scalling') {
                    currentscalingSize = Number(selectVal) + 10;
                } else {
                    currentscalingSize = scalingSize_ + 10;
                }
                if (currentscalingSize <= 400) {
                    scalingSize_ = currentscalingSize;
                    $scanPageScalingList.children('option[value=scalling]').prop('selected', true)
                    $('#scanPageScalingList').xuxDropdown().xuxDropdown('refresh');
                    onChangeScaling(scalingSize_);
                }
                expScaleFlg = currentscalingSize >= 400 ? false : true;
                showPreviewScaleButton(expScaleFlg, redScaleFlg);

                return false;
            });

            <%-- 帳票イメージ縮小ボタン --%>
            $('#scanPageReduceButtonEnable').click(function () {
                var $scanPageScalingList = $('#scanPageScalingList');
                if (!$scanPageScalingList) {
                    return;
                }
                expScaleFlg = true;
                var selectVal = $scanPageScalingList.children('option:selected').val();
                var currentscalingSize = 0;
                if (selectVal !== 'scalling') {
                    currentscalingSize = Number(selectVal) - 10;
                } else {
                    currentscalingSize = scalingSize_ - 10;
                }
                if (10 <= currentscalingSize) {
                    scalingSize_ = currentscalingSize;
                    $scanPageScalingList.children('option[value=scalling]').prop('selected', true);
                    $('#scanPageScalingList').xuxDropdown().xuxDropdown('refresh');
                    onChangeScaling(scalingSize_);
                }
                redScaleFlg = currentscalingSize <= 10 ? false : true;
                showPreviewScaleButton(expScaleFlg, redScaleFlg);

                return false;
            });

            <%-- 表示設定ダイアログ初期化 未対応2021-08-23--%>

            <%-- 表示設定入力チェック --%>
            function checkSize(name) {
                var $answerImageMax = $('#' + name);

                var val = $answerImageMax.val();
                if (val === '') {
                    alertMessageInfo("<%= Resources.Messages.DiscrepancyAnswerImageNotInput %>");
                    return;
                }
                var regexp = new RegExp(/^[1-9][0-9]*$/);
                var isInputError = false;
                if (!val.match(regexp)) {
                    isInputError = true;
                }
                var limitSize = new Number('<%= ConfigurationManager.AppSettings["AnswerImageSizeMaxLimit"] %>');
                if (isInputError || val > limitSize) {
                    var alertMsg = "<%= Resources.Messages.DiscrepancyAnswerImageSize %>";
                    alertMessageInfo(alertMsg.replace("_MAX_", limitSize));
                    return false;
                }
                return true;
            }
            


            function PostElementRows(doExportCsv) {
                dispFormatLoading("<%= Resources.Messages.ProcessingMessage %>");
                isUpdating_ = true;

                var doExportCsv = doExportCsv === undefined ? false : doExportCsv;
		        <%-- 更新処理 --%>
                $.ajax({
                    type: 'POST',
                    url: 'api/QuestionnaireFormatElementRowsUpdate',
                    contentType: 'application/json',
                    data: JSON.stringify({ formId: formId_, formName: formName_, userId: userId_, elementRows: getChangedElementRows(), isExportCsv: doExportCsv }),
                    success: function (data, dataType) {
                        isUpdating_ = false;
                        var remainList = data != null ? data.RemainList : null;
                        var failList = data != null ? data.FailList : null;
                        if (failList != null && 0 < failList.length) {
                            // CSV出力に失敗したレコードがある場合は通知
                            alertMessageInfo('<%= Resources.Messages.ConfirmExportDataFailMessage %>' + "\r\n" + failList.join("\r\n"));
                        }
                        remainRecordIds_ = remainList;
                        if (remainRecordIds_ == null || remainRecordIds_.length == 0) {
                            // 表示レコードなし
                            windowGlobal.unbind('beforeunload');   // 警告を出さない。
                            window.open('about:blank', '_self').close();
                            return;
                        }
                        prevData_ = elementRowsList_;//$('#elementsTable').DataTable().rows({filter: 'applied'}).data();

                        // レコードデータ出力（削除レコード対応）
                        if (jobIds_.length > remainRecordIds_.length) {
                            remainRecordIds_ = remainRecordIds_.map(function (element) { return String(element); });
                            var tmpIds = [];
                            for (var i = 0; i < jobIds_.length; i++) {
                                if (remainRecordIds_.indexOf(jobIds_[i]) >= 0) {
                                    tmpIds.push(jobIds_[i]);
                                }
                            }
                            jobIds_ = tmpIds;

                            $.ajax({
                                type: 'POST',
                                url: 'api/ScanPageInfo',
                                contentType: 'application/json',
                                data: JSON.stringify({ jobId: jobIds_, formId: formId_ }),
                                success: function (data, dataType) {
                                    scanPageInfo_ = data;
                                    $('#scanPageCount').text(scanPageInfo_.length);
                                    scanPageIndex_ = 0;
                                    if (!scanPageInfo_ || scanPageInfo_.length == 0) {
                                        $('#scanPageIndex').text(scanPageIndex_);
                                        showPreviewScaleButton(false, false);
                                        showPreviewPageButton(false, false);

                                        return;
                                    }
                                    loadScanPageImage();
                                }
                            });
                        }

                        loadTabData(true);
                        removeLoading();
                        // レコード一覧に更新情報を反映
                        opener.NoticeConfirmCorrectUpdate();
                    },
                    error: function (XMLHttpRequest, textStatus, errorThrown) {
                        if (XMLHttpRequest.status == 401) {
                            removeLoading();
                            timeout();
                            return;
                        }
                        alertMessageEror('<%= Resources.Messages.FailedToUpdateMsg %>');
                        removeLoading();
                    },
                });
            }

            $('#colorMode, #bothSide, #layout').change(function () {
                ChangeSelect($(this));
            });

            $('#scanPagePanel').mousedown(function (e) {
                var $scanPagePanel = $('#scanPagePanel');
                $scanPagePanel.css('cursor', 'url(image/hand_drag_p24_24.png), url(image/hand_drag.cur), move');
                var bx = e.pageX;
                var by = e.pageY;
                $(document).on('mousemove.move', function (e) {
                    if (scaledScanPageImageWidth_ > scanPagePanelWidth_) {
                        moveX_ += bx - e.pageX;
                        bx = e.pageX;
                        if (moveX_ < 0) moveX_ = 0;
                        if (moveX_ > scaledScanPageImageWidth_ - scanPagePanelWidth_) moveX_ = scaledScanPageImageWidth_ - scanPagePanelWidth_;
                    }
                    if (scaledScanPageImageHeight_ > scanPagePanelHeight_) {
                        moveY_ += by - e.pageY;
                        by = e.pageY;
                        if (moveY_ < 0) moveY_ = 0;
                        if (moveY_ > scaledScanPageImageHeight_ - scanPagePanelHeight_) moveY_ = scaledScanPageImageHeight_ - scanPagePanelHeight_;
                    }
                    if (isBrowserChrome()) {
                        $scanPagePanel.css('overflow', 'auto').scrollLeft(moveX_).scrollTop(moveY_);
                        $scanPagePanel.css('overflow', 'hidden').scrollLeft();
                    } else {
                        $scanPagePanel.scrollLeft(moveX_).scrollTop(moveY_);
                    }
                    return false;
                }).one('mouseup', function () {
                    $scanPagePanel.css('cursor', 'url(image/hand_hover_p24_24.png), url(image/hand_hover.cur), move');
                    $(document).off('mousemove.move');
                });
                return false;
            })
                .hover(function () {
                    $(this).css('cursor', 'url(image/hand_hover_p24_24.png), url(image/hand_hover.cur), move');
                }, function () {
                    $(this).css('cursor', 'auto');
                });
            $('#previewVisible').click(function () {
                if ($('.scanPageArea').is(':hidden')) {
                    $('.scanPageArea').show();
                    $('.areaSeparator').width(0);
                    $('#previewVisibleEnable').hide();
                    changePreviewCloseBtnPosition(previewSpaceWidth_);
                    $('#previewVisibleDisable').show();
                } else {
                    $('.scanPageArea').hide();
                    $('.areaSeparator').width(24);
                    $('#previewVisibleEnable').show();
                    $('#previewVisibleDisable').hide();
                }
                //$elementsTable_.columns.adjust().draw();
                return false;
            });

            $(window).resize(function () {
                <%-- プレビュー閉じるボタンの幅、プレビュー枠のpadding・borderを考慮して、プレビュー閉じるボタンを移動 --%>
                changePreviewCloseBtnPosition(previewSpaceWidth_);
                <%-- 画面のサイズによってスキャン画像の大きさを変更する --%>
                var tableWidth = parseInt($('#elementsTableDiv').css('width').slice(0, -2), 10);
                if (tabIndex_ == 13) {
                    scanTabWidth_ = tableWidth - TABLE_WIDTH_QUESTION - TABLE_WIDTH_SELECT - TABLE_WIDTH_CONFIRM;
                } else {
                    scanTabWidth_ = tableWidth - TABLE_WIDTH_QUESTION - TABLE_WIDTH_SELECT - TABLE_WIDTH_VALUE - TABLE_WIDTH_CONFIRM;
                }
                var ansImgMaxWidth = scanTabWidth_ < config.answerImageMaxWidth ? scanTabWidth_ : config.answerImageMaxWidth;
                var ansImgSenMaxWidth = scanTabWidth_ < config.answerImageSentenceMaxWidth ? scanTabWidth_ : config.answerImageSentenceMaxWidth;
                $('img.thumb').css('max-width', ansImgMaxWidth + 'px');
                $('img.thumbSentence').css('max-width', ansImgSenMaxWidth + 'px');
            });
            //-----------------------2021/08/23 add begin--------------------------//
            
            var selectelementImageId = "";
            var searchDisplayItems = null;
            function renderTable(displayItems) {

                var isFirstLoad = false;
                searchDisplayItems = displayItems;
                <%-- DataTablesオプションの定義 --%>
                if (DataTableOptions == null) {
                    createJobTable();
                    var tablePageLength = backupPageLength_otherTab
                    if(tabIndex_ == 13){
                        tablePageLength = backupPageLength_freeEntryTab
                    }
                    DataTableOptions = {
                        data: function (params) {
						    var end = 0;
							<%-- 選択されたページでレコードの開始位置 --%>
                            var start = params.start;
							<%-- 表示ページの総件数 --%>
                            var count = params.count;
							<%-- 総件数 --%>
                            var sumNumber = searchDisplayItems.length;
							 <%-- 総件数＜=選択されたページでレコードの開始位置　+　表示ページの総件数 --%>
                            if (sumNumber <= start + count) {
							    <%-- 総件数は終了位置を設定する --%>
                                end = sumNumber;
                            } else {
								<%-- 選択されたページでレコードの開始位置　+　表示ページの総件数は終了位置を設定する --%>
                                end = start + count;
                            }
							<%--　アンケートビューのリストで開始位置から終了位置まで取得する --%>
                            var tempPageitems = searchDisplayItems.slice(start, end);
                            return {
                                "numberOfAllItems": searchDisplayItems.length,
                                "fields": getTableFields(),
                                "items": tempPageitems
                            }
                        },
                        columns: getTableTbody(displayItems),
                        pageNavigation: 'bottom',
                        columnResizable: false,
                        focusUnit: "none",
                        //size: 'full',
                        hoverState: true,
                        autoLoad: true,
                        labelLayout: 'leading',
                        selectionUnit: 'row',
                        selectionRemains: true,
                        itemId: 'elementImageId',
                        pageNumbers: true,
                        itemsPerPage:tablePageLength,
                        dropdown: false,
                        itemNumbers: true,
                        pagesPerLoad: tablePageLength,
                        itemsPerPageChoices: itemsPerPageChoices,
                        itemsPerPagePosition: "bottom",
                        clear: true,
                        endButtons: true,
                        sortOptions: {
                            column: 0,
                            order: 'asc'
                        },
                        multipleSelections: false,
                        //search: true,
                        noRowMessage: '<%= Resources.Messages.DataTableZeroRecordsMessage %>',
                        changeItemsPerPage: function (event, ui) {
                            if (tabIndex_ == 13) {
                                backupPageLength_freeEntryTab = ui.value;
                                $.cookie(COOKIENAME_PAGE_LENGTH_FREE_ENTRY_TAB, backupPageLength_freeEntryTab)
                            }
                            else {
                                backupPageLength_otherTab = ui.value;
                                $.cookie(COOKIENAME_PAGE_LENGTH_OTHER_TAB, backupPageLength_otherTab)
                            }
                            currentPage = 1;
                            isApplyButton = false;
                        },
                        afterRender: function () {
                            tempData = elementRowsList_;
                            // ページナビゲーションでmousedownイベントを追加する
                            $('#elementsTableDiv .xux-pageNavigation-bottom').mousedown(function (event) {
                                 // 現在のページをクリックした場合は直接戻ります。
                                if (!$(event.originalEvent.target).is('a')) {
                                    return;
                                }

                                // 現在フォーカスされている要素を取得する。
                                var focusedElement = document.activeElement; 

                                //要素がテキストエリアの場合
                                if (focusedElement && focusedElement.tagName === 'TEXTAREA') {
                                    // 現在フォーカスされているテキストエリアがフォーカスを失う
                                    focusedElement.blur(); 
                                }

                                // 編集した行を取得する
                                var changedRows = getChangedElementRows();

                                // 編集した場合
                                if (0 < changedRows.length || isUpdating_) {
                                    confirmMessageEror('<%= Resources.Messages.ConfirmDataChangedMessage %>', function () {
                                        restoreValue();
                                         // ページナビゲーションのイベントを復元する。
                                        $('#elementsTableDiv .xux-pageNavigation-bottom').css('pointer-events', '');
                                         // 元のクリックイベントをトリガーする。
                                        $(event.originalEvent.target).trigger('click');       

                                    }, function () {
                                         // ページナビゲーションのイベントを復元する。
                                        $('#elementsTableDiv .xux-pageNavigation-bottom').css('pointer-events', '');  

                                    }, '<%= Resources.Messages.OkButtonCaption %>', '<%= Resources.Messages.CancelButtonCaption %>');

                                    // ページナビゲーションのイベントを無効にする。
                                    $('#elementsTableDiv .xux-pageNavigation-bottom').css('pointer-events', 'none');
                                    currentPage = 1;
                                    isApplyButton = false;
                                }
                            });

                            var trTemp = 0;
                            if (tabIndex_ < 13) {
                                if (tempData.length > 0) {
                                    for (var i = 0; i < tempData.length; i++) {
                                        if (selectelementImageId) {
                                            if (selectelementImageId.toString().indexOf("Confirm") > 0) {
                                                var selectelementImageIdTemp = selectelementImageId.replace("Confirm", "");
                                                if (tempData[i].elementImageId == selectelementImageIdTemp) {
                                                    selectelementImageId = elementRowsList_[i].elementImageId;
                                                    break;
                                                }
                                            } else {
                                                if (tempData[i].elementImageId == selectelementImageId) {
                                                    if (elementRowsList_[i - 1]) {
                                                        selectelementImageId = elementRowsList_[i - 1].elementImageId;
                                                        break;
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                            
                            $("#elementsTable").find("tr").each(function () {
                                trTemp = trTemp + $(this).height();
                                if ($(this).find("td").first().find('input').first().val() == selectelementImageId) {
                                    $(this).addClass("xux-table-selected");
                                }
                            });

                            selectelementImageId = "";
                            if (trTemp < 607) {
                                //$("#elementsTable").find("tbody").first().css("width", "calc( 100% - 1em )");
                            }
                            //$("#elementsTableDiv").find(".xux-decoratedTable-trailingBox").eq(1).css("display", "none");
                            $("#dialog-confirm").xuxModalWindow({});
                       	    <%-- 表示設定ボタン --%>
                            <%--  var $configButton = $('<input type="button" id="configButton" value="<%= Resources.Messages.ConfigButtonCaption %>" />')
                                .click(function () {
                                    if (!isAliveSession()) return false; --%>

					            <%-- 表示設定ダイアログを開く --%>
                                <%-- $('#answerImageMaxWidth').val(config.answerImageMaxWidth);
                                    $('#answerImageMaxHeight').val(config.answerImageMaxHeight);
                                    $('#answerImageSentenceMaxWidth').val(config.answerImageSentenceMaxWidth);
                                    $('#answerImageSentenceMaxHeight').val(config.answerImageSentenceMaxHeight);
                                    $("input[type=text]").xuxTextField();
                                    $("#configDialog").xuxModalWindow("open");//$configDialog.dialog('open');
                                }); --%>

			                <%-- 確認済カウント、未確認カウント、表示設定ボタンの描画 --%>
                            <%--  var tempHtmp = $("#elementsTableDiv").find('.ui-helper-clearfix').first().html();
                            if (tempHtmp == "") {
                                $("#elementsTableDiv").find('.ui-helper-clearfix').first()
                                    .append("<%= Resources.Messages.VerifiedCountCaption %>")
                                    .append($('<span id="verifiedCount"></span>'))
                                    .append("<%= Resources.Messages.DataTableLengthMenuCaption %>")
                                    .append("&nbsp;&nbsp;")
                                    .append("<%= Resources.Messages.UnverifiedCountCount %>")
                                    .append($('<span id="unverifiedCount"></span>'))
                                    .append("<%= Resources.Messages.DataTableLengthMenuCaption %>")
                                    .append($configButton);
                            } --%>

                            <%-- 確認済、未確認のカウント表示 --%>
                            $('#verifiedCount').text(verifiedCount_);
                            $('#unverifiedCount').text(unverifiedCount_);
                            //$('.FilterDialog').unbind("click");
                            //$('.FilterDialog').click(function () {
                            //    var clickColumn = parseInt($(this).attr("columnindex"));
                            //    var columnDef = DataTableOptions.columns[clickColumn];
                            //    if (columnDef.sortable === false) {
                            //        return;
                            //    }
                            //    if (columnDef.sortable !== false) {

                            //    }


                            //    if (DataTableOptions.columns[clickColumn].searchTableColumnDirection == "asc") {
                            //        toggleQuestionSort($elementsTable_, clickColumn, 'desc');
                            //    } else if (DataTableOptions.columns[clickColumn].searchTableColumnDirection == "") {
                            //        toggleQuestionSort($elementsTable_, clickColumn, 'asc');
                            //    } else {
                            //        toggleQuestionSort($elementsTable_, clickColumn, 'asc');
                            //    }
                            //    //$("#columnPopup").xuxModalWindow("open");
                            //    //createFilterDialog(-1, $(this));
                            //    $("#columnPopupTitel").html($(this).html());
                            //});
                            resetTableHeadercolor();
                            $("textarea").xuxTextArea();
                            $("input[type=checkbox]").xuxCheckbox();
                            $("input[type=button]").xuxButton();
							$("#elementsTable").find("select").xuxDropdown({ width: 'full' });
                            $("#elementsTable").find("thead").first().css("padding", "0px");
                            $('#tabs').find("ul").css("margin-top", "0px");
                            $('#tabs').find("ul").css("margin-bottom", "0px");
                            if (allVerifiedCheckBoxValue != null) {
                                if (allVerifiedCheckBoxValue) {
                                    $("#allVerifiedCheckBox").prop("checked", true).xuxCheckbox("refresh");
                                }
                            }
                            $(".confirmTextArea").focus(function () {
                                var tempelementImageId = $(this).attr("elementImageId");
                                for (var i = 0; i < searchDisplayItems.length; i++) {
                                    if (searchDisplayItems[i].elementImageId == tempelementImageId) {
                                        selectRow(searchDisplayItems[i]);
                                        break;
                                    }
                                    
                                }
                                selectRowColor(tempelementImageId);
                            });
                            $("label[for=allVerifiedCheckBox]").css("position", "absolute");
                            $("label[for=allVerifiedCheckBox]").css("margin-left", "40px");
                            $("label[for=allVerifiedCheckBox]").css("margin-top", "-2px");

                            let tableHeigth = $(".scanPageArea>div")[0].clientHeight- $("#confirmInfo").outerHeight(true) - $("#tabs>ul").outerHeight(true)-$('#elementsTable>thead').outerHeight(true) - parseInt(Number($("#elementsTableDiv").css("paddingTop").slice(0,-2))*2) - $(".xux-decoratedTable-trailingBox").outerHeight(true)
                            $('#elementsTable').find("tbody").first().css("height", tableHeigth +"px" )
                            showSortFlag();
                            setAllSelectBox();
                            removeLoading()
                        },
                        select: function (event, ui) {
                            selectRow(ui.itemObject._data);
                            selectelementImageId = ui.itemObject._data.elementImageId;
                        }

                    };
                    clickHeaderCell = 0;
                    DataTableOptions.columns[0].searchTableColumnDirection = DataTableOptions.sortOptions.order;
                    clickHeaderCellWidth = 62;
                    $elementsTable_ = $('#elementsTableDiv').xuxDecoratedTable(DataTableOptions);
                    isFirstLoad = true;
                } else {                    
                    $('#elementsTableDiv').xuxDecoratedTable('reload');
                }
                        
                
                
                $elementsTable_.order = function (tempSortOptions) {

                    if (tempSortOptions) {
                        DataTableOptions.sortOptions.column = tempSortOptions[0][0];
                        DataTableOptions.sortOptions.order = tempSortOptions[0][1];
                    } else {
                        if ($elementsTable_) {
                            return [[DataTableOptions.sortOptions.column, DataTableOptions.sortOptions.order]];
                        } else {
                            return null;
                        }

                    }
                }
                
                if (isFirstLoad) {
                    toggleQuestionSort($elementsTable_, DataTableOptions.sortOptions.column, DataTableOptions.sortOptions.order, null)
                }
            }

            <%-- 表示設定ボタン --%>
            $('#configButton').click(function () {
                if (!isAliveSession()) return false;
                <%-- 表示設定ダイアログを開く --%>
                $('#answerImageMaxWidth').val(config.answerImageMaxWidth);
                $('#answerImageMaxHeight').val(config.answerImageMaxHeight);
                $('#answerImageSentenceMaxWidth').val(config.answerImageSentenceMaxWidth);
                $('#answerImageSentenceMaxHeight').val(config.answerImageSentenceMaxHeight);
                $("input[type=text]").xuxTextField();
                $("#configDialog").xuxModalWindow("open");
            });

            function setAllSelectBox() {
                var checkBoxCount = $("[name=VerifiedCheckBox]").length;
                var checkCount = 0;
                $("[name=VerifiedCheckBox]").each(function () {
                    var isChecked = $(this).is(':checked');
                    if (isChecked) {
                        checkCount++;
                    }

                });
                if (checkCount > 0 && checkCount == checkBoxCount) {
                    $("#allVerifiedCheckBox").prop('checked', true).xuxCheckbox("refresh");
                } else {
                    $("#allVerifiedCheckBox").prop('checked', false).xuxCheckbox("refresh");
                }
            }
            function selectRowColor(tempelementImageId, isClickType) {
                $("#elementsTable").find("tr").each(function () {
                    if ($(this).find("td").first().find('input').first().val() == tempelementImageId) {
                        $(this).addClass("xux-table-selected");
                        if (isClickType == "Confirm") {
                            selectelementImageId = tempelementImageId + "Confirm";
                        }
                        else {
                            selectelementImageId = tempelementImageId;
                        }
                        
                    } else {
                        $(this).removeClass("xux-table-selected");
                    }
                });
            }
            function showSortFlag() {
                setTimeout(function () {
                    if (isApplyButton) {

                        // すべてのa要素を取得します
                        function getPageLinks() {
                            return $('.xux-page-number');
                        }

                        // 次のページボタンを取得します
                        var $nextPageButton = $('.xux-next-page');

                        // currentpageが最大ページ番号を超えている場合、次のページボタンが無効になるまでクリックしてページリンクと最大ページ番号を再取得します
                        var $pageLinks = getPageLinks();
                        var maxPage = Math.max(...$pageLinks.map(function () {
                            return parseInt($(this).text());
                        }).get());

                        while (currentPage > maxPage && $nextPageButton.attr('aria-disabled') !== 'true') {
                            $($pageLinks[$pageLinks.length -1]).trigger('click');
                            $nextPageButton.trigger('click');
                            $pageLinks = getPageLinks(); // ページリンクを再取得
                            maxPage = Math.max(...$pageLinks.map(function () {
                                return parseInt($(this).text());
                            }).get()); // 最大ページ番号を再取得
                        }

                        // 該当するa要素を探してクリックイベントをトリガーします。見つからない場合は前のページ番号を順に探します。最小は1です。
                        for (let i = currentPage; i >= 1; i--) {
                            let $target = $pageLinks.filter(function () {
                                return parseInt($(this).text()) === i;
                            });
                            if ($target.length) {
                                $target.trigger('click');
                                break;
                            }
                        }

                        isApplyButton = false;
                        currentPage = 1;
                    }
                 }, 0);

                //var tempClickHeaderCellWidth = clickHeaderCellWidth;
                setTimeout(function () {
                    if (clickHeaderCell != null) {
                        $(".FilterDialog").each(function () {
                            var columnindexTemp = $(this).attr("columnindex");
                            var tempPosition = "";
                            //var clickfilterCellWidth = $(this).width() + 30;
                            var clickfilterCellWidth = 30;
                            if (tabIndex_ == 13) {
                                if (columnindexTemp == 2) {
                                    //tempPosition = "position: relative;";
                                    //tempClickHeaderCellWidth = 70;
                                    clickfilterCellWidth = 80;
                                }                              
                            }
                            else if (tabIndex_ >= 2) {
                                if (columnindexTemp == 3 ) {
                                    //tempPosition = "position: relative;";
                                    clickfilterCellWidth = 80;
                                }
                                if (columnindexTemp == 2) {
                                    //tempClickHeaderCellWidth = 70;
                                    clickfilterCellWidth = 30;
                                }
                            } else {
                                if (columnindexTemp == 4) {
                                    //tempPosition = "position: relative;";
                                    //tempClickHeaderCellWidth = 70;
                                    clickfilterCellWidth = 80;
                                }
                                if (columnindexTemp == 3) {
                                    //tempClickHeaderCellWidth = 70;
                                    clickfilterCellWidth = 30;
                                }
                            }
                            $(this).parent().parent().find(".xux-table-sort").remove();
                            if (DataTableOptions.columns[clickHeaderCell].searchTableColumnDirection == "desc") {
                                if (columnindexTemp == clickHeaderCell) {
                                    var sortTextTemp = '<span class="xux-table-sort" aria-hidden="true" style="margin-left: ' + clickfilterCellWidth + 'px;' + tempPosition + '"></span>';
                                    $(this).parent().parent().append(sortTextTemp);
                                    $(this).parent().parent().parent().attr("aria-sort", "descending");
                                    $(this).parent().parent().parent().removeClass("xux-table-sort-asc");
                                    $(this).parent().parent().parent().addClass("xux-table-sort-desc");
                                }
                            } else if (DataTableOptions.columns[clickHeaderCell].searchTableColumnDirection == "asc") {
                                if (columnindexTemp == clickHeaderCell) {


                                    var sortTextTemp = '<span class="xux-table-sort" aria-hidden="true" style="margin-left: ' + clickfilterCellWidth + 'px;' + tempPosition + '"></span>';
                                    $(this).parent().parent().append(sortTextTemp);
                                    $(this).parent().parent().parent().attr("aria-sort", "ascending");
                                    $(this).parent().parent().parent().removeClass("xux-table-sort-desc");
                                    $(this).parent().parent().parent().addClass("xux-table-sort-asc");
                                }
                            }
                            //var tempFilter = $(this).parent().parent().find(".xux-icon-funnel");
                            //if (tempFilter.length <= 0) {
                            //    var filterTextTemp = '<span  class="xux-icon xux-icon-size-medium xux-icon-funnel" style="font-size: 16px;position: absolute;left:' + clickfilterCellWidth + 'px"></span>';
                            //    $(this).parent().parent().append(filterTextTemp);
                            //}
                        });
                        //$('.xux-icon-funnel').unbind("click");
                        //$('.xux-icon-funnel').click(function () {
                        $('.headerRecord').click(function (event) {
                            if (event.target.className == "xux-choice-icon" || event.target.className.indexOf("confirmCheckBox") >= 0) {
                                return;
                            }
                            if (elementRowsList_) {
                                if (elementRowsList_ != null && elementRowsList_.length <= 0) {
                                    return;
                                }
                                var clickColumn = parseInt($(this).find(".FilterDialog").first().attr("columnindex"));
                                //$(this).parent().parent().parent().first().css("background-color", '#B2B2B2');
                                var clickObj = $(this).find(".FilterDialog").first();
                                createFilterDialog(clickColumn, clickObj);
                                $("#columnPopup").xuxModalWindow("open");
                                $("#columnPopupTitel").html(clickObj.html());
                            }
                            
                        });
                        resetTableHeadercolor();
                    }
                }, 100);
            }
            function selectRow(uiData) {
                 <%-- 表示済み設問色づけの削除 --%> 
                removeQuestionColoring();

                var aData = uiData;//$oTable.fnGetData(this);
                if (!aData) {
                    return;
                }
                          
                SetQuestionColoring(aData, config);

				<%-- 選択した設問が表示されている帳票イメージの切り替え --%>
                var selectScanPageIndex = 0, scanPageInfoLength = scanPageInfo_.length;
                for (var i = 0; i < scanPageInfoLength; i++) {
                    if (aData.scanPageId === scanPageInfo_[i].scanPageId) {
                        selectScanPageIndex = i;
                        break;
                    }
                }
                selectedElementDataId_ = aData.elementDataId;
				        <%-- 現在表示しているスキャンページと異なる場合は帳票イメージ切り替えを行う --%>
                if (selectScanPageIndex !== scanPageIndex_) {
                    setPreviewSetting();

                    scanPageIndex_ = selectScanPageIndex;
                    if (0 === scanPageIndex_) {
                        prevScanPageFlg = false;
                        nextScanPageFlg = true;
                    } else if (scanPageIndex_ === scanPageInfoLength - 1) {
                        prevScanPageFlg = true;
                        nextScanPageFlg = false;
                    } else {
                        prevScanPageFlg = true;
                        nextScanPageFlg = true;
                    }
                    loadScanPageImage();
                    showPreviewPageButton(prevScanPageFlg, nextScanPageFlg);
                }
            }

            function createFilterDialog(columnIndexTemp,obj) {

                sortFilterColumn_ = {};
                $filterDialogHeader_ = null;
                if (!elementRowsList_) {
                    return;
                }

                var $items = $('#columnPopupItems');
                $items.text('');

                var parentTag = obj;//$(this).parent().parent();
                sortFilterColumn_.search = function () { return ""; }//$elementsTable_.column(parentTag);
                var columnIndex = columnIndexTemp < 0 ? parentTag.attr("columnIndex") : columnIndexTemp;
                var columnDef = DataTableOptions.columns[columnIndex];
                $filterDialogHeader_ = $(this);

                var hasFunc = false;

				<%-- ソート機能が無効の場合はスキップ --%>
                if (columnDef.sortable === false) {
                    $("#columnPopup").xuxModalWindow('close');
                    return;
                }

				<%-- ソート機能 --%>
                if (columnDef.sortable !== false) {
                    createQuestionSort($items, $elementsTable_, columnIndex, '<%= Resources.Messages.SortDescCaption %>', '<%= Resources.Messages.SortAscCaption %>', null);
                    hasFunc = true;
                }

				<%-- フィルター機能 --%>
                var values = [];
                var isTypeSelect = false;
                if (columnDef.searchable !== false) {
                    values = $.map(elementRowsList_, function (n, i) {
                        return n[columnDef.field];//n[columnDef.data];
                    });
                    isTypeSelect = typeof (values[0]) === 'string';
                    values.sort();
                    values = $.map(values, function (n, i) { return '$' + doReplaceLineBreakToWhiteSpace(n); });
                    values = $.unique(values);

					<%-- すべて選択 --%>
                    var $allRows;
                    if (isTypeSelect) {
                        $allRows = $('<input id="' + FILTER_ALLROWS_ID + '" type="checkbox" />')
                            .change(function () {
                                var isChecked = $(this).is(':checked');
                                //$(FILTER_COND_CLASSNAME_SELECTOR).prop('checked', isChecked);
                                $('#columnPopupItems').find('[name=filterCondCheckBox]').prop('checked', isChecked).trigger('change');
                            });
                    } else {
                        $allRows = $('<input id="' + FILTER_ALLROWS_ID + '" type="radio" name="' + FILTER_RADIO_GROUP_NAME + '" />');
                    }
                    var $allRowsDiv = $('<div class="columnPopupItem"></div>')
                        .append($allRows)
                        .append('<span style="padding: 0 0 0 8px;vertical-align: middle;position: relative;top: 1px;" class="ui-button-text"><%= Resources.Messages.AllRowsCaption %></span>');
                    $items
                        //.append($('<hr class="FilterDialogHr" />'))
                        .append($allRowsDiv);

                    if (isTypeSelect) {
                	    <%-- 選択肢/一文字数値 --%>
                        var $blankCheckBox = $('<input type="checkbox" class="' + FILTER_COND_CLASSNAME + '" name="filterCondCheckBox" value="" />')
                            .change(function () {
                                changeCheckBox($(this), FILTER_ALLROWS_ID_SELECTOR, FILTER_COND_CLASSNAME_SELECTOR);
                            });
                        var $blankCheckBoxDiv = $('<div class="columnPopupItem"></div>')
                            .append($blankCheckBox)
                            .append('<span style="padding: 0 0 0 8px;vertical-align: middle;position: relative;top: 1px;" class="ui-button-text"><%= Resources.Messages.BlankRowsCheckBoxCaption %></span>');
					    $items.append($blankCheckBoxDiv);
                        
					    values = $.map(values, function (n, i) { return n.substring(1); });
                        var items = createQuestionItems(values, function (value) {
					        return value !== '' ? value : text;
                        }, FILTER_ALLROWS_ID_SELECTOR, FILTER_COND_CLASSNAME, FILTER_COND_CLASSNAME_SELECTOR,"filterCondCheckBox");
					    $items.append(items);
					    hasFunc = true;
					} else {
					    values = $.map(values, function (n, i) { return n === '$true'; });
					    var items = createConfirmRadioItems(values, function (value) {
					        return value ? '<%= Resources.Messages.CheckedCaption %>' : '<%= Resources.Messages.UncheckedCaption %>';
					    }, FILTER_COND_CLASSNAME, FILTER_RADIO_GROUP_NAME);
                        $items.append(items);
					    hasFunc = true;
                    }
                    $("input[type=checkbox]").xuxCheckbox();
                    $("input[type=radio]").xuxRadio();
                    var searchFilters = DataTableOptions.columns[columnIndex].searchTableFilters ? DataTableOptions.columns[columnIndex].searchTableFilters : "";
                    backupSearchFilter_ = DataTableOptions.columns[columnIndex].searchTableFilters ? DataTableOptions.columns[columnIndex].searchTableFilters : "";
					if (isTypeSelect) {
					    defaultCheckSelect(searchFilters, FILTER_ALLROWS_ID_SELECTOR, FILTER_COND_CLASSNAME_SELECTOR);
					} else {
					    if (searchFilters === '') {
                            $allRows.prop('checked', true).trigger('change');
					    } else {
					        var count = setFilterCheck(searchFilters, FILTER_COND_CLASSNAME_SELECTOR);
					        if (count === 0) {
                                $allRows.prop('checked', true).trigger('change');
					        }
					    }
					}
				}

				if (!hasFunc) {
					return;
				}

				<%-- フィルターダイアログのスクロール有無判定 --%>
				var filterDialogHeight = 'auto';
				if (isTypeSelect) {
                    var filterDialogMaxHeight = parseInt('<%= ConfigurationManager.AppSettings["FilterDialogMaxHeight"] %>', 10);
                    var FilterColumnHeight = 23;
                    var SortButtonHeight = 75;
                    if ((values.length + 1) * FilterColumnHeight + SortButtonHeight > filterDialogMaxHeight) {
                        var TitleAndOkButtonGroupHeight = 91;
                        filterDialogHeight = filterDialogMaxHeight + TitleAndOkButtonGroupHeight;
                    }
                }

                //$items.append($('<hr class="FilterDialogHr" />'));
                var columnPopupDiv = $("#columnPopupButtonDiv");
                $("#columnPopupButtonDiv").html("");
                var cancel = '<button type="button" class="cancle ModalWindowButton" columnIndex="' + columnIndex + '" id="filterDialogClose" style="width: 120px;"><%= Resources.Messages.CancelButtonCaption %></button>';
                columnPopupDiv.append($(cancel))
                columnPopupDiv.append("&nbsp;")
                var okstring = '<button type="button" class="ModalWindowButton" columnIndex="' + columnIndex + '" id="filterDialogOK" style="width: 120px;"><%= Resources.Messages.OkButtonCaption %></button>';
                columnPopupDiv.append($(okstring))
                $("#filterDialogOK").xuxButton();
                $("#filterDialogOK").xuxButton("option", "type", "default");

                $("input[type=checkbox]").xuxCheckbox();
                $("input[type=button]").xuxButton();
                $("#filterDialogClose").xuxButton();
                $('#filterDialogClose').unbind("click");
                $("#filterDialogClose").click(function () {
                    resetTableHeadercolor();
                    $("#columnPopup").xuxModalWindow("close");
                });
                $('#filterDialogOK').unbind("click");
                $("#filterDialogOK").click(function () {
                    saveSelectPageCount();
                    if ($("#sortAscButton").is(':checked')) {
                        DataTableOptions.sortOptions.column = columnIndex;
                        DataTableOptions.sortOptions.order = $("#sortAscButton").val();
                    }
                    if ($("#sortDescButton").is(':checked')) {
                        DataTableOptions.sortOptions.column = columnIndex;
                        DataTableOptions.sortOptions.order = $("#sortDescButton").val();
                    }
                    if (isParentClosed_) window.close();

                    if (!isAliveSession()) return false;
                    var clickOkButton = $(this);
                    var changedRows = getChangedElementRows();
                    if (changedRows.length === 0 && !isUpdating_) {
                        filterDialogOK($(this));
                    } else {
                        confirmMessageEror('<%= Resources.Messages.ConfirmDataChangedMessage %>', function () {
                            restoreValue();
                            filterDialogOK(clickOkButton);
                        },null, '<%= Resources.Messages.OkButtonCaption %>', '<%= Resources.Messages.CancelButtonCaption %>');
                    }
                });
            }
            window.restoreValue = function() {
                isUpdating_ = false;
			                <%-- 画面上に表示している値の内容をバックアップ値に戻す --%>
                var $inputValue = $('.inputValue');
                $.each($inputValue, function (index, value) {
                    var nodeName = $(this).prop('nodeName');
                    var $backupValue = $(this).siblings('.backupValue');
                    if (nodeName === 'TEXTAREA') {
                        $(this).val($backupValue.val()).trigger('change');
                    } else if (nodeName === 'SELECT') {
                        if ($backupValue.val() != "") {
                            $(this).children('option[value=' + $backupValue.val() + ']').prop('selected', true).trigger('change');
                        }
                    } else {
                        $(this).prop('checked', $backupValue.val() === 'true').trigger('change');
                    }
                });

                var $verifiedCheckBox = $('*[name=VerifiedCheckBox]');
                $.each($verifiedCheckBox, function (index, value) {
                    var $backupValue = $(this).siblings('[name="backupVerifiedValue"]');
                    $(this).prop('checked', $backupValue.val() === 'true').trigger('change');
                });

                var i, elementRowsListLength = elementRowsList_.length;
                for (i = 0; i < elementRowsListLength; i++) {
                    elementRowsList_[i].isChanged = false;
                }
            }
            function filterDialogOK(obj) {
                //isOperationCanceled_ = !isResetEditData();
                //if (isOperationCanceled_) {
                //    sortFilterColumn_.search(backupSearchFilter_, true);
                //    return;
                //}
                var columnIndex = obj.attr("columnIndex");
                if ($(FILTER_ALLROWS_ID_SELECTOR).is(':checked')) {
                    backupSearchFilter_ = '';
                    DataTableOptions.columns[columnIndex].searchTableFilters = "";
                    //sortFilterColumn_.search('', true);
                    //var tempShowTable = searchTable(DataTableOptions, elementRowsList_);
                    //renderTable(tempShowTable);
                    config.filterToDate = null;
                    config.filterFromDate = null;
                    $filterDialogHeader_.removeClass('SortedFilterDialog');
                } else {
                    $filterDialogHeader_.addClass('SortedFilterDialog');
							<%-- チェックされた検索項目を検索条件に加える --%>
                    var filters = getFilter(FILTER_COND_CLASSNAME_SELECTOR);

                    if (filters && filters.length !== 0) {
                        var filter = filters.join('|');
                        backupSearchFilter_ = filter;
                        DataTableOptions.columns[columnIndex].searchTableFilters = filter;
                        //sortFilterColumn_.search(filter, true, false, false);
                    } else {
                        backupSearchFilter_ = null;
                        DataTableOptions.columns[columnIndex].searchTableFilters = "NoSelect";//sortFilterColumn_.search(null, true);
                    }
                }
                var tempShowTable = toggleQuestionSort($elementsTable_, DataTableOptions.sortOptions.column, DataTableOptions.sortOptions.order, null);
                renderTable(tempShowTable);
                $("#columnPopup").xuxModalWindow("close");
            }
            function saveSelectPageCount() {
                //recordTablePageCount = $(".xux-decoratedTable-dropdownForItems").first().find("select").val();
            }
            function getTableTbody(displayItems) {
                var tableBody = [];
                tableBody.push({});
                if (tabIndex_ == 13) {
		            <%-- 「選択肢」「値」非表示 --%>
                   <%-- 「選択肢」非表示 --%>
                    tableBody = [
                        createTableTbody(0, displayItems),
                        createTableTbody(2, displayItems),
                        createTableTbody(4, displayItems)
                    ];
                    $('#tabTitleScan').html('<%= Resources.Messages.ScanImageRecognitionResulsColumnName %>');
                }
                else if (tabIndex_ >= 2) {
			    	<%-- 「選択肢」非表示 --%>
                    tableBody = [
                        createTableTbody(0, displayItems),
                        createTableTbody(2, displayItems),
                        createTableTbody(3, displayItems),
                        createTableTbody(4, displayItems)
                    ];
                } else {
                    tableBody = [
                        createTableTbody(0, displayItems),
                        createTableTbody(1, displayItems),
                        createTableTbody(2, displayItems),
                        createTableTbody(3, displayItems),
                        createTableTbody(4, displayItems)
                    ];
                }
                return tableBody;
            }

            function createTableTbody(columnIndex, displayItems) {
                var tempColumnTable = {}
                if (columnIndex == 0) {
                    tempColumnTable = {
                        field: "elementName",
                        //defaultSortOrder: "asc",
                        render: function (td, item) {
                            var html = '<span>' + item._data.elementName + '</span>';
                            td.css("width", "100px");
                            td.attr("title", item._data.elementName);
                            $(html).appendTo(td);
                            var temp = '<input type="hidden" id="hidden"' + item._data.elementImageId + '" value="' + item._data.elementImageId + '">';
                            td.append(temp);
                        }
                    };
                } else if (columnIndex == 1) {
                    tempColumnTable = {
                                        field: "subElementName",
                                        render: function (td, item) {
                                            var html = '<span>' + item._data.subElementName + '</span>';
                                            td.css("width", "100px")
                                            $(html).appendTo(td);
                                        }
                                    };
                } else if (columnIndex == 2) {
                    tempColumnTable = {
                                        field: "elementImageId",
                                        render: function (td, item) {
                                            var elementImage;
                                            var data = item._data;
                                            scanTabWidth_ = parseInt($('#tabTitleScan').parent().parent().css('width').slice(0, -2), 10) - 20;<%-- 右端のスクロールバーの幅の分、ヘッダとデーブルの枠にズレが生じてしまうため20px程調整する --%>
                                            var ansImgMaxWidth = scanTabWidth_ < config.answerImageMaxWidth ? scanTabWidth_ : config.answerImageMaxWidth;
                                            var ansImgSenMaxWidth = scanTabWidth_ < config.answerImageSentenceMaxWidth ? scanTabWidth_ : config.answerImageSentenceMaxWidth;
                                            if (item._data.elementType == 2 || data.elementType == 3) {
                                                elementImage = $('<img class="thumb" />')
                                                    .css('max-width', ansImgMaxWidth + 'px')
                                                    .css('max-height', config.answerImageMaxHeight + 'px');
                                            } else {
                                                elementImage = $('<img class="thumbSentence" />')
                                                    .css('max-width', ansImgSenMaxWidth + 'px')
                                                    .css('max-height', config.answerImageSentenceMaxHeight + 'px');
                                            }
                                            elementImage.attr('src', 'api/AnswerImage?elementImageId=' + data.elementImageId);
                                            
                                            $(elementImage).appendTo(td);

                                                                <%-- 値 --%>
                                            var elementValueEdit, backupValue, i;
                                            switch (data.elementType) {
						                                            <%-- 自由入力、分割文字 --%>
                                                case 1:
                                                case 4:
                                                case 5:
                                                    var sanitaizedValue = doSanitaizeDecode(data.elementValue);
                                                    elementValueEdit = $('<textarea elementImageId="' + data.elementImageId+'" class="inputValue confirmTextArea" rows="' + getRowCount(config.fontSize) + '" maxlength="' + freeEntryMaxLength_ + '" />')
                                                        .css("font-size", config.fontSize)
                                                        .val(sanitaizedValue)
                                                        .change(function () {
                                                            data.elementValue = $(this).val();
                                                            updateInnerValue(data.elementImageId, 3, data.elementValue);
                                                            data.isChanged = true;
                                                        });
                                                    backupValue = $('<input type="hidden" class="backupValue" />').
                                                        val(sanitaizedValue);
                                                    $(elementImage).appendTo(td);
                                                    $('</br>').appendTo(td);
                                                    $(elementValueEdit).appendTo(td);
                                                    $(backupValue).appendTo(td);
                                                    break;
                                            }
                                        }
                                    };
                } else if (columnIndex == 3) {
                    tempColumnTable = {
                                        field: "elementValue",
                                        render: function (td, item) {
                                            td.css("width", "55px")
                                            var elementValueEdit, backupValue, i;
                                            var data = item._data;
                                            switch (data.elementType) {
						                            <%-- 1文字数値 --%>
                                                case 2:
                                                    elementValueEdit = $('<select class="inputValue"></select>');
                                                    //if (tabIndex_ === 12) {
                                                    elementValueEdit.append($('<option>').html('').val(''));
                                                    //}
                                                    for (i = 0; i <= 9; i++) {
                                                        elementValueEdit.append($('<option>').html(i).val(i));
                                                    }
                                                    if (tabIndex_ === 12) {
                                                        elementValueEdit.val('');
                                                    } else {
                                                        elementValueEdit.val(data.elementValue);
                                                    }
                                                    elementValueEdit
                                                        .change(function () {
                                                            data.elementValue = $(this).children(':selected').val();
                                                            updateInnerValue(data.elementImageId, 3, data.elementValue);
                                                            data.isChanged = true;
                                                            selectRowColor(data.elementImageId);
                                                        });
                                                    backupValue = $('<input type="hidden" class="backupValue" />').
                                                        val(data.elementValue);

                                                    $(elementValueEdit).appendTo(td);
                                                    $(backupValue).appendTo(td);
                                                    break;
						                            <%-- 選択肢 --%>
                                                case 3:
                                                    elementValueEdit = $('<input type="checkbox" class="inputValue confirmCheckBox" />')
                                                        .prop('checked', data.elementValue)
                                                        .change(function () {
                                                            data.elementValue = $(this).is(':checked');
                                                            updateInnerValue(data.elementImageId, 3, data.elementValue.toString());
                                                            data.isChanged = true;
                                                            selectRowColor(data.elementImageId);
                                                        });
                                                    backupValue = $('<input type="hidden" class="backupValue" />').
                                                        val(data.elementValue);

                                                    $(elementValueEdit).appendTo(td);
                                                    $(backupValue).appendTo(td);
                                                    break;
                                            }
                                            
                                        }
                                    };
                } else if (columnIndex == 4) {
                    tempColumnTable = {
                                        field: "isVerified",
                                        render: function (td, item) {
                                            var data = item._data;
                               					                <%-- 確認チェックボックス --%>
                                            var checkbox = $('<input type="checkbox" name="VerifiedCheckBox" class="confirmCheckBox" />')
                                                .attr("checked", data.isVerified)
                                                .change(function () {
                                                    var isBeforeStatus = data.isVerified;
                                                    var isChecked = $(this).is(":checked");
                                                    data.isChanged = true;
                                                    if (isBeforeStatus) {
                                                        if (!isChecked) {
                                                            verifiedCount_--;
                                                            unverifiedCount_++;
                                                        }
                                                    } else {
                                                        if (isChecked) {
                                                            verifiedCount_++;
                                                            unverifiedCount_--;
                                                        }
                                                    }
                                                    data.isVerified = isChecked;
                                                    updateInnerValue(data.elementImageId, 4, isChecked);
                                                    $('#verifiedCount').text(verifiedCount_);
                                                    $('#unverifiedCount').text(unverifiedCount_);
                                                    selectRowColor(data.elementImageId, "Confirm");
                                                    setAllSelectBox();
                                                });
                                            var backupVerifiedValue = $('<input type="hidden" name="backupVerifiedValue" />')
                                                .val(data.isVerified);
                                            $(checkbox).appendTo(td);
                                            td.css("width", "110px");
                                            td.css("text-align", "center");
                                            $(backupVerifiedValue).appendTo(td);
                                        }
                                    };
                }
                tempColumnTable.searchTableFilters = "";
                return tempColumnTable;
            }

            function getTableFields() {

                var tableFields = []
                if (tabIndex_ == 13) {
                    tableFields = ["elementName", 'elementImageId', 'isVerified']
                } else if (tabIndex_ >= 2) {
                    tableFields = ["elementName", 'elementImageId', 'elementValue', 'isVerified']
                } else {
                    tableFields = ["elementName", 'subElementName', 'elementImageId', 'elementValue', 'isVerified']
                }
                return tableFields;
            }

            function createJobTable() {
                $("#elementsTableMasterDiv").html("");
                var tempTable = "";
                var filterTextTemp = '<span  class="xux-icon xux-icon-size-medium xux-icon-funnel" style="font-size: 16px;position: absolute;margin-top: 3px;"></span>';
                var filterTextConfirmTemp = '<span  class="xux-icon xux-icon-size-medium xux-icon-funnel" style="font-size: 16px;position: absolute;margin-left: 62px;"></span>';
                var filterImageTemp = '<span  class="xux-icon xux-icon-size-medium xux-icon-funnel" style="font-size: 16px;position: absolute;padding-left:' + 10 + 'px"></span>';
                if (tabIndex_ == 13) {
                    tempTable = '<div id="elementsTableDiv" style="padding: .6em 0 .4em .4em;"><table id="elementsTable">' +
                        '<thead>' +
                        '<th class="headerRecord" style="width:100px"><span span columnIndex="0" class="FilterDialog"><%= Resources.Messages.ElementNameColumnName %></span><span class="boxSpan"></span>' + filterImageTemp + '</th>' +
                        '<th><span id="tabTitleScan"><%= Resources.Messages.ScanImageRecognitionResulsColumnName %></span></th>' +
                        '<th class="headerRecord" style="width:110px"><span  style="position: absolute;margin-top: 1px;" columnIndex="2" class="FilterDialog"><%= Resources.Messages.VerifiedColumnName %></span><span class="boxSpan"></span>&nbsp;<input id="allVerifiedCheckBox" type="checkbox" class="confirmCheckBox">&nbsp;&nbsp;' + filterTextConfirmTemp + '</th>' +
                        '</thead>' +
                        '<tbody></tbody>' +
                        '</table> </div>';
                } else if (tabIndex_ >= 2) {
                    tempTable = '<div id="elementsTableDiv" style="padding: .6em .4em;"><table id="elementsTable">' +
                        '<thead>' +
                        '<th class="headerRecord" style="width:100px"><span columnIndex="0" class="FilterDialog"><%= Resources.Messages.ElementNameColumnName %></span><span class="boxSpan"></span>' + filterImageTemp + '</th>' +
                        '<th><span id="tabTitleScan"><%= Resources.Messages.ElementImageColumnName %></span></th>' +
                        '<th class="headerRecord" style="width:55px"><span columnIndex="2" class="FilterDialog"><%= Resources.Messages.ElementValueColumnName %></span><span class="boxSpan"></span>' + filterImageTemp + '</th>' +
                        '<th class="headerRecord" style="width:110px"><span style="position: absolute;margin-top: 1px;" columnIndex="3" class="FilterDialog"><%= Resources.Messages.VerifiedColumnName %></span><span class="boxSpan"></span>&nbsp;<input id="allVerifiedCheckBox" type="checkbox" class="confirmCheckBox">&nbsp;&nbsp;' + filterTextConfirmTemp + '</th>' +
                        '</thead><tbody></tbody></table> </div>';
                } else {
                    tempTable = '<div id="elementsTableDiv" style="padding: .6em .4em;"><table id="elementsTable">' +
                        '<thead>' +
                        '<th class="headerRecord" style="width:100px" ><span columnIndex="0" class="FilterDialog"><%= Resources.Messages.ElementNameColumnName %></span><span class="boxSpan"></span>' + filterImageTemp + '</th>' +
                        '<th class="headerRecord" style="width:100px" ><span columnIndex="1" class="FilterDialog"><%= Resources.Messages.SubElementNameColumnName %></span><span class="boxSpan"></span>' + filterImageTemp + '</th>' +
                        '<th><span id="tabTitleScan"><%= Resources.Messages.ElementImageColumnName %></span></th>' +
                        '<th class="headerRecord" style="width:55px" ><span columnIndex="3" class="FilterDialog"><%= Resources.Messages.ElementValueColumnName %></span><span class="boxSpan"></span>' + filterImageTemp + '</th>' +
                        '<th class="headerRecord" style="width:110px" ><span style="position: absolute;margin-top: 1px;" columnIndex="4" class="FilterDialog"><%= Resources.Messages.VerifiedColumnName %></span><span class="boxSpan"></span>&nbsp;<input id="allVerifiedCheckBox" type="checkbox" class="confirmCheckBox">&nbsp;&nbsp;' + filterTextConfirmTemp + '</th>' +
                        '</thead>' +
                        '<tbody></tbody>' +
                        '</table> </div>';
                       
                }
                $("#elementsTableMasterDiv").html(tempTable);
                $("#applyButton, #applyButtonTop").xuxButton();
                
           
                $("#scanPageExpandButtonEnable").xuxButton();
                $("#scanPageReduceButtonDisable").xuxButton();
                $("#scanPageReduceButtonEnable").xuxButton();
                $("#scanPageExpandButtonDisable").xuxButton();
                $("#applyButton, #applyButtonTop").xuxButton("option", "type", "default");
                <%-- 一括確認チェックボックス --%>
                $('#allVerifiedCheckBox').click(function () {
				    <%-- タブ切り替え時の初期化処理で発火しないようガード --%>
                    if (isChangeTab_) {
                        return;
                    }
                    if (!elementRowsList_ || elementRowsList_.length === 0) {
                        return;
                    }
                    var isChecked = $(this).is(':checked');
                    $('#elementsTable').find('[name=VerifiedCheckBox]').prop('checked', isChecked).trigger('change');
                });
                //---------
                $('#applyButton, #applyButtonTop').unbind("click");
                <%-- 確認訂正処理実行 --%>
                $('#applyButton, #applyButtonTop').click(function () {
                    allVerifiedCheckBoxValue = $("#allVerifiedCheckBox").is(':checked');
                    if (isParentClosed_) window.close();

                    var changedRows = getChangedElementRows();
                    if (changedRows.length === 0)
                        return false;

                    if (!chechInputMaxLength(changedRows, freeEntryMaxLength_)) {
                        alertMessageInfo('<%= string.Format(Resources.Messages.OverInputMaxLengthMessage, QuestionnaireConfirm.Util.RecordUtil.GetFreeEntryMaxLength()) %>');
                        return false;
                    }

                    var $applyButton = $('#applyButton, #applyButtonTop');
                    $applyButton.prop('disabled', true);

                    var pageNavigation = $("#elementsTableDiv").xuxDecoratedTable("pageNavigation");
                    //　現在のページ番号を取得する
                    currentPage = pageNavigation.xuxPageNavigation("option", "currentPage");
                    dispFormatLoading("<%= Resources.Messages.ProcessingMessage %>");
                    isUpdating_ = true;
                    isApplyButton = true;

                    var isExec = false; // CSV出力対象の場合はtrue
                    if (isExportCsv_) {
                        // Web.configで出力するに設定されていた場合
                        removeLoading();
                        isExec = checkExportCsv(false, PostElementRows, timeout);
                    }
                    if (!isExec) {
                        PostElementRows(false)
                    }
                    $applyButton.prop('disabled', false);
                    return false;
                });
                $('#cancelButton, #cancelButtonTop').unbind("click");
                $('#cancelButton, #cancelButtonTop').click(function () {
                    window.close();
                });

            }

            
            $("#dialog-confirm-ok").click(function () {
                $("#dialog-confirm").xuxModalWindow("close");
                PostElementRows(true);

            });
            $("#dialog-confirm-close").click(function () {
                isUpdating_ = false;
                $("#dialog-confirm").xuxModalWindow("close");
            });
            $("#selectFormClose").click(function () {
                $("#configDialog").xuxModalWindow("close");
            });
            $("#selectFormOK").click(function () {
                if (!isAliveSession()) return false;

                        <%-- 入力チェック --%>
                if (!(checkSize('answerImageMaxWidth')
                    && checkSize('answerImageMaxHeight')
                    && checkSize('answerImageSentenceMaxWidth')
                    && checkSize('answerImageSentenceMaxHeight'))) {
                    return;
                }
                <%-- 再描画 --%>
                config.answerImageMaxWidth = $('#answerImageMaxWidth').val();
                config.answerImageMaxHeight = $('#answerImageMaxHeight').val();
                config.answerImageSentenceMaxWidth = $('#answerImageSentenceMaxWidth').val();
                config.answerImageSentenceMaxHeight = $('#answerImageSentenceMaxHeight').val();
                var ansImgMaxWidth = scanTabWidth_ < config.answerImageMaxWidth ? scanTabWidth_ : config.answerImageMaxWidth;
                var ansImgSenMaxWidth = scanTabWidth_ < config.answerImageSentenceMaxWidth ? scanTabWidth_ : config.answerImageSentenceMaxWidth;
                $('img.thumb').css('max-width', ansImgMaxWidth + 'px');
                $('img.thumb').css('max-height', config.answerImageMaxHeight + "px");
                $('img.thumbSentence').css('max-width', ansImgSenMaxWidth + 'px');
                $('img.thumbSentence').css('max-height', config.answerImageSentenceMaxHeight + "px");
                //$("#elementsTableDiv").xuxDecoratedTable('reload');
                <%-- Cookie保存 --%>
                var aiWidth = config.answerImageMaxWidth;
                var aiHeight = config.answerImageMaxHeight;
                var aisWidth = config.answerImageSentenceMaxWidth;
                var aisHeight = config.answerImageSentenceMaxHeight;
                var answerImageSetting = getCookie(COOKIENAME_ANSWER_IMAGE_SETTING);
                var userId = userId_;
                if (answerImageSetting) {
                    var isExistedUser = false;
                    for (var i = 0; i < answerImageSetting.length; i++) {
                        if (answerImageSetting[i].user == userId) {
                            isExistedUser = true;
                            answerImageSetting[i].ai.width = aiWidth;
                            answerImageSetting[i].ai.height = aiHeight;
                            answerImageSetting[i].ais.width = aisWidth;
                            answerImageSetting[i].ais.height = aisHeight;
                        }
                    }
                    if (!isExistedUser) {
                        answerImageSetting.push({
                            user: userId,
                            ai: { width: aiWidth, height: aiHeight },
                            ais: { width: aisWidth, height: aisHeight }
                        });
                    }
                } else {
                    answerImageSetting = [{
                        user: userId,
                        ai: { width: aiWidth, height: aiHeight },
                        ais: { width: aisWidth, height: aisHeight }
                    }];
                }
                setCookie(COOKIENAME_ANSWER_IMAGE_SETTING, answerImageSetting);
                $("#configDialog").xuxModalWindow("close");
            });
            // ソート作成
            function createQuestionSort($items, $elementsTable, columnIndex, textDesc, testAsc, isCanceledFunc) {
                $("#columnPopupSortButton").html("");
                $("#columnPopupSortButton").css("margin-left", "4px");
                var $sortDescButton = $('<input type="radio" id="sortDescButton" class="sortDescRadio" value="desc" name="sortButtonGroupName" />');
                var tempsortDescButtonDiv = $('<div id="sortDescButtonDiv"></div>');
                tempsortDescButtonDiv.append($sortDescButton).append('<span style="padding: 0 0 0 8px;" class="ui-button-text">' + textDesc + '</span>');

                var $sortAscButton = $('<input  id="sortAscButton" class="sortAscRadio" type="radio"  value="asc" name="sortButtonGroupName"/>');
                var tempsortAscButtonDiv = $('<div id="sortAscButtonDiv"></div>');
                tempsortAscButtonDiv.append($sortAscButton).append('<span style="padding: 0 0 0 8px;" class="ui-button-text">' + testAsc + '</span>');
                $("#columnPopupSortButton").append(tempsortDescButtonDiv).append(tempsortAscButtonDiv);
                //var $sortDescButton = $('<input id="sortDescButton" type="button" value="' + textDesc + '" />')
                //    .button()
                //    .click(function () { toggleQuestionSort($elementsTable, columnIndex, 'desc', isCanceledFunc); });
                //var $sortAscButton = $('<input class="sortAscButtonDiv" id="sortAscButton" type="button" value="' + testAsc + '" />')
                //    .button()
                //    .click(function () { toggleQuestionSort($elementsTable, columnIndex, 'asc', isCanceledFunc); });
                //$items
                //    .append($('<div></div>').append($sortDescButton))
                //    .append($('<div></div>').append($sortAscButton));
                changeQuestionSortButtonColor($elementsTable, columnIndex);
            }
            // ソート処理
            function toggleQuestionSort($elementsTable, columnIndex, direction, isCanceledFunc) {
                //if (isCanceledFunc != null) {
                //    isCanceledFunc();
                //}
                clickHeaderCell = columnIndex;
                clickHeaderCellWidth = $("#elementsTable").find("[columnindex=" + columnIndex + "]").first().width() + 8;
                DataTableOptions.columns[columnIndex].searchTableColumnDirection = direction;
                if (!isAliveSession()) return false;
                var clickOkButtonColumnIndex = columnIndex;
                var directionOkButton = direction;
                
                var sortelementsTable = $elementsTable;
                return bindTableSort(clickOkButtonColumnIndex, directionOkButton, sortelementsTable);
            }
            function bindTableSort(columnIndex, direction, $elementsTable) {
                var tempkey = getTableFields();
                var sortPatam = {
                    sortKey: tempkey[columnIndex],
                    sortOrder: direction
                };
                var tempSortTable = sortObjectData(elementRowsList_, sortPatam);
                elementRowsList_ = tempSortTable;

                var tempDataTable = searchTable(DataTableOptions, tempSortTable);
               
                var sortConds = $elementsTable.order();
                var sortCondIndex = indexOf(sortConds, function (cond) { return cond[0] === columnIndex; });
                if (0 <= sortCondIndex) {
                    if (sortConds[sortCondIndex][1] === direction) {
                        sortConds.splice(sortCondIndex, 1);
                        if (sortConds.length === 0) {
                            sortConds[0] = [columnIndex, direction];
                        }
                    }
                    else {
                        sortConds[sortCondIndex][1] = direction;
                    }
                }
                else {
                    sortConds = [[columnIndex, direction]];
                }


                //renderTable(tempDataTable);
                $elementsTable.order(sortConds);
                return tempDataTable;
                //$elementsTable.columns.adjust().draw();
                //changeQuestionSortButtonColor($elementsTable, columnIndex);
                
            }
            // ソートボタンの色を変更する
            function changeQuestionSortButtonColor($elementsTable, columnIndex) {
                var enable = 'background: #d8d8d8 none repeat scroll 0 0 !important;';
                var disable = '';
                var sortConds = $elementsTable.order();
                if (sortConds != null && 0 < sortConds.length) {
                    if (sortConds[0].length == 2) {
                        if (sortConds[0][0] == columnIndex) {
                            if (sortConds[0][1] == 'desc') {
                                //$('#sortDescButton.ui-button').css({ 'cssText': enable });
                                //$('#sortAscButton.ui-button').css({ 'cssText': disable });
                                $(".sortDescRadio").prop('checked', true).trigger('change');
                            } else if (sortConds[0][1] == 'asc') {
                                //$('#sortDescButton.ui-button').css({ 'cssText': disable });
                                //$('#sortAscButton.ui-button').css({ 'cssText': enable });
                                $(".sortAscRadio").prop('checked', true).trigger('change');
                            }
                        }
                    }
                }
            }
            function createQuestionItems(values, convertCaption, idSelector, className, classNameSelector,inputName) {
                return $.map(values, function (value, index) {
                    if (value === '') {
                        return null;
                    }
                    var removeBRTag = value.replace(/<[Bb][rR]\/>/g, '');
                    var sanitaizeValue = doSanitaizeEncode(doSanitaizeDecode(removeBRTag));
                    var $checkbox = $('<input type="checkbox" class="' + className + '" value="' + sanitaizeValue + '" name="' + inputName+'" />')
                        .change(function () { changeCheckBox($(this), idSelector, classNameSelector); });
                    var showCheckText = convertCaption ? convertCaption(sanitaizeValue) : sanitaizeValue;
                    return $('<div class="columnPopupItem"></div>')
                        .append($checkbox)
                        .append('<span style="padding: 0 0 0 8px;vertical-align: middle;position: relative;top: 1px;" class="ui-button-text">' + showCheckText+'</span>');
                });
            }
            function resetTableHeadercolor() {
                $(".FilterDialog").each(function () {
                    var columnindexTemp = $(this).attr("columnindex");
                    if (DataTableOptions.columns[columnindexTemp].searchTableFilters == "") {
                        $(this).parent().parent().find(".xux-icon-funnel").first().css("color", '');
                        $(this).parent().parent().parent().first().css("background-color", '');
                    } else {
                        $(this).parent().parent().find(".xux-icon-funnel").first().css("color", '#1b8f98');
                        $(this).parent().parent().parent().first().css("background-color", '#B2B2B2');
                    }
                });
            }
            //-----------------------2021/08/23 add end--------------------------//
        });
    </script>

    <script src="xux/xux-js/xux-gfocal-middle-light-3.1.0-alpha-06.min.js"></script>
    <script>
        $("html").attr('lang', 'ja');
        xuxInitialize({
            prefix: "xux/",
        });

    </script>
    <script src="xux/xux-js/xux-gfocal-middle-fujifilmbi-3.1.0-alpha-06.min.js"></script>
    <script src="js/jquery.cookie.js"></script>
    <script src="js/common.js?date=<%=DateTime.Now.ToString("yyyyMMddHHmmss")%>"></script>
    <script src="js/filter.js?date=<%=DateTime.Now.ToString("yyyyMMddHHmmss")%>"></script>
    <script>
        // xuxDropdownを拡張する
        $.widget('xux.xuxDropdown', $.xux.xuxDropdown, {
            _changeItem: function (li) {
                var selectedIndex, el = this.element, oldSelectedIndex = this._oldSelectedIndex, ddList = this._ddList, self = this;
                if (!li) {
                    return;
                }

                selectedIndex = li.data(this._ITEM_INDEX_KEY);
                el.find("option").eq(selectedIndex).prop("selected", true);

                // ドロップダウンの値が変更する場合
                if ((oldSelectedIndex || oldSelectedIndex === 0) && selectedIndex !== oldSelectedIndex && this._initialized) {
                    var changedRows = getChangedElementRows();
                    //　アンケートビューの1ページ表示件数のドロップダウンが存在する、かつ、内容を編集した場合
                    if (this.element.parents('.xux-decoratedTable-dropdownForItems').length > 0 && (0 < changedRows.length || isUpdating_)) {
                        el.find("option").eq(oldSelectedIndex).prop("selected", true);
                        self._select({ currentTarget: ddList.find('li').eq(oldSelectedIndex) });
                        confirmMessageEror('<%= Resources.Messages.ConfirmDataChangedMessage %>', function () {
                            el.find("option").eq(selectedIndex).prop("selected", true);
                            self._select({ currentTarget: ddList.find('li').eq(selectedIndex) });
                            restoreValue();
                            el.change(); 
                        }, function () {

                        }, '<%= Resources.Messages.OkButtonCaption %>', '<%= Resources.Messages.CancelButtonCaption %>');
                   } else {
                       el.change();
                   }
               }
           },
       });
        (function () {
            $("body").xuxPage();
        });
    </script>
</head>
<body >

    <div class="layoutFormat">
       
        <form runat="server" style="margin: 0 10px;">
            <asp:HiddenField ID="userId" runat="server" />
            <asp:HiddenField ID="businessId" runat="server" />
            <asp:HiddenField ID="businessRecordIds" runat="server" />
            <asp:HiddenField ID="formId" runat="server" />
            <asp:HiddenField ID="formName" runat="server" />
            <asp:HiddenField ID="config" runat="server" />

            <div class="backLinkArea">
                <div class="backLink">
                    <label class="formatTitle"><%= Resources.Messages.ConfirmationWindowTitle %> - </label>
                    <span id="recordId" class="formatTitle"></span>
                </div>
            </div>

            <table id="mainContent" class="mainContent">
                <tr>
                    <td class="scanPageArea">
                        <div>
                            <div id="scanPagePanel" class="scanPagePanel">
                                <img id="scanPageImage" class="scanPageImage" />
                            </div>
                            <div class="scanPageFunction">
                                <span class="sizeControl">
                                    <span id="scanPageScalingListSpan"></span>
                                    <span id="scanPageReduceButton">
                                        <button id="scanPageReduceButtonEnable" class="va-middle add-cursor">
                                            <span class="xux-icon xux-icon-size-medium xux-icon-zoomout" style="font-size: 16px; position: relative;"></span>
                                        </button>
                                        <button id="scanPageReduceButtonDisable" class="va-middle" disabled="disabled">
                                            <span class="xux-icon xux-icon-size-medium xux-icon-zoomout" style="font-size: 16px; position: relative;"></span>
                                        </button>
                                    </span>
                                    <span id="scanPageExpandButton">
                                        <button id="scanPageExpandButtonEnable" class="va-middle add-cursor">
                                            <span class="xux-icon xux-icon-size-medium xux-icon-zoomin" style="font-size: 16px; position: relative;"></span>
                                        </button>
                                        <button id="scanPageExpandButtonDisable" class="va-middle" disabled="disabled">
                                            <span class="xux-icon xux-icon-size-medium xux-icon-zoomin" style="font-size: 16px; position: relative;"></span>
                                        </button>
                                    </span>

                                </span>
                                <span class="pageControl">
								　　　　<span id="prevScanPageButton">
									<button id="prevScanPageButtonEnable" class="va-middle add-cursor" accesskey="1" title="Alt + 1">
										<span class="xux-icon xux-icon-size-medium xux-icon-leftarrowhead" style="font-size: 16px; position: relative;" ></span>
									</button>
									<button id="prevScanPageButtonDisable" class="va-middle" disabled="disabled" title="Alt + 1">
									   <span class="xux-icon xux-icon-size-medium xux-icon-leftarrowhead" style="font-size: 16px; position: relative;color:#8c8c8c" ></span></button>
								</span>
								<span id="scanPageIndex"></span>
								<span>/</span>
								<span id="scanPageCount"></span>
								<span id="nextScanPageButton">
									<button id="nextScanPageButtonEnable" class="va-middle add-cursor" accesskey="2" title="Alt + 2">
									   <span class="xux-icon xux-icon-size-medium 	xux-icon-rightarrowhead" style="font-size: 16px; position: relative;" />
									   </button>
									<button id="nextScanPageButtonDisable" class="va-middle" disabled="disabled" title="Alt + 2">
										<span class="xux-icon xux-icon-size-medium 	xux-icon-rightarrowhead" style="font-size: 16px; position: relative;color:#8c8c8c "/></button>
								</span>
                                </span>
                            </div>
                        </div>
                    </td>
                    <%-- 帳票ページと一覧の間の隙間 --%>
                    <td class="areaSeparator">
                        <span id="previewVisible">
                            <input type="image" id="previewVisibleEnable" src="image/cc_preview_open.png" style="display: none;" />
                            <input type="image" id="previewVisibleDisable" src="image/cc_preview_close.png" style="display: none;" />
                        </span>
                    </td>
                    <td class="scanRecordListArea">
                        <div id="tabs">
                            <ul>
                                <li class="tabItem"><a href="#tab"><%= Resources.Messages.CheckOnTabCaption %></a></li>
                                <li class="tabItem"><a href="#tab"><%= Resources.Messages.CheckOffTabCaption %></a></li>
                                <li class="tabItem"><a href="#tab"><%= Resources.Messages.Num0TabCaption %></a></li>
                                <li class="tabItem"><a href="#tab"><%= Resources.Messages.Num1TabCaption %></a></li>
                                <li class="tabItem"><a href="#tab"><%= Resources.Messages.Num2TabCaption %></a></li>
                                <li class="tabItem"><a href="#tab"><%= Resources.Messages.Num3TabCaption %></a></li>
                                <li class="tabItem"><a href="#tab"><%= Resources.Messages.Num4TabCaption %></a></li>
                                <li class="tabItem"><a href="#tab"><%= Resources.Messages.Num5TabCaption %></a></li>
                                <li class="tabItem"><a href="#tab"><%= Resources.Messages.Num6TabCaption %></a></li>
                                <li class="tabItem"><a href="#tab"><%= Resources.Messages.Num7TabCaption %></a></li>
                                <li class="tabItem"><a href="#tab"><%= Resources.Messages.Num8TabCaption %></a></li>
                                <li class="tabItem"><a href="#tab"><%= Resources.Messages.Num9TabCaption %></a></li>
                                <li class="tabItem"><a href="#tab"><%= Resources.Messages.NumXTabCaption %></a></li>
                                <li class="tabItem"><a href="#tab"><%= Resources.Messages.FreeTextTabCaption %></a></li>
                            </ul>
                            <div id="tab" style="margin-top: 5px">
                                <div style="display: flex; justify-content: space-between;margin-bottom: -4px">
                                    <div id="confirmInfo" style="margin-left: 7px">
                                        <span><%= Resources.Messages.VerifiedCountCaption %></span>
                                        <span id="verifiedCount"></span>
                                        <span><%= Resources.Messages.DataTableLengthMenuCaption %></span>&nbsp;&nbsp;
                                        <span><%= Resources.Messages.UnverifiedCountCount %></span>
                                        <span id="unverifiedCount"></span>
                                        <span><%= Resources.Messages.DataTableLengthMenuCaption %></span>
                                        <input type="button" id="configButton" value="<%= Resources.Messages.ConfigButtonCaption %>" />
                                    </div>
                                    <div style="margin-right: 5px">
                                        <input type="button" id="cancelButtonTop" style="margin-right: 6px;" value="<%= Resources.Messages.CancelButtonCaption %>" />
                                        <input id="applyButtonTop" style="color: #fff;" type="button" value="<%= Resources.Messages.ApplyButtonCaption %>" />
                                    </div>
                                </div>


                                <div id="elementsTableMasterDiv">
                                    <div id="elementsTableDiv" style="padding: .6em .4em;">
                                        <table id="elementsTable">
                                            <thead id="elementsTableHeader">
                                                <th style="width: 100px"><span class="FilterDialog"><%= Resources.Messages.ElementNameColumnName %></span></th>
                                                <th id="subElementNameColumnNameHeader" style="width: 100px"><span class="FilterDialog"><%= Resources.Messages.SubElementNameColumnName %></span></th>
                                                <th ><span id="tabTitleScan"><%= Resources.Messages.ElementImageColumnName %></span></th>
                                                <th style="width: 23px"><span class="FilterDialog"><%= Resources.Messages.ElementValueColumnName %></span></th>
                                                <th style="width: 110px"><span class="FilterDialog"><%= Resources.Messages.VerifiedColumnName %></span>&nbsp;<input id="allVerifiedCheckBox" type="checkbox" class="confirmCheckBox" />&nbsp;&nbsp;</th>
                                            </thead>
                                            <tbody id="elementsTableBody"></tbody>
                                        </table>
                                    </div>
                                    <div style="text-align: right; margin-right: 22px;">
                                    </div>
                                </div>

                            </div>
                        </div>
                    </td>
                </tr>
            </table>

            <div style="text-align: right; margin-right: 22px; margin-top: 7px;">
                <input type="button" id="cancelButton" style="margin-right: 6px;" value="<%= Resources.Messages.CancelButtonCaption %>" />
                <input id="applyButton" style="color: #fff;" type="button" value="<%= Resources.Messages.ApplyButtonCaption %>" />
            </div>

            <div>
                <asp:DropDownList ID="pageLength" runat="server"></asp:DropDownList>
            </div>
        </form>
        
        <div id="footer" class="copyRight">
            <%= Resources.Messages.CopyrightCaption %>
        </div>
    </div>
   
    <!-- 表示設定ダイアログ -->
    <div id="configDialog" title="<%= Resources.Messages.ConfigDialogTitle %>">
        <h2><%= Resources.Messages.ConfigDialogTitle %></h2>
        <form method="POST" name="form1" id="form2">
            <div class="answerImageMaxSize">
                <label><%= Resources.Messages.AnswerImageMaxSizeCaption %></label>
            </div>
            <br />
            <div class="answerImageMaxSize">
                <div class="answerImageMaxSizeHeader">
                    <label for="answerImageMaxWidth"><%= Resources.Messages.AnswerImageMaxWidthCaption %></label>
                </div>
                <input id="answerImageMaxWidth" type="text" class="answerImageMaxSizeValue" />
            </div>
            <br />
            <div class="answerImageMaxSize">
                <div class="answerImageMaxSizeHeader">
                    <label for="answerImageMaxHeight"><%= Resources.Messages.AnswerImageMaxHeightCaption %></label>
                </div>
                <input id="answerImageMaxHeight" type="text" class="answerImageMaxSizeValue" />
            </div>
            <br />
            <br />
            <div class="answerImageMaxSize">
                <label><%= Resources.Messages.AnswerImageSentenceMaxSizeCaption %></label>
            </div>
            <br />
            <div class="answerImageMaxSize">
                <div class="answerImageMaxSizeHeader">
                    <label for="answerImageMaxWidth"><%= Resources.Messages.AnswerImageMaxWidthCaption %></label>
                </div>
                <input id="answerImageSentenceMaxWidth" type="text" class="answerImageMaxSizeValue" />
            </div>
            <br />
            <div class="answerImageMaxSize">
                <div class="answerImageMaxSizeHeader">
                    <label for="answerImageMaxHeight"><%= Resources.Messages.AnswerImageMaxHeightCaption %></label>
                </div>
                <input id="answerImageSentenceMaxHeight" type="text" class="answerImageMaxSizeValue" />
            </div>
        </form>
        <button type="button" class="cancle ModalWindowButton" id="selectFormClose"><%= Resources.Messages.CancelButtonCaption %></button>
        <button type="button" class="ModalWindowButton" id="selectFormOK"><%= Resources.Messages.OkButtonCaption %></button>
    </div>

    <div id="columnPopup" >
        <h2 id="columnPopupTitel"></h2>
        <div id="columnPopupSortButton" ></div>
        <div id="columnPopupItems"></div>
        <div id="columnPopupButtonDiv" style="float: right;margin-bottom: 15px;">

        </div>
    </div>
    <div id="dialog-confirm">
        <h2></h2>
        <div></div>
        <button type="button" id="dialog-confirm-ok">OK</button>
        <button type="button" id="dialog-confirm-close">キャンセル</button>
    </div>
</body>
</html>