// ウィンドウOpen
function openWindow(url, windowname, width, height, scroll)
{
    var features = "resizable=yes";
    if (scroll == undefined) {
        features += ", scrollbars=no"
    } else {
        features += ", scrollbars=yes"
    }

    if (width) {
        if (window.screen.width > width)
            features += ", left=" + (window.screen.width - width) / 2;
        else
            width = window.screen.width;
            features += ", width=" + width;
    }
    if (height) {
        if (window.screen.height > height)
            features += ", top=" + (window.screen.height - height) / 2;
        else
            height = window.screen.height;
            features += ", height=" + height;
    }

    var newWin = window.open(url, windowname, features);
    newWin.resizeTo(width, height);
    newWin.reload;
    newWin.focus();
}

// ローディング中のメッセージ表示
function dispLoading(tableShowId) {
	//if ($("#modalDiv").size() == 0) {
	//	$("body").append('<div id="modalDiv"></div>');
	//}
	//var dispMsg = "";
	//if (msg != "") {
	//	dispMsg = "<div class='loadingMsg'>" + msg + "</div>";
	//}
	//if ($("#loading").size() == 0) {
	//	$("body").append('<div id="loading">' + dispMsg + '</div>');
    //}
    var topLoadingShow = $("#" + "deleteButton").offset().top + 84 + 25;
    var leftloadingShow =( $(window).width() - 80 )/ 2;
    var loadDialog = $('#loading_message_dialog');
    if (loadDialog.length > 0) {
        loadDialog.remove();
    }
    loadDialog = $('<div id="loading_message_dialog" style="display: block;z-index:100;width: 160px; height: 160px;background-color: #FFFFFF;opacity: 0.9;top:' + topLoadingShow + 'px;left:' + leftloadingShow+'px"></div>');
    $('body').append(loadDialog);
    //loadDialog.xuxModalWindow({});
    loadDialog.append('<div style ="text-align: center;padding-top: 42px;"><progress ></progress></br><div style="margin-top: 8px;">読み込み中…</div></div>');
    loadDialog.find('progress').xuxProgressIndicator({
        indicatorStyle: 'circle',
        size: 'xLarge'
    });
    loadDialog.css("position", "absolute");
    //loadDialog.xuxModalWindow({
    //    type: 'alert',
    //    height: "auto",
    //    width: "nomral",
    //}).xuxModalWindow('open');
}

function dispFormatLoading(tableShowId) {
    //if ($("#modalDiv").size() == 0) {
    //	$("body").append('<div id="modalDiv"></div>');
    //}
    //var dispMsg = "";
    //if (msg != "") {
    //	dispMsg = "<div class='loadingMsg'>" + msg + "</div>";
    //}
    //if ($("#loading").size() == 0) {
    //	$("body").append('<div id="loading">' + dispMsg + '</div>');
    //}
    var topLoadingShow = $("#" + "configButton").offset().top + 80 + 25;
    //var leftloadingShow = $("#mainContent").width() / 2;//(($(window).width() - $("#scanPagePanel").width()) - 80)/2;
    var leftloadingShow = ($(window).width() - 80) / 2;
    var loadDialog = $('#loading_message_dialog');
    if (loadDialog.length > 0) {
        loadDialog.remove();
    }
    loadDialog = $('<div id="loading_message_dialog" style="display: block;z-index:100;width: 160px; height: 160px;background-color: #FFFFFF;opacity: 0.9;top:' + topLoadingShow + 'px;left:' + leftloadingShow + 'px"></div>');
    $('body').append(loadDialog);
    //loadDialog.xuxModalWindow({});
    loadDialog.append('<div style ="text-align: center;padding-top: 42px;"><progress ></progress></br><div style="margin-top: 8px;">読み込み中…</div></div>');
    loadDialog.find('progress').xuxProgressIndicator({
        indicatorStyle: 'circle',
        size: 'xLarge'
    });
    loadDialog.css("position", "absolute");
    //loadDialog.xuxModalWindow({
    //    type: 'alert',
    //    height: "auto",
    //    width: "nomral",
    //}).xuxModalWindow('open');
}

function dispCsvLoading(tableShowId) {
    var leftloadingShow = ($(window).width() - 80) / 2;
    var loadDialog = $('#loading_message_dialog');
    if (loadDialog.length > 0) {
        loadDialog.remove();
    }
    loadDialog = $('<div id="loading_message_dialog" style="display: block;z-index:100;width: 160px; height: 160px;background-color: #FFFFFF;opacity: 0.9;top: 333px;left:' + leftloadingShow + 'px"></div>');
    $('body').append(loadDialog);
    loadDialog.append('<div style ="text-align: center;padding-top: 42px;"><progress ></progress></br><div style="margin-top: 8px;">出力中…</div></div>');
    loadDialog.find('progress').xuxProgressIndicator({
        indicatorStyle: 'circle',
        size: 'xLarge'
    });
    loadDialog.css("position", "absolute");
}

function dispPrintLoading(tableShowId) {
    var leftloadingShow = ($(window).width() - 80) / 2;
    var loadDialog = $('#loading_message_dialog');
    if (loadDialog.length > 0) {
        loadDialog.remove();
    }
    loadDialog = $('<div id="loading_message_dialog" style="display: block;z-index:100;width: 160px; height: 160px;background-color: #FFFFFF;opacity: 0.9;top: 333px;left:' + leftloadingShow + 'px"></div>');
    $('body').append(loadDialog);
    loadDialog.append('<div style ="text-align: center;padding-top: 42px;"><progress ></progress></br><div style="margin-top: 8px;">印刷中…</div></div>');
    loadDialog.find('progress').xuxProgressIndicator({
        indicatorStyle: 'circle',
        size: 'xLarge'
    });
    loadDialog.css("position", "absolute");
}

// ローディング中のメッセージ削除
function removeLoading() {
	//$("#loading, #modalDiv").remove();
    var loadDialog = $('#loading_message_dialog');
    loadDialog.css("display", "none");
    //loadDialog.xuxModalWindow('close');
}

// ブラウザリサイズ時のカラム幅調整
var timer_ = false;
$(window).resize(function() {
	if (timer_ !== false) {
		clearTimeout(timer_);
	}
	timer_ = setTimeout(function () {
	    if(!(typeof $elementsTable_ == "undefined" || $elementsTable_ === null)){
			//$elementsTable_.columns.adjust();
		}
	}, 200);
});

// 指定したカラム名を持つヘッダー部のインデックス取得
function indexOf(array, func) {
	var arrayLength = array.length;
	for (var i = 0; i < arrayLength; i++) {
		if (func(array[i]))
			return i;
	}
	return -1;
}

// 値を変更済みの行リスト取得
function getChangedElementRows() {
	var changedRows = [];
	var elementRowsListLength = elementRowsList_.length;
	for (var i = 0; i < elementRowsListLength; i++) {
		var row = elementRowsList_[i];
		if (row.isChanged) {
		    var copied = null;
		    // エレメント値変更チェック
		    // (1)エレメント値に変更がなければ、elementValue(=サニタイズ済み)の値ではなく、元々のエレメント値(=elementData)をサーバ－に送る。
            // (2)この場合、修正前のデータに影響を与えないように、コピーを作成して送る。
		    if (row.elementType == 1 || row.elementType == 4 || row.elementType == 5) {
		        var orgVal = doSanitaizeDecode(row.elementValue);
		        if (row.elementData == orgVal) {
		            copied = $.extend(true, {}, row);
		            copied.elementValue = row.elementData;
		        }
		    }
		    if (copied != null) {
		        changedRows.push(copied);
		    } else {
		        changedRows.push(row);
		    }
		}
	}
	return changedRows;
}

// 文字列のbyte数取得
function CountLength(str) {
	var r = 0, strLength = str.length;
	for (var i = 0; i < strLength; i++) {
		var c = str.charCodeAt(i);
		if ((c >= 0x0 && c < 0x81) || (c == 0xf8f0) || (c >= 0xff61 && c < 0xffa0) || (c >= 0xf8f1 && c < 0xf8f4)) {
			r += 10;
		} else {
			r += 18;
		}
	}
	return r;
}

// 表示済み設問色づけの削除
function removeQuestionColoring() {
    var $questionColoringBorder = $('#questionColoringBorder');
    var $questionColoringArea = $('#questionColoringArea');
    if ($questionColoringBorder && $questionColoringArea) {
        $questionColoringBorder.remove();
        $questionColoringArea.remove();
		originalTop_ = 0;
		originalLeft_ = 0;
		originalWidth_ = 0;
		originalHeight_ = 0;
	}
}

// プルダウンの内容を未選択のもののみにする
function ChangeSelect(select) {
	var obj = select.children();
	var val = select.val();
	for (var i = 0; i < obj.length; i++) {
		if (i == val) {
			obj.eq(i).hide();
		} else {
			obj.eq(i).show();
		}
	}
}

// ブラウザがChromeか判定
function isBrowserChrome() {
	var ua = window.navigator.userAgent.toLowerCase();
	if (ua.indexOf('chrome') != -1) {
		return true;
	} else {
		return false;
	}
}

// ブラウザがFireFoxか判定
function isBrowserFirefox() {
    var ua = window.navigator.userAgent.toLowerCase();
    if (ua.indexOf('firefox') != -1) {
        return true;
    } else {
        return false;
    }
}

// ブラウザがIE9か判定
function isBrowserIE9() {
	var ua = window.navigator.userAgent.toLowerCase();
	var ver = window.navigator.appVersion.toLowerCase();
	if (ua.indexOf("msie") != -1 && ver.indexOf("msie 9.") != -1) {
		return true;
	} else {
		return false;
	}
}

// 自由入力、分割文字列の入力文字数をチェックする
function chechInputMaxLength(changedRows, maxSize) {
	var i, changedRowsLength = changedRows.length;
	for (i = 0; i < changedRowsLength; i++) {
		// 対象は自由入力と分割文字列
		if (changedRows[i].elementType === 1 || changedRows[i].elementType === 4) {
			if (changedRows[i].elementValue.length > maxSize) {
				return false;
			}
		}
	}
	return true;
}

// サニタイズ処理（エンコード）
function doSanitaizeEncode(str) {
	if (!str || typeof str !== 'string')
		return str;
	return str.replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;').replace(/"/g, '&quot;').replace(/'/g, '&#39;');
}

// サニタイズ処理（デコード）
function doSanitaizeDecode(str) {
	if (!str || typeof str !== 'string')
		return str;
	return str.replace(/&lt;/g, '<').replace(/&gt;/g, '>').replace(/&quot;/g, '"').replace(/&#39;/g, '\'').replace(/&amp;/g, '&');
}

// 正規表現（エンコード）
function doRegExEncode(str) {
	if (!str)
		return str;
	return str
		.replace(/\\/g, '\\\\')
		.replace(/\-/g, '\\-')
		.replace(/\^/g, '\\^')
		.replace(/\*/g, '\\*')
		.replace(/\+/g, '\\+')
		.replace(/\./g, '\\.')
		.replace(/\?/g, '\\?')
		.replace(/\{/g, '\\{')
		.replace(/\}/g, '\\}')
		.replace(/\(/g, '\\(')
		.replace(/\)/g, '\\)')
		.replace(/\[/g, '\\[')
		.replace(/\]/g, '\\]')
		.replace(/\$/g, '\\$')
		.replace(/\|/g, '\\|')
		.replace(/\//g, '\\/');
}

/** 
 * フィルターダイアログの検索条件からダブルクォーテーションで囲まれた条件を取得する。 
 * @param {string} value  検索条件
 * @return {JSON object} 切り出した検索条件
 *	"result": {
 *		"clippedValue": string, // ダブルクォーテーションで囲まれた文字列を切り抜いた検索条件
 *		"cutoutStrings": string array [] // ダブルクォーテーションで囲まれた文字列の配列
 *	}
 */
function getSurroundedSearchCondition(value) {
	var result = {};
	result["clippedValue"] = value;
	result["cutoutStrings"] = [];
	if (!value || value.length === 0) {
		return result;
	}
	
	var DoubleQuotes = '"';
	var clippedValue = value;
	var cutoutStrings = [];

	var index_s = -1, index_e = -1;
	while (true) {
		index_s = clippedValue.indexOf(DoubleQuotes);
		if (index_s === -1) {
			break;
		}
		index_e = clippedValue.indexOf(DoubleQuotes, index_s + 1);
		if (index_e === -1) {
			break;
		}
		// ダブルクォーテーションで囲まれた文字列を配列に格納
		cutoutStrings.push(clippedValue.slice(index_s + 1, index_e));
		// 検索条件からダブルクォーテーションで囲まれた文字列を除去する
		var str1 = "";
		if (index_s !== 0) {
			str1 = clippedValue.slice(0, index_s);
		}
		var str2 = "";
		if (index_e !== clippedValue.length - 1) {
			str2 = clippedValue.slice(index_e + 1);
		}
		clippedValue = str1 + str2;
	}
	
	result["clippedValue"] = clippedValue;
	result["cutoutStrings"] = cutoutStrings;
	return result;
}

// 改行コードの半角スペース変換
function doReplaceLineBreakToWhiteSpace(str) {
	if (!str || typeof str !== 'string')
		return str;
	return str.replace(/\r/g, ' ').replace(/\n/g, ' ');
}

// フォントサイズチェック
function checkFontSize(fontSize) {
    if (!/^small$|^medium$|^large$/i.test(fontSize)) {
        fontSize = "medium";
    }
    return fontSize;
}
// ハイライト透明度チェック
function checkHightlightOpacity(type, opacity) {
    var defaultOpacity = "0.2";
    if (type == 1) {
        // 塗りつぶし
        defaultOpacity = "0.2";
    } else if (type == 2) {
        // 線
        defaultOpacity = "1.0";
    }

    if (isNaN(opacity)) {
        opacity = defaultOpacity;
    }

    try {
        var value = parseFloat(opacity);
        opacity = 0 <= value && value <= 1 ? value : defaultOpacity;
    } catch (e) {
        opacity = defaultOpacity;
    }

    return opacity;
}

// 行数取得
function getRowCount(fontSize) {
    var rowCount = 5;
    if (isBrowserChrome()) {
        rowCount = 5;
    } else if (isBrowserFirefox()) {
        if (fontSize == 'small') {
            rowCount = 4;
        }
    } else {
        rowCount = 6;
    }
    return rowCount;
}

// クリッピング画像の数値チェック
function checkAnswerImage(type, value) {
    var defalut = 1;
    if (type == 1) {
        // 選択肢/数値（幅）
        defalut = 240;
    } else if (type == 2) {
        // 選択肢/数値（高さ）
        defalut = 60;
    } else if (type == 3) {
        // 文字列（幅）
        defalut = 600;
    } else if (type == 4) {
        // 文字列（高さ）
        defalut = 300;
    }

    if (isNaN(value) || (value < 1 || 2000 < value)) {
        value = defalut;
    }

    return value;
}
        
// Cookie情報取得
function getCookie(name) {
    if (cookie = $.cookie(name)) {
        return $.parseJSON(decodeURIComponent(cookie));
    } else {
        return null;
    }
}
        
// Cookie情報保存
function setCookie(key, cookie) {
    var cs = JSON.stringify(cookie);
    var en = encodeURIComponent(cs);
    $.cookie(key, en, { expires: 365 });
}

/** 
 * 拡縮ボタン表示制御(帳票ビュー、アンケートビュー)
 * @param {bool} exp  拡大ボタン(true:enable, false:disable)
 * @param {bool} red  縮小ボタン(true:enable, false:disable)
 * @return
 */
function showPreviewScaleButton (exp, red) {
    if (exp) {
        $('#scanPageExpandButtonEnable').show();
        $('#scanPageExpandButtonDisable').hide();
    } else {
        $('#scanPageExpandButtonEnable').hide();
        $('#scanPageExpandButtonDisable').show();
    }
    if (red) {
        $('#scanPageReduceButtonEnable').show();
        $('#scanPageReduceButtonDisable').hide();
    } else {
        $('#scanPageReduceButtonEnable').hide();
        $('#scanPageReduceButtonDisable').show();
    }
}

/** 
 * プレビューページボタン表示制御(帳票ビュー、アンケートビュー)
 * @param {bool} exp  前ページボタン(true:enable, false:disable)
 * @param {bool} red  次ページボタン(true:enable, false:disable)
 * @return
 */
function showPreviewPageButton (prev, next) {
    if (prev) {
        $('#prevScanPageButtonEnable').show();
        $('#prevScanPageButtonDisable').hide();
    } else {
        $('#prevScanPageButtonEnable').hide();
        $('#prevScanPageButtonDisable').show();
    }
    if (next) {
        $('#nextScanPageButtonEnable').show();
        $('#nextScanPageButtonDisable').hide();
    } else {
        $('#nextScanPageButtonEnable').hide();
        $('#nextScanPageButtonDisable').show();
    }
}

/** 
 * 確認訂正プレビュー閉じるボタン位置変更
 * @param {int} spaceWidth  padding等のスペース
 * @return
 */
function changePreviewCloseBtnPosition(spaceWidth) {
    var panelWidth = parseInt($('#scanPagePanel').css('width').slice(0, -2), 10);
    $('#previewVisibleDisable').css('left', panelWidth - spaceWidth);
}


// 確認訂正終了レコードをCSV出力するかチェックする
// ※PostRows(PostElementRows() in FormFormat.aspx,QuestionnaireFormat.aspx)は、ネームスペースが異なるために、直接呼ぶことはできない。
function checkExportCsv(viewMode, PostRows, timeout_func) {
    var result = false;
    // 確認訂正終了レコードが存在するかチェックする
    var recordIds = getEndConfirmRecord(viewMode, timeout_func);
    if (0 < recordIds.length) {
        result = true;
        var msg = isDelete_ ? messageConfirmExportDataAndDelete_ : messageConfirmExportData_;
        msg += "<br />" + recordIds.join("<br />");
        $("#dialog-confirm").find("h2").first().html(titleConfirmEndFormat_);
        $("#dialog-confirm").find("div").first().html('<p class="message" style="white-space: pre-wrap;"></p>');
        $("#dialog-confirm").find("div").first().children('p.message').html(msg);
        $("#dialog-confirm").xuxModalWindow({});
        $("#dialog-confirm").xuxModalWindow({
            height: "auto",
            width: "nomral"
        });
        $("#dialog-confirm").xuxModalWindow("open");
        
        
        //$("#dialog-confirm").dialog({
        //    resizable: false,
        //    modal: true,
        //    minHeight: 120,
        //    maxHeight: 400,
        //    title: titleConfirmEndFormat_,
        //    buttons: {
        //        OK: function () {
        //            $(this).dialog("close");
        //            PostRows(true);
        //        },
        //        "キャンセル": function () {
        //            isUpdating_ = false;
        //            $(this).dialog("close");
        //        }
        //    },
        //    open: function () {
        //        $("#dialog-confirm").html(msg);
        //    },
        //});
    }
    return result;
}

// 確認訂正終了レコードが存在するかチェックする
// 表示制御用（一覧で編集可/不可を制御する）の場合はisViewModeがtrue
function getEndConfirmRecord(isViewMode, timeout_func) {
    var endRecordIds = [];
    var recordIds = [];
    var elementRows = [];
    if (isViewMode) {
        // すべてのレコードID
        recordIds = jobIds_;
    } else {
        // 編集対象のレコードIDのみ
        elementRows = getChangedElementRows();
    }
    $.ajax({
        type: 'POST',
        url: 'api/EndConfirmRecord',
        contentType: 'application/json',
        async: false,
        data: JSON.stringify({
            businessId: $('#businessId').val(),
            formId: formId_,
            elementRows: elementRows,
            businessRecordIds: recordIds
        }),
        success: function (data, dataType) {
            if (Array.isArray(data) == false) {               
                timeout_func();
                return;
            }
            endRecordIds = data;
        },
    });
    return endRecordIds;
}

function messageAlert(option) {
    
    let dialog = $('#dialog-alert');

    if (dialog.length > 0) {
        dialog.remove();
    }
    dialog = $('<div id="dialog-alert" style="display: none;"></div>');

    $('body').append(dialog);
    dialog.append('<h2 class="title"></h2>');
    dialog.append('<p class="message" style="white-space: pre-wrap;"></p>');

    if (option.iconClass !== undefined) {
        dialog.append('<button class="cancel" type="button">' + (option.buttonMessages.cancel || '<%= Resources.Messages.OKButtonCaption %>')
            + '</button>');
    }
    if (option.flag === '2') {
        dialog.append('<button class="cancel" type="button">' + (option.buttonMessages.cancel || "<%= Resources.Messages.CancelButtonCaption %>")
            + '</button>');
    }

    dialog.append('<button class="ok" type="button">' + (option.buttonMessages.ok || "OK")
        + '</button>');

    if (option.iconClass) {
        $('<span></span>').addClass(option.iconClass).appendTo(
            dialog.children('h2.title'));
    }
    dialog.children('h2.title').append(option.title);
    dialog.children('p.message').html(option.message);
    dialog.find('.record-list-box').xuxListBox({ width: 'narrow' });


    dialog.children('button').click(function () {
        let mes = $(this);

        if (option.callbackObj) {
            if (mes.is('.ok') && $.isFunction(option.callbackObj.ok)) {
                option.callbackObj.ok(option.callbackObj.okParams);
            }
            if (mes.is('.cancel') && $.isFunction(option.callbackObj.cancel)) {
                option.callbackObj.cancel(option.callbackObj.cancelParams);
            }
        }
        if (dialog.parent().length > 0) {
            dialog.xuxModalWindow('close');
        }
    });

    dialog.xuxModalWindow({
        type: option.type,
        span: option.iconClass ? 'no' : 'yes',
        typeIcon: option.typeIcon === undefined ? true : option.typeIcon,
        closeOnEscape: false,
        width: option.wide === undefined ? 'wide' : option.wide
    });
    dialog.xuxModalWindow('open');
}

function alertMessageInfo(message, okFunction) {
    messageAlert({
        type: 'alert',
        message: message,
        title: "Info",
        flag: 1,
        callbackObj: { ok: okFunction, cancel: null },
        buttonMessages: { ok: null, cancel: null },
        typeIcon: true,
        wide: "wide"
    });
}
function alertMessageEror(message, okFunction) {
    messageAlert({
        type: 'fault',
        message: message,
        title: "エラー",
        flag: 1,
        callbackObj: { ok: okFunction, cancel: null },
        buttonMessages: { ok: null, cancel: null },
        typeIcon: true,
        wide: "wide"
    });
}
function confirmMessageEror(message, okFunction, cancelFunction, buttonOKMessages, buttonCancelMessages) {
    messageAlert({
        type: 'alert',
        message: message,
        title: "確認",
        flag: "2",
        callbackObj: { ok: okFunction, cancel: cancelFunction },
        buttonMessages: { ok: buttonOKMessages, cancel: buttonCancelMessages },
        typeIcon: true,
        wide: "wide"
    });
}
function showDiv(tempShowDiv, tempColumnPopupItems, tempclickObj, tableDiv, zIndex, showType) {
    tempColumnPopupItems.css("max-height", "400px");
    tempColumnPopupItems.css("overflow-y", "auto");
    tempColumnPopupItems.css("overflow-x", "hidden");
    var tempShowDivWidth = tempShowDiv.width() + 30;
    //tempShowDiv.css("min-width", tempShowDivWidth + "px");
    tempShowDiv.css("padding-left", "10px");
    tempShowDiv.css("padding-right", "10px");
    if (zIndex) {
        tempShowDiv.css("z-index", zIndex);
    } else {
        tempShowDiv.css("z-index", "100");
    }    
    tempShowDiv.css("background", " #EFEFEF");
    tempShowDiv.css("position", "absolute");
    var tempclickObjParent = tempclickObj.parent().parent();
    tempShowDiv.css("top", tempclickObjParent.offset().top + tempclickObjParent.height() + 12);
    tempShowDiv.css("right", "");
    tempShowDiv.css("left", "");
    if (isDivOver(tableDiv, tempShowDiv, tempclickObjParent)) {
        if (showType == "unknownFilter") {
            tempShowDiv.css("left", tempclickObjParent.offset().left);
        } else {
            tempShowDiv.css("right", "10px");
        }        
    } else {
        tempShowDiv.css("left", tempclickObjParent.offset().left);
    }
   

    if (tempShowDiv.css("display") == "none") {
        tempShowDiv.show();
    } else {
        tempShowDiv.show();
    }
    
}

function isDivOver(div1, div2, clickObj) {
    var div1Width = div1.width();
    var div2Width = div2.width();
    var div1Left = div1.offset().left;
    var div2Left = clickObj.offset().left;
    var div1Right = div1Left + div1Width;
    var div2Right = div2Left + div2Width;
    if (div2Right > div1Right) {
        return true;
    } else {
        return false;
    }
}

function closeDiv(tempShowDiv) {
    tempShowDiv.hide();
}

/**
 * 値がNaN、空、またはundefinedかをチェックし、必要に応じてデフォルト値を適用します。
 * また、値が文字列の場合、数値に変換し、
 * その数値が特定の配列内に存在するかどうかを確認します。
 * 存在しない場合はデフォルト値を設定します。
 *
 * @param {any} value - 確認する値
 * @param {number} defaultValue - 値が無効な場合に設定するデフォルト値
 * @param {number[]} validArray - 有効な数値の配列
 * @return {number} - 最終的に設定された値
 */
function validateAndSet(value, defaultValue, validArray) {
    // 値を数値に変換しようとする
    var numericValue = Number(value);

    // 値がNaN、空、またはundefinedか、
    // もしくは変換後の値が有効な配列に存在しないかをチェック
    if (isNaN(numericValue) || value === '' || value === undefined || !validArray.includes(numericValue)) {
        return defaultValue;
    } else {
        return numericValue;
    }
}

 
//スペースキーを押したときに、フォーカスが可視のチェックボックスにある場合、そのチェックボックスを選択または選択解除する関数

function checkboxSpacekeyDown(event) {

    var activeElement = document.activeElement.nodeName;

    if (activeElement === 'UL') {
        return;
    }

    var focus = $(':focus');

    if (!focus.is('input[type="checkbox"]:visible')) {
        return;
    }
 
    // スペースキー
    if (event.keyCode === 32) {
        event.preventDefault();

        if (focus.length > 0) {
            // trigger('click')を使用してチェックボックスを選択または選択解除

            focus.trigger('click');
        }

    }
}