﻿/* DataTable
----------------------------------*/
// 起動時のチェックON処理（選択肢）
function defaultCheckSelect(searchFilters, idSelector, classNameSelector) {
    if (searchFilters === '') {
        $(idSelector).prop('checked', true).trigger('change');
    } else {
        var count = setFilterCheck(searchFilters, classNameSelector);
        var $filterCond = $(classNameSelector);
        if (count === 0 || count !== $filterCond.length) {
            $(idSelector).prop('checked', false);
        } else {
            $(idSelector).prop('checked', true);
        }
    }
}

// フィルタダイアログのOKボタン押下時に対象のフィルタ文字列の配列を取得する
function getFilter(classNameSelector) {
    var $filterCond = $(classNameSelector);
    var filters = [];
    $.each($filterCond, function (index, value) {
        if ($(this).prop('checked')) {
            if ($(this).val() == '(^.+)') {
                filters.push('(^.+)');
            } else {
                filters.push('(^' + doRegExEncode($(this).val()) + '$)');
            }
        }
    });
    return filters;
}

// 起動時のチェックON処理時に選択されている項目をチェックONにする
function setFilterCheck(searchFilters, classNameSelector) {
    var $filterCond = $(classNameSelector);
    var count = 0;
    $.each($filterCond, function (index, value) {
        if ($(this).val() == '(^.+)') {
            value = '(^.+)'
        } else {
            value = '(^' + doRegExEncode($(this).val()) + '$)';
        }
        if (0 <= searchFilters.indexOf(value)) {
            $(this).prop('checked', true).trigger('change');
            count++;
        }
    });
    return count;
}

// DataTableのフィルタアイテムの作成（チェックボックス）
function createItems(values, convertCaption, idSelector, className, classNameSelector) {
    return $.map(values, function (value, index) {
        if (value === '') {
            return null;
        }
        var removeBRTag = value.replace(/<[Bb][rR]\/>/g, '');
        var sanitaizeValue = doSanitaizeEncode(doSanitaizeDecode(removeBRTag));
        var $checkbox = $('<input type="checkbox" class="' + className + '" value="' + sanitaizeValue + '" />')
            .change(function () { changeCheckBox($(this), idSelector, classNameSelector); });
        return $('<div class="ui-state-disabled" style="margin-left: 28px; opacity: 1.35;"   ></div>')
            .append($checkbox)
            .append(convertCaption ? convertCaption(sanitaizeValue) : sanitaizeValue);
    });
}

// DataTableのフィルタアイテムの作成（ラジオボタン）
function createConfirmRadioItems(values, convertCaption, className, radioGroupName) {
    return $.map(values, function (value, index) {
        if (value === '') {
            return null;
        }
        var sanitaizeValue = doSanitaizeEncode(doSanitaizeDecode(value));
        var $radio = $('<input type="radio" class="' + className + '" value="' + sanitaizeValue + '" name="' + radioGroupName + '" />');
        var showRadioText = convertCaption ? convertCaption(sanitaizeValue) : sanitaizeValue;
        return $('<div class="columnPopupItem"></div>')
            .append($radio)
            .append('<span style="padding: 0 0 0 8px;vertical-align: middle;position: relative;top: 1px;" class="ui-button-text">' + showRadioText+'</span>');
    });
}

// チェックボックスのON/OFFイベント
function changeCheckBox($this, idSelector, classNameSelector) {
    if ($this.is(':checked')) {
        var $filterCond = $(classNameSelector);
        var count = 0;
        $.each($filterCond, function (index, value) {
            if ($(this).is(':checked')) {
                count++;
            }
        });
        if (count !== 0 && count === $filterCond.length) {
            $(idSelector).prop('checked', true).xuxCheckbox("refresh");
        }
    } else {
        $(idSelector).prop('checked', false).xuxCheckbox("refresh");
    }
}

// ソート作成
function createSort($items, $elementsTable, columnIndex, textDesc, testAsc, isCanceledFunc) {
    var $sortDescButton = $('<input id="sortDescButton" type="button" value="' + textDesc + '" />')
        .button()
        .click(function () { toggleSort($elementsTable, columnIndex, 'desc', isCanceledFunc); });
    var $sortAscButton = $('<input class="sortAscButtonDiv" id="sortAscButton" type="button" value="' + testAsc + '" />')
        .button()
        .click(function () { toggleSort($elementsTable, columnIndex, 'asc', isCanceledFunc); });
    $items
        .append($('<div  class="ui-state-disabled" style="text-align: center; opacity: 1.35;" ></div>').append($sortDescButton).append($sortAscButton));

    changeSortButtonColor($elementsTable, columnIndex);
}

// ソート処理
function toggleSort($elementsTable, columnIndex, direction, isCanceledFunc) {
    if (isCanceledFunc != null) {
        isCanceledFunc();
    }
    
    var sortConds = $elementsTable.order();
    var sortCondIndex = indexOf(sortConds, function (cond) { return cond[0] === columnIndex; });
    if (0 <= sortCondIndex) {
        if (sortConds[sortCondIndex][1] === direction) {
            sortConds.splice(sortCondIndex, 1);
            if (sortConds.length === 0) {
                sortConds[0] = [columnIndex, direction];
            }
        }
        else {
            sortConds[sortCondIndex][1] = direction;
        }
    }
    else {
        sortConds = [[columnIndex, direction]];
    }

    $elementsTable.order(sortConds);
    $elementsTable.columns.adjust().draw();

    changeSortButtonColor($elementsTable, columnIndex);
}

// ソートボタンの色を変更する
function changeSortButtonColor($elementsTable, columnIndex) {
    //var enable = 'background: #dfeffc none repeat scroll 0 0 !important;';
    //var disable = 'background: #dfeffc none repeat scroll 0 0;';
    //var sortConds = $elementsTable.order();
    //if (0 < sortConds.length) {
    //    if (sortConds[0].length == 2) {
    //        if (sortConds[0][0] == columnIndex) {
    //            if (sortConds[0][1] == 'desc') {
    //                $('#sortDescButton.ui-button').css({ 'cssText': enable });
    //                $('#sortAscButton.ui-button').css({ 'cssText': disable });
    //            } else if (sortConds[0][1] == 'asc') {
    //                $('#sortDescButton.ui-button').css({ 'cssText': disable });
    //                $('#sortAscButton.ui-button').css({ 'cssText': enable });
    //            }
    //        }
    //    }
    //}
}
//---------------------2021-08-25add begin------------------------------//
function sortTableData(tableData, sortParam, { sortEmptyUp = false } = {}) {
    
    var descSort = sortParam && sortParam.sortOrder === 'desc';
    var sortIndex = tableData.fields.indexOf(sortParam.sortKey);
    if (sortParam && sortParam.sortKey) {
        tableData.items.sort(function (a, b) {
            var sortResult = null;
            var secondSortIndex = tableData.fields.indexOf(sortParam.secondSortKey);
            if (secondSortIndex < 0) {
                sortResult = sortSingleData(a[sortIndex], b[sortIndex]);
            } else {
                var secondSortParam = {
                    secondSortValueA: a[secondSortIndex],
                    secondSortValueB: b[secondSortIndex],
                    secondSortOrder: sortParam.secondSortOrder
                };
                sortResult = sortSingleData(a[sortIndex], b[sortIndex], { sortEmptyUp: sortEmptyUp, secondSortParam: secondSortParam });
            }
            if (sortResult === 0) {
                return sortResult;
            } else {
                return descSort ? sortResult * (-1) : sortResult;
            }
        });
    }
    return tableData;
}

var _re_formatted_numeric = /[',$£€¥%\u2009\u202F]/g;

function isNonNumber(value, re_formatted) {
    if (isParamEmpty(value)) {
        return false;
    }

    if (typeof value === 'number') {
        return false;
    }

    if (typeof value === 'string') {
        value = value.replace(re_formatted, '');
        return isNaN(value);
    }

    return true;
}

function sortObjectData(arrayObjecttemp, sortParam) {
    
    var arrayObject = arrayObjecttemp;
    if (!sortParam && !sortParam.sortOrder || sortParam.sortOrder.trim() === "") {
        return arrayObject;
    }

    var descSort = sortParam && sortParam.sortOrder === 'desc';
    if (sortParam && sortParam.sortKey) {
        var containsNonNumeric = arrayObject.some((value) => isNonNumber(value[sortParam.sortKey], _re_formatted_numeric));
        var sortKey = sortParam.sortKey;
        arrayObject.sort(function (a, b) {
            var sortResult = null;
            var secondSortKey = sortParam.secondSortKey;
            if (secondSortKey < 0) {
                sortResult = sortSingleData(a[sortKey], b[sortKey], containsNonNumeric);
            } else {
                var secondSortParam = {
                    secondSortValueA: a[secondSortKey],
                    secondSortValueB: b[secondSortKey],
                    secondSortOrder: sortParam.secondSortOrder
                };
                sortResult = sortSingleData(a[sortKey], b[sortKey], containsNonNumeric, { secondSortParam: secondSortParam })
            }
            if (sortResult === 0) {
                return sortResult;
            } else {
                return descSort ? sortResult * (-1) : sortResult;
            }
        });
    } else {
    	var containsNonNumeric = arrayObject.some((value) => isNonNumber(value, _re_formatted_numeric));
        arrayObject.sort(function (a, b) {
            return sortSingleData(a, b, containsNonNumeric);
        });
    }
    return arrayObject;
}
function sortSingleData(a, b, containsNonNumeric, { sortEmptyUp = false, secondSortParam = {} } = {}) {
    if (isParamEmpty(a) && isParamEmpty(b)) {
        return 0;
    } else if (isParamEmpty(a)) {
        return sortEmptyUp ? 1 : -1;
    } else if (isParamEmpty(b)) {
        return sortEmptyUp ? -1 : 1;
    } else if (!containsNonNumeric) {
        if (typeof a === 'string') {
            a = a.replace(_re_formatted_numeric, '')
        }
        if (typeof b === 'string') {
            b = b.replace(_re_formatted_numeric, '')
        }
        var x = parseFloat(a) || 0;
        var y = parseFloat(b) || 0;
        if (!isNaN(x) && !isNaN(y)) {
            return x < y ? -1 : x > y ? 1 : 0;
        }
    } else if (isParamEmpty(secondSortParam)) {
        return (a + '') === (b + '') ? 0 : (a + '') > (b + '') ? 1 : -1;
    } else if ((a + '') === (b + '')) {
        var secondSortResult = sortSingleData(secondSortParam.secondSortValueA, secondSortParam.secondSortValueB);
        return secondSortParam.secondSortOrder === 'asc' ? secondSortResult : parseInt('-' + secondSortResult);
    } else {
        if (a instanceof Date || b instanceof Date) {
            return a > b ? 1 : -1;
        }
        else {
           return (a + '') > (b + '') ? 1 : -1;
        }
    }
}
function isParamEmpty(param, flag) {
    if (param && typeof param === 'string') {
        param = trim(param);
    }
    if (param === undefined || param === null || param === '' || param.length === 0) {
        return true;
    } else if (flag && JSON.parse(param).length === 0) {
        return true;
    } else if (param instanceof Date) {
        return false;
    } else if (typeof param === 'object') {
        if (param instanceof Error) {
            return false;
        }
        if (Object.keys(param).length === 0) {
            return true;
        }
    }
    return false;
}
function trim(str) {
    var start = 0, end = 0;
    for (var i = 0; i < str.length; i++) {
        if (str.charCodeAt(i) !== 32) {
            start = i;
            break;
        }
    }
    for (var i = str.length - 1; i >= 0; i--) {
        if (str.charCodeAt(i) !== 32) {
            end = i + 1;
            break;
        }
    }
    return str.substring(start, end);
}
function searchTable(tempDataTableOptions, tempElementTableDataList) {
    
    //var returnRow = [];
    var tempRow = [];
    var elementTableDataList = tempElementTableDataList;
    var isSearchTable = false;
    for (var i = 0; i < tempDataTableOptions.columns.length; i++) {
        
        if (tempDataTableOptions.columns[i].searchTableFilters != "") {
            tempRow = [];
            isSearchTable = true;
            for (var k = 0; k < elementTableDataList.length; k++) {
                var keyTemp = tempDataTableOptions.columns[i].searchTableFilters.split("|");
                for (var j = 0; j < keyTemp.length; j++) {
                    if (keyTemp[j] != "") {
                        var re = new RegExp(keyTemp[j], "g");
                        var columnsText = elementTableDataList[k][tempDataTableOptions.columns[i].field];
                        if (re.test(columnsText)) {
                            tempRow.push(elementTableDataList[k]);
                        }
                    }
                  
                }
               
            }
        }
        if (i == tempDataTableOptions.columns.length - 1) {
            if (isSearchTable) {
                elementTableDataList = tempRow;
            }            
        } else if (tempRow.length >= 0 && i < tempDataTableOptions.columns.length) {
            if (isSearchTable) {
                elementTableDataList = null;
                elementTableDataList = tempRow;
            }
            
        }
    }

    return elementTableDataList;
}
//---------------------2021-08-25add end --------------------------------//