﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Login.aspx.cs" Inherits="WebRegistrationService.Login" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml" lang="ja">
<head runat="server">
    <meta charset="UTF-8" />
    <title>Login</title>
    <script type="text/javascript" charset="utf-8" src="js/LocalAccess.js"></script>
    <script type="text/javascript" charset="utf-8" src="js/apeos.js"></script>
    <script type="text/javascript" charset="utf-8" src="js/WebServiceReq.js"></script>
    <script type="text/javascript" charset="utf-8" src="js/ComFunc.js"></script>
    <script type="text/javascript" charset="utf-8" src="js/LogoutParams.js"></script>
    <script type="text/javascript" charset="utf-8" src="js/Base64.js"></script>

    <script src="xux/utilities.js"></script>
    <script src="xux/xux-js/xux-efocal-3.1.0-alpha-06.min.js"></script>
    <!-- LocaleScript Replace Start -->
    <script>
        xuxInitialize({
            prefix: "xux/",
            min: true,
            customServiceInfo: false
        });
    </script>
    <!-- LocaleScript Replace End -->
    <script>
        $(function () {
            $.xux.applicationReset(null);

            $("body").xuxPage({
                logout: function () {
                    var _localAccess = new LocalAccess();
                    _localAccess.Logout(LocalAccess.successLogout, LocalAccess.errorLogout);  
                }
            });

            $("#boundingBox").xuxBoundingBox();
            $("#customizedContent").xuxStaticText();

            document.getElementById("returnButton").onclick = function () {
                document.getElementById("dReturnButton").click();
            };

            // タイトルセット
            document.getElementById("scanTitle").textContent = "Record Link";

            function loginPromise(userId, password) {
                var name = document.getElementById("dName");
                var pass = document.getElementById("dPass");
                name.value = userId;
                pass.value = password;
                document.getElementById("dLoginButton").click();
            }

            var modalWindow = $("<div />").appendTo("body");

            modalWindow.xuxLoginModalWindow({
                login: function (event, ui) {
                    loginPromise(ui.userId, ui.password);
                },

                cancel: false,

                // Customize information area.
                information: function (content) {
                    var warnMessage = '<%=Session["WarnMessage"]%>';

                    if (warnMessage != "") {
                        $("<div class='warnMessage' />").appendTo(content).text(warnMessage).xuxStaticText();
                    }
                }
            }).xuxLoginModalWindow("open");

        });

    </script>
    <script src="js/versionInfo.js"></script>
    <link rel="stylesheet" href="css/style.css" />
</head>
<body>
    <div class="xux-header">
        <div class="xux-utilityLinksNav">
            <ul></ul>
        </div>
    </div>

    <form id="login" runat="server">
        <div class="xux-header adjust orderTop">
            <button type="button" id="returnButton" class="returnBtn"></button>
            <span id="scanTitle" class="titleWithReturn"></span>
        </div>
        <div class="xux-page-main">
        </div>

        <%-- ダミーエリア --%>
        <div style="display: none;">
            <asp:TextBox ID="dName" runat="server"></asp:TextBox>
            <asp:TextBox ID="dPass" runat="server"></asp:TextBox>
            <asp:Button ID="dLoginButton" runat="server" OnClick="dLoginButton_Click" />
            <asp:Button ID="dReturnButton" runat="server" OnClick="dReturnButton_Click" />
            <asp:Button ID="dLogoutButton" runat="server" OnClick="dLogoutButton_Click" />
        </div>
    </form>

</body>
</html>
