﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Menu.aspx.cs" Inherits="WebRegistrationService.Menu" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml" lang="ja">
<head runat="server">
    <meta charset="utf-8" />
    <title></title>
    <script type="text/javascript" charset="utf-8" src="js/LocalAccess.js"></script>
    <script type="text/javascript" charset="utf-8" src="js/apeos.js"></script>
    <script type="text/javascript" charset="utf-8" src="js/WebServiceReq.js"></script>
    <script type="text/javascript" charset="utf-8" src="js/ComFunc.js"></script>
    <script type="text/javascript" charset="utf-8" src="js/LogoutParams.js"></script>
    <script type="text/javascript" charset="utf-8" src="js/Base64.js"></script>

    <script src="xux/utilities.js"></script>
    <script src="xux/xux-js/xux-efocal-3.1.0-alpha-06.min.js"></script>
    <!-- LocaleScript Replace Start -->
    <script>
        xuxInitialize({
            prefix: "xux/",
            min: true,
            customServiceInfo: false
        });
    </script>
    <!-- LocaleScript Replace End -->

    <script>
        $(function () {
            var userName = '<%=Session["DisplayedUserName"]%>' != null ? '<%=Session["DisplayedUserName"]%>' : null;

            $("body").xuxPage({
                user: userName,
                logout: function () {
                    var _localAccess = new LocalAccess();
                    _localAccess.Logout(LocalAccess.successLogout, LocalAccess.errorLogout);   
                }
            });

            var modalWindow = $("<div />").appendTo("body"),
                table;

            $("<div class='menuTitle' />").appendTo(modalWindow).text("作業種類").xuxStaticText();

            table = $("<table />").appendTo(modalWindow);
    
            modalWindow.xuxModalWindow().xuxModalWindow("open");
    
            table.xuxTable({
                height: "auto",
                header: false,
    
                columns: [
                    {
                        field: "job"
                    }
                ],
    
                data: {
                    fields: ["job"],
                    items: [
                        ["読み取り用原紙登録"],
                        ["情報抽出"]
                    ]
                },
    
                select: function (event, ui) {
                    var selectedItems = table.xuxTable("selectionState").selectedItems,
                        selectedItem = selectedItems[0];
    
                    if (selectedItem.get('job') == "読み取り用原紙登録") {
                        document.getElementById("dFilesRegisterButton").click();
                    }
                    else if (selectedItem.get('job') == "情報抽出") {
                        document.getElementById("dOcrFilesStoreButton").click();
                    }
                }
            });

            if ('<%=Session["DisplayedUserName"]%>' == "") {
                $("#xux-utilityLinks-userIcon").addClass("noLoginIcon");
            }

        });
    </script>
    <script src="js/versionInfo.js"></script>
    <link rel="stylesheet" href="css/style.css" />
</head>

<body>
    <div class="xux-header">
        <div class="xux-utilityLinksNav">
            <ul></ul>
        </div>
    </div>

    <form id="menu" runat="server">
        <div class="xux-header adjust orderTop">
            <div id="scanTitle" class="title">Record Link</div>
        </div>
        <div class="xux-page-main">
        </div>

        <%-- ダミーエリア --%>
        <div  style="display: none;">
            <asp:Button ID="dFilesRegisterButton" runat="server" OnClick="dFilesRegisterButton_Click" />
            <asp:Button ID="dOcrFilesStoreButton" runat="server" OnClick="dOcrFilesStoreButton_Click" />
            <asp:Button ID="dLogoutButton" runat="server" OnClick="dLogoutButton_Click" />
        </div>
    </form>
</body>

</html>
