﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="SelectBusiness.aspx.cs" Inherits="WebRegistrationService.SelectBusiness" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml" lang="ja">
<head runat="server">
    <meta charset="utf-8" />
    <title></title>
    <script type="text/javascript" charset="utf-8" src="js/LocalAccess.js"></script>
    <script type="text/javascript" charset="utf-8" src="js/apeos.js"></script>
    <script type="text/javascript" charset="utf-8" src="js/WebServiceReq.js"></script>
    <script type="text/javascript" charset="utf-8" src="js/ComFunc.js"></script>
    <script type="text/javascript" charset="utf-8" src="js/LogoutParams.js"></script>
    <script type="text/javascript" charset="utf-8" src="js/Base64.js"></script>

    <script src="xux/utilities.js"></script>
    <script src="xux/xux-js/xux-efocal-3.1.0-alpha-06.min.js"></script>
    <!-- LocaleScript Replace Start -->
    <script>
        xuxInitialize({
            prefix: "xux/",
            min: true,
            customServiceInfo: false
        });
    </script>
    <!-- LocaleScript Replace End -->
    
    <script>
        $(function () {

            var userName = '<%=Session["DisplayedUserName"]%>' != null ? '<%=Session["DisplayedUserName"]%>' : null;

            $("body").xuxPage({
                user: userName,
                logout: function () {
                    var _localAccess = new LocalAccess();
                    _localAccess.Logout(LocalAccess.successLogout, LocalAccess.errorLogout);
                }
            });

            document.getElementById("returnButton").onclick = function () {
                document.getElementById("dReturnButton").click();
            };

            document.getElementById("resetButton").onclick = function () {
                document.getElementById("dResetButton").click();
            };

            // タイトルセット
            var processId = '<%=Session["ProcessId"]%>';
            document.getElementById("scanTitle").textContent = processId == "1" ? "業務選択(読み取り用原紙登録)" : "業務選択(情報抽出)";

            var modalWindow = $("<div />").appendTo("body"),
                table,
                selected = false;    // 選択済みかどうか

            // 情報抽出の場合、現在のレコード使用量を表示
            if (processId == "2") {
                modalWindow.xuxModalWindow({
                    information: function (content) {
                        var amount = '<%=Session["UsedAmount"]%>' + "/" + '<%=Session["Threshold"]%>';

                        $("<div><span class='amountTitle'>現在のレコード<br>使用量(件)</span></div>").appendTo(content).xuxStaticText();
                        $("<div />").appendTo(content).text(amount).xuxStaticText();
                    }
                })
            }

            $("<button type='button' id='nextButton'><span class='xux-icon xux-icon-dummy_00090'></span>次へ</button>")
                .appendTo(modalWindow)
                .click(function () {
                    if (!$("#nextButton").prop("disabled")) {
                        if (selected) {
                            document.getElementById("dNextButton").click();
                        }
                    }
                });
    
            var nextButton = $("#nextButton").xuxButton();
            nextButton.text("次へ");
            $("#nextButton").prop("disabled", true);
            nextButton.xuxButton("disable");
    
            table = $("<table class='marginTop10' />").appendTo(modalWindow);
    
            function initSelectedItem() {
                var selectedIndex = '<%=Session["SelectBusinessIndex"]%>';

                if (selectedIndex != -1) {
                    table.xuxTable("selectionState", {
                        initiallySelectedItemIds: [Number(selectedIndex)]
                    });

                    selected = true;

                    document.getElementById("dSelectedBusinessIndexBox").value = selectedIndex;

                    $("#nextButton").prop("disabled", false);
                    nextButton.xuxButton("enable");
                }
            }

            modalWindow.xuxModalWindow().xuxModalWindow("open");
    
            var namesStr = document.getElementById("dBusinessNamesBox").value;
            var idsStr = document.getElementById("dBusinessIdsBox").value;
    
            var names = JSON.parse(namesStr);
            var ids = JSON.parse(idsStr);
    
            var dataArray = [];
    
            for (i = 0; i < Object.keys(names).length; i++) {
                dataArray.push([i, ids[i], names[i]]);
            }
    
            table.xuxTable({
                height: "full",
                header: false,
    
                columns: [
                    {
                        field: "name"
                    }
                ],
    
                data: {
                    fields: ["index", "id", "name"],
                    items: dataArray
                },
    
                select: function (event, ui) {
                    var selectedItems = table.xuxTable("selectionState").selectedItems,
                        selectedItem = selectedItems[0];
    
                    selected = true;
    
                    document.getElementById("dSelectedBusinessIndexBox").value = selectedItem.get('index');
    
                    $("#nextButton").prop("disabled", false);
                    nextButton.xuxButton("enable");

                    document.getElementById("dBusinessChangeButton").click();
                },

                information: function (content) {
                        $("<div />").appendTo(content).text("This area can be customized.").xuxStaticText();
                },

            });
    
            initSelectedItem();

        });
    </script>
    <script src="js/versionInfo.js"></script>
    <link rel="stylesheet" href="css/style.css" />
</head>

<body>
    <div class="xux-header">
        <div class="xux-utilityLinksNav">
            <ul></ul>
        </div>
    </div>

    <form id="selectFormBusiness" runat="server">
        <div class="xux-header adjust orderTop">
            <button type="button" id="returnButton" class="returnBtn"></button>
            <span id="scanTitle" class="titleWithReturn"></span>
            <div class="xux-utilityLinksNav xux-utilityLinks xux-domAssemblyDone" id="xux-utilityLinks">
                <button type="button" id="resetButton"
                    class="xux-api-reset xux-pressable xux-button xux-domAssemblyDone xux-button-iconAndLabel xux-threePatches xux-button-defaultWidth xux-common-headerCommandButton"
                    data-message-resource-id="efocal.customserviceinfo.reset">
                    <div class="xux-threePatches-patch xux-threePatches-left"></div>
                    <div class="xux-threePatches-patch xux-threePatches-center"></div>
                    <div class="xux-threePatches-patch xux-threePatches-right"></div>
                    <span class="xux-common-resetButtonIcon xux-button-icon"></span>
                    <span class="xux-button-label">リセット</span>
                    <div class="xux-button-sense"></div>
                </button>
            </div>
            <div class="xux-common-runActivityIndicator blueLine"></div>
        </div>
        <div class="xux-page-main">
        </div>

        <%-- ダミーエリア --%>
        <div style="display: none;">
            <asp:TextBox ID="dBusinessNamesBox" runat="server"></asp:TextBox>
            <asp:TextBox ID="dBusinessIdsBox" runat="server"></asp:TextBox>
            <asp:TextBox ID="dSelectedBusinessIndexBox" runat="server"></asp:TextBox>
            <asp:Button ID="dNextButton" runat="server" OnClick="dNextButton_Click" />
            <asp:Button ID="dReturnButton" runat="server" OnClick="dReturnButton_Click" />
            <asp:Button ID="dResetButton" runat="server" OnClick="dResetButton_Click" />
            <asp:Button ID="dLogoutButton" runat="server" OnClick="dLogoutButton_Click" />
            <asp:Button ID="dBusinessChangeButton" runat="server" OnClick="dBusinessChangeButton_Click" />
        </div>
    </form>
</body>

</html>
