﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="SettingScan.aspx.cs" Inherits="WebRegistrationService.SettingScan" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml" lang="ja">
<head runat="server">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title></title>
    <script type="text/javascript" charset="utf-8" src="js/LocalAccess.js"></script>
    <script type="text/javascript" charset="utf-8" src="js/apeos.js"></script>
    <script type="text/javascript" charset="utf-8" src="js/WebServiceReq.js"></script>
    <script type="text/javascript" charset="utf-8" src="js/ComFunc.js"></script>
    <script type="text/javascript" charset="utf-8" src="js/LogoutParams.js"></script>
    <script type="text/javascript" charset="utf-8" src="js/Base64.js"></script>

    <script src="xux/utilities.js"></script>
    <script src="xux/xux-js/xux-efocal-3.1.0-alpha-06.min.js"></script>
    <!-- LocaleScript Replace Start -->
    <script>
        xuxInitialize({
            prefix: "xux/",
            min: true,
            optionalModules: ["scan"],
            customServiceInfo: false
        });
    </script>
    <!-- LocaleScript Replace End -->
    
    <script>

        $(function () {

            function moveToSelectBusiness() {
                return (moveToSelectBusiness = function () {
                    document.getElementById("dSelectBusinessButton").click();
                    window.location.href = "SelectBusiness";
                    return closePromise = $.Deferred();
                }).apply(this, arguments);
            }

            function moveToSelectForm() {
                return (moveToSelectForm = function () {
                    document.getElementById("dSelectFormButton").click();
                    window.location.href = "SelectForm";
                    return closePromise = $.Deferred();
                }).apply(this, arguments);
            }

            function moveToScanType() {
                return (moveToScanType = function () {
                    document.getElementById("dScanTypeButton").click();
                    window.location.href = "SettingScanType";
                    return closePromise = $.Deferred();
                }).apply(this, arguments);
            }

            function moveToScanSize() {
                return (moveToScanSize = function () {
                    document.getElementById("dScanSizeButton").click();
                    window.location.href = "SettingScanSize";
                    return closePromise = $.Deferred();
                }).apply(this, arguments);
            }

            document.getElementById("returnButton").onclick = function () {
                document.getElementById("dReturnButton").click();
            };

            document.getElementById("resetButton").onclick = function () {
                document.getElementById("dResetButton").click();
            };

            // タイトルセット
            var processId = '<%=Session["ProcessId"]%>';
            document.getElementById("scanTitle").textContent = processId == "1" ? "読み取り用原紙登録" : "情報抽出";

            var userName = '<%=Session["DisplayedUserName"]%>' != null ? '<%=Session["DisplayedUserName"]%>' : null;

            $("body").xuxPage({
                user: userName,
                logout: function () {
                    var _localAccess = new LocalAccess();
                    _localAccess.Logout(LocalAccess.successLogout, LocalAccess.errorLogout);   
                }
            });

            var businessName = '<%=Session["SelectBusinessName"]%>';
            var formName = '<%=Session["SelectFormName"]%>';
            var scanType = '<%=Session["ScanType"]%>';
            var scanSize = '<%=Session["ScanSize"]%>';

            $("#m").xuxScan({
                labelOfStartButton: $.xux.gestureEnabled() ? "" : "スタート",
                slideStart: $.xux.gestureEnabled(),

                items: [
                    {
                        id: "workName",
                        label: "業務",
                        initialValue: businessName,

                        edit: function () {
                            return moveToSelectBusiness();
                        }
                    },

                    {
                        id: "formName",
                        label: "帳票",
                        initialValue: formName,

                        edit: function () {
                            return moveToSelectForm();
                        }
                    },

                    {
                        group: ""
                    },

                    {
                        id: "scanType",
                        label: "帳票送り方式",
                        initialValue: scanType,
                        icon: "xux-settingAndStart-icon-duplex",

                        edit: function () {
                            return moveToScanType();
                        }
                    },

                    {
                        id: "scanSize",
                        label: "原稿サイズ",
                        initialValue: scanSize,
                        icon: "xux-settingAndStart-icon-media",

                        edit: function () {
                            return moveToScanSize();
                        }
                    }
                ],

                information: function (content) {
                    // 情報抽出の場合、現在のレコード使用量を表示
                    if (processId == "2") {
                        var amount = '<%=Session["UsedAmount"]%>' + "/" + '<%=Session["Threshold"]%>';

                        $("<div><span class='amountTitle'>現在のレコード<br>使用量(件)</span></div>").appendTo(content).xuxStaticText();
                        $("<div />").appendTo(content).text(amount).xuxStaticText();
                    }
                },

                start: function () {
                    document.getElementById("dStartButton").click();
                }
            });

        });

    </script>
    <script src="js/versionInfo.js"></script>
    <link rel="stylesheet" href="css/style.css" />
</head>
<body>
<div class="xux-header">
    <div class="xux-utilityLinksNav">
            <ul></ul>
        </div>
    </div>
	
    <form id="settingScan" runat="server">
        <div class="xux-header adjust">
            <button type="button" id="returnButton" class="returnBtn"></button>
            <span id="scanTitle" class="titleWithReturn"></span>
            <div class="xux-utilityLinksNav xux-utilityLinks xux-domAssemblyDone" id="xux-utilityLinks">
                <button type="button" id="resetButton" class="xux-api-reset xux-pressable xux-button xux-domAssemblyDone xux-button-iconAndLabel xux-threePatches xux-button-defaultWidth xux-common-headerCommandButton" data-message-resource-id="efocal.customserviceinfo.reset">
                    <div class="xux-threePatches-patch xux-threePatches-left"></div>
                    <div class="xux-threePatches-patch xux-threePatches-center"></div>
                    <div class="xux-threePatches-patch xux-threePatches-right"></div>
                    <span class="xux-common-resetButtonIcon xux-button-icon"></span>
                    <span class="xux-button-label">リセット</span>
                    <div class="xux-button-sense"></div>
                </button>
            </div>
            <div class="xux-common-runActivityIndicator blueLine"></div>
        </div>

        <div class="xux-page-main adjust" id="m">
        </div>

        <div style="display: none">
            <asp:Button ID="dStartButton" runat="server" OnClick="dStartButton_Click" />
            <asp:Button ID="dSelectBusinessButton" runat="server" OnClick="dSelectBusinessButton_Click" />
            <asp:Button ID="dSelectFormButton" runat="server" OnClick="dSelectFormButton_Click" />
            <asp:Button ID="dScanTypeButton" runat="server" OnClick="dScanTypeButton_Click" />
            <asp:Button ID="dScanSizeButton" runat="server" OnClick="dScanSizeButton_Click" />
            <asp:Button ID="dReturnButton" runat="server" OnClick="dReturnButton_Click" />
            <asp:Button ID="dResetButton" runat="server" OnClick="dResetButton_Click" />
            <asp:Button ID="dLogoutButton" runat="server" OnClick="dLogoutButton_Click" />
        </div>
    </form>
</body>
</html>