﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="SettingScanType.aspx.cs" Inherits="WebRegistrationService.SettingScanType" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml" lang="ja">
<head runat="server">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title></title>
    <script type="text/javascript" charset="utf-8" src="js/LocalAccess.js"></script>
    <script type="text/javascript" charset="utf-8" src="js/apeos.js"></script>
    <script type="text/javascript" charset="utf-8" src="js/WebServiceReq.js"></script>
    <script type="text/javascript" charset="utf-8" src="js/ComFunc.js"></script>
    <script type="text/javascript" charset="utf-8" src="js/LogoutParams.js"></script>
    <script type="text/javascript" charset="utf-8" src="js/Base64.js"></script>

    <script src="xux/utilities.js"></script>
    <script src="xux/xux-js/xux-efocal-3.1.0-alpha-06.min.js"></script>
    <!-- LocaleScript Replace Start -->
    <script>
        xuxInitialize({
            prefix: "xux/",
            min: true,
            optionalModules: ["scan"],
            customServiceInfo: false
        });
    </script>
    <!-- LocaleScript Replace End -->
    
    <script>

        $(function () {
            document.getElementById("returnButton").onclick = function () {
                document.getElementById("dReturnButton").click();
            };

            document.getElementById("resetButton").onclick = function () {
                document.getElementById("dResetButton").click();
            };

            var userName = '<%=Session["DisplayedUserName"]%>' != null ? '<%=Session["DisplayedUserName"]%>' : null;

            $("body").xuxPage({
                user: userName,
                logout: function () {
                    var _localAccess = new LocalAccess();
                    _localAccess.Logout(LocalAccess.successLogout, LocalAccess.errorLogout);                    
                }
            });

            var defaultScanType = '<%=Session["DefaultScanType"]%>';
            var scanType = '<%=Session["ScanType"]%>';

            function initSelectedItem() {
                if (scanType == "両面") {
                    $("#duplexTable").addClass("xux-table-selected");
                    if (defaultScanType == "両面") {
                        $("#simplexTable").addClass("disabled");
                    }
                }
                else if (scanType == "片面") {
                    $("#simplexTable").addClass("xux-table-selected");
                }
            }

            $("#m").xuxScan({
                labelOfStartButton: $.xux.gestureEnabled() ? "" : "スタート",
                slideStart: $.xux.gestureEnabled(),

                items: [
                    {
                        render: function (content) {
                            $("<table id='duplexTable' />").appendTo(content).xuxTable({
                                height: "auto",
                                selectionUnit: "row",

                                columns: [
                                    {
                                        field: "name"
                                    }
                                ],

                                data: {
                                    fields: ["name"],
                                    items: [
                                        ["両面"]
                                    ]
                                },

                                select: function (event, ui) {
                                    document.getElementById("dDuplexButton").click();
                                },
                            });
                        }
                    },

                    {
                        render: function (content) {
                            $("<table  id='simplexTable' />").appendTo(content).xuxTable({
                                height: "auto",
                                selectionUnit: defaultScanType == "両面" ? "none" : "row",

                                columns: [
                                    {
                                        field: "name"
                                    }
                                ],

                                data: {
                                    fields: ["name"],
                                    items: [
                                        ["片面"]
                                    ]
                                },

                                select: function (event, ui) {
                                    document.getElementById("dSimplexButton").click();
                                }
                            });
                        }
                    }
                ],

                information: function (content) {
                    // 情報抽出の場合、現在のレコード使用量を表示
                    if ('<%=Session["ProcessId"]%>' == "2") {
                        var amount = '<%=Session["UsedAmount"]%>' + "/" + '<%=Session["Threshold"]%>';

                        $("<div><span class='amountTitle'>現在のレコード<br>使用量(件)</span></div>").appendTo(content).xuxStaticText();
                        $("<div />").appendTo(content).text(amount).xuxStaticText();
                    }
                },

                start: function () {
                    document.getElementById("dStartButton").click();
                }
            });

            initSelectedItem();
        });

    </script>
    <script src="js/versionInfo.js"></script>
    <link rel="stylesheet" href="css/style.css" />
</head>
<body>
    <div class="xux-header">
        <div class="xux-utilityLinksNav">
            <ul></ul>
        </div>
    </div>

    <form id="settingScanType" runat="server">
        <div class="xux-header adjust">
            <button type="button" id="returnButton" class="returnBtn"></button>
            <span id="scanTitle" class="titleWithReturn">帳票送り方式</span>
            <div class="xux-utilityLinksNav xux-utilityLinks xux-domAssemblyDone" id="xux-utilityLinks">
                <button type="button" id="resetButton" class="xux-api-reset xux-pressable xux-button xux-domAssemblyDone xux-button-iconAndLabel xux-threePatches xux-button-defaultWidth xux-common-headerCommandButton" data-message-resource-id="efocal.customserviceinfo.reset">
                    <div class="xux-threePatches-patch xux-threePatches-left"></div>
                    <div class="xux-threePatches-patch xux-threePatches-center"></div>
                    <div class="xux-threePatches-patch xux-threePatches-right"></div>
                    <span class="xux-common-resetButtonIcon xux-button-icon"></span>
                    <span class="xux-button-label">リセット</span>
                    <div class="xux-button-sense"></div>
                </button>
            </div>
            <div class="xux-common-runActivityIndicator blueLine"></div>
        </div>
        
        <div class="xux-page-main adjust" id="m">
        </div>

        <div style="display: none">
            <asp:Button ID="dStartButton" runat="server" OnClick="dStartButton_Click"  />
            <asp:Button ID="dDuplexButton" runat="server" OnClick="dDuplexButton_Click" />
            <asp:Button ID="dSimplexButton" runat="server" OnClick="dSimplexButton_Click" />
            <asp:Button ID="dReturnButton" runat="server" OnClick="dReturnButton_Click" />
            <asp:Button ID="dResetButton" runat="server" OnClick="dResetButton_Click" />
            <asp:Button ID="dLogoutButton" runat="server" OnClick="dLogoutButton_Click" />
        </div>
    </form>
</body>
</html>