﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Menu.aspx.cs" Inherits="WebRegistrationService_forWeb.Menu" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml" lang="ja">
    <head runat="server">
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
        <meta charset="UTF-8" />
        <title>Record Link</title>
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <script src="xux/xux-js/xux-gfocal-large-light-3.1.0-alpha-06.min.js"></script>
        <!-- LocaleScript Replace Start -->
        <script>
            xuxInitialize({
                prefix: "xux/",
                min: true,
            });
        </script>
        <script src="xux/xux-js/xux-gfocal-large-fujifilmbi-3.1.0-alpha-06.min.js"></script>
        <!-- LocaleScript Replace End -->
        <link href="css/style-forWeb.css" rel="stylesheet" />
        <script>
            $(function () {

                var login = false;

                $("body").xuxPage();

                // context menu

                $("#MenuTable").xuxTable({
                    selectionUnit: "row",
                    hoverState: true
                });
                $("<span>").appendTo($(".xux-section-content"));

                // 読み取り用原紙登録選択時、ダミーの読み取り用原紙登録選択時ボタンをクリック
                $("#ToSettingOriginalForm").click(function () {
                    document.getElementById("dOriginalForm").click();
                });

                // 情報抽出選択時、ダミーの情報抽出選択時ボタンをクリック
                $("#ToSettingOrc").click(function () {
                    document.getElementById("dOcr").click();
                });

                // ログイン画面
                var loginModal = $("#LoginModal").xuxModalWindow();

                $("#InputLoginInfo").xuxApplyBoxAndLayout({
                    itemCols: 2,
                });

                var loginInputText = document.getElementsByClassName("xux-inputField-wrapper");

                for (i = 0; i < loginInputText.length; i++) {
                    loginInputText[i].classList.add("loginInputBox");
                }

                // ログイン画面が表示モードの場合
                if ('<%=Session["LoginModal"]%>' == "ON") {
                    // 読み取り用原紙登録の未認証の場合は、ログイン画面を表示
                    if ('<%=Session["ProcessId"]%>' != "1" && '<%=Session["AuthenticatedOriginalForm"]%>' == "False" && '<%=Session["ErrorModal"]%>' == "OFF") {
                        loginModal.xuxModalWindow("open");
                    }
                    // 情報抽出の未認証の場合は、ログイン画面を表示
                    if ('<%=Session["ProcessId"]%>' != "2" && '<%=Session["AuthenticatedOcr"]%>' == "False" && '<%=Session["ErrorModal"]%>' == "OFF") {
                        loginModal.xuxModalWindow("open");
                    }
                }

                // ログインエラーメッセージ
                if ('<%=Session["LoginErrMsg"]%>' != "") {
                    $("#ErrorMessage").xuxStaticText({
                        type: "fault",
                        icon: true
                    })
                    document.getElementById("LoginErrorMessage").innerHTML = '<%=Session["LoginErrMsg"]%>';

                    $("#LoginName").xuxTextFieldBox({
                        width: "full",
                        type: "fault"
                    })
                    
                    $("#LoginPassword").xuxPasswordFieldBox({
                        width: "full",
                        type: "fault"
                    })
                }

                var loginBtn = document.getElementById("LoginButton");
                var okSpan = $("#LoginButton").parent();

                okSpan.prop("id", "LoginSpan");

                // 未入力時はボタンを非活性
                loginBtn.setAttribute("disabled", "disabled");
                okSpan.addClass("xux-xuxButton-disabled ui-state-disabled");

                var nameInputBox = document.getElementById("NameInputBox");
                var passInputBox = document.getElementById("PassInputBox");

                nameInputBox.addEventListener('keyup', function () {
                    if (nameInputBox.value.length > 0) {
                        if (passInputBox.value.length > 0) {
                            // ボタンを活性化
                            loginBtn.removeAttribute("disabled");
                            okSpan.removeClass("xux-xuxButton-disabled ui-state-disabled");
                        }
                    }
                });

                passInputBox.addEventListener('keyup', function () {
                    if (passInputBox.value.length > 0) {
                        if (nameInputBox.value.length > 0) {
                            // ボタンを活性化
                            loginBtn.removeAttribute("disabled");
                            okSpan.removeClass("xux-xuxButton-disabled ui-state-disabled");
                        }
                    }
                });

                // ログインボタン押下時処理
                document.getElementById("LoginButton").onclick = function () {
                    loginModal.xuxModalWindow("close");
                    document.getElementById("dLoginName").value = document.getElementById("NameInputBox").value;
                    document.getElementById("dLoginPass").value = document.getElementById("PassInputBox").value;
                    document.getElementById("dLoginButton").click();
                };

                // キャンセルボタン押下時処理
                document.getElementById("CancelButton").onclick = function () {
                    loginModal.xuxModalWindow("close");
                    $("#NameInputBox").value = "";
                    $("#PassInputBox").value = "";
                    document.getElementById("dLoginName").value = "";
                    document.getElementById("dLoginPass").value = "";

                    document.getElementById("dCancelButton").click();
                };

                // エラー画面
                var alertModal = $("#AlertModal").xuxModalWindow({
                    type: "alert"
                });

                // エラーメッセージをセット
                document.getElementById("MiddleMsg").textContent = '<%=Session["ErrorMessage"]%>';
                if ('<%=Session["ErrorMessage"]%>' == "規程の認証失敗回数を超えました。") {
                    document.getElementById("LowerMsg").textContent = "再度接続し直してください。";
                } else {
                    document.getElementById("LowerMsg").textContent = "システム管理者にお問い合わせください。";
                }

                if ('<%=Session["ErrorModal"]%>' == "ON") {
                    alertModal.xuxModalWindow("open");
                }

                document.getElementById("CloseErrorButton").onclick = function () {
                    alertModal.xuxModalWindow("close");
                    document.getElementById("dCloseErrorButton").click();
                }

                $("article").xuxBoundingBox();

                $("footer").xuxFooter();

                // フッターにAssembly情報を表示
                $('<span id="copyright" />').appendTo($("bdo"));
                document.getElementById("copyright").innerHTML = '<%=Session["VersionInfo"]%>';
            });
        </script>     
     </head>
     <body>
        <header>
            <a href="#" title="Home">Record Link</a>
        </header>
        <main>
            <article class="headerWithoutNav">
                <section>
                    <h2>作業種類</h2>
                    <table id="MenuTable">
                        <tbody>
                        <tr>
                            <td id="ToSettingOriginalForm">読み取り用原紙登録</td>
                        </tr>
                        <tr>
                            <td id="ToSettingOrc">情報抽出</td>
                        </tr>
                        </tbody>
                    </table>
                </section>
            </article>
        </main>

        <%-- エラーメッセージダイアログ --%>
        <div id="AlertModal" data-test-options="type-alert">
            <h2>システムエラー</h2>
            <p class="errorLabel">
                システムエラーが発生しました。<br />
                <asp:Label ID="MiddleMsg" runat="server"></asp:Label>
            </p>
            <p>
                <asp:Label ID="LowerMsg" runat="server"></asp:Label>
            </p>
            <button id="CloseErrorButton" type="button">閉じる</button>
        </div>

        <%-- ログインダイアログ --%>
        <div id="LoginModal">
            <h2>ログイン</h2>
            <section id="InputLoginInfo">
                <div id="LoginName">
                    <label id="NameLabel">ユーザー名</label>
                    <input id="NameInputBox" type="text" class="loginInputBox" placeholder="ユーザー名" autocomplete="off" />
                </div>
                <div id="LoginPassword">
                    <label id="PassLabel">パスワード</label>
                    <input id="PassInputBox" type="password" class="loginInputBox" placeholder="パスワード" />
                </div>
            </section>
            <hr />
            <div id="ErrorMessage">
                <span id="LoginErrorMessage"></span>
            </div>
            <button id="CancelButton" type="button">キャンセル</button>
            <button id="LoginButton" type="button">ログイン</button>
        </div>

        <form id="DummyArea" runat="server" style="display: none" defaultbutton="dLoginButton">
            <asp:Button ID="dOriginalForm" runat="server" OnClick="dOriginalForm_Click" />
            <asp:Button ID="dOcr" runat="server" OnClick="dOcr_Click" />
            <asp:TextBox ID="dLoginName" runat="server"></asp:TextBox>
            <asp:TextBox ID="dLoginPass" runat="server"></asp:TextBox>
            <asp:Button ID="dCancelButton" runat="server" OnClick="dCancelButton_Click" />
            <asp:Button ID="dLoginButton" runat="server" OnClick="dLoginButton_Click" />
            <asp:Button ID="dCloseErrorButton" runat="server" OnClick="dCloseErrorButton_Click" />
        </form>
        <footer>
            <bdo dir="ltr"></bdo>
        </footer>
    </body>
</html>
