﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="SettingOriginalForm.aspx.cs" Inherits="WebRegistrationService_forWeb.SettingOriginalForm" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml" lang="ja">
    <head runat="server">
        <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
        <meta charset="UTF-8" />
        <title>Record Link</title>
        <meta http-equiv="X-UA-Compatible" content="IE=edge" />
        <link href="css/style-forWeb.css" rel="stylesheet" />
        <script src="xux/xux-js/xux-gfocal-large-light-3.1.0-alpha-06.min.js"></script>
        <!-- LocaleScript Replace Start -->
        <script>
            xuxInitialize({
                prefix: "xux/",
                min: true,
            });
        </script>
        <script src="xux/xux-js/xux-gfocal-large-fujifilmbi-3.1.0-alpha-06.min.js"></script>
        <!-- LocaleScript Replace End -->
        <script>
            $(function () {

                var userName = '<%=Session["DisplayedUserName"]%>' != null ? '<%=Session["DisplayedUserName"]%>' : null;

                $("body").xuxPage({
                    width: "full",
                    user: userName,
                    loginout: true,
                    logout: function () {
                        document.getElementById("dLogoutButton").click();
                    }
                });

                // 「情報抽出」タブクリック時処理
                document.getElementById("SettingOcr").onclick = function (e) {
                    e.preventDefault();
                    document.getElementById("dOcrTab").click();
                };

                $("#OriginalForm", "#BusinessBox", "#FormBox").xuxApplyBoxAndLayout({
                    labelLayout: "leading",
                    itemLayout: "horizontal",
                });

                // DBから取得した値をリストに変換
                // 業務一覧
                var businessNamesStr = document.getElementById("dBusinessNamesBox").value;
                var businessIdsStr = document.getElementById("dBusinessIdsBox").value;

                var businessNames = JSON.parse(businessNamesStr);
                var businessIds = JSON.parse(businessIdsStr);

                var businessNameArray = [];
                var businessIdArray = [];

                for (i = 0; i < Object.keys(businessNames).length; i++) {
                    businessNameArray.push(businessNames[i]);
                    businessIdArray.push(businessIds[i]);
                }

                // 帳票一覧
                var formNamesStr = document.getElementById("dFormNamesBox").value;
                var formIdsStr = document.getElementById("dFormIdsBox").value;

                var formNames = JSON.parse(formNamesStr);
                var formIds = JSON.parse(formIdsStr);

                var formNameArray = [];
                var formIdArray = [];

                for (i = 0; i < Object.keys(formNames).length; i++) {
                    formNameArray.push(formNames[i]);
                    formIdArray.push(formIds[i]);
                }

                var businessSelect = document.getElementById("BusinessSelect");
                var formSelect = document.getElementById("FormSelect");

                // ドロップダウンリストにセット
                // 業務一覧に追加
                for (i = 0; i < businessNameArray.length; i++) {
                    var businessOption = document.createElement('option');
                    businessOption.setAttribute('value', 'b_' + i.toString());
                    businessOption.innerHTML = businessNameArray[i];
                    businessSelect.appendChild(businessOption);

                    // 選択された業務を選択状態にする
                    if (i == Number('<%=Session["SelectedBusinessIndex"]%>')) {
                        businessOption.setAttribute('selected', 'selected');
                    }
                };

                // 帳票一覧に追加
                for (i = 0; i < formNameArray.length; i++) {
                    var formOption = document.createElement('option');
                    formOption.setAttribute('value', 'f_' + i.toString());
                    formOption.innerHTML = formNameArray[i];
                    formSelect.appendChild(formOption);

                    // 選択された業務を選択状態にする
                    if (i == Number('<%=Session["SelectedFormIndex"]%>')) {
                        formOption.setAttribute('selected', 'selected');
                    }
                };

                $("#BusinessBox").xuxDropdownBox();
                $("#FormBox").xuxDropdownBox();

                var dropDownContent = document.getElementsByClassName("xux-labelableBox-content");

                for (i = 0; i < dropDownContent.length; i++) {
                    dropDownContent[i].classList.add("itemChild");
                }

                $("#BusinessSelect").change(function () {
                    document.getElementById("dBusinessSelectedIndex").value = this.value.slice(2);
                    document.getElementById("dBusinessSelectedButton").click();
                });

                $("#FormSelect").change(function () {
                    document.getElementById("dFormSelectedIndex").value = this.value.slice(2);
                    document.getElementById("dFormSelectedButton").click();
                })

                // FileUpload
                $("#fileUploadBox").xuxFileUploadBox();
                $("#buttonBox").xuxButtonBox();

                var fileUploadContent = document.getElementsByClassName("xux-labelableBox-content");

                for (i = 0; i < fileUploadContent.length; i++) {
                    fileUploadContent[i].classList.add("itemChild");
                    fileUploadContent[i].classList.add("fileUploadConten");
                    fileUploadContent[i].firstElementChild.classList.add("fileUploadConten");
                }

                $("#RegisterButton").xuxButton({
                    type: "default",
                });

                // 「登録」ボタン押下時
                $("#RegisterButton").click(function () {
                    document.getElementById("dRegisterButton").click();
                })


                // ログイン画面
                var loginModal = $("#LoginModal").xuxModalWindow();

                $("#InputLoginInfo").xuxApplyBoxAndLayout({
                    itemCols: 2,
                });

                var loginInputText = document.getElementsByClassName("xux-inputField-wrapper");

                for (i = 0; i < loginInputText.length; i++) {
                    loginInputText[i].classList.add("loginInputBox");
                }

                // ログイン画面が表示モードの場合
                if ('<%=Session["LoginModal"]%>' == "ON") {
                    // 情報抽出の未認証の場合は、ログイン画面を表示
                    if ('<%=Session["ProcessId"]%>' == "2" && '<%=Session["AuthenticatedOcr"]%>' == "False" && '<%=Session["ErrorModal"]%>' == "OFF") {
                        loginModal.xuxModalWindow("open");
                    }
                }

                // ログインエラーメッセージ
                if ('<%=Session["LoginErrMsg"]%>' != "") {
                    $("#ErrorMessage").xuxStaticText({
                        type: "fault",
                        icon: true
                    })
                    document.getElementById("LoginErrorMessage").innerHTML = '<%=Session["LoginErrMsg"]%>';

                    $("#LoginName").xuxTextFieldBox({
                        width: "full",
                        type: "fault"
                    })

                    $("#LoginPassword").xuxPasswordFieldBox({
                        width: "full",
                        type: "fault"
                    })
                }

                var loginBtn = document.getElementById("LoginButton");
                var okSpan = $("#LoginButton").parent();

                okSpan.prop("id", "LoginSpan");

                // 未入力時はボタンを非活性
                loginBtn.setAttribute("disabled", "disabled");
                okSpan.addClass("xux-xuxButton-disabled ui-state-disabled");

                var nameInputBox = document.getElementById("NameInputBox");
                var passInputBox = document.getElementById("PassInputBox");

                nameInputBox.addEventListener('keyup', function () {
                    if (nameInputBox.value.length > 0) {
                        if (passInputBox.value.length > 0) {
                            // ボタンを活性化
                            loginBtn.removeAttribute("disabled");
                            okSpan.removeClass("xux-xuxButton-disabled ui-state-disabled");
                        }
                    }
                });

                passInputBox.addEventListener('keyup', function () {
                    if (passInputBox.value.length > 0) {
                        if (nameInputBox.value.length > 0) {
                            // ボタンを活性化
                            loginBtn.removeAttribute("disabled");
                            okSpan.removeClass("xux-xuxButton-disabled ui-state-disabled");
                        }
                    }
                });

                // ログインボタン押下時処理
                document.getElementById("LoginButton").onclick = function () {
                    loginModal.xuxModalWindow("close");
                    document.getElementById("dLoginName").value = document.getElementById("NameInputBox").value ? document.getElementById("NameInputBox").value : "";
                    document.getElementById("dLoginPass").value = document.getElementById("PassInputBox").value ? document.getElementById("PassInputBox").value : "";
                    document.getElementById("dLoginButton").click();
                };

                // キャンセルボタン押下時処理
                document.getElementById("CancelButton").onclick = function () {
                    loginModal.xuxModalWindow("close");
                    $("#NameInputBox").value = "";
                    $("#PassInputBox").value = "";
                    document.getElementById("dLoginName").value = "";
                    document.getElementById("dLoginPass").value = "";

                    document.getElementById("dCancelButton").click();
                };

                // 完了画面
                var finishModal = $("#FinishModal").xuxModalWindow();
                $("#FinishButton").parent().addClass("xux-type-settings");

                if ('<%=Session["FinishOriginalForm"]%>' == "True") {
                    finishModal.xuxModalWindow("open");
                }

                $("#FinishButton").click(function () {
                    document.getElementById("dFinishButton").click();
                });

                // エラー画面
                var alertModal = $("#AlertModal").xuxModalWindow({
                    type: "alert"
                });

                // エラーメッセージをセット
                document.getElementById("MiddleMsg").textContent = '<%=Session["ErrorMessage"]%>';
                if ('<%=Session["ErrorMessage"]%>' == "規程の認証失敗回数を超えました。") {
                    document.getElementById("LowerMsg").textContent = "再度接続し直してください。";
                } else {
                    document.getElementById("LowerMsg").textContent = "システム管理者にお問い合わせください。";
                }

                if ('<%=Session["ErrorModal"]%>' == "ON") {
                    alertModal.xuxModalWindow("open");
                }

                document.getElementById("CloseErrorButton").onclick = function () {
                    alertModal.xuxModalWindow("close");
                    document.getElementById("dCloseErrorButton").click();
                }

                $("article").xuxBoundingBox();

                // フッターにAssembly情報を表示
                $("footer").xuxFooter();
                $('<span id="copyright" />').appendTo($("bdo"));
                document.getElementById("copyright").innerHTML = '<%=Session["VersionInfo"]%>';

            });
        </script>
     </head>
     <body>
        <header>
            <a href="#" title="Home">Record Link</a>
            <nav>
                <ul>
                </ul>
            </nav>
        </header>
        <nav>
            <ul>
                <li class="ui-state-highlight"><a id="SettingOriginalForm" href="#">読み取り用原紙登録</a></li>
                <li><a id="SettingOcr" href="#">情報抽出</a></li>
            </ul>
        </nav>
        <main>
            <form id="OriginalFormMainArea" class="mainForm" runat="server" enctype="multipart/form-data">
                <article class="articleWidth">
                    <section id="OriginalForm">
                        <h2>読み取り用原紙登録</h2>
                        <div id="BusinessBox" class="itemBox">
                            <label class="xux-labelableBox-label itemLabel itemChild">業務選択</label>
                            <select id="BusinessSelect" style="width: 300px">
                            </select>
                        </div>
                        <div id="FormBox" class="itemBox">
                            <label class="xux-labelableBox-label itemLabel itemChild">帳票選択</label>
                            <select id="FormSelect" style="width: 300px">
                            </select>
                        </div>
                        <div id="fileUploadBox" class="fileUploadBox itemBox">
                            <label class="itemLabel itemChild">ファイル選択</label>
                            <input id="FileUploadInput" type="file" name="uploadFile"/>
                        </div>
                    </section>
                    <section id="CommandSection">
                        <div id="buttonBox" style="float: right;">
                            <button id="RegisterButton" class="xux-formControl xux-normalButton" type="button">登録</button>
                        </div>
                    </section>
                </article>

                <%-- エラーメッセージダイアログ --%>
                <div id="AlertModal">
                    <h2>システムエラー</h2>
                    <p class="errorLabel">
                        システムエラーが発生しました。<br />
                        <asp:Label ID="MiddleMsg" runat="server"></asp:Label>
                    </p>
                    <p>
                        <asp:Label ID="LowerMsg" runat="server"></asp:Label>
                    </p>
                    <button id="CloseErrorButton" type="button">閉じる</button>
                </div>

                <%-- ログインダイアログ --%>
                <div id="LoginModal">
                    <h2>ログイン</h2>
                    <section id="InputLoginInfo">
                        <div id="LoginName">
                            <label id="NameLabel">ユーザー名</label>
                            <input id="NameInputBox" type="text" class="loginInputBox" placeholder="ユーザー名" autocomplete="off" />
                        </div>
                        <div id="LoginPassword">
                            <label id="PassLabel">パスワード</label>
                            <input id="PassInputBox" type="password" class="loginInputBox" placeholder="パスワード" />
                        </div>
                    </section>
                    <hr />
                    <div id="ErrorMessage">
                        <span id="LoginErrorMessage"></span>
                    </div>
                    <button id="CancelButton" type="button">キャンセル</button>
                    <button id="LoginButton" type="button">ログイン</button>
                 </div>
                
                <%-- 完了ダイアログ --%>
                <div id="FinishModal">
                    <p class="finishLabel">
                        読み取り原紙用登録が完了しました。<br />
                    </p>
                    <button id="FinishButton" type="button" class="xux-formControl xux-normalButton">業務選択に戻る</button>
                </div>
                
                <%-- ダミーエリア --%>
                <div style="display: none">
                    <asp:Button ID="dOcrTab" runat="server" OnClick="dOcrTab_Click" />
                    <asp:TextBox ID="dBusinessNamesBox" runat="server"></asp:TextBox>
                    <asp:TextBox ID="dBusinessIdsBox" runat="server"></asp:TextBox>
                    <asp:TextBox ID="dBusinessSelectedIndex" runat="server"></asp:TextBox>
                    <asp:Button ID="dBusinessSelectedButton" runat="server" OnClick="dBusinessSelectedButton_Click" />
                    <asp:TextBox ID="dFormNamesBox" runat="server"></asp:TextBox>
                    <asp:TextBox ID="dFormIdsBox" runat="server"></asp:TextBox>
                    <asp:TextBox ID="dFormSelectedIndex" runat="server"></asp:TextBox>
                    <asp:Button ID="dFormSelectedButton" runat="server" OnClick="dFormSelectedButton_Click" />
                    <asp:Button ID="dRegisterButton" runat="server" OnClick="dRegisterButton_Click" />
                    <asp:TextBox ID="dLoginName" runat="server"></asp:TextBox>
                    <asp:TextBox ID="dLoginPass" runat="server"></asp:TextBox>
                    <asp:Button ID="dCancelButton" runat="server" OnClick="dCancelButton_Click" />
                    <asp:Button ID="dLoginButton" runat="server" OnClick="dLoginButton_Click" />
                    <asp:Button ID="dFinishButton" runat="server" OnClick="dFinishButton_Click" />
                    <asp:Button ID="dLogoutButton" runat="server" OnClick="dLogoutButton_Click" />
                    <asp:Button ID="dCloseErrorButton" runat="server" OnClick="dCloseErrorButton_Click" />
                </div>
            </form>
        </main>
        <footer>
            <bdo dir="ltr"></bdo>
        </footer>
    </body>
</html>
