
////////////////////////////////////////////////////////////////

var g_fontSizeClass;

$(function() {
	var map = [];

	var params = $(location).attr("search").substr(1).split("&");

	for (var i = 0; i < params.length; i++) {
		var keyValue = params[i].split("=");

		map[keyValue[0]] = decodeURIComponent(keyValue[1]);
	}

	if (map["font-size"]) {
		g_fontSizeClass = map["font-size"];
	} else {
		g_fontSizeClass = "medium";
	}

	$("body").removeClass("small");
	$("body").removeClass("medium");
	$("body").removeClass("large");

	$("body").addClass(g_fontSizeClass);
});

$.fn.rotateFontSizeClass = function() {
	if (g_fontSizeClass == "small") {
		g_fontSizeClass = "medium";
	} else if (g_fontSizeClass == "medium") {
		g_fontSizeClass = "large";
	} else if (g_fontSizeClass == "large") {
		g_fontSizeClass = "small";
	}

	$("body").removeClass("small");
	$("body").removeClass("medium");
	$("body").removeClass("large");

	$("body").addClass(g_fontSizeClass);
}

$.fn.appendFontSizeClass = function(element) {
	if (g_fontSizeClass == "medium") {
		;
	} else if (g_fontSizeClass == "small" ||
	           g_fontSizeClass == "large") {
		if (element.href.indexOf("?") == -1) {
			element.href += "?";
		} else {
			element.href += "&";
		}

		element.href += "font-size" + "=" + g_fontSizeClass;
	}
}

////////////////////////////////////////////////////////////////

var g_toggleIndex;

$(function() {
	var map = [];

	var params = $(location).attr("search").substr(1).split("&");

	for (var i = 0; i < params.length; i++) {
		var keyValue = params[i].split("=");

		map[keyValue[0]] = decodeURIComponent(keyValue[1]);
	}

	if (map["index"]) {
		g_toggleIndex = map["index"];
	} else {
		g_toggleIndex = "show";
	}

	if (g_toggleIndex == "show") {
		$("#toggle").text("サイドバーを隠す");

		$(".lyt-side").css("display", "block");
	} else if (g_toggleIndex == "hide") {
		$("#toggle").text("サイドバーを表示する");

		$(".lyt-side").css("display", "none");
	}
});

$.fn.toggleIndex = function() {
	if (g_toggleIndex == "show") {
		g_toggleIndex = "hide";
	} else if (g_toggleIndex == "hide") {
		g_toggleIndex = "show";
	}

	if (g_toggleIndex == "show") {
		$("#toggle").text("サイドバーを隠す");

		$(".lyt-side").css("display", "block");
	} else if (g_toggleIndex == "hide") {
		$("#toggle").text("サイドバーを表示する");

		$(".lyt-side").css("display", "none");
	}
}

$.fn.appendToggleIndex = function(element) {
	if (g_toggleIndex == "show") {
		;
	} else if (g_toggleIndex == "hide") {
		if (element.href.indexOf("?") == -1) {
			element.href += "?";
		} else {
			element.href += "&";
		}

		element.href += "index" + "=" + g_toggleIndex;
	}
}

////////////////////////////////////////////////////////////////

$(function() {
	$(".index").on("click", function(event) {
		if ($(this).parent("li").hasClass("fold")) {
			if ($(this).parent("li").parent("ul").parent("li").length > 0) {
				$.fn.appendFontSizeClass(this);
				$.fn.appendToggleIndex(this);
			} else {
				$(this).parent("li").removeClass("fold");
				$(this).parent("li").addClass("unfold");

				event.preventDefault();
			}
		} else if ($(this).parent("li").hasClass("unfold")) {
			$(this).parent("li").removeClass("unfold");
			$(this).parent("li").addClass("fold");

			event.preventDefault();
		} else {
			$.fn.appendFontSizeClass(this);
			$.fn.appendToggleIndex(this);
		}
	});
});

