/**
 * @description Local language JavaScript code.
**/
(function (win, doc, $) {
    'use strict';

    win.localData = {
        flyoutUrl: '/common/flyout/partof.html',
        newsUrl: 'http://news.fujixerox.co.jp/newsfujixeroxapi/newslist/ja',
        text: {
            play: '\u518D\u751F',                   // 再生
            stop: '\u505C\u6B62',                   // 停止
            next: '\u6B21\u3078',                   // 次へ
            prev: '\u623B\u308B',                   // 戻る
            more: '\u7D9A\u304D\u3092\u898B\u308B', // 続きを見る
            close: '\u9589\u3058\u308B',            // 閉じる
            search: '\u691c\u7d22'                  // 検索
        },
        option: {
            staticHeader: false,
            legacyFont: false
        },
        drillDown: {
            general: {
                structureXml: '/_dev/comp/xml/jpn/data_structure.xml',
                dataXml: '/_dev/comp/xml/jpn/data_list.xml'
            },
            product: {
                xml: '/_dev/comp/xml/jpn/product_list.xml',
                template: '<ol>' +
                  '<li><span><b>STEP1</b> ご利用のハードウェア/ソフトウェアの選択</span>' +
                    '<ol>' +
                      '<li class="close"><span>商品分野を選択</span>' +
                        '<div class="select">' +
                          '<div>' +
                            '<ul class="link-list bi-category"></ul>' +
                          '</div>' +
                        '<!-- /select --></div>' +
                      '</li>' +
                      '<li class="close"><span>商品シリーズを選択</span>' +
                        '<div class="select">' +
                          '<div>' +
                            '<p class="attention">先に<em>1.商品分野</em>を選択してください</p>' +
                            '<p class="attention skip" style="display:none;">直接、<em>3.商品を選択</em>してください</p>' +
                            '<ul class="link-list bi-series"></ul>' +
                          '</div>' +
                        '<!-- /select --></div>' +
                      '</li>' +
                      '<li class="close"><span>商品を選択</span>' +
                        '<div class="select">' +
                          '<div>' +
                            '<p class="attention">先に<em>2.商品シリーズ</em>を選択してください</p>' +
                            '<ul class="link-list bi-product"></ul>' +
                          '</div>' +
                        '<!-- /select --></div>' +
                      '</li>' +
                    '</ol>' +
                  '</li>' +
                  '<li><span><b>STEP2</b> 選択された商品のサポート情報</span>' +
                    '<div class="result">' +
                      '<p class="attention"><em>STEP1</em>で商品を選択してください</p>' +
                    '</div>' +
                  '</li>' +
                '</ol>',
                text: {
                    support: ' のサポート情報へ',
                    related: 'よく見られているページ'
                }
            }
        }
    };
}(window, window.document, window.jQuery));
