/*
 * @description global JavasSript code.
 * @namespace fx
 */
(function (win, doc, $, callToUtilities, callToPlugins) {
    'use strict';

    var self;
    var SetFxObject = function (localizeProperty) {
        self = this;

        this.local = localizeProperty;
        this.elm = {};
        this.stat = {};
        this.util = null;
    };

    SetFxObject.prototype = {
        initializeFx: function () {
            this.updateElements();
            this.util = callToUtilities(win, doc, $, this.elm);
            this.defineSetting();
            callToPlugins(win, doc, $, this.elm, this.util, this.stat, this.local);
            this.setupFunctionStructures();
            this.setupFunctionModules();
        },
        updateElements: function () {
            this.elm.$win = $(window);
            this.elm.$doc = $(document);
            this.elm.$body = $('body');
            this.elm.$htmlAndBody = $('html, body');
            this.elm.$header = $('#header');
            this.elm.$footer = $('#footer');
            this.elm.$content = $('#content');
            this.elm.$btnNavMenu = this.elm.$header.find('.btn-nav-menu');
            this.elm.$btnNavSearch = this.elm.$header.find('.btn-nav-search');
        },
        defineSetting: function () {
            this.stat = {
                break: 'xs',
                xs: false,
                lg: false,
                md: false,
                unmd: false,
                sm: false
            };

            this.util.resize.regist(function () {
                self.stat.xs = matchMedia('(max-width: 767px)').matches;
                self.stat.lg = matchMedia('(min-width: 1200px)').matches;
                self.stat.md = matchMedia('(min-width: 992px)').matches;
                self.stat.unmd = matchMedia('(max-width: 991px)').matches;
                self.stat.sm = matchMedia('(min-width: 768px)').matches;

                if (self.stat.xs) {
                    self.stat.break = 'xs';
                } else if (self.stat.lg) {
                    self.stat.break = 'lg';
                } else if (self.stat.md) {
                    self.stat.break = 'md';
                } else if (self.stat.sm) {
                    self.stat.break = 'sm';
                }

                self.elm.$win.trigger('scroll.globally');
            });

            if (this.local.option.legacyFont) {
                this.elm.$body.addClass('opt-legacy-font');
            }
        },
        setupFunctionStructures: function () {
            var fx = this;

            fx.structureHeaderFixedScroll();
            fx.structureHeaderSearchToggle();
            fx.structureHeaderNavToggle();
            fx.structureHeaderSearchFromFixedBtn();
            fx.structureHeaderNavFlyout({
                file: self.local.flyoutUrl
            });
            fx.moduleVideoLooping();
        },
        setupFunctionModules: function () {
            var fx = this;

            fx.moduleHeroBanner();
            fx.moduleCommonBanner();
            fx.moduleDropDown();
            fx.moduleExpandableDrawer();
            fx.moduleCarousel();
            fx.moduleCalloutCopy();
            fx.moduleLytEnhance();
            fx.moduleInsight();
            fx.moduleLayoutSocial();

            $('div.main-visual').keyVisualControl({
                auto: 8000,
                text: {
                    play: self.local.text.play,
                    stop: self.local.text.stop
                }
            });
            $('div.carousel').carousel({
                ui: {
                    next: self.local.text.next,
                    prev: self.local.text.prev
                }
            });
            $('a.modal').modalizeContents({
                text: {
                    close: self.local.text.close
                }
            });
            $('div.generate-news').generateNews({
                url: self.local.newsUrl
            });
            $('.roll').setImageRoll();
            $('p.image-full').rwdImageAlt();
            $('div.toggle').togglePanel();
            $('img[usemap]').rwdImageMaps();
            $('table.tbl-sort').sortableTable();
            $('.nav-internal').find('a').setAnimateScroll({
                target: this.elm.$htmlAndBody,
                offsetTop: function () {
                    if (self.local.option.staticHeader) {
                        return 0;
                    } else if (!self.elm.$header.hasClass('fixed')) {
                        self.elm.$header.addClass('fixed');
                    }

                    return self.elm.$header.height() + 10;
                }
            });
            $('.toggle-01').accordionPanel();
            $('.toggle-02').accordionPanel({
                accordionMode: true
            });
            $('.tab, .tab-03').setRWDToggleTab();
            $('div.drill-down').browseItem1({
                xml: self.local.drillDown.product.xml,
                template: self.local.drillDown.product.template,
                text: self.local.drillDown.product.text
            });
            $('div.drill-down-general').browseItem3({
                structureXml: self.local.drillDown.general.structureXml,
                dataXml: self.local.drillDown.general.dataXml
            });
            $('.file-size').setFileSize();
            $('.embed-gmaps').setGoogleMaps();

            self.elm.$content.find('a[href^="#"]').on('click', function (event) {
                var $this = $(this);

                if (!this.hash) {
                    return;
                } else if (
                    self.util.isExistElement($this.closest('.nav-internal')) ||
                    self.util.isExistElement($this.closest('.tab-list')) ||
                    $this.hasClass('modal')
                ) {
                    return;
                }

                if (self.util.unExistElement($('#' + this.hash.split('#')[1]))) {
                    return;
                }

                event.preventDefault();

                if (!self.elm.$header.hasClass('fixed')) {
                    self.elm.$header.addClass('fixed');
                }

                location.hash = this.hash;

                win.scrollTo(0, self.elm.$content.find('#' + $this[0].hash.split('#')[1]).offset().top - self.elm.$header.height() - 10);
            });

            if (document.readyState === 'complete') {
                setTimeout(function () {
                    $('[data-height-adjust]').setAdjustHeight();
                    $('.bnr-01').parents('.col-row').attr('data-height-adjust', 'false,.bnr-01').setAdjustHeight();
                }, 10);
            } else {
                this.elm.$win.on('load', function () {
                    $('[data-height-adjust]').setAdjustHeight();
                    $('.bnr-01').parents('.col-row').attr('data-height-adjust', 'false,.bnr-01').setAdjustHeight();
                });
            }
        },
        structureHeaderFixedScroll: function () {
            var loadOnce;

            if (this.local.option.staticHeader) {
                self.elm.$header.addClass('opt-static-header');
                self.elm.$body.addClass('opt-static-header');

                return;
            }

            if (this.util.unExistElement(this.elm.$header)) {
                return;
            }

            loadOnce = false;

            this.elm.$win.on({
                'scroll.globally': function () {
                    if ($(this).scrollTop() > (self.stat.md ? 80 : 0)) {
                        self.elm.$header.addClass('fixed');

                        if (!loadOnce && location.hash && self.elm.$header.hasClass('fixed')) {
                            loadOnce = true;

                            setTimeout(function () {
                                win.scrollTo(0, self.elm.$content.find('#' + location.hash.split('#')[1]).offset().top - self.elm.$header.height() - 10);
                            }, 100);
                        }
                    } else {
                        self.elm.$header.removeClass('fixed');
                    }
                }
            });
        },
        structureHeaderSearchToggle: function () {
            var $siteSerach = this.elm.$header.find('.site-search');

            if (this.util.unExistElement($siteSerach)) {
                return;
            }

            $siteSerach.attr('role', 'search');

            this.util.initAriaToBtn(this.elm.$btnNavSearch, $siteSerach, 'site-search');

            this.elm.$btnNavSearch.on({
                'click.structureSearchToggle': function () {
                    var $self = $(this);

                    if (self.util.isAriaExpanded(self.elm.$btnNavMenu)) {
                        self.elm.$btnNavMenu.trigger('click.structureHeaderNavToggle');
                    }

                    self.util.tglAriaBtn($self);
                    self.util.tglAriaExpanded($siteSerach);
                }
            });

            self.util.resize.regist(function () {
                if (self.stat.md) {
                    self.util.changeAriaToBtn(self.elm.$btnNavSearch, $siteSerach, true);
                } else {
                    self.util.changeAriaToBtn(self.elm.$btnNavSearch, $siteSerach, false);
                }
            });
        },
        structureHeaderNavToggle: function () {
            var $navPrimary = $('#nav-primary');
            var $navSecondary = $('#nav-secondary');
            var $navAll = $navPrimary.add($navSecondary);

            if (this.util.unExistElement(this.elm.$btnNavMenu)) {
                return;
            }

            $navAll.attr('aria-hidden', 'true');
            $navSecondary.attr('role', 'navigation');

            this.elm.$btnNavMenu.attr({
                'aria-expanded': false,
                'aria-pressed': false,
                'aria-controls': 'nav-primary nav-secondary'
            }).on({
                'click.structureHeaderNavToggle': function () {
                    var $self = $(this);

                    if (self.util.isAriaExpanded(self.elm.$btnNavSearch)) {
                        self.elm.$btnNavSearch.trigger('click.structureSearchToggle');
                    }

                    if (self.util.isAriaExpanded($self)) {
                        self.elm.$header.removeClass('is-opened-menu');
                        $self.attr('aria-expanded', false);
                        $navAll.attr({
                            'aria-hidden': true,
                            'aria-expanded': false
                        });
                    } else {
                        self.elm.$header.addClass('is-opened-menu');
                        $self.attr('aria-expanded', true);
                        $navAll.attr({
                            'aria-hidden': false,
                            'aria-expanded': true
                        });
                    }
                }
            });

            this.util.resize.regist(function () {
                self.elm.$header.removeClass('is-opened-menu');

                if (self.stat.unmd) {
                    $navPrimary.css('top', self.util.getHeaderHeight());
                    $navSecondary.css('top', self.util.getHeaderHeight() + $navPrimary.height() + 1);
                    self.elm.$btnNavMenu.attr('aria-expanded', false);
                    $navAll.attr({
                        'aria-hidden': true,
                        'aria-expanded': false
                    });
                } else {
                    $navAll.css('top', 'auto');
                    self.elm.$btnNavMenu.attr('aria-expanded', true);
                    $navAll.attr({
                        'aria-hidden': false,
                        'aria-expanded': true
                    });
                }
            });
        },
        structureHeaderSearchFromFixedBtn: function () {
            var $siteSerach = this.elm.$header.find('.site-search');
            var $navPrimary = this.elm.$header.find('.nav-primary');
            var $navMain = $navPrimary.find('.nav-main');
            var $btn;

            if (this.util.unExistElement($siteSerach) || this.util.unExistElement($navPrimary) || this.util.unExistElement($navMain)) {
                return;
            }

            $btn = $('<button type="button" class="btn-nav-search visible-fixed"><span>' + this.local.text.search + '</span></button>');

            $btn.on({
                'click.structureHeaderSearchFromFixedBtn': function () {
                    if (self.elm.$header.hasClass('fixed')) {
                        self.elm.$htmlAndBody.animate({
                            scrollTop: 0
                        }, function () {
                            $siteSerach.find('input[type="search"]').focus();
                        });
                    }
                }
            });

            $('.nav-primary').find('.nav-main').after($btn);
        },
        structureHeaderNavFlyout: function (obj) {
            var $navPrimary = $('#nav-primary');
            var $navMain = $navPrimary.find('.nav-main');
            var $navSub = $navPrimary.find('.nav-sub');
            var $nav = $navMain.add($navSub).find('> li > a, > li > em > a');

            $navPrimary.flyout({
                file: obj.file,
                callback: function () {
                    $nav.eachF(function () {
                        var $this = $(this);
                        var $flyout = $this.closest('li').find('.flyout');

                        if ($flyout.length) {
                            $this.addClass('link-next');
                            $flyout.prepend('<button class="link-return">' + $this.text() + '</button>');
                        } else {
                            $this.addClass('link-direct');
                        }
                    });

                    $nav.filter('.link-next').on('click', function (event) {
                        var $flyout;
                        var $flyoutDl;

                        if (self.stat.md) {
                            return;
                        }

                        event.preventDefault();
                        $navPrimary.addClass('is-visible-flyout');

                        $flyout = $(this).closest('li').find('.flyout');
                        $flyoutDl = $flyout.find('> dl');

                        $flyout.css('visibility', 'visible').addClass('is-opened');
                        $flyoutDl.height($(win).height() + self.elm.$win.scrollTop() - $flyoutDl.offset().top);
                    });

                    $navPrimary.find('.link-return').on('click', function () {
                        $(this).closest('.flyout').removeClass('is-opened');
                        setTimeout(function () {
                            $navPrimary.removeClass('is-visible-flyout');
                        }, 250);
                    });


                    (function () {
                        var $flyoutSocialbtn = $('.flyout-socialbtn');

                        if (self.util.unExistElement($flyoutSocialbtn)) {
                            return;
                        } else {
                            self.processSnsComponent().twitter($flyoutSocialbtn.find('.btn-twitter'));
                            self.processSnsComponent().facebook($flyoutSocialbtn.find('.btn-facebook'));
                        }
                    }());
                }
            });
        },
        moduleHeroBanner: function () {
            var $heroBanner = $('.hero-banner');
            var $heroBannerBlur = $heroBanner.filter('[class*="blur"]');
            var $heroBannerNallow = $heroBanner.filter('.nallow');
            var $heroBannerAnimate = $heroBanner.filter('[class*="animate-type"]');

            if (this.util.isExistElement($heroBannerBlur)) {
                $heroBannerBlur.eachF(function () {
                    var $self = this;
                    var $background = $self.find('.background');
                    var $img = $background.find('img');
                    var $col = $self.find('.col');
                    var blurCover;

                    $self.addClass('is-covered');
                    $col.prepend('<div class="blur-cover" style="background-image: url(' + $img[0].src + ')" />');

                    blurCover = $col.find('.blur-cover').css('filter');

                    if (blurCover === 'none') {
                        $col.find('.blur-cover').addClass('on-svg');

                        var svg = '<svg><defs><filter id="blur"><feGaussianBlur stdDeviation="13"/></filter></defs><image xlink:href="' + $img[0].src + '" width="1200" height="100%" filter="url(#blur)"/></svg>';

                        $col.find('.blur-cover').prepend(svg);
                    }
                });
            }

            if (this.util.isExistElement($heroBannerNallow)) {
                $heroBannerNallow.eachF(function () {
                    var $self = this;
                    var $background = $self.find('.background');
                    var $img = $background.find('img');

                    $background.attr('style', 'background-image: url(' + $img[0].src + ')');
                    $img.hide();
                });
            }

            $heroBanner.eachF(function () {
                var $self = this;
                var $background = $self.find('.background');
                var $img = $background.find('img');

                // Experimental
                if ($self.hasClass('is-flex')) {
                    $background.css('background-image', 'url(' + $img.attr('src') + ')');
                }
            });

            if (this.util.isExistElement($heroBannerAnimate)) {
                $heroBannerAnimate.find('.background').find('img').addClass('animated');
            }
        },
        moduleLytEnhance: function () {
            var $lytEnhance = $('#enhanced-header').find('.bg-image');
            var $img;

            if (this.util.unExistElement($lytEnhance)) {
                return;
            }

            $img = $lytEnhance.find('img');
            $lytEnhance.css('background-image', 'url(' + $img.attr('src') + ')');
            $img.remove();
        },
        moduleCommonBanner: function () {
            var $commonBanner = $('.bnr-01');

            if (this.util.unExistElement($commonBanner)) {
                return;
            }

            $commonBanner.eachF(function () {
                var $self = this;
                var $image = $self.find('.image');
                var $img = $image.find('img');

                if (self.util.unExistElement($image)) {
                    return;
                }

                $image.attr('style', 'background-image: url(' + $img[0].src + ')');
                $img.addClass('unvisible');
            });
        },
        moduleDropDown: function () {
            var $dropdown = $('select.dropdown');
            var template;

            if (this.util.unExistElement($dropdown)) {
                return;
            }

            template = '<div class="dropdown-imitation"><button class="dropdown-btn"></button><ul class="dropdown-list"></ul></div>';

            $dropdown.eachF(function () {
                var $this = $(this);
                var $option = $this.find('option');
                var $template = $(template);
                var $btn = $template.find('.dropdown-btn');
                var $list = $template.find('.dropdown-list');
                var textHtml = '';


                $option.eachF(function () {
                    textHtml += '<li><button value="' + $(this).val() + '">' + $(this).text() + '</button></li>';
                });

                $btn.text($option.filter(':selected').text());
                $list.html(textHtml);

                $this.after($template);

                $btn.on({
                    'click.moduleDropDown': function () {
                        $(this).closest('.dropdown-imitation').toggleClass('active');
                    }
                });
                $list.find('button').on({
                    'click.moduleDropDown': function () {
                        $(this).closest('.dropdown-imitation').removeClass('active');
                        $btn.text($(this).text());
                        $this.val($(this).val()).trigger('change');
                    }
                });
            });
        },
        moduleExpandableDrawer: function () {
            var $drawer = $('.expandable-drawer');

            if (this.util.unExistElement($drawer)) {
                return;
            }

            $drawer.find('.hook').wrapInner('<button>').find('button').on({
                'click.moduleExpandableDrawer': function () {
                    var $target = $(this).closest('.expandable-drawer');

                    if ($target.hasClass('open')) {
                        $target.removeClass('open').addClass('close');
                    } else {
                        $target.addClass('open').removeClass('close');
                    }
                }
            });
        },
        moduleCalloutCopy: function () {
            var $calloutCopy = $('.callout-copy');

            if (self.util.unExistElement($calloutCopy)) {
                return;
            }

            $calloutCopy.eachF(function () {
                var $self = $(this);
                var $target = $self.find('.more');

                $target.before('<span class="dotted">...</span><button class="hook" type="button">' + self.local.text.more + '</button>');

                $self.find('.hook').on({
                    'click.moduleCalloutCopy': function () {
                        $target.addClass('open');
                        $(this).remove();
                        $self.find('.dotted').remove();
                    }
                });
            });
        },
        moduleCarousel: function () {
            var $root01 = $('.carousel-01');
            var $root02 = $('.carousel-02');
            var $root03 = $('.carousel-03');
            var $root04 = $('.carousel-04');
            var $root05 = $('.carousel-05');
            var $root06 = $('.carousel-06');

            if (self.util.unExistElement(
                $root01.add($root02).add($root03).add($root04).add($root05).add($root06)
            )) {
                return;
            }

            $.getScript('/common_v6/src/js/lib/slick.min.js').done(function () {
                var carouselCommonObject = {
                    btnDotHTML: '<div class="carousel-dots"></div>'
                };
                var carouselCommonSetting = {
                    dots: true,
                    prevArrow: '<button class="prev arrow" aria-label="Previous" role="button"><span>' + self.local.text.prev + '</span></button>',
                    nextArrow: '<button class="next arrow" aria-label="Next" role="button"><span>' + self.local.text.next + '</span></button>',
                    customPaging: function (slider, i) {
                        return '<button type="button" data-role="none"><span class="in-button">' + (i + 1) + '</span></button>';
                    }
                };
                var setCarousel = function ($target, object) {
                    $target.eachF(function () {
                        var $this = $(this);

                        $this.before(carouselCommonObject.btnDotHTML).slick(
                            $.extend(carouselCommonSetting, {
                                appendDots: $this.prev('.carousel-dots')
                            }, object)
                        );

                        self.elm.$win.on('update.carousel', function () {
                            $this.slick('setPosition');
                        });
                    });
                };
                var option;

                if (self.util.isExistElement($root01)) {
                    setCarousel($root01, {
                        responsive: [
                            {
                                breakpoint: 768,
                                settings: {
                                    slidesToShow: 1,
                                    slidesToScroll: 1
                                }
                            }
                        ]
                    });
                }

                if (self.util.isExistElement($root02)) {
                    setCarousel($root02, {
                        slidesToShow: 2,
                        slidesToScroll: 2,
                        responsive: [
                            {
                                breakpoint: 768,
                                settings: {
                                    slidesToShow: 1,
                                    slidesToScroll: 1
                                }
                            }
                        ]
                    });
                }

                if (self.util.isExistElement($root03)) {
                    var $image = $root03.find('.image');

                    $image.eachF(function () {
                        var $img = $(this).find('img');

                        $(this).css('background-image', 'url(' + $img[0].src + ')');
                        $img.hide();
                    });

                    setCarousel($root03, {
                        slidesToShow: 1,
                        slidesToScroll: 1
                    });
                }

                if (self.util.isExistElement($root04)) {
                    setCarousel($root04, {
                        slidesToShow: 4,
                        slidesToScroll: 4,
                        responsive: [
                            {
                                breakpoint: 768,
                                settings: {
                                    slidesToShow: 1,
                                    slidesToScroll: 1
                                }
                            }
                        ]
                    });
                }

                if (self.util.isExistElement($root05)) {
                    setCarousel($root05, {
                        slidesToShow: 3,
                        slidesToScroll: 3,
                        prevArrow: false,
                        nextArrow: false,
                        responsive: [
                            {
                                breakpoint: 768,
                                settings: {
                                    slidesToShow: 1,
                                    slidesToScroll: 1
                                }
                            }
                        ]
                    });
                }

                if (self.util.isExistElement($root06)) {
                    option = {
                        fade: true,
                        prevArrow: false,
                        nextArrow: false,
                        speed: 200
                    };

                    $root06.eachF(function () {
                        if (this.hasClass('autoplay')) {
                            option.autoplay = true;
                            option.autoplaySpeed = 5000;
                        }

                        setCarousel(this, option);
                    });
                    $root06.prev('.carousel-dots').show();
                }
            });
        },
        moduleVideoLooping: function () {
            var $videoLooping = $('.video-looping');

            if (this.util.unExistElement($videoLooping)) {
                return;
            }

            $videoLooping.eachF(function () {
                var $this = $(this);

                if (!$this[0].dataset) {
                    return;
                }

                if (!$this[0].dataset.videoSrc) {
                    return;
                }

                var htmlText = '<div class="video"><video src="' + $this[0].dataset.videoSrc + '" autoplay loop muted></video></div>';
                $(this).append(htmlText);
            });
        },
        moduleInsight: function () {
            var $lytInsight = $('.lyt-insight');

            if (this.util.unExistElement($lytInsight)) {
                return;
            }

            var $insightFilterList = $lytInsight.find('.insight-filter-list');
            var $insightLytCol = $lytInsight.find('.insight-lyt-col');
            var $insightItem = $insightLytCol.find('.insight-item');
            var $insightBtnMore = $lytInsight.find('.insight-btn-more');
            var $insightBtnGrid = $insightFilterList.find('.insight-btn-grid');
            var $insightBtnList = $insightFilterList.find('.insight-btn-list');
            var $insightTextUndefined = $lytInsight.find('.insight-text-undefined');
            var $insightFilterCategory = $insightFilterList.find('select[data-filter-name="category"]');
            var $insightFilterType = $insightFilterList.find('select[data-filter-name="type"]');
            var $insightFilterIndustries = $insightFilterList.find('select[data-filter-name="industries"]');
            var currentViewIdx = 0;
            var filterParam;
            var initFilterParam = function () {
                filterParam = {
                    category: 'all',
                    type: 'all',
                    industries: 'all'
                };
            };
            var initIndustries = function () {
                $insightFilterIndustries.parent().hide();
                filterParam.industries = 'all';
                $insightFilterIndustries.next('.dropdown-imitation').find('.dropdown-list button').eq(0).trigger('click');
            };
            var initFilter = function (flag) {
                initFilterParam();

                if (!flag) {
                    $insightFilterCategory.next('.dropdown-imitation').find('.dropdown-list button').eq(0).trigger('click');
                    $insightFilterType.next('.dropdown-imitation').find('.dropdown-list button').eq(0).trigger('click');
                    initIndustries();
                }

                $insightTextUndefined.hide();
                $insightItem.addClass('is-target');
                currentViewIdx = 9;
                $insightItem.show();
                $insightItem.filter(':gt(8)').hide();
                if ($insightItem.length > 9) {
                    $insightBtnMore.show();
                }
            };
            var itemShowAdd = function (getNum) {
                currentViewIdx += getNum;
                var $numAfterItem = $insightItem.filter('.is-target').filter(':gt(' + (currentViewIdx - 1) + ')');
                $insightItem.filter('.is-target').show();
                $numAfterItem.hide();

                if ($numAfterItem.length === 0) {
                    $insightBtnMore.hide();
                } else {
                    $insightBtnMore.show();
                }
            };
            var itemFilter = function (type, value) {
                filterParam[type] = value;

                var filterSelectorTxt = '';
                var $target;

                if (filterParam.category !== 'all') {
                    filterSelectorTxt += '[data-item-category="' + filterParam.category + '"]';
                }
                if (filterParam.type !== 'all') {
                    filterSelectorTxt += '[data-item-type="' + filterParam.type + '"]';
                }
                if (filterParam.industries !== 'all') {
                    filterSelectorTxt += '[data-item-industries="' + filterParam.industries + '"]';
                }
                if (filterSelectorTxt === '') {
                    initFilter(true);
                } else {
                    $insightItem.removeClass('is-target').hide();
                    $insightItem.filter(filterSelectorTxt).show().addClass('is-target');
                    currentViewIdx = 0;

                    $target = $insightItem.filter('.is-target');

                    $target.filter(':gt(8)').hide();
                    $insightTextUndefined.hide();

                    if ($target.length === 0) {
                        $insightTextUndefined.show();
                    } else if ($target.length > 9) {
                        $insightBtnMore.show();
                        currentViewIdx = $target.length;
                    } else {
                        $insightBtnMore.hide();
                        currentViewIdx = 9;
                    }
                }
            };

            initFilter();

            $insightFilterCategory.on('change', function () {
                itemFilter('category', this.value);
            });
            $insightFilterType.on('change', function () {
                itemFilter('type', this.value);

                var $option = $insightFilterType.find('option').filter('[value="' + this.value + '"]');

                if ($option[0].dataset.filterTrigger) {
                    $insightFilterIndustries.parent().show();
                } else {
                    initIndustries();
                }
            });
            $insightFilterIndustries.on('change', function () {
                itemFilter('industries', this.value);
            });
            $insightFilterList.find('button.insight-btn-reset').on('click', function () {
                initFilter();
            });
            $insightBtnMore.on('click', function () {
                itemShowAdd(9);
            });

            $insightBtnGrid.addClass('active');
            $insightFilterList.find('.insight-grid').find('button').on('click', function () {
                var $this = $(this);

                $this.addClass('active');

                if ($this.hasClass('insight-btn-grid')) {
                    $insightBtnList.removeClass('active');
                    $lytInsight.removeClass('insight-view-list');
                } else if ($this.hasClass('insight-btn-list')) {
                    $insightBtnGrid.removeClass('active');
                    $lytInsight.addClass('insight-view-list');
                }
            });
        },
        processSnsComponent: function () {
            return {
                twitter: function ($element) {
                    if (self.util.unExistElement($element)) {
                        return;
                    }

                    $element.attr({
                        'target': '_blank',
                        'href': $element[0].href + '?' + $.param({
                            'original_referer': encodeURIComponent(location.href),
                            'text': doc.title + '\n' + location.href,
                            'tw_p': 'tweetbutton',
                            'url': encodeURIComponent(location.href)
                        })
                    });
                },
                facebook: function ($element) {
                    if (self.util.unExistElement($element)) {
                        return;
                    }

                    $element.attr({
                        'target': '_blank',
                        'href': $element[0].href + '?' + $.param({
                            u: location.href,
                            src: 'share_button'
                        })
                    });
                }
            };
        },
        moduleLayoutSocial: function () {
            $.proxy(function () {
                if (self.util.unExistElement($(this))) {
                    return;
                }

                self.processSnsComponent().twitter($(this).find('.btn-twitter'));
                self.processSnsComponent().facebook($(this).find('.btn-facebook'));
            }, $('.lyt-socialbtn'))();
        }
    };

    $(function () {
        var fxInstance = new SetFxObject(win.localData);

        fxInstance.initializeFx();
        fxInstance.util.resize.init();

        window.onbeforeprint = function () {
            $('#header').removeClass('fixed');
        };

        var mediaQueryList = window.matchMedia('print');
        mediaQueryList.addListener(function (mql) {
            if (mql.matches) {
                $('#header').removeClass('fixed');
            }
        });
    });
}(
    window,
    window.document,
    window.jQuery,
    /*
     * Utilitys.
     */
    function (win, doc, $, thisElm) {
        'use strict';

        var $win = thisElm.$win;
        var $header = thisElm.$header;
        var SetUtility = function () {};

        SetUtility.prototype = {
            isExistElement: function ($element) {
                if ($element.length <= 0) {
                    return false;
                } else {
                    return true;
                }
            },
            unExistElement: function ($element) {
                if ($element.length <= 0) {
                    return true;
                } else {
                    return false;
                }
            },
            isAriaExpanded: function ($element) {
                return $element.attr('aria-expanded') === 'true' ? true : false;
            },
            isAriaHidden: function ($element) {
                return $element.attr('aria-hidden') === 'true' ? true : false;
            },
            isAriaPressed: function ($element) {
                return $element.attr('aria-pressed') === 'true' ? true : false;
            },
            changeAriaToBtn: function ($btn, $controls, bool) {
                $btn.attr({
                    'aria-expanded': bool,
                    'aria-pressed': bool
                });
                $controls.attr('aria-expanded', bool);
            },
            changeAriaToToggle: function ($hook, $controls, bool) {
                $hook.attr('aria-expanded', bool);
                $controls.attr('aria-expanded', bool);
            },
            initAriaToBtn: function ($btn, $controls, controls) {
                $btn.attr({
                    'aria-expanded': false,
                    'aria-pressed': false,
                    'aria-controls': controls
                });
                $controls.attr({
                    'aria-expanded': false
                });
            },
            initAriaToToggle: function ($hook, $controls, controls) {
                $hook.attr({
                    'aria-expanded': false,
                    'aria-controls': controls
                });
                $controls.attr({
                    'aria-expanded': false
                });
            },
            tglAriaExpanded: function ($element) {
                if (this.isAriaExpanded($element)) {
                    $element.attr({
                        'aria-expanded': false
                    });
                } else {
                    $element.attr({
                        'aria-expanded': true
                    });
                }
            },
            tglAriaBtn: function ($element) {
                if (this.isAriaExpanded($element)) {
                    $element.attr({
                        'aria-expanded': false,
                        'aria-pressed': false
                    });
                } else {
                    $element.attr({
                        'aria-expanded': true,
                        'aria-pressed': true
                    });
                }
            },
            HasHeaderClassFixed: function () {
                if (this.unExistElement($header)) {
                    return false;
                } else {
                    if ($header.hasClass('fixed')) {
                        return true;
                    } else {
                        return false;
                    }
                }
            },
            getHeaderHeight: function () {
                return $header.height();
            },
            resize: {
                funcs: [],
                regist: function (func) {
                    this.funcs.push(func);
                },
                reset: function () {
                    this.funcs.length = 0;

                    $win.off('resize.globally');
                },
                init: function () {
                    var resizeTimerId = false;
                    var i = -1;
                    var self = this;
                    var l = self.funcs.length;

                    for (i = 0; i < l; i++) {
                        self.funcs[i].apply();
                    }

                    $win.on({
                        'resize.globally': function (event) {
                            if (resizeTimerId !== false) {
                                clearTimeout(resizeTimerId);
                            }

                            resizeTimerId = setTimeout(function () {
                                for (i = 0; i < l; i++) {
                                    self.funcs[i].apply(null, [event]);
                                }
                            }, 100);
                        }
                    });
                }
            }
        };

        return new SetUtility();
    },
    /*
     * jQuery Plugins.
     */
    function (win, doc, $, thisElm, thisUtil, thisStat, thisLocal) {
        'use strict';

        var $win = thisElm.$win;
        var $doc = thisElm.$doc;

        /*
         * @external "jQuery.fn".eachF
         */
        $.fn.eachF = (function () {
            var jq = jQuery([1]);

            return function (c) {
                var i = -1;
                var el;
                var len = this.length;

                while (++i < len && (el = jq[0] = this[i]) && c.call(jq, i, el) !== false);

                delete jq[0];

                return this;
            };
        }());
        /*
         * @external "jQuery.fn".setAnimateScroll
         */
        $.fn.setAnimateScroll = function (options) {
            if (!this) {
                return;
            }

            var o = $.extend({
                target: $('html, body'),
                offsetTop: 0
            }, options || {});
            var historyObj = win.history;

            return this.eachF(function () {
                var $self = $(this);
                var push = true;
                var scrollPos = 0;

                $self.on({
                    'click': function (event) {
                        var hash = this.hash.split('#')[1];

                        if (hash === 'top') {
                            push = false;
                        } else {
                            push = true;
                        }

                        if (!hash) {
                            return;
                        } else if (hash === 'top' || hash === '') {
                            scrollPos = 0;
                        } else {
                            var $target = $('#' + hash);

                            if ($target.length <= 0) {
                                return;
                            }

                            scrollPos = $target.offset().top;

                            if (typeof o.offsetTop === 'function') {
                                scrollPos -= o.offsetTop();
                            }
                        }

                        event.preventDefault();

                        o.target.animate({
                            scrollTop: scrollPos
                        }).promise().then(function () {
                            if ('pushState' in historyObj && push) {
                                historyObj.pushState(null, null, '#' + hash);
                            }
                        });
                    }
                });
            });
        };
        /*
         * @external "jQuery.fn".flyout
         */
        $.fn.flyout = function (options) {
            var o = $.extend({
                file: '/PATH/TO/FLYOUT.html',
                delay: 400,
                callback: null,
                classes: {
                    activeClass: 'is-opened'
                }
            }, options || {});

            this.eachF(function () {
                var $root = this;
                var $items = $root.children('ul').children('li');
                var items = [];

                if (!$items) {
                    return false;
                }

                if (!$items.hasClass('w-full') && !$items.hasClass('w-nallow')) {
                    return true;
                }

                $.ajax({
                    dataType: 'html',
                    url: o.file,
                    error: function () {
                        return false;
                    }
                }).done(function (html) {
                    var $flyout = $(html);

                    $items.eachF(function (i) {
                        items[i] = false;

                        var $li = this;
                        var classes = $li.attr('class');

                        if (classes) {
                            var category = $li.attr('class').split(' ')[0];
                            var width = $li.attr('class').split(' ')[1];

                            if (!!category && !!width) {
                                $li.append($flyout.find('#' + category).find('.' + width));
                                items[i] = category;
                            }
                        }
                    });

                    $items.each(function (i) {
                        var $li = $(this);
                        var timer;

                        if (!!items[i]) {
                            $li.on({
                                'mouseover': function () {
                                    timer = setTimeout(function () {
                                        $items.filter('.' + o.classes.activeClass).removeClass(o.classes.activeClass);
                                        $li.addClass(o.classes.activeClass);
                                    }, o.delay);
                                },
                                'mouseout touchstart': function () {
                                    clearTimeout(timer);

                                    if (!matchMedia('(max-width: 767px)').matches) {
                                        setTimeout(function () {
                                            $('body').one('mousemove touchend', function (e) {
                                                (!$(e.target).closest('.' + items[i]).length) && $li.removeClass(o.classes.activeClass);
                                            });
                                        }, 0);
                                    }
                                }
                            }).find('a').on('blur focusout touchend', function () {
                                setTimeout(function () {
                                    (!$(':focus').closest('.' + items[i]).length) && $li.removeClass(o.classes.activeClass);
                                }, 0);
                            }).eq(0).on('focus focusin', function () {
                                $li.addClass(o.classes.activeClass);
                            });
                        } else {
                            $li.find('a').on({
                                'mouseover focusin': function () {
                                    $li.addClass(o.classes.activeClass);
                                },
                                'mouseout focusout': function () {
                                    $li.removeClass(o.classes.activeClass);
                                }
                            });
                        }
                    });

                    if (o.callback) {
                        o.callback.apply();
                    }
                });
            });

            return this;
        };
        /*
         * @external "jQuery.fn".setRWDToggleTab
         */
        $.fn.setRWDToggleTab = function () {
            this.eachF(function () {
                var $root = $(this);
                var $tabList = $root.find('.tab-list > li');
                var $tabs = $root.find('.tabs');
                var $tabsItems = $tabs.children();
                var $tabsHeaders = $tabsItems.find('> .hdg');
                var toggleTabsHeaders = function ($element) {
                    var $content = $element.parent('.tabPanel');

                    if ($content.hasClass('active')) {
                        $content.removeClass('active');
                        $content.addClass('close');
                    } else {
                        $content.removeClass('close');
                        $content.addClass('active');

                        $win.trigger('update.carousel');
                    }
                };

                $tabs.removeClass('static');
                $tabsItems.addClass('tabPanel close');

                $tabsHeaders.on({
                    'click.setRWDToggleTab': function (event) {
                        event.preventDefault();
                        toggleTabsHeaders($(this));
                    },
                    'keydown.setRWDToggleTab': function (event) {
                        if (event.keyCode === 13) {
                            event.preventDefault();
                            toggleTabsHeaders($(this));
                        }
                    }
                });

                $tabList.eachF(function () {
                    var $element = $(this);
                    var hasHref = $element.find('a').attr('href');

                    if (!!hasHref && hasHref.indexOf('#') !== 0) {
                        return;
                    }
                });

                $tabList.on('click', function (event) {
                    var $element = $(this);
                    var target = event.currentTarget;
                    var idx = $tabList.index(target);

                    event.preventDefault();
                    $element.find('a').focus();
                    $tabList.removeClass('active');
                    $tabList.eq(idx).addClass('active');
                    $tabsItems.removeClass('active');
                    $tabsItems.eq(idx).addClass('active');

                    $win.trigger('update.carousel');
                });

                $tabsHeaders.attr('tabindex', 0);

                var once = false;
                var toHash = function () {
                    once = true;

                    var hash = location.hash;
                    var $target = $tabsItems.filter(hash);

                    if ($target.length > 0) {
                        var $a = $('a[href="' + hash + '"]').click();
                        var offset = thisLocal.option.staticHeader ? 0 : $('#header').height() - 20;

                        $('html, body').animate({
                            scrollTop: $a.offset().top - offset
                        });
                    }
                };
                var winWidth = 0;

                thisUtil.resize.regist(function () {
                    if (winWidth === win.innerWidth) {
                        return;
                    }

                    winWidth = win.innerWidth;

                    if (thisStat.break === 'xs') {
                        $tabList.removeClass('active');
                        $tabsItems.removeClass('active');
                    } else {
                        $tabList.filter('.active').removeClass('active').end().first().addClass('active');
                        $tabsItems.filter('.active').removeClass('active').end().first().addClass('active');
                    }

                    $win.trigger('update.carousel');

                    if (!once) {
                        toHash();
                    }
                });
            });

            return this;
        };
        /*
         * @external "jQuery.fn".setImageRoll
         */
        $.fn.setImageRoll = function () {
            if (!this) {
                return false;
            }

            var imgRollInitialize = function ($target) {
                $target.on({
                    'mouseenter': function () {
                        if ($(this).hasClass('unroll')) {
                            return;
                        }

                        this.src = this.src.replace(/(.png|.jpg|.gif)/, '_o$1');
                    },
                    'mouseleave': function () {
                        if ($(this).hasClass('unroll')) {
                            return;
                        }

                        this.src = this.src.replace(/_o(.png|.jpg|.gif)/, '$1');
                    }
                });
            };

            this.eachF(function () {
                var $this = $(this);

                if (
                    $this[0].tagName.toLowerCase() === 'img' ||
                    (
                        $this[0].tagName.toLowerCase() === 'input' &&
                        $this[0].type.toLowerCase() === 'image'
                    )
                ) {
                    imgRollInitialize($this);
                } else {
                    $this.find('img, input[type="image"]').eachF(function () {
                        imgRollInitialize($(this));
                    });
                }
            });
        };
        /*
         * @external "jQuery.fn".togglePanel
         */
        $.fn.togglePanel = function () {
            if (!this) {
                return false;
            }

            this.eachF(function () {
                var $self = $(this);
                var $hook = $self.find('.hook');

                $hook.on({
                    'click.togglePanel': function () {
                        if (!thisStat.xs) {
                            return;
                        }

                        var $target = $hook.parent('.toggle');

                        if ($target.hasClass('open')) {
                            $target.removeClass('open');
                            $target.addClass('close');
                        } else {
                            $target.addClass('open');
                            $target.removeClass('close');
                        }
                    },
                    'keydown.togglePanel': function (event) {
                        if (!thisStat.xs) {
                            return;
                        }

                        if (event.keyCode !== 13) {
                            return;
                        }

                        var $target = $hook.parent('.toggle');

                        if ($target.hasClass('open')) {
                            $target.removeClass('open');
                            $target.addClass('close');
                        } else {
                            $target.addClass('open');
                            $target.removeClass('close');
                        }
                    }
                });

                thisUtil.resize.regist(function () {
                    if (thisStat.xs) {
                        $hook.attr('tabindex', 0);
                    } else {
                        $hook.removeAttr('tabindex');
                    }
                });
            });
        };
        /*
         *  @external "jQuery.fn".accordionPanel
         */
        $.fn.accordionPanel = function (options) {
            var doc = document;
            var win = window;

            if (!this || ('undefined' === typeof win.addEventListener && 'undefined' === typeof doc.querySelectorAll)) {
                return false;
            }

            var locHref = location.href;
            var locHash = locHref.slice(-(locHref.length - locHref.indexOf('#')));

            var o = $.extend({
                ui: '.hook',
                classes: {
                    open: 'open',
                    close: 'close'
                },
                duration: 250
            }, options || {});

            this.each(function () {
                var $root = $(this);
                var $uis = $root.children(o.ui).attr('tabindex', 0);
                var uisLength = $uis.length;

                var flag = false;
                var fromHash = false;
                var isAnimating = false;

                for (var i = 0; i < uisLength ; i++) {
                    if ($uis.eq(i).hasClass(o.classes.open)) {
                        if (!flag) {
                            flag = true;
                        }
                    } else {
                        $uis.eq(i).removeClass(o.classes.open).addClass(o.classes.close);
                    }

                    if (locHash.indexOf($uis.eq(i).attr('id')) >= 0) {
                        $uis.eq(i).addClass(o.classes.open).removeClass(o.classes.close);
                        fromHash = true;
                    }
                }

                if (!$root.hasClass('all-close') && !o.accordionMode) {
                    (!flag) && (!fromHash) && $uis.eq(0).removeClass(o.classes.close).addClass(o.classes.open);
                }

                $uis.on('click keydown', function (e) {
                    if ((('click' === e.type) || (13 === e.which))) {
                        isAnimating = true;

                        var $ui      = $(this);
                        var $content = $ui.next();
                        var status   = $ui.hasClass(o.classes.open);

                        if (status) {
                            $content.slideUp(o.duration, function () {
                                $ui.addClass(o.classes.close).removeClass(o.classes.open);
                                isAnimating = false;
                            });
                        } else {
                            if (o.accordionMode) {
                                $uis.removeClass(o.classes.open).next().slideUp(o.duration);
                            } else {
                                var h = 0;

                                if (!thisLocal.option.staticHeader) {
                                    h = $('#header').addClass('fixed').height();
                                }

                                $('html, body').stop().animate({
                                    scrollTop: $ui.offset().top - h - 10
                                }, o.duration);
                            }



                            $content.slideDown(o.duration, function () {
                                $ui.addClass(o.classes.open).removeClass(o.classes.close);
                                isAnimating = false;
                            });
                        }

                        return false;
                    }
                });
            });

            $('a.hook-toggle[href^="#"]').each(function () {
                $(this)
                .off('click.hookToggle keydown.hookToggle')
                .on('click.hookToggle keydown.hookToggle', function (e) {
                    if ((('click' === e.type) || (13 === e.which))) {
                        var $target = $($(this).attr('href'));
                        var h = $('#header').addClass('fixed').height();

                        if ($target[0] && $target.hasClass(o.classes.close)) {
                            $target.trigger('click');
                        } else {
                            $('html, body').stop().animate({
                                scrollTop: $target.offset().top - h - 20
                            }, o.duration);
                        }
                    }
                });
            });

            return this;
        };
        /*
         * @external "jQuery.fn".rwdImageAlt
         */
        $.fn.rwdImageAlt = function (options) {
            if (!this) {
                return false;
            }

            var o = $.extend({
                exclude: 'excludeRwdImageAlt',
                letClass: 'alt-description'
            }, options);

            var func = function () {
                // do nothing.
            };

            func.init = function ($element) {
                var self = this;

                if (window.innerWidth <= 767) {
                    this.add($element);
                }

                $win.on('resize', function () {
                    if (window.innerWidth <= 767) {
                        self.add($element);
                    } else if (window.innerWidth > 767) {
                        self.reposit($element);
                    }
                });
            };
            func.add = function ($element) {
                this.originalAlt = $element[0].alt;
                if (!$element.next('.' + o.letClass)[0]) {
                    $element.after('<span class=' + o.letClass + '>' + $element[0].alt.replace('\r', '').replace('\n', '<br>') + '</span>').attr('alt', '');
                }
            };
            func.reposit = function ($element) {
                var $altTextElm = $element.next('.' + o.letClass);

                if ($altTextElm[0]) {
                    $element.attr('alt', $altTextElm.html().replace('<br>', '\r\n'));
                    $altTextElm.remove();
                }
            };

            return this.each(function () {
                var $ui = $(this);

                if ($ui.hasClass(o.exclude)) {
                    return;
                }

                if (!$ui.has('img').length) {
                    return;
                }

                var $targetImg = $ui.find('img');
                var $targetImgLength = $targetImg.length;

                for (var i = 0; i < $targetImgLength; i++) {
                    if ($targetImg[i].alt === '') {
                        return;
                    }

                    func.init($($targetImg[i]));
                }
            });
        };
        /*
         * @external "jQuery.fn".modalizeContents
         */
        $.fn.modalizeContents = function (options) {
            if (!this) {
                return false;
            }

            var o = $.extend({
                classes: {
                    static: 'static',
                    blind: 'modal-blind',
                    close: 'close'
                },
                text: {
                    close: 'close'
                },
                duration: 500
            }, options || {});

            this.eachF(function (i) {
                var $ui = $(this);
                var $content = $($ui.attr('href'));
                var modalized = false;
                var initModalizeStyle = function () {
                    var hook = (thisStat.break !== 'xs');

                    $content[(hook) ? 'removeClass' : 'addClass'](o.classes.static).css((hook) ? {
                        'position': 'absolute',
                        'z-index': 1001,
                        'display': (modalized) ? 'block' : 'none',
                        'opacity': (modalized) ? 1 : 0
                    } : {
                        'position': 'static',
                        'display': 'block',
                        'opacity': 1
                    }).find('.' + o.classes.close).css({
                        'display': (hook) ? 'block' : 'none'
                    });

                    if (modalized) {
                        $('.' + o.classes.blind + '-' + i)[(hook) ? 'show' : 'hide']();
                    }
                };

                $content.append('<div class="' + o.classes.close + '"><a href="#">' + o.text.close + '</a></div>');

                thisUtil.resize.regist(function () {
                    initModalizeStyle();
                });

                $ui.on('click', function () {
                    if ((thisStat.break !== 'xs') && !modalized) {
                        modalized = true;

                        var $blind = $('.' + o.classes.blind + '-' + i);
                        var $close = $content.find('.' + o.classes.close).find('a');
                        var $parent = $content.parent();
                        var parent = {
                            top: 0,
                            left: 0
                        };

                        if (!$blind.length) {
                            $blind = $('<div class="' + o.classes.blind + ' ' + o.classes.blind + '-' + i + '" />').css({
                                'background-color': '#000',
                                'position': 'fixed',
                                'top': 0,
                                'right': 0,
                                'bottom': 0,
                                'left': 0,
                                'z-index': 1000,
                                'opacity': 0
                            }).hide();
                            $content.after($blind);
                        }
                        $blind.show().stop(true, false).animate({
                            'opacity': 0.5
                        }, o.duration, function () {
                            $(this).one('click', hideModal);
                        });

                        while ($parent) {
                            if ('relative' === $parent.css('position')) {
                                parent.top += $parent[0].offsetTop;
                                parent.left += $parent[0].offsetLeft;
                            }

                            $parent = $parent.parent();

                            if ($parent.is('body')) {
                                break;
                            }
                        }

                        $('#header').css('z-index', 1);

                        setTimeout(function () {
                            var setPosTop = (((doc.documentElement.scrollTop || doc.body.scrollTop)) + (($win.innerHeight() - $content.innerHeight()) * 0.5));
                            var calcPosTop = (setPosTop < 0) ? 10 + (0 - parent.top) : (0 - parent.top) + setPosTop;

                            $content.show().css({
                                top: calcPosTop,
                                left: (($win.innerWidth() - $content.innerWidth()) * 0.5) - parent.left
                            }).stop(true, false).animate({
                                'opacity': 1
                            }, o.duration).attr('tabindex', 0).trigger('focus');

                            if ($win.innerHeight() < $content.innerHeight()) {
                                $('html, body').scrollTop((setPosTop < 0) ? 0 : setPosTop - 10);
                            }

                            // // This Trigger for rwdImageMaps
                            // $win.trigger('resize');
                        }, o.duration * 0.5);

                        var stopVideo = function () {
                            var $videoEmbed = $content.find('.video-embed');

                            if ($videoEmbed.length > 0) {
                                var $video = $videoEmbed.find('video');

                                if ($video.length > 0) {
                                    $video[0].pause();
                                } else {
                                    var $youtube = $videoEmbed.find('iframe')[0].contentWindow;

                                    $youtube.postMessage('{"event":"command","func":"pauseVideo","args":""}', '*');
                                }
                            }
                        };
                        var hideModal = function () {
                            stopVideo();

                            $content.stop(true, false).animate({
                                'opacity': 0
                            }, o.duration, function () {
                                $(this).hide();
                            }).removeAttr('tabindex');

                            setTimeout(function () {
                                $blind.stop(true, false).animate({
                                    'opacity': 0
                                }, o.duration, function () {
                                    $(this).hide();
                                    modalized = false;
                                });

                                $ui.trigger('focus');

                                // HACK megadropdown menu in header
                                // $('#content.lyt-type-6').css('z-index', 2);
                                $('#header').css('z-index', 1000);
                            }, o.duration * 0.5);
                            return false;
                        };

                        $doc.on('keydown', function (e) {
                            if (27 === e.which) {
                                hideModal();
                            }
                        });

                        $close.off('click').on('click', function () {
                            hideModal();
                        });
                    }
                });
            });

            return this;
        };
        /*
         * Swipe 1.0
         * Brad Birdsall, Prime
         * Copyright 2011, Licensed GPL & MIT
         *
         * @external "jQuery.fn".swipe
         */
        $.fn.swipe = function (element, options) {
            if (!element) {
                return null;
            }

            this.options = options || {};
            this.index = this.options.startSlide || 0;
            this.speed = this.options.speed || 500;
            this.callback = this.options.callback || function () {
                // do nothing.
            };
            this.delay = this.options.auto || 0;
            this.container = element;
            this.element = this.container.children[0];
            this.container.style.overflow = 'hidden';
            this.element.style.listStyle = 'none';
            this.setup();
            this.begin();

            if (this.element.addEventListener) {
                this.element.addEventListener('touchstart', this, false);
                this.element.addEventListener('touchmove', this, false);
                this.element.addEventListener('touchend', this, false);
                this.element.addEventListener('transitionend', this, false);
                window.addEventListener('resize', this, false);
            }
        };
        $.fn.swipe.prototype = {
            setup: function () {
                this.slides = this.element.children;
                this.length = this.slides.length;

                if (this.length < 2) {
                    return null;
                }

                this.width = this.container.getBoundingClientRect().width;

                if (!this.width) {
                    return null;
                }

                this.container.style.visibility = 'hidden';

                $(this.element).css({
                    '-webkit-transform-style': 'preserve-3d',
                    '-moz-transform-style': 'preserve-3d',
                    '-ms-transform-style': 'preserve-3d',
                    '-o-transform-style': 'preserve-3d',
                    'transform-style': 'preserve-3d'
                });

                this.element.style.width = (this.slides.length * this.width) + 'px';

                var index = this.slides.length;

                while (index--) {
                    var el = this.slides[index];
                    el.style.width = this.width + 'px';
                    el.style.display = 'table-cell';
                    el.style.verticalAlign = 'top';
                }

                this.slide(this.index, 0);
                this.container.style.visibility = 'visible';
            },
            slide: function (index, duration) {
                clearTimeout(this.interval);
                var self = this;
                $(self.element).stop(false, false).animate({
                    'margin-left': -(index * this.width) + 'px'
                }, duration, function () {
                    self.transitionEnd();
                });
                // set new index to allow for expression arguments
                this.index = index;
            },
            getPos: function () {
                // return current index position
                return this.index;
            },
            prev: function (delay) {
                this.delay = delay || 0;
                this.slide(this[(this.index) ? 'index' : 'length'] - 1, this.speed);
            },
            next: function (delay) {
                this.delay = delay || 0;
                this.slide((this.index < this.length - 1) ? this.index + 1 : 0, this.speed);
            },
            begin: function () {
                var _this = this;
                this.interval = (this.delay) ? setTimeout(function () {
                    _this.next(_this.delay);
                }, this.delay) : 0;
            },
            stop: function () {
                this.delay = 0;
                clearTimeout(this.interval);
            },
            resume: function () {
                this.delay = this.options.auto || 0;
                this.begin();
            },
            handleEvent: function (e) {
                switch (e.type) {
                    case 'touchstart': {
                        this.onTouchStart(e);
                        break;
                    }
                    case 'touchmove': {
                        this.onTouchMove(e);
                        break;
                    }
                    case 'touchend': {
                        this.onTouchEnd(e);
                        break;
                    }
                    case 'resize': {
                        this.setup();
                        break;
                    }
                }
            },
            transitionEnd: function (e) {
                if (this.delay) {
                    this.begin();
                }
                this.callback(e, this.index, this.slides[this.index]);
            },
            onTouchStart: function (e) {
                this.start = {
                    // get touch coordinates for delta calculations in onTouchMove
                    pageX: e.touches[0].pageX,
                    pageY: e.touches[0].pageY,
                    // set initial timestamp of touch sequence
                    time: Number(new Date())
                };
                // used for testing first onTouchMove event
                this.isScrolling = undefined;
                // reset deltaX
                this.deltaX = 0;
                // set transition time to 0 for 1-to-1 touch movement
                this.element.style.webkitTransitionDuration = 0;
            },
            onTouchMove: function (e) {
                // ensure swiping with one touch and not pinching
                if (e.touches.length > 1 || e.scale && e.scale !== 1) {
                    return;
                }
                this.deltaX = e.touches[0].pageX - this.start.pageX;
                // determine if scrolling test has run - one time test
                if (typeof this.isScrolling === 'undefined') {
                    this.isScrolling = !!(this.isScrolling || Math.abs(this.deltaX) < Math.abs(e.touches[0].pageY - this.start.pageY));
                }
                // if user is not trying to scroll vertically
                if (!this.isScrolling) {
                    // prevent native scrolling
                    e.preventDefault();
                    // cancel slideshow
                    clearTimeout(this.interval);
                    // increase resistance if first or last slide
                    this.deltaX = this.deltaX /
                        ((!this.index && this.deltaX > 0 // if first slide and sliding left
                            || this.index === this.length - 1 // or if last slide and sliding right
                            && this.deltaX < 0 // and if sliding at all
                        ) ?
                        (Math.abs(this.deltaX) / this.width + 1) // determine resistance level
                        : 1); // no resistance if false
                    // translate immediately 1-to-1
                    //this.element.style.webkitTransform = 'translate3d(' + (this.deltaX - this.index * this.width) + 'px,0,0)';
                    this.element.style.marginLeft = (this.deltaX - this.index * this.width) + 'px';
                }
            },
            onTouchEnd: function (e) {
                // determine if slide attempt triggers next/prev slide
                var isValidSlide =
                    Number(new Date()) - this.start.time < 250 // if slide duration is less than 250ms
                    && Math.abs(this.deltaX) > 20 // and if slide amt is greater than 20px
                    || Math.abs(this.deltaX) > this.width / 2, // or if slide amt is greater than half the width
                // determine if slide attempt is past start and end
                    isPastBounds =
                        !this.index && this.deltaX > 0 // if first slide and slide amt is greater than 0
                        || this.index === this.length - 1 && this.deltaX < 0; // or if last slide and slide amt is less than 0
                // if not scrolling vertically
                if (!this.isScrolling) {
                    // call slide function with slide end value based on isValidSlide and isPastBounds tests
                    this.slide(this.index + ((isValidSlide && !isPastBounds) ? ((this.deltaX < 0) ? 1 : -1) : 0), this.speed);
                }
            }

        };
        /*
         * @external "jQuery.fn".keyVisualControl
         * @required Swipe 1.0
         */
        $.fn.keyVisualControl = function (options) {
            if (!this) {
                return false;
            }

            var o = $.extend({
                duration: 500,
                auto: 0,
                classes: {
                    panels: 'image',
                    thumbs: 'location',
                    controller: 'move-control',
                    active: 'active',
                    stop: 'stop',
                    static: 'static'
                },
                text: {
                    play: 'Play',
                    stop: 'Stop'
                }
            }, options || {});

            this.eachF(function () {
                var $root = $(this).removeClass(o.classes.static);
                var $panels = $root.find('.' + o.classes.panels);
                var $ui = {
                    thumbs: $root.find('.' + o.classes.thumbs).find('li').find('a'),
                    controller: $root.find('.' + o.classes.controller)
                };
                var $controllerText = $ui.controller.find('span');

                if (1 >= $panels.find('li').length) {
                    $root.find('.' + o.classes.thumbs).hide();
                    $ui.controller.hide();
                    $panels.find('ul').css('display', 'block');
                    $panels.find('li').rwdImageAlt();
                    return false;
                }

                (0 < o.auto) ? $controllerText.text(o.text.stop) : $ui.controller.hide();

                var $keyVisual = new $.fn.swipe($panels.get(0), {
                    speed: o.duration,
                    auto: ('xs' === thisStat.break) ? false : o.auto,
                    callback: function (event, index) {
                        $ui.thumbs.parent().removeClass(o.classes.active).eq(index).addClass(o.classes.active);
                    }
                });

                $ui.thumbs.on('click touchstart', function (e) {
                    $keyVisual.slide($ui.thumbs.index(this));
                    e.preventDefault();
                });

                $ui.controller.on('click touchstart', function () {
                    if ('xs' !== thisStat.break) {
                        var isStop = $root.hasClass(o.classes.stop);
                        $keyVisual[(isStop) ? 'resume' : 'stop']();
                        statePaster(isStop);
                        return false;
                    }
                });

                thisUtil.resize.regist(function () {
                    if ('xs' === thisStat.break) {
                        $keyVisual.stop();
                        $controllerText.text(o.text.play);
                        $keyVisual.options.auto = false;
                    } else if (!$root.hasClass(o.classes.stop)) {
                        $keyVisual.options.auto = o.auto;
                        $keyVisual.resume();
                        $controllerText.text(o.text.stop);
                    }
                });

                $panels.find('li').rwdImageAlt();

                function statePaster (state) {
                    $root[(state) ? 'removeClass' : 'addClass'](o.classes.stop);
                    $controllerText.text((state) ? o.text.stop : o.text.play);
                }
            });

            return this;
        };
        /*
         * @external "jQuery.fn".carousel
         */
        $.fn.carousel = function (options) {
            if (!this) {
                return false;
            }

            var o = $.extend({
                classes: {
                    banner: 'bnr',
                    location: 'location',
                    next: 'next',
                    prev: 'prev',
                    static: 'static',
                    sp: 'sp'
                },
                ui: {
                    next: 'Next',
                    prev: 'Back'
                },
                spDisplay: 3,
                ptDisplay: 3,
                duration: 250
            }, options || {});

            this.each(function () {
                var $root = $(this).removeClass(o.classes.static);
                var $frame = $root.children('.' + o.classes.banner);
                var $bnrs = $frame.children('ul');
                var $bnr = $bnrs.children('li');
                var bnrLen = $bnr.length;
                var current = 0;
                var lock = false;
                var html = '<ul class="' + o.classes.location + '">' +
                    '<li class="' + o.classes.prev + '"><a href="#"><span>' + o.ui.prev + '</span></a></li>' +
                    '<li class="' + o.classes.next + '"><a href="#"><span>' + o.ui.next + '</span></a></li>' +
                '</ul>';

                $root.append(html);

                var $uis = $root.find('.' + o.classes.location);
                var $ui = {
                    next: $uis.find('.' + o.classes.next).find('a'),
                    prev: $uis.find('.' + o.classes.prev).find('a')
                };

                function initializeCarousel () {
                    if (thisStat.xs) {
                        initSp();
                    } else {
                        initPt();
                    }
                }

                thisUtil.resize.regist(function () {
                    initializeCarousel();
                });

                function initSp () {
                    lock = true;

                    $frame.css({
                        'width': 'auto',
                        'margin-left': 'inherit'
                    });
                    $bnr.css({
                        'width': 'auto',
                        'display': 'block'
                    }).find('a').css({
                        'height': 'auto'
                    }).attr('tabindex', 0);

                    if (bnrLen > o.spDisplay) {
                        $bnr.hide();

                        var $priority = $bnr.filter('.' + o.classes.sp);

                        if ($priority.length) {
                            if ($priority.length < o.spDisplay) {
                                $bnr.filter('.' + o.classes.sp).show();
                                randomShow($bnr.filter(':not(.' + o.classes.sp + ')'), o.spDisplay - $priority.length);
                            } else {
                                randomShow($priority, o.spDisplay);
                            }
                        } else {
                            randomShow($bnr, o.spDisplay);
                        }
                    }
                }

                function initPt () {
                    lock = false;

                    $bnr.css({
                        'display': 'block'
                    }).show();

                    for (var b = o.ptDisplay; bnrLen > b; b++) {
                        $bnr.eq(b).find('a').attr('tabindex', -1);
                    }

                    var padding = parseInt($root.css('padding-right'), 10) + parseInt($root.css('padding-left'), 10);
                    var margin = parseInt($bnr.eq(0).children('a').css('margin-right'), 10);
                    var width = parseInt($bnr.eq(0).css('width'), 10);

                    adjustStyle();

                    $win.on('resize.carouselAdjustStyle', adjustStyle);

                    $frame.css({
                        'margin-left': '-' + (current * width) + 'px'
                    });

                    function adjustStyle () {
                        padding = parseInt($root.css('padding-right'), 10) + parseInt($root.css('padding-left'), 10);
                        margin = parseInt($bnr.eq(0).children('a').css('margin-right'), 10);

                        $frame.css({
                            'width': (($root.innerWidth() - padding + margin) / o.ptDisplay * bnrLen) + 'px',
                            'margin-left': '-' + (current * width) + 'px'
                        });
                        $bnr.css({
                            'width': (100 / bnrLen) + '%'
                        });

                        width = parseInt($bnr.eq(0).css('width'), 10);
                    }

                    function slide (dir) {
                        if (!lock) {
                            lock = true;
                            var temp = current + (dir ? 1 : -1);
                            var range = bnrLen - o.ptDisplay;
                            var _current = (temp > range) ? 0 : (temp < 0) ? range : temp;

                            $bnr.find('a').attr('tabindex', -1);
                            $frame.animate({
                                'margin-left': '-' + (_current * width) + 'px'
                            }, o.duration, function () {
                                current = _current;
                                for (var b = current; range + current - 1 > b; b++) {
                                    $bnr.eq(b).find('a').attr('tabindex', 0);
                                }
                                lock = false;
                            });
                        }
                    }

                    if (bnrLen - o.ptDisplay > 0) {
                        $ui.next.on('click', function () {
                            slide(true);
                            return false;
                        });

                        $ui.prev.on('click', function () {
                            slide(false);
                            return false;
                        });
                    } else {
                        $uis.hide();
                    }
                }

                function randomShow (elems, pickOut) {
                    var slot = [];
                    var _slot = [];

                    for (var _s = 0; elems.length > _s; _s++) {
                        _slot[_s] = _s;
                    }

                    for (var s = 0; pickOut > s; s++) {
                        var num = Math.ceil((elems.length - s) * Math.random()) - 1;
                        slot[s] = _slot[num];
                        _slot.splice(num, 1);
                    }

                    slot.sort();

                    for (var __s = 0; slot.length > __s; __s++) {
                        elems.eq(slot[__s]).show();
                    }
                }
            });
            return this;
        };
        /*
         *  @external "jQuery.fn".generateNews
         */
        $.fn.generateNews = function (options) {
            if (!this) {
                return;
            }

            var o = $.extend({
                url: 'http://news.fujixerox.co.jp/newsfujixeroxapi/newslist/en'
            }, options || {});

            this.each(function () {
                var $root = $(this);

                $.ajax({
                    dataType: 'jsonp',
                    url: o.url,
                    jsonpCallback: '__newsfujixerox_latestlist'
                }).done(function (json) {
                    if (json['important_html']) {
                        $root.append(json['important_html']);
                    }

                    var list = json['count_list'];
                    var listLength = list.length;
                    var html = '<table><tbody>';
                    var i = 0;

                    for (i = 0; listLength > i; i++) {
                        html += '<tr><th>' + list[i]['date_string'] + '</th>';
                        html += '<td><ul class="link-list"><li>';
                        html += '<a href="' + list[i].url + '"';
                        html += (0 < parseInt(list[i].blank, 10)) ? ' target="blank"' : '';
                        html += '>' + list[i].title + '</a>';
                        html += '</li></ul></td></tr>';
                    }

                    $root.append(html += '</tbody></table>');
                });
            });

            return this;
        };
        /*
         *  @external "jQuery.fn".sortableTable
         */
        $.fn.sortableTable = function (options) {
            if (!this) {
                return false;
            }

            var o = $.extend({
                isNumRegEx: /^[0-9.-]+$/,
                extractNumRegEx: /[\d.-]/g
            }, options);

            // Sort Mode : ASC, Change DESC is Argument (b, a)
            var sortType = {
                number: function (a, b) {
                    return a.data - b.data;
                },
                string: function (a, b) {
                    a = String(a.data);
                    b = String(b.data);

                    return a < b ? -1 : a > b ? 1 : 0;
                }
            };

            return this.each(function () {
                var self = $(this);
                var $thead = self.find('thead');
                var $theadTh = $thead.find('th');
                var $theadThLength = $theadTh.length;
                var $tbody = self.find('tbody');
                var $tbodyTr = $tbody.find('tr');
                var $tbodyTrLength = $tbodyTr.length;
                var originalCache = $tbody.html();
                var originalCacheFlag = false;

                var sortRun = function (element) {
                    var $parentCell = element.parent('th, td');
                    var $targetNumber = $parentCell.index();
                    var isNumberSort = $parentCell.hasClass('sort-fix-number');
                    var sortObj = {
                        number: [],
                        string: [],
                        merge: null
                    };

                    for (var i = 0 ; i < $tbodyTrLength ; i++) {
                        var targetRowData = $tbodyTr.eq(i).find('th, td').eq($targetNumber).text();

                        // Trim Space
                        targetRowData = targetRowData.replace(/^\s]+|\s+$/g, '');

                        if (isNumberSort) {
                            if (!targetRowData.match(o.extractNumRegEx)) {
                                sortObj.string.push({
                                    'idx': i,
                                    'data': ''
                                });
                            } else {
                                sortObj.number.push({
                                    'idx': i,
                                    'data': targetRowData.match(o.extractNumRegEx).join('')
                                });
                            }
                        } else {
                            if (o.isNumRegEx.test(targetRowData)) {
                                // is Number => push sortObj.number
                                sortObj.number.push({
                                    'idx': i,
                                    'data': targetRowData
                                });
                            } else {
                                // is String => push sortObj.string
                                sortObj.string.push({
                                    'idx': i,
                                    'data': targetRowData
                                });
                            }
                        }
                    }

                    sortObj.merge = sortObj.number.concat(sortObj.string);
                    sortObj.number.sort(sortType.number);
                    sortObj.string.sort(sortType.string);

                    switch (true) {
                        case element.hasClass('state-default'): {
                            $theadTh.find('a').removeClass('state-asc state-desc').addClass('state-default');
                            element.removeClass('state-default').addClass('state-asc');
                            if (isNumberSort) {
                                sortObj.merge = sortObj.number.concat(sortObj.string);
                            } else {
                                sortObj.merge = sortObj.merge.sort(sortType.string);
                            }
                            originalCacheFlag =  false;
                            break;
                        }
                        case element.hasClass('state-asc'): {
                            $theadTh.find('a').removeClass('state-asc state-desc').addClass('state-default');
                            element.removeClass('state-default').addClass('state-desc');
                            if (isNumberSort) {
                                sortObj.number.reverse();
                                sortObj.string.reverse();
                                sortObj.merge = sortObj.string.concat(sortObj.number);
                            } else {
                                sortObj.merge = sortObj.merge.sort(sortType.string).reverse();
                            }
                            originalCacheFlag =  false;
                            break;
                        }
                        case element.hasClass('state-desc'): {
                            $theadTh.find('a').removeClass('state-asc state-desc').addClass('state-default');
                            $tbody.empty().append(originalCache);
                            originalCacheFlag =  true;
                            break;
                        }
                    }

                    if (originalCacheFlag === true) {
                        return;
                    }

                    var result = '';

                    if (element.hasClass() !== 'state-desc') {
                        for (var i = 0, anl = sortObj.merge.length ; i < anl ; i++) {
                            result += '<tr>' + $tbodyTr.eq(sortObj.merge[i].idx).html() + '</tr>';
                        }
                        $tbody.empty().append(result);
                    }
                    result = '';
                };

                var init = function () {
                    for (var i = 0 ; i < $theadThLength ; i++) {
                        var $targetElement = $theadTh.eq(i);

                        if ($targetElement.hasClass('sort-denial')) {
                            continue;
                        }

                        $targetElement.wrapInner('<a href="#" class="btn-sort state-default" />').find('a').on('click', function (e) {
                            e.preventDefault();
                            sortRun($(this));
                        });
                    }
                };

                init();
            });
        };
        /*
         * Copyright (c) 2012 Matt Stow
         * Licensed under the MIT license
         *
         * @see https://github.com/stowball/jQuery-rwdImageMaps
         * @see http://mattstow.com
         * @external "jQuery.fn".rwdImageMaps
         */
        $.fn.rwdImageMaps = function () {
            if (!this) {
                return false;
            }

            var $img = this;
            var rwdImageMap = function () {
                $img.each(function () {
                    if (typeof $(this).attr('usemap') === 'undefined') {
                        return;
                    }

                    var that = this;
                    var $that = $(that);

                    $('<img />').on('load', function () {
                        var w = $that.attr('width') || $(this).get(0).naturalWidth || $that.width();
                        var h = $that.attr('height') || $(this).get(0).naturalHeight || $that.height();
                        var wPercent = $that.width() / 100;
                        var hPercent = $that.height() / 100;
                        var map = $that.attr('usemap').replace('#', '');
                        var c = 'coords';

                        $('map[name="' + map + '"]').find('area').each(function () {
                            var $this = $(this);

                            if (!$this.data(c)) {
                                $this.data(c, $this.attr(c));
                            }

                            var coords = $this.data(c).split(',');
                            var coordsPercent = new Array(coords.length);
                            var coordsPercentLength = coordsPercent.length;

                            for (var i = 0; i < coordsPercentLength; ++i) {
                                if (i % 2 === 0) {
                                    coordsPercent[i] = parseInt(((coords[i] / w) * 100) * wPercent, 10);
                                } else {
                                    coordsPercent[i] = parseInt(((coords[i] / h) * 100) * hPercent, 10);
                                }
                            }

                            $this.attr(c, coordsPercent.toString());
                        });
                    }).attr('src', $that.attr('src'));
                });
            };

            $win.on('load resize', function () {
                rwdImageMap();
            });

            $win.on('update.carousel', function () {
                rwdImageMap();
            });

            return this;
        };
        /*
         * @external "jQuery.fn".browseItem1
         */
        $.fn.browseItem1 = function (options) {
            if (!this) {
                return false;
            }

            var o = $.extend({
                xml: '/PATH/TO/product_list.xml',
                classes: {
                    list: 'link-list',
                    active: 'active',
                    selected: 'selected',
                    open: 'open',
                    close: 'close'
                },
                template: '',
                text: {
                    support: '',
                    related: ''
                }
            }, options || {});

            this.each(function () {
                var $root = $(this);
                $.ajax({
                    dataType: 'xml',
                    url: o.xml
                }).done(function (xml) {
                    $root.html(o.template);

                    var $xml = $(xml).find('productsCategoryList');
                    var $rootInner1 = $root.children('ol').children('li').children('ol').children('li');
                    var $rootInner1on1 = $rootInner1.eq(0);
                    var $rootInner1on2 = $rootInner1.eq(1);
                    var $rootInner1on3 = $rootInner1.eq(2);
                    var $rootInner2 = $root.children('ol').children('li').eq(1);
                    var $category = {
                        root: $rootInner1on1,
                        output: $rootInner1on1.find('.' + o.classes.list)
                    };
                    var $series = {
                        root: $rootInner1on2,
                        output: $rootInner1on2.find('.' + o.classes.list),
                        attention: $rootInner1on2.find('.attention'),
                        skip: $rootInner1on2.find('.skip'),
                        init: function () {
                            selected.series = false;
                            $series.root.removeClass(o.classes.selected);
                            $series.output.html('');
                            $series.attention.show();
                            $series.skip.hide();
                        }
                    };
                    var $product = {
                        root: $rootInner1on3,
                        output: $rootInner1on3.find('.' + o.classes.list),
                        attention: $rootInner1on3.find('.attention'),
                        init: function () {
                            selected.product = false;
                            $product.root.removeClass(o.classes.selected);
                            $product.output.html('');
                            $product.attention.show();
                        }
                    };
                    var $toggleUi = $rootInner1.children('span').attr('tabindex', 0);
                    var $result = {
                        root: $rootInner2,
                        output: $rootInner2.find('.result'),
                        attention: $rootInner2.find('.result').find('.attention').get(0),
                        init: function () {
                            $result.output.html($result.attention);
                        }
                    };
                    var selected = {
                        category: false,
                        series: false,
                        product: false
                    };
                    var $xProductsCategory = $xml.children('productsCategory');
                    var $xCategoryName = $xProductsCategory.children('categoryName');
                    var categoryNameLength = $xCategoryName.length;
                    var categoryHtml = '';

                    for (var cn = 0; categoryNameLength > cn; cn++) {
                        categoryHtml += '<li><a href="#" id="bi-category-' + cn + '">' + $xCategoryName.eq(cn).text() + '</a></li>';
                    }

                    $category.output.append(categoryHtml).find('a').on('click', function () {
                        var $a = $(this);

                        activeControll($a, 'category');
                        closer($category.root);
                        opener($series.root);

                        var $xSeriesName = $xProductsCategory.eq(selected.category).find('seriesName');
                        var seriesLength = $xSeriesName.length;
                        var seriesHtml = '';
                        var skip = false;

                        for (var sn = 0; seriesLength > sn; sn++) {
                            seriesHtml += '<li><a href="#" id="bi-series-' + sn + '">' + $xSeriesName.eq(sn).text() + '</a></li>';
                            if (!$xSeriesName.eq(sn).text()) {
                                skip = true;
                            }
                        }

                        initer([$series, $product, $result]);
                        $series.output.append(seriesHtml).parent('div').scrollTop(0);
                        $series.attention.hide();
                        $series.skip.hide();

                        if (!!skip) {
                            $series.skip.show();
                            $series.output.find('a').eq(0).trigger('click');
                            $series.output.html('');
                        }

                        return false;
                    });

                    $root.on('click', '.bi-series a', function () {
                        var $a = $(this);
                        activeControll($a , 'series');
                        closer($series.root);
                        opener($product.root);
                        var $xProducts = $xProductsCategory.eq(selected.category).find('series').eq(selected.series).find('product');
                        var productLength = $xProducts.length;
                        var productHtml = '';

                        for (var pn = 0; productLength > pn; pn++) {
                            productHtml += '<li><a href="#" id="bi-product-' + pn + '">' + $xProducts.eq(pn).find('productName').text() + '</a></li>';
                        }

                        initer([$product, $result]);
                        $product.output.append(productHtml).parent('div').scrollTop(0);
                        $product.attention.hide();
                        return false;
                    });
                    $root.on('click', '.bi-product a', function () {
                        var $a = $(this);

                        activeControll($a, 'product');
                        closer($product.root);

                        var $xProduct = $xProductsCategory.eq(selected.category).find('series').eq(selected.series).find('product').eq(selected.product);
                        var productName = $xProduct.find('productName').text();
                        var supportUrl = $xProduct.find('productName').attr('supportUrl');
                        var $relatedLinks = (0 < $xProduct.find('relatedLink').length) ? $xProduct.find('relatedLink') : false;
                        var resultHtml = '<ul class="' + o.classes.list + '"><li class="btn"><a href="' + supportUrl + '">' + productName + o.text.support + '</a></li></ul>';

                        if (!!$relatedLinks) {
                            resultHtml += '<div class="related"><h3 class="hdg">' + o.text.related + '</h3><ul class="' + o.classes.list + '">';
                            var relatedLinksLength = $relatedLinks.length;
                            for (var nr = 0; relatedLinksLength > nr; nr++) {
                                resultHtml += '<li><a href="' + $relatedLinks.eq(nr).attr('url') + '">' + $relatedLinks.eq(nr).text() + '</a></li>';
                            }
                            resultHtml += '</ul></div>';
                        }

                        initer([$result]);
                        $result.output.html(resultHtml).scrollTop(0);

                        return false;
                    });
                    $toggleUi.on('click keydown', function (e) {
                        if (thisStat.xs && (('click' === e.type) || (13 === e.which))) {
                            var $target = $(this).parent('li');
                            var opened = $target.hasClass(o.classes.open);
                            $target.removeClass(o.classes[(opened) ? 'open' : 'close']).addClass(o.classes[(opened) ? 'close' : 'open']);
                            return false;
                        }
                    });

                    $root.attr('data-height-adjust', 'false,>ol>li>ol>li>span');
                    $root.setAdjustHeight();

                    function activeControll ($a, str) {
                        var $li = $a.parent();
                        var $lis = $li.parent('ul').find('li');
                        var $area = $a.closest('.select').parent('li');

                        $lis.removeClass(o.classes.active);
                        $li.addClass(o.classes.active);
                        $area.addClass(o.classes.selected);
                        selected[str] = parseInt($a.attr('id').replace('bi-' + str + '-', ''), 10);
                    }
                    function opener ($target) {
                        ($target.hasClass(o.classes.close)) && $target.removeClass(o.classes.close).addClass(o.classes.open);
                    }
                    function closer ($target) {
                        ($target.hasClass(o.classes.open)) && $target.removeClass(o.classes.open).addClass(o.classes.close);
                    }
                    function initer (arr) {
                        var arrLength = arr.length;
                        for (var na = 0; arrLength > na; na++) {
                            arr[na].init();
                        }
                    }
                });
            });

            return this;
        };
        /*
         * @external "jQuery.fn".browseItem3
         */
        $.fn.browseItem3 = function (options) {
            if (!this) {
                return false;
            }

            var locationPath = window.location.pathname;
            var xmlDirPath = locationPath.slice(0, locationPath.lastIndexOf('/')) + '/xml/';
            var o = $.extend({
                structureXml: xmlDirPath + 'data_structure.xml',
                dataXml: xmlDirPath + 'data_list.xml',
                classes: {
                    list: 'link-list',
                    active: 'active',
                    selected: 'selected',
                    open: 'open',
                    close: 'close'
                },
                template:
                    '<ol>' +
                      '<li>' +
                        '<ol>' +
                          '<li class="close"><span class="insertAnyTitle1"><!-- Insert:[anyTitle1] --></span>' +
                            '<div class="select">' +
                              '<div>' +
                                '<ul class="link-list bi-any1"></ul>' +
                              '</div>' +
                            '<!-- /select --></div>' +
                          '</li>' +
                          '<li class="close"><span class="insertAnyTitle2"><!-- Insert:[anyTitle2] --></span>' +
                            '<div class="select">' +
                              '<div>' +
                                '<p class="attention insertAnyTitle6"><!-- Insert:[anyTitle6] --></p>' +
                                '<p class="attention skip insertAnyTitle9" style="display:none;"><!-- Insert:[anyTitle9] --></p>' +
                                '<ul class="link-list bi-any2"></ul>' +
                              '</div>' +
                            '<!-- /select --></div>' +
                          '</li>' +
                          '<li class="close last-child"><span class="insertAnyTitle3"><!-- Insert:[anyTitle3] --></span>' +
                            '<div class="select">' +
                              '<div>' +
                                '<p class="attention insertAnyTitle7"><!-- Insert:[anyTitle7] --></p>' +
                                '<p class="attention skip insertAnyTitle10" style="display:none;"><!-- Insert:[anyTitle10] --></p>' +
                                '<ul class="link-list bi-any3"></ul>' +
                              '</div>' +
                            '<!-- /select --></div>' +
                          '</li>' +
                        '</ol>' +
                      '</li>' +
                      '<li><span class="insertAnyTitle4"><!-- Insert:[anyTitle4] --></span>' +
                        '<div class="result">' +
                          '<p class="attention insertAnyTitle8"><!-- Insert:[anyTitle8] --></p>' +
                        '</div>' +
                      '</li>' +
                    '</ol>',
                text: {
                    relatedTitle: ''
                }
            }, options || {});
            var xmlParseError = function ($element) {
                if (!$element.find('noscript')[0]) {
                    return;
                }

                $element.html($element.find('noscript').text()
                    .replace(/&lt;/g, '<')
                    .replace(/&gt;/g, '>')
                    .replace(/&nbsp;/g, ' '));

                return false;
            };

            this.each(function () {
                var $root = $(this);
                /*
                 * undefinedXml
                 * @return {[type]} [description]
                 */
                var insertDataToStructure = function () {
                    $.ajax({
                        dataType: 'xml',
                        url: o.dataXml
                    }).done(function (xml) {
                        var $xml = $(xml).find('xmlRoot');
                        var $selectArea = $root.children('ol').children('li').children('ol').children('li');
                        var $selectChild1 = $selectArea.eq(0);
                        var $selectChild2 = $selectArea.eq(1);
                        var $selectCHild3 = $selectArea.eq(2);
                        var $resultArea = $root.children('ol').children('li').eq(1);
                        var $any1Obj = {
                            root: $selectChild1,
                            output: $selectChild1.find('.' + o.classes.list)
                        };
                        var $any2Obj = {
                            root: $selectChild2,
                            output: $selectChild2.find('.' + o.classes.list),
                            attention: $selectChild2.find('.attention'),
                            skip: $selectChild2.find('.skip'),
                            init: function () {
                                selected.any2 = false;
                                $any2Obj.root.removeClass(o.classes.selected);
                                $any2Obj.output.html('');
                                $any2Obj.attention.show();
                                $any2Obj.skip.hide();
                            }
                        };
                        var $any3Obj = {
                            root: $selectCHild3,
                            output: $selectCHild3.find('.' + o.classes.list),
                            attention: $selectCHild3.find('.attention'),
                            skip: $selectCHild3.find('.skip'),
                            init: function () {
                                selected.any3 = false;
                                $any3Obj.root.removeClass(o.classes.selected);
                                $any3Obj.output.html('');
                                $any3Obj.attention.show();
                                $any3Obj.skip.hide();
                            }
                        };
                        var $toggleUi = $selectArea.children('span').attr('tabindex', 0);
                        var $result = {
                            root: $resultArea,
                            output: $resultArea.find('.result'),
                            attention: $resultArea.find('.result').find('.attention').get(0),
                            init: function () {
                                $result.output.html($result.attention);
                            }
                        };
                        var selected = {
                            any1: false,
                            any2: false,
                            any3: false
                        };
                        var $xAnyRoot = $xml.children('anyRoot');
                        var $xAny1Data = $xAnyRoot.children('any1Data');
                        var any1DataLength = $xAny1Data.length;
                        var any1Html = '';
                        var domain = window.location.href.split('/');
                        var _domain = [];

                        for (var idx = 0, l = 3; idx < l; idx++) {
                            _domain[idx] = domain[idx];
                        }

                        domain = _domain.join('/');

                        (function () {
                            var i = 0;

                            for (i = 0; any1DataLength > i; i++) {
                                any1Html += '<li><a href="#" id="bi-any1-' + i + '">' + $xAny1Data.eq(i).text() + '</a></li>';
                            }
                        })();

                        $any1Obj.output.append(any1Html);
                        $root.on('click', '.bi-any1 a', function () {
                            var $a = $(this);
                            activeControll($a, 'any1');
                            closer($any1Obj.root);
                            opener($any2Obj.root);

                            var $xAny2Data = $xAnyRoot.eq(selected.any1).find('any2Data');
                            var any2DataLength = $xAny2Data.length;
                            var any2Html = '';
                            var skip = false;

                            for (var sn = 0; any2DataLength > sn; sn++) {
                                any2Html += '<li><a href="#" id="bi-any2-' + sn + '">' + $xAny2Data.eq(sn).text() + '</a></li>';
                                if (!$xAny2Data.eq(sn).text()) {
                                    skip = true;
                                }
                            }

                            initer([$any2Obj, $any3Obj, $result]);
                            $any2Obj.output.append(any2Html).parent('div').scrollTop(0);
                            $any2Obj.attention.hide();
                            $any2Obj.skip.hide();

                            if (!!skip) {
                                $any2Obj.skip.show();
                                $any2Obj.output.find('a').eq(0).trigger('click');
                                $any2Obj.output.html('');
                            }

                            return false;
                        });

                        $root.on('click', '.bi-any2 a', function () {
                            var $a = $(this);
                            activeControll($a , 'any2');
                            closer($any2Obj.root);
                            opener($any3Obj.root);

                            var $xAny3Data = $xAnyRoot.eq(selected.any1).find('group').eq(selected.any2).find('item');
                            var any3Data = $xAny3Data.length;
                            var any3Html = '';

                            for (var pn = 0; any3Data > pn; pn++) {
                                any3Html += '<li><a href="#" id="bi-any3-' + pn + '">' + $xAny3Data.eq(pn).find('any3Data').text() + '</a></li>';
                            }

                            if (any3Data === 1 && $xAny3Data.eq(0).find('any3Data').text() === '') {
                                $any3Obj.output.html('');
                                $any3Obj.attention.hide();
                                $any3Obj.skip.show();
                                related();
                            } else {
                                initer([$any3Obj, $result]);
                                $any3Obj.output.append(any3Html).parent('div').scrollTop(0);
                                $any3Obj.attention.hide();
                            }

                            return false;
                        });

                        $root.on('click', '.bi-any3 a', function () {
                            var $a = $(this);
                            activeControll($a, 'any3');
                            closer($any3Obj.root);
                            related();

                            return false;
                        });

                        $result.output.on('click', 'a', function () {
                            var $a = $(this);

                            if (0 === $a.closest('.related').length) {
                                var href = $a.attr('href') || '/';

                                if (!(/http/.test(href))) {
                                    href = domain + href;
                                }
                            }
                        });

                        $toggleUi.on('click keydown', function (e) {
                            if (thisStat.xs && (('click' === e.type) || (13 === e.which))) {
                                var $target = $(this).parent('li');
                                var opened = $target.hasClass(o.classes.open);

                                $target.removeClass(o.classes[(opened) ? 'open' : 'close']).addClass(o.classes[(opened) ? 'close' : 'open']);

                                return false;
                            }
                        });

                        function activeControll ($a, str) {
                            var $li = $a.parent();
                            var $lis = $li.parent('ul').find('li');
                            var $area = $a.closest('.select').parent('li');

                            $lis.removeClass(o.classes.active);
                            $li.addClass(o.classes.active);
                            $area.addClass(o.classes.selected);
                            selected[str] = parseInt($a.attr('id').replace('bi-' + str + '-', ''), 10);
                        }

                        function opener ($target) {
                            ($target.hasClass(o.classes.close)) && $target.removeClass(o.classes.close).addClass(o.classes.open);
                        }

                        function closer ($target) {
                            ($target.hasClass(o.classes.open)) && $target.removeClass(o.classes.open).addClass(o.classes.close);
                        }

                        function initer (arr) {
                            var arrLength = arr.length;
                            var i = 0;

                            for (i = 0; arrLength > i; i++) {
                                arr[i].init();
                            }
                        }

                        function related () {
                            var $xItem = $xAnyRoot.eq(selected.any1).find('group').eq(selected.any2).find('item').eq(selected.any3);
                            var any3Data = $xItem.find('any3Data').text();
                            var exportUrl = $xItem.find('exportUrl').text();
                            var exportText = $xItem.find('exportText').text();
                            var resultHtml = '<ul class="' + o.classes.list + '"><li class="btn"><a href="' + exportUrl + '">' + exportText + '</a></li></ul>';
                            var $related1 = (0 < $xItem.find('related1').length) ? $xItem.find('related1') : false;
                            var $relatedUrl1 = (0 < $xItem.find('relatedUrl1').length) ? $xItem.find('relatedUrl1') : false;
                            var $related2 = (0 < $xItem.find('related2').length) ? $xItem.find('related2') : false;
                            var $relatedUrl2 = (0 < $xItem.find('relatedUrl2').length) ? $xItem.find('relatedUrl2') : false;
                            var $related3 = (0 < $xItem.find('related3').length) ? $xItem.find('related3') : false;
                            var $relatedUrl3 = (0 < $xItem.find('relatedUrl3').length) ? $xItem.find('relatedUrl3') : false;

                            if (!!$related1 && !!$relatedUrl1) {
                                resultHtml += '<div class="related"><h3 class="hdg">' + o.text.relatedTitle + '</h3><ul class="' + o.classes.list + '">';
                                resultHtml += '<li><a href="' + $relatedUrl1.text() + '">' + $related1.text() + '</a></li>';

                                if (!!$related2 && !!$relatedUrl2) {
                                    resultHtml += '<li><a href="' + $relatedUrl2.text() + '">' + $related2.text() + '</a></li>';
                                }
                                if (!!$related3 && !!$relatedUrl3) {
                                    resultHtml += '<li><a href="' + $relatedUrl3.text() + '">' + $related3.text() + '</a></li>';
                                }

                                resultHtml += '</ul></div>';
                            }

                            initer([$result]);
                            $result.output.html(resultHtml).scrollTop(0);
                        }

                        $root.attr('data-height-adjust', 'false,>ol>li>ol>li>span');
                        $root.setAdjustHeight();
                    }).fail(function () {
                        if (('console' in window)) {
                            console.error('404 (Not Found): Structure XML: ' + o.dataXml);
                        }

                        xmlParseError($root);
                    });
                };
                var createStructure = function () {
                    $.ajax({
                        dataType: 'xml',
                        url: o.structureXml
                    }).done(function (xml) {
                        $root.html(o.template);

                        var $xml = $(xml);
                        var $replaceArray = {
                            anyTitle1: $root.find('.insertAnyTitle1'),
                            anyTitle2: $root.find('.insertAnyTitle2'),
                            anyTitle3: $root.find('.insertAnyTitle3'),
                            anyTitle4: $root.find('.insertAnyTitle4'),
                            // anyTitle5: $root.find('.insertAnyTitle5'), -> Result: Related title
                            anyTitle6: $root.find('.insertAnyTitle6'),
                            anyTitle7: $root.find('.insertAnyTitle7'),
                            anyTitle8: $root.find('.insertAnyTitle8'),
                            anyTitle9: $root.find('.insertAnyTitle9'),
                            anyTitle10: $root.find('.insertAnyTitle10')
                        };
                        var key = null;

                        for (key in $replaceArray) {
                            if ($xml.find(key)[0]) {
                                if ($replaceArray.hasOwnProperty(key)) {
                                    $replaceArray[key].html($xml.find(key).text());
                                }
                            }
                        }

                        if ($xml.find('anyTitle5')[0]) {
                            o.text.relatedTitle = $xml.find('anyTitle5').text();
                        }

                        insertDataToStructure();
                    }).fail(function () {
                        if (('console' in window)) {
                            console.error('404 (Not Found): Structure XML: ' + o.structureXml);
                        }

                        xmlParseError($root);
                    });
                };
                var initialize = function () {
                    createStructure();
                    // initialize() -> createStructure() -> insertDataToStructure();
                };

                initialize();
            });

            return this;
        };
        /*
         * @external "jQuery.fn".setAdjustHeight
         */
        $.fn.setAdjustHeight = function (options) {
            if (!this) {
                return false;
            }

            var config = {
                exclude: 'adjust-exclude'
            };
            var $root = this;
            var $rootIdx;
            var $rootLeng = $root.length;
            var resizeTimerId;

            if (options) {
                jQuery.extend(config, options);
            }

            /**
             * 高さを設定
             * @param maxHeight
             * @param $target
             */
            var adjust = function (maxHeight, $target) {
                $target.each(function () {
                    var $this = $(this);

                    if (!$this.hasClass(config.exclude)) {
                        $this.height(maxHeight);

                        if ($this.find('> a').length > 0) {
                            $this.find('> a').height(maxHeight);
                        }
                    }
                })

                // for (iterator = holdIdx; iterator < idx; iterator++) {
                //     $targetChild = $target.eq(iterator);
                //
                //     if ($targetChild.hasClass(config.exclude)) {
                //         continue;
                //     }
                //
                // }
            };
            /**
             * 高さぞろえ.マックスの高さを取得
             * @param $this
             * @param $childSelector 高さを変更する要素
             */
            var scanningLine = function ($this, $childSelector) {
                var $childs = $this.find($childSelector);
                var idx = 0;
                var leng = $childs.length;

                if (leng <= 1) {
                    return;
                }

                $childs.css('height', 'auto');

                var maxHeight = 0;
                var $item;

                for (idx; idx < leng; idx++) {
                    $item = $childs.eq(idx);
                    maxHeight = Math.max($item.height(), maxHeight);

                    //最後の要素なら
                    if (idx === leng - 1) {
                        adjust(maxHeight, $childs);
                    }
                }
            };
            var initialize = function () {
                $rootIdx = 0;

                var $self;
                var $selectors;
                var idx;
                var leng;

                for (; $rootIdx < $rootLeng; $rootIdx++) {
                    $self = $root.eq($rootIdx);
                    $selectors = $self[0].getAttribute('data-height-adjust').split(',');
                    idx = 0;
                    leng = $selectors.length;

                    for (idx = leng - 1; idx >= 0; idx--) {
                        if (idx === 0) {
                            if ($selectors[idx] === 'true') {
                                scanningLine($self, '> *');
                            } else {
                                $self.children().css('height', 'auto');
                            }
                        } else {
                            if ($selectors[0] === 'true') {
                                scanningLine($self, '> *');
                            }

                            scanningLine($self, $selectors[idx]);
                        }
                    }
                }
            };

            initialize();

            $win.on({
                'resize.heightAdjust': function () {
                    if (resizeTimerId !== false) {
                        clearTimeout(resizeTimerId);
                    }

                    resizeTimerId = setTimeout(function () {
                        initialize();
                    }, 200);
                },
                'update.heightAdjust': function () {
                    initialize();
                }
            });

            return $root;
        };
        /*
         * @external "jQuery.fn".setFileSize
         */
        $.fn.setFileSize = function () {
            var $root, $rootIdx, $rootLeng, initialize;

            if (!this) {
                return false;
            }

            $root = $(this);
            $rootIdx = 0;
            $rootLeng = $root.length;

            if ($rootLeng < 0) {
                return this;
            }

            initialize = function (element) {
                $.ajax({
                    url: element.href,
                    type: 'HEAD'
                }).done(function (data, textStatus, jqXHR) {
                    var txt;
                    var cntLength = jqXHR.getResponseHeader('Content-Length') / 1024;
                    // var cntType = jqXHR.getResponseHeader('Content-Type').split('/')[1].toUpperCase();

                    cntLength = (cntLength > 1) ? parseInt(cntLength, 0) : cntLength.toFixed(1);
                    if (cntLength > 1024) {
                        txt = (cntLength / 1024).toFixed(1) + 'MB';
                    } else {
                        txt = cntLength + 'KB';
                    }

                    $(element).after('<span class="view-file-size">' + txt + '</span>');
                });
            };


            for (; $rootIdx < $rootLeng; $rootIdx++) {
                initialize($root[$rootIdx]);
            }

            return $root;
        };

        /*
         * @external "jQuery.fn".setGoogleMaps
         */
        $.fn.setGoogleMaps = function () {
            var $root;
            var mapUrl;
            var _google;

            if (this.length === 0) {
                return false;
            }

            $root = $(this);
            mapUrl = 'https://maps.googleapis.com/maps/api/js?key=';

            $.ajax($root[0].dataset.keyJson).done(function (data) {
                $.getScript(mapUrl + data.apiKey.googleMaps).done(function () {
                    _google = window.google;

                    $root.find('.gmaps').each(function () {
                        var $this = $(this);
                        var dataAttr = this.dataset;
                        var latlng = dataAttr.mapLatlng.split(',');
                        var zoom = parseInt(dataAttr.mapZoom, 10) || 16;
                        var setting = {
                            position: {
                                lat: parseFloat(latlng[0]),
                                lng: parseFloat(latlng[1])
                            },
                            $content: $this.find('.gmaps-content')
                        };
                        var map = new _google.maps.Map($this.find('.gmaps-viewarea')[0], {
                            zoom: zoom,
                            center: setting.position,
                            mapTypeControl: false
                        });
                        var marker = new _google.maps.Marker({
                            position: setting.position,
                            map: map
                        });
                        var infoWindow = new _google.maps.InfoWindow({
                            content: '<div class="gmaps-inner">' + setting.$content.html() + '</div>'
                        });

                        infoWindow.open(map, marker);
                        marker.addListener('click', function () {
                            infoWindow.open(map, marker);
                        });
                    });
                });
            });

            return $root;
        };
    }
));
